/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class AnimatedObject
extends Sprite {
    boolean needsToRespectBoundary = true;
    boolean needsToBeFollowedByCamera = false;
    boolean needsToBounce = false;
    SoccerField myContainer;
    String myDirection = "";
    public static String[] possibleDIrections = new String[]{"F", "B", "L", "R"};
    int myBoundary;
    int mySpeed = 1;

    public AnimatedObject(int n, int n2, Image image, int n3, int n4, int[] nArray) {
        super(image, n3, n4);
        this.setFrameSequence(nArray);
        this.defineReferencePixel(n3 / 2 + 1, n4 / 2 + 1);
        this.setRefPixelPosition(n, n2);
    }

    public void moveTo(String string, int n) {
        this.myDirection = string;
        if (!this.canMove()) {
            return;
        }
        if (this.myDirection == "F") {
            this.setTransform(0);
            this.move(0, -n);
            this.followCamera("F", n);
        } else if (this.myDirection == "B") {
            this.setTransform(1);
            this.move(0, n);
            this.followCamera("B", n);
        } else if (this.myDirection == "L") {
            this.setTransform(6);
            this.move(-n, 0);
            this.followCamera("L", n);
        } else if (this.myDirection == "R") {
            this.setTransform(5);
            this.move(n, 0);
            this.followCamera("R", n);
        }
        this.nextFrame();
    }

    public boolean canMove() {
        if (MSCanvas.myLayerManager.myGoalSign.isShowing()) {
            return false;
        }
        if (!this.needsToRespectBoundary) {
            return true;
        }
        return !this.myContainer.isObjectAtBoundary(this);
    }

    public String getDirection() {
        return this.myDirection;
    }

    public void setContainer(SoccerField soccerField) {
        this.myContainer = soccerField;
    }

    public boolean isInfront(AnimatedObject animatedObject) {
        AnimatedObject animatedObject2 = animatedObject.getWidth() > this.getWidth() ? animatedObject : this;
        return this.getXDistance(animatedObject) <= animatedObject2.getWidth() / 2 + 1;
    }

    public int getYDistance(AnimatedObject animatedObject) {
        return Math.abs(this.getRefPixelY() - animatedObject.getRefPixelY());
    }

    public int getXDistance(AnimatedObject animatedObject) {
        return Math.abs(this.getRefPixelX() - animatedObject.getRefPixelX());
    }

    public boolean isGoingTo(AnimatedObject animatedObject) {
        if (this.getDirection() == "F") {
            return animatedObject.getRefPixelY() < this.getRefPixelY();
        }
        if (this.getDirection() == "B") {
            return animatedObject.getRefPixelY() > this.getRefPixelY();
        }
        return false;
    }

    public boolean isAtLeftOf(AnimatedObject animatedObject) {
        return this.getRefPixelX() < animatedObject.getRefPixelX();
    }

    public boolean isAtRightOf(AnimatedObject animatedObject) {
        return this.getRefPixelX() > animatedObject.getRefPixelX();
    }

    public boolean isInFrontOf(AnimatedObject animatedObject) {
        return this.getRefPixelY() < animatedObject.getRefPixelY();
    }

    public boolean isOver(AnimatedObject animatedObject) {
        return this.getRefPixelY() == animatedObject.getRefPixelY() && this.getRefPixelX() == animatedObject.getRefPixelX();
    }

    public boolean isAtBackOf(AnimatedObject animatedObject) {
        return this.getRefPixelY() > animatedObject.getRefPixelY();
    }

    public void followCamera(String string, int n) {
        if (!this.needsToBeFollowedByCamera) {
            return;
        }
        if (string == "F") {
            if (MSLayerManager.intCurrentLeftY > 0 && this.getRefPixelY() < MSLayerManager.getYCenterOfScreen()) {
                MSLayerManager.intCurrentLeftY -= n;
            }
        } else if (string == "B") {
            if (MSLayerManager.intCurrentLeftY < MSLayerManager.cameraBottomLimit && this.getRefPixelY() > MSLayerManager.getYCenterOfScreen()) {
                MSLayerManager.intCurrentLeftY += n;
            }
        } else if (string == "R") {
            if (MSLayerManager.intCurrentLeftX < MSLayerManager.cameraRightLimit && this.getRefPixelX() > MSLayerManager.getXCenterOfScreen()) {
                MSLayerManager.intCurrentLeftX += n;
            }
        } else if (string == "L" && MSLayerManager.intCurrentLeftX > 0 && this.getRefPixelX() < MSLayerManager.getXCenterOfScreen()) {
            MSLayerManager.intCurrentLeftX -= n;
        }
    }

    public boolean isBetweenX(AnimatedObject animatedObject, AnimatedObject animatedObject2) {
        return this.getRefPixelX() < animatedObject.getRefPixelX() && animatedObject.getRefPixelX() < animatedObject2.getRefPixelX() || this.getRefPixelX() > animatedObject.getRefPixelX() && animatedObject.getRefPixelX() > animatedObject2.getRefPixelX();
    }

    public boolean isBetweenY(AnimatedObject animatedObject, AnimatedObject animatedObject2) {
        return this.getRefPixelY() < animatedObject.getRefPixelY() && animatedObject.getRefPixelY() < animatedObject2.getRefPixelY() || this.getRefPixelY() > animatedObject.getRefPixelY() && animatedObject.getRefPixelY() > animatedObject2.getRefPixelY();
    }
}

