/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.midlet.MIDlet;

public class MSCanvas
extends GameCanvas
implements CommandListener {
    static int CORNER_X = 0;
    static int CORNER_Y = 0;
    static int DISP_WIDTH;
    static int DISP_HEIGHT;
    static Display myDisplay;
    static MobileSoccer myGame;
    static MSLayerManager myLayerManager;
    static Command theMenuCommand;
    static Command thePauseCommand;
    static Command theGoCommand;
    static MSTopBar myTopBar;
    static Image myPlayerPic;
    static Image myFieldPic;
    static Image myPlayerComPic;
    static Image myBallPic;
    static Image myGoalSignPic;
    static Image myGoalPic;
    static int DISPLAY_COMMANDS_HEIGHT;

    public MSCanvas(MobileSoccer mobileSoccer) {
        super(false);
        myDisplay = Display.getDisplay((MIDlet)mobileSoccer);
        myGame = mobileSoccer;
        theMenuCommand = new Command("Menu", 7, 1);
        this.addCommand(theMenuCommand);
        thePauseCommand = new Command("Pause", 7, 1);
        theGoCommand = new Command("Go", 7, 1);
        this.addCommand(theGoCommand);
        try {
            myPlayerPic = Image.createImage((String)"/gamepics/player1.png");
            myPlayerComPic = Image.createImage((String)"/gamepics/player2.png");
            myFieldPic = Image.createImage((String)"/gamepics/soccer_field.png");
            myBallPic = Image.createImage((String)"/gamepics/ball.png");
            myGoalSignPic = Image.createImage((String)"/gamepics/goal_sign.png");
            myGoalPic = Image.createImage((String)"/gamepics/goal.png");
            DISP_WIDTH = this.getGraphics().getClipWidth();
            DISP_HEIGHT = this.getGraphics().getClipHeight();
            myTopBar = new MSTopBar(this.getGraphics());
            myLayerManager = new MSLayerManager(CORNER_X, CORNER_Y + MSCanvas.myTopBar.HEIGHT, DISP_WIDTH, DISP_HEIGHT - MSCanvas.myTopBar.HEIGHT - DISPLAY_COMMANDS_HEIGHT);
        }
        catch (Exception exception) {
            // empty catch block
        }
        SoccerField.TOTAL_HEIGHT = myFieldPic.getHeight();
        SoccerField.TOTAL_WIDTH = myFieldPic.getWidth();
        myLayerManager.setScreenAtCenter();
    }

    public void paint(Graphics graphics) {
        this.clearScreen(graphics);
        try {
            if (myLayerManager == null) {
                myLayerManager = new MSLayerManager(CORNER_X, CORNER_Y, DISP_WIDTH, DISP_HEIGHT);
            }
            myTopBar.paint(graphics);
            myLayerManager.paint(graphics);
        }
        catch (Exception exception) {
            this.errorMsg(graphics, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void advance() {
        myTopBar.getNewTime();
        try {
            this.paint(this.getGraphics());
            this.flushGraphics();
        }
        catch (Exception exception) {
            this.errorMsg(exception);
        }
        try {
            if (myLayerManager != null) {
                myLayerManager.advance();
            }
        }
        catch (Exception exception) {
            this.errorMsg(exception);
        }
        MSCanvas mSCanvas = this;
        synchronized (mSCanvas) {
            try {
                ((Object)((Object)this)).wait(1L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void checkKeys() {
        int n = this.getKeyStates();
        if ((n & 4) != 0) {
            myLayerManager.MoveLeft();
        }
        if ((n & 0x20) != 0) {
            myLayerManager.MoveRight();
        }
        if ((n & 0x40) != 0) {
            myLayerManager.MoveBack();
        }
        if ((n & 2) != 0) {
            myLayerManager.MoveForward();
        }
        if ((n & 0x200) != 0) {
            myLayerManager.PlayerKick();
        }
    }

    public void clearScreen(Graphics graphics) {
        graphics.setColor(14677221);
        graphics.fillRect(CORNER_X, CORNER_Y, DISP_WIDTH, DISP_HEIGHT);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == theMenuCommand) {
            myGame.pauseApp();
            myGame.menu_BackToMenuFromGame();
        } else if (command == theGoCommand) {
            this.setStateRunning();
        } else if (command == thePauseCommand) {
            myGame.pauseApp();
        }
    }

    public void setStateRunning() {
        this.setFullScreenMode(true);
        this.removeCommand(theGoCommand);
        this.addCommand(thePauseCommand);
        myGame.userAction_Continue();
    }

    public void setStatePaused() {
        this.setFullScreenMode(false);
        this.removeCommand(thePauseCommand);
        this.addCommand(theGoCommand);
    }

    void errorMsg(Exception exception) {
        this.errorMsg(this.getGraphics(), exception);
        this.flushGraphics();
    }

    void errorMsg(Graphics graphics, Exception exception) {
        if (exception.getMessage() == null) {
            this.errorMsg(graphics, exception.getClass().getName());
        } else {
            this.errorMsg(graphics, exception.getClass().getName() + ":" + exception.getMessage());
        }
    }

    void errorMsg(Graphics graphics, String string) {
        System.out.println(string);
    }

    void flushKeys() {
        this.getKeyStates();
    }

    static {
        DISPLAY_COMMANDS_HEIGHT = 0;
    }

    class MSTopBar {
        int CORNER_X = 0;
        int CORNER_Y = 0;
        int WIDTH;
        int HEIGHT;
        int INITIAL_TIME = 2700;
        int SECOND_DURATION = 6;
        int INITIAL_COUNTER = 0;
        int myCurrentTimeINT = this.INITIAL_TIME;
        String myCurrentTime;
        String myCurrentScore;
        String myCurrentScoreCom;
        int headerOffset1;
        int headerOffset2;
        Font FONT_HEADER;
        int FONT_HEIGHT;

        public MSTopBar(Graphics graphics) {
            this.CORNER_X = graphics.getClipX();
            this.CORNER_Y = graphics.getClipY();
            this.WIDTH = graphics.getClipWidth();
            this.FONT_HEADER = Font.getFont((int)64, (int)0, (int)8);
            this.FONT_HEIGHT = this.FONT_HEADER.getHeight();
            this.HEIGHT = this.FONT_HEIGHT + 2;
            this.headerOffset1 = this.FONT_HEADER.stringWidth("Time: 00:00 ");
            this.headerOffset2 = this.FONT_HEADER.stringWidth("Time: 00:00 Player:00 ");
        }

        public String formatNumber(int n) {
            if (n < 10) {
                return "0" + String.valueOf(n);
            }
            return String.valueOf(n);
        }

        public String formatTime(int n) {
            this.myCurrentTime = "";
            int n2 = n % 60;
            int n3 = n / 60;
            this.myCurrentTime = this.myCurrentTime + n3 + ":";
            if (n2 / 10 < 1) {
                this.myCurrentTime = this.myCurrentTime + "0";
            }
            this.myCurrentTime = this.myCurrentTime + n2;
            return this.myCurrentTime;
        }

        public void paint(Graphics graphics) {
            this.myCurrentTime = "Time: " + this.formatTime(this.myCurrentTimeINT);
            this.myCurrentScore = MSCanvas.myLayerManager.mySoccerGoal != null ? "Player:" + this.formatNumber(MSCanvas.myLayerManager.mySoccerGoal.myCurrentScore) : "Player:00";
            this.myCurrentScoreCom = MSCanvas.myLayerManager.mySoccerGoalCom != null ? "Com:" + this.formatNumber(MSCanvas.myLayerManager.mySoccerGoalCom.myCurrentScore) : "Com:00";
            graphics.setColor(153);
            graphics.fillRect(this.CORNER_X, this.CORNER_Y, this.WIDTH, this.HEIGHT);
            graphics.setColor(0xFFFFFF);
            graphics.setFont(this.FONT_HEADER);
            graphics.drawString(this.myCurrentTime, 2, 1, 20);
            graphics.drawString(this.myCurrentScore, 2 + this.headerOffset1, 1, 20);
            graphics.drawString(this.myCurrentScoreCom, 2 + this.headerOffset2, 1, 20);
        }

        public void getNewTime() {
            if (this.INITIAL_COUNTER++ == this.SECOND_DURATION) {
                --MSCanvas.myTopBar.myCurrentTimeINT;
                this.INITIAL_COUNTER = 0;
            }
        }
    }
}

