/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;

public class MSLayerManager
extends LayerManager {
    static int CANVAS_X;
    static int CANVAS_Y;
    static int DISP_WIDTH;
    static int DISP_HEIGHT;
    SoccerPlayer myPlayer;
    SoccerPlayerCom myPlayerCom;
    SoccerField myField;
    SoccerBall myBall;
    SoccerGoalSign myGoalSign;
    SoccerGoal mySoccerGoal;
    SoccerGoal mySoccerGoalCom;
    static int intCurrentLeftX;
    static int intCurrentLeftY;
    static boolean gameObjectsInitialized;
    static int cameraBottomLimit;
    static int cameraRightLimit;

    public MSLayerManager(int n, int n2, int n3, int n4) throws Exception {
        CANVAS_X = n;
        CANVAS_Y = n2;
        DISP_WIDTH = n3;
        DISP_HEIGHT = n4;
    }

    public void paint(Graphics graphics) throws Exception {
        if (!gameObjectsInitialized) {
            this.initGameObjects();
        }
        this.setViewWindow(intCurrentLeftX, intCurrentLeftY, DISP_WIDTH, DISP_HEIGHT);
        this.paint(graphics, CANVAS_X, CANVAS_Y);
    }

    void MoveLeft() {
        this.myPlayer.moveLeft();
    }

    void MoveRight() {
        this.myPlayer.moveRight();
    }

    void MoveBack() {
        this.myPlayer.moveBackwards();
    }

    void MoveForward() {
        this.myPlayer.moveForward();
    }

    void PlayerKick() {
        this.myPlayer.kickBall();
    }

    void advance() {
        this.myGoalSign.advance();
        if (this.isStillShowingGoal()) {
            return;
        }
        this.myBall.advance();
        this.myPlayer.advance(this.myBall);
        this.myPlayerCom.advance(this.myBall, this.myPlayer);
        if (this.myBall.isGoal(this.mySoccerGoal, this.mySoccerGoalCom)) {
            this.myGoalSign.goal();
            this.myBall.resetAfterGoal();
            this.setScreenAtCenter();
            this.myPlayerCom.setToCentralArea();
            this.myPlayer.setToCentralArea();
        }
    }

    void initGameObjects() throws Exception {
        this.myField = new SoccerField();
        this.myPlayer = new SoccerPlayer(0, 0);
        this.myBall = new SoccerBall(0, 0);
        this.myPlayerCom = new SoccerPlayerCom(0, 0);
        this.myGoalSign = new SoccerGoalSign(MSLayerManager.getXCenterOfScreen(), MSLayerManager.getYCenterOfScreen());
        this.mySoccerGoal = new SoccerGoal(SoccerField.getXCenterOfField(), 0, "HOME");
        this.mySoccerGoalCom = new SoccerGoal(SoccerField.getXCenterOfField(), SoccerField.TOTAL_HEIGHT, "VISIT");
        this.myPlayer.setContainer(this.myField);
        this.myPlayerCom.setContainer(this.myField);
        this.myBall.setContainer(this.myField);
        this.mySoccerGoal.setContainer(this.myField);
        this.mySoccerGoalCom.setContainer(this.myField);
        this.myPlayer.setGoal(this.mySoccerGoal);
        this.myPlayerCom.setGoal(this.mySoccerGoalCom);
        this.myBall.setBallAtCenter();
        this.myPlayer.setToCentralArea();
        this.myPlayerCom.setToCentralArea();
        this.append((Layer)this.myGoalSign);
        this.append((Layer)this.myPlayer);
        this.append((Layer)this.myPlayerCom);
        this.append((Layer)this.mySoccerGoal);
        this.append((Layer)this.mySoccerGoalCom);
        this.append((Layer)this.myBall);
        this.append((Layer)this.myField);
        cameraBottomLimit = SoccerField.TOTAL_HEIGHT - DISP_HEIGHT;
        cameraRightLimit = SoccerField.TOTAL_WIDTH - DISP_WIDTH;
        gameObjectsInitialized = true;
        System.out.println("Game objects initialized OK");
    }

    static int getXCenterOfScreen() {
        return intCurrentLeftX + DISP_WIDTH / 2;
    }

    static int getYCenterOfScreen() {
        return intCurrentLeftY + DISP_HEIGHT / 2;
    }

    public boolean isStillShowingGoal() {
        return this.myGoalSign.isShowing();
    }

    public void setScreenAtCenter() {
        intCurrentLeftX = SoccerField.getXCenterOfField() - DISP_WIDTH / 2;
        intCurrentLeftY = SoccerField.getYCenterOfField() - DISP_HEIGHT / 2;
        this.setViewWindow(intCurrentLeftX, intCurrentLeftY, DISP_WIDTH, DISP_HEIGHT);
    }

    static {
        gameObjectsInitialized = false;
    }
}

