/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.List;

class MenuList
extends List
implements CommandListener {
    private MobileSoccer midlet;
    private Command exitCommand;
    private static Image thePlayIcon;
    private static Image theInstructionsIcon;
    private static Image theConfigurationIcon;
    private static Image theHighScoresIon;

    MenuList(MobileSoccer mobileSoccer) {
        super("Mobile Soccer", 3);
        this.midlet = mobileSoccer;
        this.setFitPolicy(1);
        try {
            thePlayIcon = Image.createImage((String)"/menupics/Play.png");
            theInstructionsIcon = Image.createImage((String)"/menupics/Instructions.png");
            theConfigurationIcon = Image.createImage((String)"/menupics/Configuration.png");
            theHighScoresIon = Image.createImage((String)"/menupics/HighScores.png");
        }
        catch (Exception exception) {
            System.out.println("Error loading menu icons images");
        }
        this.append("Play Game", thePlayIcon);
        this.append("Instructions", theInstructionsIcon);
        this.append("Configuration", theConfigurationIcon);
        this.append("High Scores", theHighScoresIon);
        this.exitCommand = new Command("Exit", 7, 1);
        this.addCommand(this.exitCommand);
        this.setCommandListener(this);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == List.SELECT_COMMAND) {
            int n = this.getSelectedIndex();
            if (n != -1) {
                switch (++n) {
                    case 1: {
                        this.midlet.userAction_NewGame();
                        break;
                    }
                    case 2: {
                        this.midlet.userAction_Instructions();
                        break;
                    }
                    case 3: {
                        this.midlet.userAction_Configuration();
                        break;
                    }
                    case 4: {
                        this.midlet.userAction_HighScore();
                        break;
                    }
                    default: {
                        break;
                    }
                }
            }
        } else if (command == this.exitCommand) {
            this.midlet.userAction_Quit();
        }
    }

    public void restoreMenu() {
        this.set(0, "Play Game", thePlayIcon);
    }
}

