/*
 * Decompiled with CFR 0.152.
 */
public class SoccerBall
extends AnimatedObject {
    String myState = "";
    int myPow = 0;
    int myInercy = 0;
    SoccerPlayer myLastOwner;
    SoccerPlayer myCurrentOwner;
    static int KICK_RANGE = 30;
    static int FIELD_OFFSET_Y = 0;
    static int INITIAL_POW = 8;
    static int INITIAL_INERCY = 16;
    static int WIDTH = 9;
    static int HEIGHT = 9;
    static int playerShift = 7;
    int currentXShift;
    int currentYShift;
    static int[] FRAME_SEQUENCE = new int[]{0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2};

    public SoccerBall(int n, int n2) throws Exception {
        super(n, n2, MSCanvas.myBallPic, WIDTH, HEIGHT, FRAME_SEQUENCE);
        this.setRefPixelPosition(n, n2);
        this.needsToRespectBoundary = false;
        this.needsToBeFollowedByCamera = true;
        System.out.println("Soccer ball loaded ok");
    }

    public void setPosition(SoccerPlayer soccerPlayer) {
        if (soccerPlayer.getDirection().equals("F")) {
            this.currentYShift = -1;
            this.currentXShift = 0;
        }
        if (soccerPlayer.getDirection().equals("B")) {
            this.currentYShift = 1;
            this.currentXShift = 0;
        }
        if (soccerPlayer.getDirection().equals("L")) {
            this.currentXShift = -1;
            this.currentYShift = 0;
        }
        if (soccerPlayer.getDirection().equals("R")) {
            this.currentXShift = 1;
            this.currentYShift = 0;
        }
        this.moveTo(soccerPlayer.getDirection(), 0);
        this.setRefPixelPosition(soccerPlayer.getRefPixelX() + this.currentXShift * playerShift, soccerPlayer.getRefPixelY() + this.currentYShift * playerShift);
        this.myCurrentOwner = soccerPlayer;
        this.myState = "";
    }

    public void setAsKicked(SoccerPlayer soccerPlayer) {
        this.myState = "BEING_KICKED";
        this.myLastOwner = soccerPlayer;
        this.myCurrentOwner = null;
        this.myPow = INITIAL_POW;
        this.myInercy = INITIAL_INERCY;
        this.myDirection = soccerPlayer.getDirection();
    }

    public void advance() {
        if (this.myState == "BEING_KICKED") {
            this.nextFrame();
            if (this.myInercy > 0 && this.myPow > 0) {
                if (this.myPow-- == 1) {
                    --this.myInercy;
                    this.myPow = 1;
                }
                this.moveTo(this.myDirection, this.myPow);
            } else {
                this.myState = "";
                this.myPow = INITIAL_POW;
                this.myLastOwner.setAsNormal();
            }
        }
    }

    public boolean isGoal(SoccerGoal soccerGoal, SoccerGoal soccerGoal2) {
        if (this.getRefPixelY() < 0 && this.isInfront(soccerGoal)) {
            System.out.println("com goal");
            ++soccerGoal.myCurrentScore;
            return true;
        }
        if (this.getRefPixelY() > SoccerField.TOTAL_HEIGHT && this.isInfront(soccerGoal2)) {
            System.out.println("player goal");
            ++soccerGoal2.myCurrentScore;
            return true;
        }
        return false;
    }

    public void resetAfterGoal() {
        this.myPow = INITIAL_POW;
        this.myInercy = 0;
        this.myState = "";
        this.myDirection = "";
        if (this.myLastOwner != null) {
            this.myLastOwner.setAsNormal();
        }
        if (this.myCurrentOwner != null) {
            this.myCurrentOwner.setAsNormal();
        }
        this.setBallAtCenter();
    }

    public void setBallAtCenter() {
        this.setRefPixelPosition(SoccerField.getXCenterOfField(), SoccerField.getYCenterOfField() + FIELD_OFFSET_Y);
    }
}

