/*
 * Decompiled with CFR 0.152.
 */
public class SoccerPlayer
extends AnimatedObject {
    String myState = "";
    static int WIDTH = 13;
    static int HEIGHT = 13;
    static int[] FRAME_SEQUENCE = new int[]{0, 0, 0, 0, 0, 1, 1, 1, 1, 1};
    static int[] FRAME_SEQUENCE_KICK = new int[]{2, 2, 2, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1};
    SoccerBall myBall;
    static int INITIAL_CATCH_BALL_TIMER = 20;
    int catchBallTimer = 0;
    SoccerGoal myGoal;
    static String[] LEFT_LOOP_PATH = new String[]{"L", "", "", "", "", "", "", "", "", "", "", "", "L", "", "", "", "", "", "", "", "", "", "", "", "L", "", "", "", "", "", "", "", "", "", "", "", "L", "", "", "", "", "", "", "", "", "", "", ""};
    int myStepCounter = -1;
    static String[] LEFT_ZIGZAG_PATH = new String[]{"L", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "R", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""};
    String[] myCurrentPath;
    static int PANIC_DISTANCE = 30;

    public SoccerPlayer(int n, int n2) throws Exception {
        super(n, n2, MSCanvas.myPlayerPic, WIDTH, HEIGHT, FRAME_SEQUENCE);
        System.out.println("Soccer player loaded ok");
        this.defineReferencePixel(WIDTH / 2 + 1, HEIGHT / 2 + 1);
    }

    public String getDirection() {
        return this.myDirection;
    }

    public void moveForward() {
        super.moveTo("F", this.mySpeed);
        if (this.myBall != null) {
            this.myBall.moveTo("F", this.mySpeed);
            this.myBall.setPosition(this);
        }
    }

    public void moveBackwards() {
        super.moveTo("B", this.mySpeed);
        if (this.myBall != null) {
            this.myBall.moveTo("B", this.mySpeed);
            this.myBall.setPosition(this);
        }
    }

    public boolean isCloseAside(SoccerPlayer soccerPlayer) {
        return this.getXDistance(soccerPlayer) < PANIC_DISTANCE;
    }

    public void moveLeft() {
        super.moveTo("L", this.mySpeed);
        if (this.myBall != null) {
            this.myBall.moveTo("L", this.mySpeed);
            this.myBall.setPosition(this);
        }
    }

    public void turn(String string) {
        if (string.equals("R")) {
            this.turnRight();
        } else if (string.equals("L")) {
            this.turnLeft();
        } else {
            this.keepGoing();
        }
    }

    public void turnLeft() {
        System.out.println("LEFT");
        if (this.myDirection == "B") {
            this.moveLeft();
        } else if (this.myDirection == "L") {
            this.moveForward();
        } else if (this.myDirection == "F") {
            this.moveRight();
        } else if (this.myDirection == "R") {
            this.moveBackwards();
        }
    }

    public void turnRight() {
        System.out.println("RIGHT");
        if (this.myDirection == "B") {
            this.moveRight();
        } else if (this.myDirection == "L") {
            this.moveBackwards();
        } else if (this.myDirection == "F") {
            this.moveLeft();
        } else if (this.myDirection == "R") {
            this.moveForward();
        }
    }

    public void stepThePath() {
        if (this.myBall == null) {
            this.setAsNormalWithBall();
        }
        if (this.myStepCounter++ < this.myCurrentPath.length) {
            this.turn(this.myCurrentPath[this.myStepCounter - 1]);
        } else {
            this.setAsNormalWithBall();
        }
    }

    public void moveRight() {
        super.moveTo("R", this.mySpeed);
        if (this.myBall != null) {
            this.myBall.moveTo("R", this.mySpeed);
            this.myBall.setPosition(this);
        }
    }

    public void catchBall(SoccerBall soccerBall) {
        this.myBall = soccerBall;
        if (this.myBall.myCurrentOwner != null) {
            this.myBall.myLastOwner = this.myBall.myCurrentOwner;
        }
        this.myBall.myCurrentOwner = this;
        if (this.myBall.myLastOwner != null && this.myBall.myCurrentOwner != this.myBall.myLastOwner) {
            this.myBall.myLastOwner.myBall = null;
            this.myBall.myLastOwner.catchBallTimer = 0;
        }
        this.myBall.setPosition(this);
        this.myBall.myCurrentOwner.catchBallTimer = INITIAL_CATCH_BALL_TIMER;
        System.out.println("Ball Catched");
    }

    public void kickBall() {
        if (this.myBall != null) {
            this.myBall.setAsKicked(this);
            this.myState = "KICKING";
            this.setFrameSequence(FRAME_SEQUENCE_KICK);
            this.myBall = null;
            this.catchBallTimer = 0;
        }
    }

    public boolean isCloseAhead(SoccerPlayer soccerPlayer) {
        return this.getYDistance(soccerPlayer) < PANIC_DISTANCE;
    }

    public void keepGoing() {
        if (this.myDirection == "L") {
            this.moveLeft();
        } else if (this.myDirection == "F") {
            this.moveForward();
        } else if (this.myDirection == "R") {
            this.moveRight();
        } else if (this.myDirection == "B") {
            this.moveBackwards();
        }
    }

    public void makeALeftLoop() {
        System.out.println("MAKING_LEFT_LOOP");
        this.myStepCounter = 0;
        this.myState = "MAKING_LEFT_LOOP";
        this.myCurrentPath = LEFT_LOOP_PATH;
    }

    public void setAsNormal() {
        System.out.println("NORMAL");
        this.myState = "";
        this.setFrameSequence(FRAME_SEQUENCE);
        this.myBall = null;
        this.catchBallTimer = 0;
    }

    public boolean isDangerouslyClose(SoccerPlayer soccerPlayer) {
        if (this.myBall == null) {
            return false;
        }
        return this.isCloseAhead(soccerPlayer) && this.isCloseAside(soccerPlayer);
    }

    public void setAsNormalWithBall() {
        System.out.println("WITHBALL");
        this.myState = "";
        this.setFrameSequence(FRAME_SEQUENCE);
    }

    public void advance(SoccerBall soccerBall) {
        if (soccerBall == null) {
            return;
        }
        if (this.collidesWith(soccerBall, true) && this.canCatchBall(soccerBall)) {
            this.catchBall(soccerBall);
            this.catchBallTimer = INITIAL_CATCH_BALL_TIMER;
        }
    }

    public boolean canCatchBall(SoccerBall soccerBall) {
        if (this.myBall != null) {
            return false;
        }
        return --this.catchBallTimer < 0 && this.isLookingAt(soccerBall);
    }

    public boolean isGoingToGoal() {
        if (this.myGoal.getRefPixelY() < this.getRefPixelY() && this.getDirection() == "F") {
            return true;
        }
        return this.myGoal.getRefPixelY() > this.getRefPixelY() && this.getDirection() == "B";
    }

    public boolean hasTheBall() {
        return this.myBall != null && this.myBall.myCurrentOwner == this;
    }

    public void goToMyGoal() {
        if (this.myGoal == null) {
            return;
        }
        if (!this.isOnRange()) {
            this.followThisY(this.myGoal);
            this.followThisX(this.myGoal);
        } else if (!this.isInfront(this.myGoal)) {
            this.followThisX(this.myGoal);
        } else {
            this.followThisY(this.myGoal);
            this.kickBall();
        }
    }

    public void followBall(SoccerBall soccerBall) {
        if (soccerBall == null) {
            return;
        }
        this.followThis(soccerBall);
    }

    public void setGoal(SoccerGoal soccerGoal) {
        this.myGoal = soccerGoal;
    }

    public void followThis(AnimatedObject animatedObject) {
        if (animatedObject.getRefPixelY() > this.getRefPixelY()) {
            this.moveBackwards();
        } else if (animatedObject.getRefPixelY() < this.getRefPixelY()) {
            this.moveForward();
        }
        if (animatedObject.getRefPixelX() > this.getRefPixelX()) {
            this.moveRight();
        } else if (animatedObject.getRefPixelX() < this.getRefPixelX()) {
            this.moveLeft();
        }
    }

    public void followThisX(AnimatedObject animatedObject) {
        if (animatedObject.getRefPixelX() > this.getRefPixelX()) {
            this.moveRight();
        } else if (animatedObject.getRefPixelX() < this.getRefPixelX()) {
            this.moveLeft();
        }
    }

    public void followThisY(AnimatedObject animatedObject) {
        if (animatedObject.getRefPixelY() > this.getRefPixelY()) {
            this.moveBackwards();
        } else if (animatedObject.getRefPixelY() < this.getRefPixelY()) {
            this.moveForward();
        }
    }

    public boolean isOnRange() {
        if (this.myBall == null) {
            return false;
        }
        return this.myBall.getYDistance(this.myGoal) <= SoccerBall.KICK_RANGE;
    }

    public void moveAwayFromPlayer(SoccerPlayer soccerPlayer) {
        if (this.isCloseAside(soccerPlayer)) {
            this.goToMyGoal();
        }
        if (this.shallIAvoid(soccerPlayer)) {
            if (this.isGoingToGoal()) {
                this.makeLeftZigZag();
            } else {
                this.goToMyGoal();
            }
        }
    }

    public boolean shallIAvoid(SoccerPlayer soccerPlayer) {
        return this.isDangerouslyClose(soccerPlayer) && this.isBetweenY(soccerPlayer, this.myGoal);
    }

    public void setToCentralArea() {
        int n = 20;
        if (this instanceof SoccerPlayerCom) {
            n *= -1;
        }
        this.setRefPixelPosition(SoccerField.getXCenterOfField(), SoccerField.getYCenterOfField() + n);
        this.followThisY(this.myGoal);
    }

    public boolean isLookingAt(AnimatedObject animatedObject) {
        return this.getDirection().equals("B") && this.isInFrontOf(animatedObject) || this.getDirection().equals("F") && this.isAtBackOf(animatedObject) || this.getDirection().equals("R") && this.isAtLeftOf(animatedObject) || this.getDirection().equals("L") && this.isAtRightOf(animatedObject);
    }

    public void makeLeftZigZag() {
        System.out.println("MAKING_LEFTZIGZAG");
        this.myStepCounter = 0;
        this.myState = "MAKING_LEFTZIGZAG";
        this.myCurrentPath = LEFT_ZIGZAG_PATH;
    }
}

