unit EnemyEdit_U;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls;

type
  TEnemySetData = record
    celWidth,celheight : array[0..19] of Integer;
    hx,hy,hw,hh        : array[0..19] of Integer;
    HP,Score           : array[0..19] of Integer;
    //4x8 x 20 = 640Byte
  end;


type
  TForm1 = class(TForm)
    Image1: TImage;
    Label1: TLabel;
    Image2: TImage;
    Label4: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Button1: TButton;
    Label13: TLabel;
    Button2: TButton;
    Button3: TButton;
    Bevel1: TBevel;
    Edit1: TEdit;
    Edit2: TEdit;
    Label14: TLabel;
    Label15: TLabel;
    Bevel2: TBevel;
    Edit3: TEdit;
    Edit4: TEdit;
    Label16: TLabel;
    Label17: TLabel;
    Edit5: TEdit;
    Edit6: TEdit;
    Edit7: TEdit;
    Edit8: TEdit;
    Label2: TLabel;
    Label3: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Edit2Change(Sender: TObject);
    procedure Edit4Change(Sender: TObject);
    procedure Edit6Change(Sender: TObject);
    procedure Edit8Change(Sender: TObject);
    procedure Image2MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Button1Click(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
    //ORIGINAL
    _celWidth,_celheight : array[0..19] of Integer;
    _hx1,_hy1,_hx2,_hy2  : array[0..19] of Integer;
    _HP,_Score           : array[0..19] of Integer;
    _BNo,_INo            : array[0..19] of Integer;
    //RENEWAL
    celWidth,celheight : array[0..19] of Integer;
    hx1,hy1,hx2,hy2    : array[0..19] of Integer;
    HP,Score           : array[0..19] of Integer;
    //Data
    ED : TEnemySetdata;
    Oimg,Rimg : array[0..19] of TBitmap;
    //
    ENO : Integer;
    //
    procedure Setpara(no,cw,ch,ax1,ay1,ax2,ay2,ahp,ascore, BNo,INo : Integer);
    procedure Createdata;
    procedure savedata;
    procedure Loaddata;
    procedure ReDraw;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
var
  iii : Integer;
begin
  //ORIGINALSet
  Setpara(0 ,60,40,   5,5,55,35,   10,200,  0,0); //1
  Setpara(1 ,60,40,   5,5,55,35,   10,150,  0,1); //2
  Setpara(2 ,100,100, 10,10,90,90, 100,800, 1,0); //^
  Setpara(3 ,100,100, 10,10,90,90, 100,800, 1,1);
  Setpara(4 ,100,100, 10,10,90,90, 80,700,  1,2);
  Setpara(5 ,70,60,   10,15,60,45, 10,400,  2,3);
  Setpara(6 ,150,86,  5,20,145,66, 75,500,  3,0); //boon
  Setpara(7 ,50,50,   0,0,50,50,   5,150,   4,0); //Bom
  setpara(8 ,50,50,   0,0,50,50,   15,550,  5,0);
  setpara(9 ,50,50,   0,0,50,50,   25,250,  6,0);
  setpara(10,50,50,   5,5,45,45,   80,300,  7,0); //C
  setpara(11,50,50,   5,5,45,45,   35,200,  8,0);
  setpara(12,50,50,   5,5,45,45,   100,400, 9,0);
  setpara(13,146,134, 20,20,126,114,2500,2000,10,0);
  setpara(14,100,100, 10,10,90,90, 300,800, 1,4);
  setpara(15,50,50,   0,0,50,50,   15,650,  11,1);
  setpara(16,50,50,   0,0,50,50,   50,400,  12,0); //kuru
  setpara(17,64,64,   0,0,64,64,   800,1500,13,0);

  if (FileExists('..\EnemySetData.dat') = false)then createdata
                                                else Loaddata;

  for iii := 0 to 19 do
  begin
    Oimg[iii] := TBitmap.Create;
    if (FileExists('Enemy'+IntToStr(iii+1)+'.bmp') = True)then
      OImg[iii].LoadFromFile('Enemy'+IntToStr(iii+1)+'.bmp');
    Rimg[iii] := TBitmap.Create;
    if (FileExists('..\bmp\Enemy'+IntToStr(iii+1)+'.bmp') = True)then
      OImg[iii].LoadFromFile('..\bmp\Enemy'+IntToStr(iii+1)+'.bmp');
  end;
end;

procedure TForm1.Setpara(no,cw,ch,ax1,ay1,ax2,ay2,ahp,ascore, Bno,INo : Integer);
begin
  _celWidth[no] := cw;
  _celHeight[no] := ch;
  _hx1[no] := ax1;
  _hy1[no] := ay1;
  _hx2[no] := ax2;
  _hy2[no] := ay2;
  _HP[no]  := ahp;
  _Score[no] := aScore;
  _BNo[no] := Bno;
  _INo[no] := INo;
end;

procedure TForm1.CreateData;
var
  iii : Integer;
begin
  for iii := 0 to 19 do
  begin
   celWidth[iii] := _celwidth[iii];
   celHeight[iii] := _celheight[iii];
   hx1[iii] := _hx1[iii];
   hy1[iii] := _hy1[iii];
   hx2[iii] := _hx2[iii];
   hy2[iii] := _hy2[iii];
   HP[iii]  := _HP[iii];
   Score[iii] := _Score[iii];
  end;
  savedata;
end;

procedure TForm1.savedata;
var
  iii,a1,a2,a3,a4 : Integer;
  FF : File;
begin
  for iii := 0 to 19 do
  begin
   ED.celWidth[iii] := celwidth[iii];
   ED.celHeight[iii] := celheight[iii];
   ED.hw[iii] := abs(hx1[iii]-hx2[iii]);
   ED.hh[iii] := abs(hy1[iii]-hy2[iii]);
   ED.hx[iii] := ((hx1[iii]+hx2[iii]) div 2) - (celWidth[iii] div 2);
   ED.hy[iii] := ((hy1[iii]+hy2[iii]) div 2) - (celHeight[iii] div 2);
   ED.HP[iii]  := HP[iii];
   ED.Score[iii] := Score[iii];
  end;
  assignfile(ff,'..\EnemySetData.dat');
  ReWrite(ff,1);
  blockWrite(ff,ED,640,a4);
  closefile(ff);
  Form1.Edit8.Text := IntToStr(a4);
end;

procedure TForm1.loaddata;
var
  iii,a1,a2,a3,a4 : Integer;
  FF : File;
begin
  assignfile(ff,'..\EnemySetData.dat');
  ReSet(ff,1);
  BlockRead(ff,ED,640);
  CloseFile(ff);
  for iii := 0 to 19 do
  begin
   celwidth[iii] := ED.celWidth[iii];
   celheight[iii] := ED.celHeight[iii];
   hx1[iii] := (celWidth[iii] div 2) + ED.hx[iii] - (ED.hw[iii] div 2);
   hx2[iii] := (celWidth[iii] div 2) + ED.hx[iii] + (ED.hw[iii] div 2);
   hy1[iii] := (celHeight[iii] div 2) + ED.hy[iii] - (ED.hh[iii] div 2);
   hy2[iii] := (celHeight[iii] div 2) + ED.hy[iii] + (ED.hh[iii] div 2);
   HP[iii]  := ED.HP[iii];
   Score[iii] := ED.Score[iii];
  end;
end;

procedure TForm1.ReDraw;
var
  a1,a2,a3,a4 : Integer;
begin
  Edit1.Text := IntToStr(_HP[ENO]);
  Edit3.Text := IntToStr(_Score[ENO]);
  Edit5.Text := IntToStr(_celWidth[ENO]);
  Edit7.Text := IntToStr(_celHeight[ENO]);
  Edit2.Text := IntToStr(HP[ENO]);
  Edit4.Text := IntToStr(Score[ENO]);
  Edit6.Text := IntToStr(celWidth[ENO]);
  Edit8.Text := IntToStr(celHeight[ENO]);

  Image1.Canvas.Brush.Color := $02FFFFFF;
  Image1.Canvas.FillRect(rect(0,0,250,250));
  a3 := 640 div _celWidth[ENO];
  a1 := _INo[ENO] mod a3;
  a2 := _INo[ENO] div a3;
  a1 := a1 * _celWidth[ENO];
  a2 := a2 * _CelHeight[ENO];
  BitBlt(Image1.Canvas.Handle,0,0,_celWidth[ENO],_celHeight[ENO],
         Oimg[_BNo[ENO]].Canvas.Handle,a1,a2,
         SRCCOPY);
  Image1.Canvas.Brush.Color := $028888ff;
  Image1.Canvas.FrameRect(rect(_hx1[ENO],_hy1[ENO],_hx2[ENO],_hy2[ENO]));
  Image1.Refresh;

  Image2.Canvas.Brush.Color := $02FFFFFF;
  Image2.Canvas.FillRect(rect(0,0,250,250));
  a3 := 640 div celWidth[ENO];
  a1 := _INo[ENO] mod a3;
  a2 := _INo[ENO] div a3;
  a1 := a1 * celWidth[ENO];
  a2 := a2 * celHeight[ENO];
  BitBlt(Image2.Canvas.Handle,0,0,celWidth[ENO],celHeight[ENO],
         Oimg[_BNo[ENO]].Canvas.Handle,a1,a2,
         SRCCOPY);
  Image2.Canvas.Brush.Color := $028888ff;
  Image2.Canvas.FrameRect(rect(hx1[ENO],hy1[ENO],hx2[ENO],hy2[ENO]));
  Image2.Refresh;

  Label3.Caption := IntToStr(ENO);
end;

procedure TForm1.FormDestroy(Sender: TObject);
var
  iii : Integer;
begin
  for iii := 0 to 19 do
  begin
    Oimg[iii].free;
    Rimg[iii].free;
  end;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  ENO := (ENO + 18 - 1) mod 18;
  ReDraw;
end;


procedure TForm1.Button3Click(Sender: TObject);
begin
  ENO := (ENO + 18 + 1) mod 18;
  ReDraw;
end;

procedure TForm1.Edit2Change(Sender: TObject);
begin
  Edit2.Text := IntToStr(StrToIntDef(Edit2.Text,0));
  hp[ENO] := StrToInt(Edit2.text);
end;

procedure TForm1.Edit4Change(Sender: TObject);
begin
  Edit4.Text := IntToStr(StrToIntDef(Edit4.Text,0));
  score[ENO] := StrToInt(Edit4.text);
end;

procedure TForm1.Edit6Change(Sender: TObject);
begin
  Edit6.Text := IntToStr(StrToIntDef(Edit6.Text,0));
  celWidth[ENO] := StrToInt(Edit6.text);
end;

procedure TForm1.Edit8Change(Sender: TObject);
begin
  Edit8.Text := IntToStr(StrToIntDef(Edit8.Text,0));
  celHeight[ENO] := StrToInt(Edit8.text);
end;

procedure TForm1.Image2MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var
  aaa : Integer;
begin
  if (Button = mbLeft)then
  begin
    hx1[ENO] := X;
    hy1[ENO] := Y;
  end
  else
  begin
    hx2[ENO] := X;
    hy2[ENO] := Y;
  end;

  if (hx1[ENO] > hx2[ENO])then
    begin aaa := hx1[ENO]; hx1[ENO] := hx2[ENO]; hx2[ENO] := aaa; end;
  if (hy1[ENO] > hy2[ENO])then
    begin aaa := hy1[ENO]; hy1[ENO] := hy2[ENO]; hy2[ENO] := aaa; end;
  ReDraw;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  Savedata;
  MessageDlg('GŁ``XV܂', mtInformation,[mbOk], 0);
end;

end.
