unit Kota43a;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, Kota43b,  KeyObj,   ExtCtrls, StdCtrls, DSound,
  ddsd, Defs,KeyDefs, dddd,DDraw, math, Ddidex, AlphaLib16, KBGM,MMSystem,
  MP3Plyr;

type
  TForm1 = class(TForm)
    DDDD1: TDDDD;
    DDIDEX1: TDDIDEX;
    DDSD1: TDDSD;
    MP3Player1: TMP3Player;
    procedure FormDestroy(Sender: TObject);
    procedure AppIdle(Sender:TObject; var Done : boolean);
    procedure DDDD1Init(Sender: TObject; fNeedChange: Boolean);
    procedure MP3Player1EndPlay(Sender: TObject;
      Reason: TMP3EndPlayReason);
    procedure FormCreate(Sender: TObject);
    procedure FormResize(Sender: TObject);

  private
    { Private 錾 }
    Level1,Level2,Flag1 : Integer;
    title : TDDDDSurFace;
    Select1 : TDDDDSurface;
    Frame1,Frame2 : Integer;
    FrameTime : LongInt;
    CCount : Integer;
    LastTime : LongInt;
    PPD : TPlayData;
    //Stagep
    StageNo : Integer;
    StageFile : string;
    StageSel : Boolean;
    //titile
    Diffcult,BGMsound,SlowWait,DrawSize,BLTMode,EditWait,ShotColor,BGMMode : Byte;
    cy,cx,aa1 : Integer;
    ans : array[0..24] of String;
    //BGM
    BGMPlay : Boolean;
    BGMPlayMode : Byte;
    Midihandle : HDATA;
    BGMName : String;
    BGMWave:TDDSDWavedata;
    //PlayOption
    PlayFrm : LongInt;
    PlayRec : Boolean;
    RecNo : Byte;
    NoHitMode : Boolean;
    SamplePlay : Boolean;
    //TempHiscore
    NameEnt : array[0..2] of String[1];
    //
    TitleCount : Integer;
    DemoPlay : boolean;
    NormalPlay : Boolean;
    //B@̏otO
    SecCount,SecCount2 : Integer;
    //BOMgpepJE^
    DeleteShot : Byte;
    //MIDI
    midi_ok : byte;
    //FullScreenMode
    FullScreenMode : Boolean;
    //FeedBack
    FeedBuf : TDDDDSurface;
    Feed_Count : Integer;
    //܂₵iT T
    TMesCount : Integer;
    //GfBOp
    DemoCount : Integer;

  public
    { Public 錾 }
    procedure DataLoad;
    procedure FedeOut;
    procedure GamePlay;
    procedure GameStart;
    procedure PlayerSub;
    procedure ImageDraw;
    procedure Imagedraw2;
    procedure GamePause;
    procedure TitleMenu;
    procedure continue;
    procedure GameOver;
    procedure StageLoad;
    procedure ScoreRanking;
    procedure HiScoreCheck;
    procedure BGMEnable(filename : string);
    procedure BGMDisable;
    procedure VerDisp;
    procedure Config;
    procedure Select;
    procedure AttackShot;
    procedure AttackENS;
    procedure AttackBom;
    procedure StageSelect;
    procedure RecModeSelect;
    procedure AllClear;
    procedure EndingDemo;
    procedure OpeningDemo;
    procedure NameEntry;
    procedure ScoreAdd;

    procedure PlayDataWrite;
    procedure BGMPlayerMenu;

    procedure PlayDataSelect;

    //procedure startDemo;           //

    procedure DrawFeedBack;          //oJ
    procedure EntryFeedBack;

    procedure PrintStageLogo;
    procedure GameStop;
  end;

var
  Form1: TForm1;
  STG1 : TSTG;
  Key1 : TKey;
  Alph1: Talpha16;

implementation

{$R *.DFM}

procedure TForm1.AppIdle(Sender:TObject; var Done : boolean);
var
  SlowTime,waitTime,TempTime : LongInt;
begin
  if (STG1.ErrorCode = 255)then begin Close; exit; end;   //FileȂ
  //FrmeCount
  if ((GetTickCount - FrameTime)>1000) then
  begin
    Frame2 := Frame1*1000 div (GetTickCount-FrameTime);
    Frame1 := 0;
    FrameTime := GetTickCount;
  end;

  Frame1 := Frame1 + 1;

  Key1.GetKey;
  
  //ESC
  if ((Key1.ESC = True)or(Key1.PTrig4 = True))then
   if (DemoPlay = False)then
    case Level1 of
      2 : begin                 //PlayPauseMenu
           Level1 := 4;
          end;
      4 : begin                 //game
            Level1 := 2;
            cy := 0;
          end;
      5 : begin
               FedeOut;
               Level1 := 255;
               STG1.ErrorCode := 255;
               exit;
          end;

      else
          begin
               FedeOut;
               EntryFeedBack;
               BGMDisable;
               Level2 := 1;
               Level1 := 5;
          end;
    end;

  case Level1 of
    0: DataLoad;
    1: GameStart;
    2: GamePlay;
    4: GamePause;
    5: TitleMenu;
    6: Continue;
    7: StageLoad;
    8: GameOver;
    9: ScoreRanking;
    11:Config;
    12:Select;
    13:NameEntry;
    14:BgmPlayerMenu;
    15:PlayDataSelect;
    16:ScoreAdd;
    17:RecModeSelect;
    20:StageSelect;
    21:OpeningDemo;
    22:EndingDemo;
    30:AllClear;
  end;

  //SE
  STG1.PlaySE;
  //fps

  WaitTime := 25 + (EditWait-5);                         //Wait
  SlowTime := 0;

  if ((SlowWait = 0)and(Level1 = 2))then
    case STG1.Dif of
     -1 :begin        //Easy
          SlowTime := 20;
          if (STG1.DES < 60)then SlowTime := STG1.DES div 3;
         end;
     0,1 : begin        //Normal & Hard
          SlowTime := 0;
          if (STG1.DES > 30)and(STG1.DES < 105)then SlowTime := (STG1.DES-30) div 5;
          if (STG1.DES > 105)then SlowTime := 15;
         end;
    end;

  //Wait
  if (EditWait <> 9)then while ((TimeGetTime-LastTime)<(WaitTime+SLowTime)) do;

  //FPSl߂
  if((SlowTime = 0)and(Level1 = 2))then STG1.SetFPScounter(TimeGetTime - LastTime);
  LastTime := TimeGetTime;

  //if ((GetAsyncKeyState($79) and $8000) <> 0)then GameStop;

  Done := False;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  timeEndPeriod(1);

  BGMDisable;
  MP3Player1.Stop;

  //KGBFree
  KBGMFree(Midihandle);
  KBGMClose;

  with STG1.Configdata do
  begin
    Flag[0] := diffcult;
    Flag[1] := BGMsound;
    Flag[2] := SlowWait;
    Flag[3] := DrawSize;
    Flag[4] := BltMode;
    Flag[5] := STG1.BackCut;
    Flag[6] := STG1.WaveVolume;
    Flag[7] := EditWait;
    Flag[8] := shotColor;
    Flag[9] := BGMMode;
  end;
  STG1.ConfigWrite;
  title.free;
  FeedBuf.free;
  Alph1.free;;
  STG1.free;
  ShowCursor(True);
  BGMWave.Free;
end;


//BGM----------------------------------------------------
procedure TForm1.BGMEnable(filename : string);
var
  aaa : string;
begin
  if (midi_ok = 1)then Exit;
  //BGMName := filename;
  if (BGMPlay = True)then BGMDisable;;
  if (BGMsound = 0)then
  begin
    case BGMMode of
     0 : begin
          aaa := filename + '.mid';
          if (FileExists(aaa) = True)then
          begin
           KBGMSendSysx(GS_RESET);           //oO```(^^//
           if (KBGMLoadFile(LPHDATA(MidiHandle),PChar(aaa)) <> KBGM_NOERROR)then STG1.ErrorCode := 255;
           KBGMInit(MidiHandle);
           if (KBGMPlay(MidiHandle,REP) <> KBGM_NOERROR)then STG1.ErrorCode := 255;
           BGMPlay := True;
           BGMPlayMode := 0;
          end;
         end;
     1 : begin
           //MP3
           BGMPlay := False;
           aaa := filename + '.mp3';
           if (FileExists(aaa) = False)then Exit;
           //if (midi_ok = 1)then Exit;
           if (MP3Player1.QueryOpen(aaa) = False)then Exit;
           //BGMName := aaa;
           //Play
           MP3Player1.FileName := aaa;
           MP3Player1.Play;
           BGMPlayMode := 1;
           BGMPlay := True;
         end;
     2 : begin
           BGMPlay := False;
           aaa := filename + '.wav';
           if (FileExists(aaa) = False)then Exit;
           BGMWave:=TDDSDWaveData.Create(DDSD1,aaa);
           DDSD1.Channels[8].WaveData:=BGMWave;
           DDSD1[8].Volume := 0;
           DDSD1[8].LoopPlay;
           BGMPlayMode := 2;
           BGMPlay := True;
         end;
    end;
  end;
end;

procedure TForm1.BGMDisable;
begin
  //BGMName := 'None';
  if (midi_ok = 1)then Exit;
  if (BGMPlay = True)then
  begin
    case BGMPlayMode of
      0 : begin
           KBGMStop;
           KBGMFree(MidiHandle);
          end;
      1 : MP3Player1.Stop;
      2 : DDSD1[8].STOP;
    end;
  end;
  BGMPlay := False;
end;

//f|^|k------------------------------------------------
procedure TForm1.DataLoad;
begin
  AL.FontName := 'lr SVbN';

  if (FileExists('bmp\Title.bmp') = False)then begin Close; exit; end;
  title := TDDDDSurFace.CreateOnSystemMemory(DD,300,600,0);
  title.LoadBMP('bmp\title.bmp');

  Alph1.GetPixelFormat(title);
  STG1.LoadEnemySetData;

  if (FileExists('bmp\select.bmp') = False)then Close;
  Select1 := TDDDDSurFace.CreateOnSystemMemory(DD,300,450,0);
  Select1.LoadBMP('bmp\select.bmp');

  STG1.EntryBank('bmp\player.bmp',50,50,7,3,0,true,true);
  //1...Bom
  STG1.EntryBank('bmp\bom.bmp',48,47,4,4,1,false,true);      //
  //2...ComShot
  STG1.EntryBank('bmp\comshot'+IntToStr(ShotColor+1)+'.bmp',16,16, 34,1 ,2,false,true);
  //3...MyShot
  STG1.EntryBank('bmp\myshot.bmp',8,24,6,1,3,false,true);
  //4...effect
  STG1.EntryBank('bmp\effect.bmp',8,8,18,1,4,false,true);
  //5...Naprm
  STG1.EntryBank('bmp\myshot2.bmp',48,48,16,1,5,false,false);
  //8...message
  STG1.EntryBank('bmp\mes1.bmp',300,50,1,10,8,false,false);
  //9...font
  STG1.EntryBank('bmp\font1.bmp',12,18,11,1,9,false,false);
  //29...destroy
  STG1.EntryBank('bmp\destroy.bmp',50,50,1,1,29,false,true);
  //28...messeage2
  STG1.EntryBank('bmp\font2.bmp',12,16,20,1,28,false,true);
  STG1.EntryBank('bmp\font3.bmp',8,8,20,1,27,false,true);
  //26..FlashBom
  STG1.EntryBank('bmp\bom2.bmp',128,128,5,3,26,false,false);
  //Laser
  STG1.EntryBank('bmp\comshot_ls.bmp',40,300,1,1,25,false,false);
  //L̊
  STG1.EntryBank('bmp\event2.bmp',80,80,1,1,24,false,false);

         //10...G1
  with STG1 do
  begin
   EntryBank('bmp\Enemy1.bmp',ESS.celWidth[0],ESS.celHeight[0],3,1,10,true,true);
         //11...G2
   EntryBank('bmp\Enemy2.bmp',ESS.celWidth[2],ESS.celHeight[2],5,1,11,true,true);
         //12...G3
   EntryBank('bmp\enemy3.bmp',ESS.celWidth[5],ESS.celHeight[5],7,1,12,true,true);
         //13...G4
  STG1.EntryBank('bmp\Enemy4.bmp',ESS.celWidth[6],ESS.celHeight[6],1,1,13,true,true);
         //14...G5 eY
  STG1.EntryBank('bmp\Enemy5.bmp',ESS.celWidth[7],ESS.celHeight[7],9,1,14,true,true);
         //15...G6 KXY
  STG1.EntryBank('bmp\Enemy6.bmp',ESS.celWidth[8],ESS.celHeight[8],9,1,15,true,true);
  //16...G7 
  STG1.EntryBank('bmp\Enemy7.bmp',ESS.celWidth[9],ESS.celHeight[9],9,1,16,true,true);
  //17...G8 C
  STG1.EntryBank('bmp\Enemy8.bmp',ESS.celWidth[10],ESS.celHeight[10],9,1,17,true,true);
  //18...G8 C
  STG1.EntryBank('bmp\Enemy9.bmp',ESS.celWidth[11],ESS.celHeight[11],9,1,18,true,true);
  //19...G8 C
  STG1.EntryBank('bmp\Enemy10.bmp',ESS.celWidth[12],ESS.celHeight[12],9,1,19,true,true);
  //20...G8 {X
  STG1.EntryBank('bmp\Enemy11.bmp',ESS.celWidth[13],ESS.celHeight[13],9,1,20,true,true);
  //񂷂G
  STG1.EntryBank('bmp\Enemy12.bmp',ESS.celWidth[15],ESS.celHeight[15],10,1,21,true,true);
  //^q
  STG1.EntryBank('bmp\Enemy13.bmp',ESS.celWidth[16],ESS.celHeight[16],10,1,22,true,true);
  //]C
  STG1.EntryBank('bmp\Enemy14.bmp',ESS.celWidth[17],ESS.celHeight[17],5,1,23,True,true);
  end;

  STG1.EntrySoundBank('se\bom4.wav',0,0);
  STG1.EntrySoundBank('se\bom5.wav',1,1);
  STG1.EntrySoundBank('se\bom6.wav',2,2);
  STG1.EntrySoundBank('se\bom7.wav',3,3);
  STG1.EntrySoundBank('se\shot5.wav',4,4);    //Myshot
  STG1.EntrySoundBank('se\shot3.wav',5,5);    //Enemy Boll
  STG1.EntrySoundBank('se\shot6.wav',6,6);    //Enemy LongBow
  STG1.EntrySoundBank('se\shot7.wav',7,7);    //Enemy BigBoll
  STG1.EntrySoundBank('se\shot8.wav',7,14);
  STG1.EntrySoundBank('se\warning2.wav',3,8);
  STG1.EntrySoundBank('se\decide1.wav',0,9);
  STG1.EntrySoundBank('se\decide2.wav',1,10);
  STG1.EntrySoundBank('se\Get1.wav',7,11);
  STG1.EntrySoundBank('se\1UP.wav',3,12);
  STG1.EntrySoundBank('se\ENS.wav',4,13);
  STG1.EntrySoundBank('se\laser2.wav',4,15);

  Level2 := 1;
  Level1 := 21;
  //tHǧ덷p
  Form1.ClientWidth  := 640;
  Form1.ClientHeight := 480;
end;

//Q|C|`----------------------------
procedure TForm1.GamePlay;
var
   aaa : integer;
begin
  inc(PlayFrm);
  //Đ
  if (SamplePlay = True)then
  begin
    aaa := PPD.PlayData[PlayFrm];
    if ((aaa and 2)  <> 0)then Key1.Up := True     else Key1.Up := False;
    if ((aaa and 4)  <> 0)then Key1.Right := True  else Key1.Right := False;
    if ((aaa and 8)  <> 0)then Key1.Left := True   else Key1.Left := False;
    if ((aaa and 16) <> 0)then Key1.Down := True   else Key1.Down := False;
    if ((aaa and 32) <> 0)then Key1.Trig1 := True  else Key1.Trig1 := False;
    if ((aaa and 64) <> 0)then Key1.PTrig2 := True else Key1.PTrig2 := False;
    if ((aaa and 128)<> 0)then Key1.PTrig3 := True else Key1.PTrig3 := False;
  end;
  //ĐI
  if ((PPD.PlayData[PlayFrm] = 255)and(SamplePlay = True))then       //II
    begin
      Level1 := 8;
      Level2 := 1;
      StageNo := 1;
      StageFile := 'stage1.stg';
      Key1.GetKey;
      SamplePlay := False;
      exit;
    end;

  //^
  if (PlayRec = True)then
  begin
    aaa := 0;
    if (PlayFrm > 89990)then PlayFrm := 89990;
    if (Key1.Up = True)then aaa := aaa or 2;
    if (Key1.Right = True)then aaa := aaa or 4;
    if (Key1.Left = True)then aaa := aaa or 8;
    if (Key1.Down = True)then aaa := aaa or 16;
    if (Key1.Trig1 = True)then aaa := aaa or 32;
    if (Key1.PTrig2 = True)then aaa := aaa or 64;
    if (Key1.PTrig3 = True)then aaa := aaa or 128;
    PPD.PlayData[PlayFrm] := aaa;
  end;

  //if ((GetAsyncKeyState($7A) and $8000) <> 0)then STG1.SkipStage;
  if ((GetAsyncKeyState($7B) and $8000) <> 0)then
     if(PlayREC = True)then
     begin
       if(StageSel = TRUE)then
       begin
         StageNo := StageNo + 10;
         PlayDataWrite;
         StageNo := StageNo - 10;
       end
       else PlayDataWrite;
     end;

  if (STG1.StageClear = True)then level1 := 16;

  if (STG1.PD[0].Empty = False)then begin CCount := 400; Level1 := 6; end;
  if ((STG1.BOD[0].Empty = true)and(STG1.MNo = 3))then      //BOSS BGM
  begin
    if (STG1.MCount = 150)then BGMDisable;
    if (STG1.MCount = 40 )then
      if (stageno = 5)then BGMEnable('bgm\boss2')
                      else BGMEnable('bgm\boss');
  end;
  if (STG1.PD[0].HP > 0)then PlayerSub;
  STG1.PlaySTG;
  STG1.Draw;
  if ((SamplePlay = True)and(GetTickCount and $3FF > 512))then
  begin
    STG1.DrawFont(80,250,'RETURN TO TITLE',3);
    STG1.DrawFont(80,262,'PUSH ESC KEY',3);
  end;
  //Đ\L
  if (PlayRec = True)then STG1.DrawFont(40,35,Format('REC%5d',[PlayFrm]),3);
  if (SamplePlay = True)then STG1.DrawFont(40,35,format('PLAY%5d',[PlayFrm]),3);
  if ((demoPlay = True)and(Level1 = 2))then STG1.DrawFont(150,110,'DEMONSTRATION',0);
  if ((demoplay = true)and(KEY1.AllTrig = true))then
  begin
       FedeOut;
       BGMDisable;
       Level2 := 1;
       level1 := 5;
       EntryFeedBack;
  end;
  //Mode
  if (NoHitMode = True)then STG1.DrawFont(50,25,'GOD MODE',3);

  ImageDraw;

end;
//(game->game)pݒ----------------------------

procedure TForm1.StageLoad;
begin
  FedeOut;
  PrintStageLogo;
  EntryFeedBack;
  BGMDisable;
  STG1.DataClear2;  //f|^|False
  //STG1.Drawfont(150,250,'STAGE DATA NOW LOADING',3);
  //ImageDraw;
  with STG1.PD[0] do
  begin
   HP  := 4;
   NoHit := 50; //G
   a2 := 0;
   x := 150;
   y := 200;
  end;
  stagefile := 'stage'+intToStr(StageNo)+'.stg';
  if (FileExists(stagefile) = False)then close;
  STG1.EntryStage(stagefile,StageNo);
  STG1.SetUpStage(10);
  STG1.LoadBoss('',StageNo);
  STG1.LoadPlayerMes('mes\stage'+IntToStr(StageNo)+'_'+IntToStr(STG1.PD[0].SelectNo)+'.txt');
  //BGM
  BGMEnable('bgm\stage'+IntToStr(StageNo));
  Level1 := 2;
  //Message

  //Flags
  STG1.BackESD := 0;
  STG1.BossFlash := 0;
  STG1.FlashCount := 0;
  STG1.BDCount := 0;
  STG1.PDCount := 0;
  DeleteShot := 0;
  AL.RndStep := 0;
  //ււ
  EntryFeedBack;
end;
//(Title->Game)pݒ----------------------------
procedure TForm1.GameStart;
begin
  with STG1.PD[0] do
  begin
   Empty := True;
   h1 := 0;    //蔻
   h2 := 0;
   h3 := 2;
   h4 := 2;
   hit := True;
   x  := 150;
   y  := 250;
   a1 := 0;    //X
   a2 := 0;    //SLP
   a3 := 0;    //eԊu̐
   score := 0;
   bom := 3;   //{
   PNo := 2;   //c@
   HP  := 4;
   NoHit := 50; //G
  end;
  STG1.PointScore := 100;
  STG1.PD[0].SLevel := 0; //Shot̋
  if (StageSel = True)then STG1.PD[0].SLevel := 65;
  STG1.DestroyEnemy := 0; //Itemoϐ
  StageLoad;
  PlayFrm := 0;           //PlayFrm
end;

//@ړEvC|---------------------------------------------
procedure TForm1.PlayerSub;           //SL
var
  ax1,ay1,asp : SmallInt;
  iii : Integer;
begin
  ax1 := 0; ay1 := 0; asp := STG1.PD[0].Speed1;
                                      //L|̔
  if (KEY1.Trig1 = True)then asp := STG1.PD[0].Speed2;
  if (KEY1.Left  = True)then ax1 := ax1 - 1;
  if (KEY1.Right = True)then ax1 := ax1 + 1;
  if (KEY1.Up    = True)then ay1 := ay1 - 1;
  if (KEY1.Down  = True)then ay1 := ay1 + 1;
  STG1.PD[0].a1 := STG1.PD[0].a1 + ax1*2;
  if (STG1.PD[0].a1 <> 0)then STG1.PD[0].a1 := STG1.PD[0].a1 - abs(STG1.PD[0].a1) div STG1.PD[0].a1;
  if (STG1.PD[0].a1 < -9)then STG1.PD[0].a1 := -9;
  if (STG1.PD[0].a1 >  9)then STG1.PD[0].a1 :=  9;
  
  if ((ax1<>0)and(ay1<>0))then        //΂߈ړ͈ړʂȂ
   begin
    STG1.PD[0].x := STG1.PD[0].x + ax1*round(asp/1.3);
    STG1.PD[0].y := STG1.PD[0].y + ay1*round(asp/1.3);
   end
  else
   begin
    STG1.PD[0].x := STG1.PD[0].x + ax1*asp;
    STG1.PD[0].y := STG1.PD[0].y + ay1*asp;
   end;
                                      //ʊOoĂ܂
  if (STG1.PD[0].x > 290)then STG1.PD[0].x := 290;
  if (STG1.PD[0].x < 10) then STG1.PD[0].x := 10;
  if (STG1.PD[0].y > 290)then STG1.PD[0].y := 290;
  if (STG1.PD[0].y < 10) then STG1.PD[0].y := 10;

  if (STG1.PD[0].SelectNo < 2)then           //0&1
  begin
                                      //e̔ˊԊutO
   STG1.PD[0].a2 := STG1.PD[0].a2 + 1;
   if (STG1.PD[0].a2 > 153)then STG1.PD[0].a2 := 153;
   STG1.PD[0].a3 := STG1.PD[0].a3 - 1;
   if (STG1.PD[0].a3 < 0)then STG1.PD[0].a3 := 0;
                                      //ʏě
   if (STG1.PD[0].a3 = 0)then
    if ((KEY1.Trig1 = True) and (STG1.PD[0].a2 > 3))then
    begin
     STG1.EntrySound(4);
     STG1.PD[0].a3 := 3;
     STG1.PD[0].a2 := STG1.PD[0].a2 - 2;
     STG1.EntryEffect(STG1.PD[0].x-12,STG1.PD[0].y-12,0,0,6);
     STG1.EntryEffect(STG1.PD[0].x+12,STG1.PD[0].y-12,0,0,6);
     AttackShot;
    end;
  end
  else
  begin
   STG1.PD[0].a2 := STG1.PD[0].a2 + 1;
   if (STG1.PD[0].a2 > 153)then STG1.PD[0].a2 := 153;
   //|U|
   if (KEY1.Trig1 = True)then
    begin
     STG1.EntrySound(15);
     AttackShot;
    end;
  end;

                                      //uip|܂v̉o
  if (STG1.PD[0].a2 mod 50 = 0)then
  begin
    STG1.EntryEffect(STG1.PD[0].a2 div 2 + 20,291,0,0,3);
    //STG1.EntryEffect(STG1.PD[0].x,STG1.PD[0].y,0,0,2);
  end;
                                      //ip|̌
  if ((KEY1.PTrig2 = True) and (STG1.PD[0].a2 > 50))then
  begin
   STG1.PD[0].a2 := STG1.PD[0].a2 - 50;
   STG1.EntrySound(13);
   AttackENS;
  end;
                                      //LPII{ˁII
  if ((KEY1.PTrig3 = True) and (STG1.PD[0].BOM > 0))then   //BOM
  begin
   STG1.PD[0].NoHit := 60;
   //STG1.EnemyShotClear;
   for iii := 0 to 200 do
     if not(STG1.ESD[iii].kind = 5)then STG1.ESD[iii].empty := False;

   STG1.PD[0].BOM := STG1.PD[0].BOM - 1;
   STG1.EntrySound(2);
   AttackBom;
   DeleteShot := 30;
  end;

  //e
  if (DeleteShot > 0)then dec(DeleteShot);
  if (DeleteShot > 0)then
    for iii := 0 to 200 do
     if not(STG1.ESD[iii].kind = 5)then STG1.ESD[iii].empty := False;

  //蔻
  if ((STG1.PlayerHit = True)and(STG1.PD[0].NoHit = 0))then
   begin
    //Sleep(1500);
    STG1.EntryBom(STG1.PD[0].x,STG1.PD[0].y,0,0,9);
    STG1.EntryBom(STG1.PD[0].x,STG1.PD[0].y,0,0,1);
    STG1.PD[0].NoHit := 100;
    if (NoHitMode = False)then STG1.PD[0].HP := STG1.PD[0].HP - 1;
   end;
end;

//vC|Vbg--------------------------------------
procedure TForm1.AttackShot;
begin
  with STG1.PD[0] do
   case(SelectNo) of
    0 : begin
        case (SLevel div 20) of
         0 : begin                           //qdc khfgsmhmf
             STG1.EntryPlayerShot(x-10,y-7,-1,-20,  0,-10,2,10, 2, 9);
             STG1.EntryPlayerShot(x+10,y-7,1,-20,   0,-10,2,10, 2, 9);
             end;
         1 : begin
             STG1.EntryPlayerShot(x-10,y-7,-2,-20,  0,-10,2,10, 2, 6);
             STG1.EntryPlayerShot(x   ,y-7,0,-20,   0,-10,2,10, 2, 8);
             STG1.EntryPlayerShot(x+10,y-7,2,-20,   0,-10,2,10, 2, 6);
             end;
         2 : begin
             STG1.EntryPlayerShot(x-8,y-7,0,-20,   0,-10,2,10, 2, 8);
             STG1.EntryPlayerShot(x+8,y-7,0,-20,   0,-10,2,10, 2, 8);
             STG1.EntryPlayerShot(x+10,y-7,3,-17,  0,-10,2,10, 3, 4);
             STG1.EntryPlayerShot(x-10,y-7,-3,-17, 0,-10,2,10, 1, 4);
             end;
         3 : begin
             STG1.EntryPlayerShot(x-10,y-7,-1,-20,   0,-10,2,10, 2, 4);
             STG1.EntryPlayerShot(x   ,y-7,0,-20,    0,-10,2,10, 2, 8);
             STG1.EntryPlayerShot(x+10,y-7,1,-20,    0,-10,2,10, 2, 4);
             STG1.EntryPlayerShot(x+10,y-7,3,-17,    0,-10,2,10, 3, 4);
             STG1.EntryPlayerShot(x-10,y-7,-3,-17,   0,-10,2,10, 1, 4);
             end;
        end;
        end;
    1 : begin
        case (SLevel div 20) of
         0 : begin                          //enqbd ahqc
             STG1.EntryPlayerShot(x-10,y-7,-1,-20,  0,-10,2,10, 2, 9);
             STG1.EntryPlayerShot(x+10,y-7,1,-20,   0,-10,2,10, 2, 9);
             end;
         1 : begin
             STG1.EntryPlayerShot(x-10,y-7,-3,-20,  0,-10,2,10, 2, 6);
             STG1.EntryPlayerShot(x   ,y-7,0,-20,  0,-10,2,10, 2, 8);
             STG1.EntryPlayerShot(x+10,y-7,3,-20,  0,-10,2,10, 2, 6);
             end;
         2 : begin
             STG1.EntryPlayerShot(x-8,y-7,-1,-20,  0,-10,2,10, 2, 8);
             STG1.EntryPlayerShot(x+8,y-7,1 ,-20,  0,-10,2,10, 2, 8);
             STG1.EntryPlayerShot(x+10,y-7,5,-17, 0,-10,2,10, 3, 4);
             STG1.EntryPlayerShot(x-10,y-7,-5,-17,0,-10,2,10, 1, 4);
             end;
         3 : begin
             STG1.EntryPlayerShot(x-10,y-7,-3,-20,  0,-10,2,10, 2, 4);
             STG1.EntryPlayerShot(x   ,y-7,0,-20,  0,-10,2,10, 2, 8);
             STG1.EntryPlayerShot(x+10,y-7,3,-20,  0,-10,2,10, 2, 4);
             STG1.EntryPlayerShot(x+10,y-7,7,-17, 0,-10,2,10, 3, 4);
             STG1.EntryPlayerShot(x-10,y-7,-7,-17,0,-10,2,10, 1, 4);
             end;
         end;
         end;

     2 : begin
         case (SLevel div 20) of
         0,1 : begin                          //MeTA
              STG1.EntryPlayerShot(x,(y-14) div 2,0,0,
                                   0,0,40,y, 10, 3);
             end;
         2 : begin
              STG1.EntryPlayerShot(x,(y-14) div 2,0,0,
                                   0,0,40,y, 10, 4);
             end;
         3 : begin
              STG1.EntryPlayerShot(x,(y-14) div 2,0,0,
                                   0,0,40,y, 10, 5);
             end;
        end;
        end;
   end;

end;

procedure TForm1.AttackENS;
begin
  with STG1.PD[0] do
   case SelectNo of
     0,2 : begin
         STG1.EntryPlayerShot(x-10,y-15,-3,-9, 0,0,45,45, 4, 4);
         STG1.EntryPlayerShot(x+10,y-15,3,-9,  0,0,45,45, 4, 4);
         end;
     1 : begin
         STG1.EntryPlayerShot(x-10,y-15,-4,-11, 0,0,45,45, 4, 4);
         STG1.EntryPlayerShot(x+10,y-15, 4,-11, 0,0,45,45, 4, 4);
         end;
   end;
end;

procedure TForm1.AttackBom;
var
  iii : Integer;
begin
  with STG1.PD[0] do
   case SelectNo of
     0 : begin
         for iii := 1 to 9 do
          begin
           STG1.EntryPlayerShot(x,y-iii*45-40,0,0, 0,0,45,45, 4, 3);
           STG1.EntryPlayerShot(x+iii*20,y-iii*35,0,0, 0,0,45,45, 4, 3);
           STG1.EntryPlayerShot(x-iii*20,y-iii*35,0,0, 0,0,45,45, 4, 3);
          end;
         end;
     1 : begin
         for iii := 0 to 12 do
          begin
           STG1.EntryPlayerShot(x+AL.SinT2(iii*120) div 18,y-iii*25,0,0, 0,0,45,45, 4, 3);
           STG1.EntryPlayerShot(x-AL.SinT2(iii*120) div 18,y-iii*25,0,0, 0,0,45,45, 4, 3);
          end;
         end;
     2 : begin
         for iii := 0 to 7 do
          begin
           STG1.EntryPlayerShot(x+AL.SinT2(iii*128+42) div 17,y-40+AL.CosT2(iii*128+42) div 17,0,0, 0,0,45,45, 4, 3);
           STG1.EntryPlayerShot(x+AL.SinT2(iii*128+84) div 12,y-40+AL.CosT2(iii*128+84) div 12,0,0, 0,0,45,45, 4, 3);
           STG1.EntryPlayerShot(x+AL.SinT2(iii*128+0 ) div 24,y-40+AL.CosT2(iii*128+0 ) div 24,0,0, 0,0,45,45, 4, 4);
           //STG1.EntryPlayerShot(x+AL.SinT2(iii*128) div 12,y-40+AL.CosT2(iii*128) div 12,0,0, 0,0,45,45, 4, 4);
          end;
         end;
  end;
end;

procedure TForm1.Imagedraw2;
var
  fx : DDBLTFX;
  rc1,rc2,rc3,rc4 : Trect;
  p : TPoint;
begin
  ZeroMemory(@fx,sizeof(DDBLTFX)); //ʂ̓iVȂ̂ŁA0Ŗ
  fx.dwSize:=sizeof(DDBLTFX);      //łAdwSize͓ĂKv

  rc1 := rect(95,15,545,465);         //Windows2000łBLT߂œ{]͏oȂ݂
  rc2 := rect(0,0,300,300);           //̂ŁA]̈c+1Pixel邱Ƃ
  rc3 := rect(170,90,470,390);        //EEEȂ
  rc4 := rect(0,0,450,450);

  case BltMode of
       0 : begin
                if (FullScreenMode = true)then
                  DDDD1.FrontBuffer.Surface.Blt(@rc3,STG1.BackBuf.Surface,@rc2,DDBLT_WAIT,@fx)
                else
                begin
                     STG1.BackBuf.PutFast(170,90,rect(0,0,300,300),
                                          DDBLTFAST_WAIT or DDBLTFAST_NOCOLORKEY);
                     DDDD1.Flip;
                end;
           end;
       1 : begin
                if (FullScreenMode = true)then
                  DDDD1.FrontBuffer.Surface.Blt(@rc1,STG1.BackBuf.Surface,@rc2,DDBLT_WAIT,@fx)
                else
                begin
                     DDDD1.BackBuffer.Blt(STG1.BackBuf,rect(0,0,300,300),
                                          rect(0,0,300,300),DDBLT_WAIT,fx);
                     p := Form1.ClientToScreen(Point(0,0));
                     rc1 := Form1.ClientRect;
                     with rc1 do
                     begin
                       Left  := 95 * Right  div 640;
                       Top   := 15 * Bottom div 480;
                       Right := 545* Right  div 640;
                       Bottom:= 465* Bottom div 480;
                       Inc(Left,p.X);
                       Inc(Right,p.X);
                       Inc(Top,p.Y);
                       Inc(Bottom,p.Y);
                     end;
                     DDDD1.FrontBuffer.Surface.Blt(@rc1,DDDD1.BackBuffer.surface,@rc2,DDBLT_WAIT,@fx);
                     //DDDD1.BackBuffer.Blt(STG1.BackBuf,rect(95,15,545,465),
                     //                     rect(0,0,300,300),DDBLT_WAIT,fx);
                     //DDDD1.Flip;
                end;
           end;
       2 : begin
                STG1.TempBuf.Blt(STG1.BackBuf,rect(0,0,450,450),
                                 rect(0,0,300,300),DDBLT_WAIT,fx);
                if (FullScreenMode = true)then
                  DDDD1.FrontBuffer.Surface.Blt(@rc1,STG1.TempBuf.Surface,@rc4,DDBLT_WAIT,@fx)
                else
                begin
                     STG1.TempBuf.PutFast(95,15,rect(0,0,450,450),
                                          DDBLTFAST_WAIT or DDBLTFAST_NOCOLORKEY);
                     DDDD1.Flip;
                end;
           end;
  end;

end;

//-----------------------------------------
procedure TForm1.ImageDraw;
begin
  //FRM
  if (GetTickCount and $3FF > 512)then
    STG1.DrawFont(270,22,'FPSx'+IntToStr(Frame2),3);

  DrawFeedBack;

  ImageDraw2;
end;

//-----------------------------------------

procedure TForm1.GamePause;
begin
  STG1.Draw;
  if (Key1.PUp = true)then cy := cy - 1;
  if (key1.Pdown = true)then cy := cy + 1;
  if ((Key1.PUp or key1.Pdown) = true)then STG1.EntrySound(10);
  if (cy > 4)then cy := 4;
  if (cy < 0)then cy := 0;

  AL.BlendRect(STG1.BackBuf,rect(25,100,275,270),AL.RGB24TO16($000000),BM_NORMAL);
  STG1.DrawFont(150,115,'GAME PAUSE',2);
  STG1.DrawFont(150,170,'CONTINUE',0);
  STG1.DrawFont(150,190,'RETURN TO MENU',0);
  STG1.DrawFont(150,210,'BGM REPLAY',0);
  STG1.DrawFont(150,230,'SCREEN MODE '+ans[BltMode+5],0);
  STG1.DrawFont(150,250,'SHOT WAIT   '+ans[SlowWait],0);
  AL.BlendRect(STG1.BackBuf,rect(25,160+cy*20,275,180+cy*20),AL.RGB24TO16($FF0000),BM_SCREEN);

  if ((Key1.PTrig1)or(Key1.PTrig2)or(Key1.PTrig3))then
    case cy of
     0 : begin
          Level2 := 1;
          Level1 := 2;
         end;
     1 : begin
          FedeOut;
          BGMDisable;
          Level2 := 1;
          level1 := 5;
          EntryFeedBack;
         end;
     2 : begin
          BGMDisable;
          BGMEnable(BGMName);
         end;
     3 : begin
          BltMode := (BltMode + 1) mod 3;
          DDDD1.Clear;
          DDDD1.Flip;
          DDDD1.Clear;
          DDDD1.Flip;
         end;
     4 : begin
          SlowWait := (SlowWait + 1) mod 2;
         end;
    end;

  ImageDraw;
end;

//^Cgj|-----------------------
procedure TForm1.TitleMenu;
begin
  if (level2 = 1)then
  begin
    STG1.MuteSound;
    BGMEnable('bgm\title');
    level2 := 0; cy := 0;cx := 0;
    StageNo := 1;StageFile := 'stage1.stg';
    PlayFrm := 0; PlayRec := False;
    SamplePlay := False;
    stg1.dif := diffcult;
    NoHitMode := False;
    TitleCount := 0;
    DemoPlay := False;
    STG1.InitFPScounter;
  end;

  STG1.PutBackFace(title,0,0,rect(0,0,300,300),1);

  //if ((GetAsyncKeyState($52) and $8000) <> 0) then Level1 := 22;

  if (Key1.PUp = true)then cy := cy - 1;
  if (key1.Pdown = true)then cy := cy + 1;
  if ((Key1.PUp or key1.Pdown) = true)then
    begin cx := 0; STG1.EntrySound(10); titlecount := 0;end;
  if (cy > 6)then cy := 6;
  if (cy < 0)then cy := 0;

  AL.AlphaBlendRect(STG1.BackBuf,rect(80,170,220,280),$000000,128,BM_NORMAL);
  STG1.DrawFont(250,295,'FINAL VERSION 3',3);
  //if (AL.PixelFormat = PF_555)then STG1.DrawFont(250,285,'PIXELFORMAT 555',3)
  //                            else STG1.DrawFont(250,285,'PIXELFORMAT 565',3);
  STG1.DrawFont(240,285,'PRESENTED BY KO-TA',3);
  //start/Diff/SE/BGM/Exit/HIsco                        

  STG1.DrawFont(150,180,'MAIN GAME',3);
  STG1.DrawFont(150,195,'STAGE SELECT',3);
  STG1.DrawFont(150,210,'SCORE RANKING',3);
  STG1.DrawFont(150,225,'REPLAY MODE',3);
  STG1.DrawFont(150,240,'CONFIG',3);
  STG1.DrawFont(150,255,'BGM PLAYER',3);
  STG1.DrawFont(150,270,'EXIT GAME',3);
  AL.BlendRect(STG1.BackBuf,rect(80,175+cy*15,220,185+cy*15),AL.RGB24TO16($FF0000),BM_SCREEN);

  if ((Key1.Ptrig1 or Key1.Ptrig2 or Key1.Ptrig3)=True)then
  begin
   cx := 0;
   case cy of
    0 : begin              //Main Game
         STG1.EntrySound(9);
         STG1.PlaySE;
         Level1 := 17;
         Level2 := 1;
         STG1.Dif := Diffcult - 1;
         STG1.PD[0].score := 0;
         FedeOut;
         StageSel := False;
         NormalPlay := true;
         PlayRec := False;
         EntryFeedBack;
        end;
    1 : begin              //Stage Select
         STG1.EntrySound(9);
         STG1.PlaySE;
         Level1 := 20;
         Level2 := 1;
         STG1.Dif := Diffcult - 1;
         STG1.PD[0].score := 0;
         FedeOut;
         StageSel := True;
         PlayRec := False;
         NormalPlay := True;
         EntryFeedBack;
        end;
    2 : begin
         Level1 := 9;
         EntryFeedback;
         STG1.EntrySound(9);
         STG1.PlaySE;
        end;
    3 : begin              //SamplePlay
         STG1.EntrySound(9);
         STG1.PlaySE;
         FedeOut;
         SamplePlay := True;
         PlayRec := False;
         StageSel := False;
         NormalPlay := False;
         level1 := 15;
         level2 := 1;
         EntryFeedBack;
        end;
    4 : begin
         STG1.EntrySound(9);
         STG1.PlaySE;
         Level1 := 11;
         cy := 0;
         EntryFeedBack;
        end;
    5 : begin
         STG1.EntrySound(9);
         STG1.PlaySE;
         Level1 := 14;
         Level2 := 1;
         EntryFeedBack;
        end;
    6 : begin
         FedeOut;
         Level1 := 255;
         STG1.ErrorCode := 255;
         exit;
        end;
   end;
  end;

  inc(TitleCount);
  if (TitleCount > 500)then
  begin
    //Level2 := 1;
    //Level1 := 21;
    DemoPlay := True;
    SamplePlay := True;
    PlayRec := False;
    StageSel := False;
    NormalPlay := False;
    //
    stg1.LoadPlayData('Demo.PDF',ppd);
    StageNo := 1;
    StageFile :='Stage1.stg';
    PlayFrm := 0;
    STG1.Dif := PPD.Dif;
    STG1.PD[0].score := 0;
    case PPD.playerType of       //@
      0 : begin
            STG1.PD[0].Speed1 := 5;
            STG1.PD[0].Speed2 := 4;
          end;
      1 : begin
            STG1.PD[0].Speed1 := 7;
            STG1.PD[0].Speed2 := 5;
          end;
      2 : begin
            STG1.PD[0].Speed1 := 5;
            STG1.PD[0].Speed2 := 5;
          end;
    end;
    STG1.PD[0].SelectNo := PPD.Playertype;
    Level1 := 1;
    Level2 := 1;
  end;

  ImageDraw;
end;

procedure TForm1.Continue;
begin
  STG1.Draw;
  if (PlayRec = True)then
  begin
    PlayRec := False;
    if (StageSel = TRUE)then
    begin
      StageNo := StageNo + 10;
      PlayDataWrite;
    end
    else PlayDataWrite;
  end;
  TMesCount := (TMesCount + 5) mod 300;
  //AL.BlendRect(STG1.BackBuf,rect(0,125,300,175),$000000,BM_NORMAL);
  STG1.DrawBank(TMesCount-150,150,1,5,8,4);
  STG1.DrawBank(TMesCount+150,150,1,5,8,4);


  AL.AlphaBlendRect(STG1.BackBuf,rect(50,200,250,270),$000000,180,BM_NORMAL);
  STG1.DrawFont(150,220,'CONTINUE',0);
  STG1.DrawFONT(150,250,'GIVE UP GAME',0);
  if((key1.Pup or key1.Pdown) = True)then cy := (cy + 1) mod 2;
  if((key1.Pup or key1.Pdown) = True)then STG1.EntrySound(10);
  AL.BlendRect(STG1.BackBuf,rect(50,210+cy*30,250,230+cy*30),AL.RGB24TO16($FF0000),BM_SCREEN);
  ImageDraw;
  if ((KEY1.PTrig1 or Key1.PTrig2 or Key1.PTrig3) = True)then
   case cy of
     0 : begin
         if (StageSel = False)then HiScoreCheck;
         with STG1.PD[0] do
         begin
          Empty := True;
          x  := 150;
          y  := 250;
          a1 := 0;    //X
          a2 := 150;    //SLP
          a3 := 0;    //eԊu̐
          SLevel := 65;  //ShotLevel
          score := 0;
          bom := 3;   //{
          PNo := 2;   //c@
          HP  := 4;
          NoHit := 80; //G
         end;
         Level1 := 2;
         Level2 := 1;
         cy := 0;
         EntryFeedBack;
         end;

     1 : begin
         cy := 0;
         Level1 := 8;
         if (StageSel = False)then HiScoreCheck;
         end;
   end;


end;

procedure TForm1.GameOver;
begin
  BGMDisable;
  STG1.Draw;
  AL.BlendRect(STG1.BackBuf,rect(0,125,300,175),$000000,BM_NORMAL);
  AL.AlphaBlend(STG1.BackBuf,0,125,STG1.IB[8].img,rect(0,0,300,50),random(125)+130,BM_SCREEN);
  ImageDraw;
  if (((KEY1.PTrig1 or Key1.PTrig2 or Key1.PTrig3) = True)or(DemoPlay = True))then
  begin
    Level2 := 1;
    Level1 := 5;
    FedeOut;
    EntryFeedBack;
  end;
end;

procedure TForm1.HiScoreCheck;
var
  iii,aaa : Integer;
begin
  with STG1 do
  begin
  aaa := 10;
  for iii := 0 to 8 do
    if (SCR.Score[DIF+1][8-iii] < PD[0].score)then aaa := 8-iii+1;
  if (aaa < 9)then
   for iii := 0 to 8-aaa do
   begin
     SCR.score[DIF+1][8-iii] := SCR.score[DIF+1][7-iii];
     SCR.Name[DIF+1][8-iii] := SCR.Name[DIF+1][7-iii];
     SCR.PlayType[DIF+1][8-iii] := SCR.PlayType[DIF+1][7-iii];
     SCR.Stage[DIF+1][8-iii] := SCR.Stage[DIF+1][7-iii];
   end;
  SCR.score[DIF+1][aaa-1] := PD[0].score;
  SCR.Name[DIF+1][aaa-1] := PD[0].Name;
  SCR.PlayType[DIF+1][aaa-1] := PD[0].SelectNo;  //PlayType
  SCR.Stage[DIF+1][aaa-1] := STG1.StageNo;
  end;
end;

procedure TForm1.ScoreRanking;
var
  iii,jjj,aaa : Integer;
begin
  STG1.Clear;
  STG1.BackBuf.BltFast(Title,0,0,rect(0,300,300,600),0);
  //STG1.DrawFont(150,20,'(HI SCORE RANKING)',1);
  STG1.DrawFont(152,22,'(HI SCORE RANKING)',0);
  case Level2 of
    0 : STG1.DrawFont(150,40,'EASY',2);
    1 : STG1.DrawFont(150,40,'NORMAL',2);
    2 : STG1.DrawFont(150,40,'HARD',2);
  end;
  for iii := 0 to 8 do
  begin
   STG1.DrawFont(30,70+iii*25,IntToStr(iii+1),0);
   STG1.DrawFont(70,70+iii*25,STG1.SCR.name[Level2,iii],0);
   STG1.DrawFont(240,70+iii*25,'STAGE '+IntToStr(STG1.SCR.Stage[Level2,iii]),3);
   STG1.DrawBank(280,70+iii*25,STG1.SCR.PlayType[Level2,iii]+1,3,9,0);
   for jjj := 0 to 6 do
   begin
    aaa := (STG1.SCR.score[Level2][iii] div trunc(power(10,jjj))) mod 10;
    if (jjj > 3)then STG1.DrawBank(185-jjj*12,70+iii*25,aaa+1,2,9,0)
                else STG1.DrawBank(185-jjj*12,70+iii*25,aaa+1,1,9,0);
   end;
  end;
  ImageDraw;

  if ((KEY1.PTrig1 or Key1.PTrig2 or Key1.PTrig3) = True)then
  begin
    Level2 := Level2 + 1;
    STG1.EntrySound(9);
    if (Level2 = 3)then begin Level2 := 0; Level1 := 5; EntryFeedBack; end;
  end;
end;

//Ver Disp
procedure TForm1.VerDisp;
var
  Loading : TDDDDSurface;
begin
  Loading := TDDDDSurface.CreateOnSystemMemory(DD,200,32,0);
  Loading.LoadBMP('bmp\load.bmp');
  DD.Clear;
  DD.Flip;
  DD.Clear;
  Loading.PutFast(220,180,rect(0,0,200,32),DDBLTFAST_NOCOLORKEY);
  DD.Flip;
  Loading.free;
end;

//Config
procedure TForm1.Config;
var
  iii,jjj : Integer;
  tcol : array[0..12] of Byte;
begin
  STG1.Clear;
  STG1.BackBuf.BltFast(Title,0,0,rect(0,300,300,600),0);
  for iii := 0 to 12 do tcol[iii] := 1;
  if (Key1.PUp = true)then cy := cy - 1;
  if (key1.Pdown = true)then cy := cy + 1;
  if ((Key1.PUp or key1.Pdown) = true)then STG1.EntrySound(10);
  if (cy > 10)then cy := 10;
  if (cy < 0)then cy := 0;

  tcol[cy] := 0;
  //STG1.DrawFont(150,15,'CONFIG',1);
  STG1.DrawFont(152,12,'CONFIG',0);

  STG1.DrawFont(150,50,'RETURN TO MENU',tcol[0]);
  STG1.DrawFont(100,70,'GAME LEVEL',tcol[1]);
  STG1.DrawFont(250,70,ans[Diffcult+2],2);
  STG1.DrawFont(100,90,'SCREEN MODE',tcol[2]);
  STG1.DrawFont(250,90,ans[BltMode+5],2);
  STG1.DrawFont(100,110,'SE SOUND',tcol[3]);
  STG1.DrawFont(250,110,ans[STG1.SEOff],2);
  STG1.DrawFont(100,130,'BGM SOUND',tcol[4]);
  STG1.DrawFont(250,130,ans[BGMSound],2);
  STG1.DrawFont(100,150,'WAVE VOLUME',tcol[5]);
  STG1.DrawFont(250,150,IntToStr((10-STG1.WaveVolume)*10)+'%',2);
  STG1.DrawFont(100,170,'SHOT WAIT',tcol[6]);
  STG1.DrawFont(250,170,ans[SlowWait],2);
  STG1.DrawFont(100,190,'BACK GROUND',tcol[7]);
  STG1.DrawFont(250,190,ans[STG1.BackCut],2);
  STG1.DrawFont(100,210,'EDIT WAIT',tcol[8]);
  if (EditWait <> 9)then STG1.DrawFont(250,210,IntToStr(EditWait-5),2)
                    else STG1.DrawFont(250,210,'NO WAIT',2);
  STG1.DrawFont(100,230,'SHOT COLOR',tcol[9]);
  STG1.DrawFont(250,230,ans[ShotColor+11],2);
  STG1.DrawFont(100,250,'BGM SELECT',tcol[10]);
  STG1.DrawFont(250,250,ans[BGMMode+14],2);
  //STG1.DrawFont(150,280,'HISCORE DELETE',tcol[11]);
  for iii := 0 to 14 do
  begin
    AL.AlphaBlendRect(STG1.BackBuf,rect(iii*10,40+cy*20,iii*10+10,60+cy*20),AL.RGB24TO16($FF0000),255-iii*15,BM_SCREEN);
    AL.AlphaBlendRect(STG1.BackBuf,rect(290-iii*10,40+cy*20,300-iii*10,60+cy*20),AL.RGB24TO16($FF0000),255-iii*15,BM_SCREEN);
  end;

  if ((Key1.Ptrig1 or Key1.Ptrig2 or Key1.Ptrig3)=True)then
  begin
   STG1.EntrySound(9);
   case cy of
    0 : begin
        CY := 4;
        Level1 := 5;
        EntryFeedBack;
        end;
    1 : Diffcult := (diffcult + 1) mod 3;
    2 : begin
        BltMode := (BltMode + 1) mod 3;
        DDDD1.Clear;
        DDDD1.Flip;
        DDDD1.Clear;
        DDDD1.Flip;
        end;
    3 : STG1.SEOff  := (STG1.SEOff  + 1) mod 2;
    4 : begin
         BGMSound  := (BGMSound  + 1) mod 2;
         BGMDisable;
         BGMEnable('bgm\title');
        end;
    5 : STG1.WaveVolume := (STG1.WaveVolume + 1) mod 10;
    6 : SlowWait := (SlowWait + 1) mod 2;
    7 : STG1.BackCut := (STG1.BackCut + 1) mod 2;
    8 : Editwait := (Editwait + 1) mod 10;
    9: begin
         ShotColor := (ShotColor + 1) mod 3;
         if (FileExists('bmp\comshot'+IntToStr(ShotColor+1)+'.bmp') = true)then
           STG1.EntryBank('bmp\comshot'+IntToStr(ShotColor+1)+'.bmp',16,16, 34,1 ,2,false,true);
        end;
    10 :begin
         BGMMode := (BGMMode + 1) mod 3;
         BGMEnable('bgm\title');
        end;
    11: begin
         STG1.EntrySound(3);
         for iii := 0 to 5 do
          for jjj := 0 to 9 do
          begin
           STG1.SCR.score[iii,jjj] := 0;
           STG1.SCR.Name[iii,jjj] := 'XXX';
           STG1.SCR.PlayType[iii,jjj] := 1;
           STG1.SCR.Stage[iii,jjj] := 0;
          end;
        end;
   end;
  end;

  ImageDraw;
end;

//---LZNg
procedure TForm1.Select;
begin
  if (level2 = 1)then
  begin
    level2 := 0;
    cy := 0;
    cx := 10;
    SecCount := 0;
    SecCount2:= 2;   //@̂̐iŏ2ABo3j
  end;

  STG1.BackBuf.BltFast(Title,0,0,rect(0,300,300,600),0);
  Flag1 := (Flag1 + 1) mod 40;
  //STG1.WaveDraw(rect(0,25,300,75),abs(10 - Flag1 div 2));

  if (Key1.Pup = True)then
  begin
    cy := (cy + 1) mod SecCount2;
    SecCount := SecCount + 1;
  end;
  if (SecCount > 3)then SecCount2 := 3;  //B@̏oI
  if (Key1.PDown = True)then cy := (cy - 1 + SecCount2) mod SecCount2;
  if ((Key1.PUp or key1.Pdown) = true)then
    begin STG1.EntrySound(10); cx := 10; end;
  if (cx > 0)then cx := cx - 1;

  //L摜
  TMesCount := (TMesCount + 4) mod 300;
  STG1.DrawBank(TMesCount-150,50,1,4,8,4);
  STG1.DrawBank(TMesCount+150,50,1,4,8,4);

  STG1.DrawFont(150,270,'SELECT PLAY CHARACTER',3);
  AL.BlendRect(STG1.BackBuf,rect(0,100,300,250),0,BM_NORMAL);
  Al.Blend(STG1.BackBuf,0,100,Select1,rect(0,cy*150,300,cy*150+150),BM_SCREEN);
  if (cx > 0)then Alph1.WindNoise(STG1.BackBuf,rect(0,100,300,250),cx*10);
  if ((GetTickCount div 500) mod 2 = 1)then
  begin
    STG1.DrawBank(150,90,7,3,9,0);
    STG1.DrawBank(150,260,8,3,9,0);
  end;

  if ((Key1.Ptrig1 or Key1.Ptrig2 or Key1.Ptrig3)=True)then
    case cy of
      0 : begin
          STG1.PD[0].Speed1 := 5;
          STG1.PD[0].Speed2 := 4;
          STG1.PD[0].SelectNo := 0;
          cy := 0;
          Level1 := 1;
          Level2 := 1;
          end;
      1 : begin
          STG1.PD[0].Speed1 := 7;
          STG1.PD[0].Speed2 := 5;
          STG1.PD[0].SelectNo := 1;
          cy := 0;
          Level1 := 1;
          Level2 := 1;
          end;
      2 : begin
          STG1.PD[0].Speed1 := 5;
          STG1.PD[0].Speed2 := 5;
          STG1.PD[0].SelectNo := 2;
          cy := 0;
          Level1 := 1;
          Level2 := 1;
          end;
    end;
  if(((GetAsyncKeyState($10) and $8000) <> 0)and(PlayRec = False))
                                            then NoHitMode := True
                                            else NoHitMode := False;
  ImageDraw
end;


procedure TForm1.FedeOut;
var
  iii,jjj,xxx,yyy : Integer;
  Tile : array[0..5,0..5] of Byte;
  fx:DDBLTFX;
  rc : TRect;
  TempTime : LongInt;
begin
  STG1.MuteSound;
  ZeroMemory(@fx,sizeof(DDBLTFX));
  fx.dwFillColor := 0;
  fx.dwSize:=sizeof(DDBLTFX);

  for iii := 0 to 5 do
   for jjj := 0 to 5 do
    Tile[jjj,iii] := 0;

  for iii := 0 to 24+16 do
  begin
   TempTime := GetTickCount;
   if (iii < 25)then
   begin
     xxx := random(5);
     yyy := random(5);
     while(tile[xxx,yyy] > 0)do
     begin
      xxx := random(5);
      yyy := random(5);
     end;
     tile[xxx,yyy] := 1;
   end;

   for jjj := 0 to 24 do
   begin
     xxx := jjj mod 5;
     yyy := jjj div 5;
     if ((tile[xxx,yyy] > 0)and(tile[xxx,yyy] < 16))then
     begin
       with rc do
       begin
         top:=yyy*60;
         left:=xxx*60;
         right:=xxx*60+60;
         bottom:=yyy*60+60;
       end;
       //fx.dwFillColor := $101010*tile[xxx,yyy];
       tile[xxx,yyy] := tile[xxx,yyy] + 1;
       //STG1.BackBuf.surface.Blt(rc,nil,rc,   //ȂƏȂ
       //DDBLT_COLORFILL or DDBLT_WAIT,fx);
       AL.BlendRect(STG1.BackBuf,rc,AL.RGB24TO16($101010),BM_SCREEN);
     end;
   end;
   ImageDraw2;
   while ((GetTickCount-TempTime)<25)do;

  end;
end;

//^悷邩ȂI
procedure TForm1.RecModeSelect;
var
  iii : Integer;
begin
  if (level2 = 1)then
  begin
    if (StageSel = False)then BGMEnable('bgm\select');
    level2 := 0;
    STG1.ev_count[0] := 0;
    STG1.ev_count[1] := 0;
    cy := 0;
    cx := 0;
    STG1.ClearMesBoard;
    STG1.EntryMesBoard2('ʂɗVт܂','^悵Ȃ̂ŏył',3,200,1);
  end;

  if (Key1.PUp = true)then
  begin
    cy := cy - 1;
    STG1.EntryMesBoard2('ʂɗVт܂','^悵Ȃ̂ŏył',3,200,1);
  end;
  if (key1.Pdown = true)then
  begin
    cy := cy + 1;
    STG1.EntryMesBoard2('Ȃ̃vC^悵܂','ŃvCeĐł܂',3,200,1);
  end;
  if ((Key1.PUp or key1.Pdown) = true)then STG1.EntrySound(10);
  if (cy > 1)then cy := 1;
  if (cy < 0)then cy := 0;

  STG1.Clear;
  STG1.BackBuf.BltFast(Title,0,0,rect(0,300,300,600),0);
  STG1.DrawFont(150,30,'( PLAYMODE SELECT )',0);


  STG1.DrawFont(130,130,'NORMAL PLAY MODE',0);

  STG1.DrawFont(130,170,'RECORD PLAY MODE',0);

  for iii := 0 to 14 do
  begin
    AL.AlphaBlendRect(STG1.BackBuf,rect(iii*10,110+cy*40,iii*10+10,150+cy*40),AL.RGB24TO16($FF0000),255-iii*15,BM_ADD);
    AL.AlphaBlendRect(STG1.BackBuf,rect(290-iii*10,110+cy*40,300-iii*10,150+cy*40),AL.RGB24TO16($FF0000),255-iii*15,BM_ADD);
  end;

  STG1.DrawMesBoard;
  //L̃ZtJE^
  dec(STG1.ev_count[0]);
  if (STG1.ev_count[0] < 0)then STG1.ev_count[0] := 0;
  dec(STG1.ev_count[1]);
  if (STG1.ev_count[1] < 0)then STG1.ev_count[1] := 0;
  ImageDraw;
  
  if ((Key1.Ptrig1 or Key1.Ptrig2 or Key1.Ptrig3)=True)then
  begin
   case cy of
        0 : begin               //NORMAL MODE
              STG1.EntrySound(9);
              STG1.PlaySE;
              EntryFeedBack;
              SamplePlay := False;
              PlayRec := False;
              cy := 0;
              cx := 0;
              Level1 := 13;
              Level2 := 1;
            end;
        1 : begin               //Recording Mode
              STG1.EntrySound(9);
              STG1.PlaySE;
              EntryFeedBack;
              SamplePlay := False;
              PlayRec := True;
              cy := 0;
              cx := 0;
              Level1 := 15;
              Level2 := 1;
            end;
    end;
  end;

end;

//Xe|W|h
procedure TForm1.StageSelect;
var
  iii : Integer;
begin
  if (level2 = 1)then
  begin
    BGMEnable('bgm\select'); level2 := 0;
    cy := 0;
    cx := 0;
  end;

  if (Key1.PUp = true)then cy := cy - 1;
  if (key1.Pdown = true)then cy := cy + 1;
  if ((Key1.PUp or key1.Pdown) = true)then STG1.EntrySound(10);
  if (cy > 4)then cy := 4;
  if (cy < 0)then cy := 0;

  STG1.Clear;
  STG1.BackBuf.BltFast(Title,0,0,rect(0,300,300,600),0);
  STG1.DrawFont(150,30,'( STAGE SELECT MODE )',0);
  STG1.DrawFont(150,45,'1 STAGE ONLY',3);

  STG1.DrawFont(130,95,'STRTING EPSODE',0);
  STG1.DrawFont(180,110,'NIGHT CITY',3);

  STG1.DrawFont(130,135,'EPSODE 2',0);
  STG1.DrawFont(180,150,'DEEP FOREST',3);

  STG1.DrawFont(130,175,'EPSODE 3',0);
  STG1.DrawFont(180,190,'WATER SIDE',3);

  STG1.DrawFont(130,215,'EPSODE 4',0);
  STG1.DrawFont(180,230,'DRAKNESS GATE',3);

  STG1.DrawFont(130,255,'LAST EPSODE',0);
  STG1.DrawFont(180,270,'FINAL BATTLE',3);

  for iii := 0 to 14 do
  begin
    AL.AlphaBlendRect(STG1.BackBuf,rect(iii*10,80+cy*40,iii*10+10,120+cy*40),AL.RGB24TO16($FF0000),255-iii*15,BM_ADD);
    AL.AlphaBlendRect(STG1.BackBuf,rect(290-iii*10,80+cy*40,300-iii*10,120+cy*40),AL.RGB24TO16($FF0000),255-iii*15,BM_ADD);
  end;

  if ((Key1.Ptrig1 or Key1.Ptrig2 or Key1.Ptrig3)=True)then
  begin
   STG1.EntrySound(9);
   STG1.PlaySE;
   EntryFeedBack;
   StageNo := CY+1;
   Level1 := 17;
   Level2 := 1;
  end;

  ImageDraw;
end;

procedure TForm1.NameEntry;
var
  jjj,iii,aaa : Integer;
  acx,acy : Integer;
begin
  if (level2 = 1)then
  begin
    cx := 0; //J|\
    cy := 0; //OJ|\
    aa1 := 0;
    Level2 := 0;
    NameEnt[0] := ' ';
    NameEnt[1] := ' ';
    NameEnt[2] := ' ';
    //BGMEnable('bgm\select');
  end;
  aa1 := (aa1 + 1) mod 30;
  if ((Key1.PUp = true)and(cx>8))then cx := cx - 9;
  if ((key1.Pdown = true)and(cx<18))then cx := cx + 9;
  if (Key1.PLeft = true)then cx := cx - 1;
  if (Key1.PRight = true)then cx := cx + 1;
  if ((Key1.PUp or key1.Pdown or Key1.PLeft or Key1.PRight) = true)
    then begin aa1 := 0; STG1.EntrySound(10); end;
  if (cx > 26)then cx := 26;
  if (cx < 0)then cx := 0;

  if ((Key1.PTrig2 = True)and(cy>0))then
  begin
    NameEnt[cy] := ' ';
    cy := cy - 1;
    NameEnt[cy] := ' ';
  end;

  if (Key1.PTrig1 = True)then
  begin
    STG1.EntrySound(9);
    NameEnt[cy] := copy('ABCDEFGHIJKLMNOPQRSTUVWXYZ ',cx+1,1);
    cy := cy + 1;
  end;

  //NextLevel = 12;
  STG1.BackBuf.BltFast(Title,0,0,rect(0,300,300,600),0);
  //STG1.WaveDraw(rect(0,25,300,75),abs(10 - Flag1 div 2));
  TMesCount := (TMesCount + 4) mod 300;
  STG1.DrawBank(TMesCount-150,50,1,6,8,4);
  STG1.DrawBank(TMesCount+150,50,1,6,8,4);

  STG1.DrawFont(70,130,'YOUR NAME',1);
  AL.BlendRect(STG1.BackBuf,rect(0,170,300,180),AL.RGB24TO16($88AAFF),BM_SCREEN);
  AL.BlendRect(STG1.BackBuf,rect(140,142,160,145),AL.RGB24TO16($88FFAA),BM_SCREEN);
  AL.BlendRect(STG1.BackBuf,rect(170,142,190,145),AL.RGB24TO16($88FFAA),BM_SCREEN);
  AL.BlendRect(STG1.BackBuf,rect(200,142,220,145),AL.RGB24TO16($88FFAA),BM_SCREEN);
  for iii := 0 to 2 do
    STG1.DrawFont(150+iii*30,130,NameEnt[iii],0);
  for iii := 0 to 2 do
   for jjj := 0 to 8 do
   begin
     aaa := jjj+iii*9+1;
     if ((cx+1) = aaa)then
     begin
       AL.BlendRect(STG1.BackBuf,rect(10+jjj*32,192+iii*30,32+jjj*32,209+iii*30),AL.RGB24TO16($888888),BM_MODULATE);
       STG1.DrawFont(20+jjj*32,200+iii*30,copy('ABCDEFGHIJKLMNOPQRSTUVWXYZ ',aaa,1),2)
     end
     else
     begin
       AL.BlendRect(STG1.BackBuf,rect(10+jjj*32,192+iii*30,32+jjj*32,209+iii*30),AL.RGB24TO16($DDDDDD),BM_MODULATE);
       STG1.DrawFont(20+jjj*32,200+iii*30,copy('ABCDEFGHIJKLMNOPQRSTUVWXYZ ',aaa,1),0)
     end;
   end;

  AL.BlendRect(STG1.BackBuf,rect(140+cy*30,120,160+cy*30,140),AL.RGB24to16($110804*abs(aa1-15)),BM_SCREEN);
  acx := cx mod 9;
  acy := cx div 9;
  //AL.BlendRect(STG1.BackBuf,rect(10+acx*32,190+acy*30,30+acx*32,210+acy*30),30+abs(aa1-15),BM_SCREEN);

  AL.BlendRect(STG1.BackBuf,rect(18+acx*32,0,22+acx*32,190+acy*30),AL.RGB24to16($040811*abs(aa1-15)),BM_SCREEN);
  AL.BlendRect(STG1.BackBuf,rect(18+acx*32,210+acy*30,22+acx*32,300),AL.RGB24to16($040811*abs(aa1-15)),BM_SCREEN);
  AL.BlendRect(STG1.BackBuf,rect(0,198+acy*30,8+acx*32,202+acy*30),AL.RGB24to16($040811*abs(aa1-15)),BM_SCREEN);
    AL.BlendRect(STG1.BackBuf,rect(28+acx*32,198+acy*30,300,202+acy*30),AL.RGB24to16($040811*abs(aa1-15)),BM_SCREEN);
  ImageDraw;

  if (cy = 3)then
  begin
   STG1.EntrySound(9);
   STG1.PlaySE;
   Level1 := 12;
   Level2 := 1;
   //FedeOut;
   EntryFeedBack;
   STG1.PD[0].Name := NameEnt[0] + NameEnt[1] + NameEnt[2];
  end;
end;

procedure TForm1.AllClear;
begin
  if (StageSel = False)then HiScoreCheck;
  DemoCount := 0;
  Level1 := 22;
  FedeOut;
  EntryFeedBack;
end;

procedure TForm1.PlayDataWrite;
begin
  //Il=255
  if (PlayFrm > 89990)then PlayFrm := 89990;
  PPD.PlayData[89991] := STG1.GetFPScounter;
  PPD.PlayData[PlayFrm-1] := 255;
  PPD.Score := STG1.PD[0].score;
  PPD.Dif := STG1.Dif;
  PPD.Name := STG1.PD[0].Name;
  PPD.PlayerType := STG1.PD[0].SelectNo;
  PPD.Stage := StageNo;
  stg1.SavePlayData('PlayData\PlayData'+IntToStr(RecNo)+'.PDF',ppd);
  PlayFrm := 0;
end;

//I|vjO
procedure TForm1.OpeningDemo;
begin
  BGMDisable;
  //demo1.Present;
  //StartDemo;
  Key1.GetKey;   //ȂKvEEE
  Level1 := 5;
  Level2 := 1;
end;

//GfBO

procedure TForm1.EndingDemo;
var
  cgimage,bgimage,cgimage2 : TDDDDSurface;
  DemoLevel2 : Integer;
  TempTime : DWORD;
  ff : TextFile;
  Buf : string[128];
  xxx,iii : Integer;
begin
  //ŏ̓LʂɃf[^[ǂݍ
  BGMDisable;
  BGMEnable('bgm\ending');
  //EndingLoad;
  DemoLevel2 := 0;
  Key1.GetKey;
  AL.MaskColor := $45261421;

  if (fileExists('mes\ending.txt') = False)then
  begin
      STG1.ErrorCode := 255;
      Exit;
  end;
  AssignFile(ff,'mes\ending.txt');
  Reset(ff);

  Buf := '';
  while(Buf <> '$'+IntToStr(STG1.PD[0].SelectNo))do readln(ff,Buf);
  readln(ff,Buf);

  bgimage := TDDDDSurface.CreateOnSystemMemory(DDDD1,640,480,0);
  cgimage := TDDDDSurface.CreateOnSystemMemory(DDDD1,640,480,0);
  cgimage2:= TDDDDSurface.CreateOnSystemMemory(DDDD1,640,480,0);
  cgimage.FillRect(rect(0,0,640,480),$FFFFFF);
  cgimage2.FillRect(rect(0,0,640,480),0);

  while (DemoLevel2 = 0)do
  begin
    TempTime := TimeGetTime;
    Key1.GetKey;
    if (Key1.PTrig1 or Key1.PTrig2 or Key1.PTrig3)=True then Readln(ff,buf);
    if (Key1.PTrig4 or Key1.ESC)then DemoLevel2 := 1;
    While(TimeGetTime - TempTime < 33)do ;

    if (Buf = '$END')then DemoLevel2 := 1;

    if (Buf = '$SUBEND')then
    begin
      readln(ff,buf);
      if (STG1.PD[0].score < 1800000)then DemoLevel2 := 1;
    end;

    if (Buf[1] = '#')then
    begin
      cgimage2.FillRect(rect(0,0,640,480),$000000);
      if (fileExists('bmp\'+buf) = True)then cgimage2.LoadBMP('bmp\'+buf);

      temptime := TimegetTime;
      while (timegettime - temptime < 1000)do
      begin
        bgimage.BltFast(cgimage,0,0,rect(0,0,640,480),DDBLTFAST_NOCOLORKEY);
        AL.AlphaBlend(bgimage,0,0,cgimage2,rect(0,0,640,480),
                     (timegettime - temptime) div 4 + 5,BM_NORMAL);
        bgimage.PutFast(0,0,rect(0,0,640,480),DDBLTFAST_NOCOLORKEY);
        DDDD1.Flip;
      end;
      temptime := timeGetTime;
      cgimage.BltFast(cgimage2,0,0,rect(0,0,640,480),DDBLTFAST_NOCOLORKEY);
      Readln(ff,buf);
    end;

    if(demolevel2 = 0)then
    begin
      bgimage.BltFast(cgimage,0,0,rect(0,0,640,480),DDBLTFAST_NOCOLORKEY);
      xxx := 320-Byte(Buf[0])*5;
      AL.BlendRect(bgimage,rect(0,395,640,425),$000088,BM_NORMAL);
      AL.TextOut(bgimage,xxx+2,402,Buf,$000000,14,[fsBOLD]);
      AL.TextOut(bgimage,xxx,400,Buf,$FFFFFF,14,[fsBOLD]);
    end;
    bgimage.PutFast(0,0,rect(0,0,640,480),DDBLTFAST_NOCOLORKEY);
    DDDD1.Flip;
  end;

  for iii:=0 to 20 do
  begin
    temptime := TimeGetTime;
    AL.BlendRect(bgimage,rect(0,0,640,480),AL.RGB24to16($E0FFE0),BM_MODULATE);
    bgimage.PutFast(0,0,rect(0,0,640,480),DDBLTFAST_NOCOLORKEY);
    DDDD1.Flip;while(TimeGetTime - temptime < 75)do;
  end;

  for iii:=0 to 20 do
  begin
    temptime := TimeGetTime;
    AL.BlendRect(bgimage,rect(0,0,640,480),AL.RGB24to16($E0E0E0),BM_MODULATE);
    bgimage.PutFast(0,0,rect(0,0,640,480),DDBLTFAST_NOCOLORKEY);
    DDDD1.Flip;while(TimeGetTime - temptime < 75)do;
  end;

  Stg1.BackBuf.FillRect(rect(0,0,300,300),$000000);
  bgimage.free;
  cgimage.free;
  cgimage2.free;
  DDDD1.Clear;
  DDDD1.Flip;
  DDDD1.Clear;
  Level1 := 5;
  closefile(ff);
  AL.MaskColor := $0;
  Level2 := 1;
end;


procedure TForm1.BGMPlayerMenu;
var
  iii : Integer;
begin
  if (Level2 = 1)then
  begin
    cy := 0;
    Level2 := 0;
  end;

  if (Key1.PUp = true)then cy := cy - 1;
  if (key1.Pdown = true)then cy := cy + 1;
  if ((Key1.PUp or key1.Pdown) = true)then STG1.EntrySound(10);
  if (cy > 9)then cy := 9;
  if (cy < 0)then cy := 0;

  STG1.BackBuf.BltFast(Title,0,0,rect(0,300,300,600),0);
  //for iii := 0 to 19 do
  //  AL.BlendRect(STG1.BackBuf,rect(iii*15,150+random(120),iii*15+5,300),$000008*iii,BM_ADD);
  STG1.DrawFont(150,25,'BGM MODE',0);
  STG1.DrawFont(150,80,'RETURN TO MENU',2);
  STG1.DrawFont(100,100,'STRTING EPSODE',0);
   STG1.DrawFont(230,100,'NIGHT SITY',3);
  STG1.DrawFont(100,120,'EPSODE 2',0);
   STG1.DrawFont(230,120,'DEEP FOREST',3);
  STG1.DrawFont(100,140,'EPSODE 3',0);
   STG1.DrawFont(230,140,'WATER SIDE',3);
  STG1.DrawFont(100,160,'EPSODE 4',0);
   STG1.DrawFont(230,160,'DARKNESS GATE',3);
  STG1.DrawFont(100,180,'BOSS BATTLE',0);
   STG1.DrawFont(230,180,'DESTROYER',3);
  STG1.DrawFont(100,200,'FINAL EPSODE',0);
   STG1.DrawFont(230,200,'FINAL BATTLE',3);
  STG1.DrawFont(100,220,'PLAYER SELECT',0);
   STG1.DrawFont(230,220,'STAND UP',3);
  STG1.DrawFont(100,240,'TITLE MENU',0);
   STG1.DrawFont(230,240,'TITLE',3);
  STG1.DrawFont(100,260,'ENDING',0);
   STG1.DrawFont(230,260,'LAST MESSAGE',3);
  for iii := 0 to 14 do
  begin
    AL.AlphaBlendRect(STG1.BackBuf,rect(iii*10,70+cy*20,iii*10+10,90+cy*20),AL.RGB24TO16($FF0000),255-iii*15,BM_ADD);
    AL.AlphaBlendRect(STG1.BackBuf,rect(290-iii*10,70+cy*20,300-iii*10,90+cy*20),AL.RGB24TO16($FF0000),255-iii*15,BM_ADD);
  end;

  ImageDraw;

  if ((Key1.Ptrig1 or Key1.Ptrig2 or Key1.Ptrig3)=True)then
    case cy of
      0 : begin
           STG1.EntrySound(9);
           Level1 := 5;
           Level2 := 0;
           cy := 5;
           EntryFeedBack;
          end;
      1 : BGMEnable('bgm\Stage1');
      2 : BGMEnable('bgm\Stage2');
      3 : BGMEnable('bgm\Stage3');
      4 : BGMEnable('bgm\Stage4');
      5 : BGMEnable('bgm\Boss');
      6 : BGMEnable('bgm\Boss2');
      7 : BGMEnable('bgm\select');
      8 : BGMEnable('bgm\Title');
      9 : BGMEnable('bgm\Ending');
    end;
end;

//PlayRecSelect
//---LZNg
procedure TForm1.PlayDataSelect;
var
  jjj,aaa : Integer;
begin
  if (level2 = 1)then
  begin
    if(SamplePlay = True)then BGMEnable('bgm\select');
    level2 := 0;
    cy := 0;
    cx := 10;
    stg1.LoadPlayData('PlayData\PlayData'+IntToStr(cy)+'.PDF',ppd);
    aa1 := 0;
    if (FileExists('PlayData\PlayData'+IntToStr(cy)+'.PDF') = True)then aa1 := 1;
  end;

  STG1.BackBuf.BltFast(Title,0,0,rect(0,300,300,600),0);

  if (Key1.PDown = True)then cy := (cy + 1) mod 100;
  if (Key1.PUp = True)then cy := (cy - 1 + 100) mod 100;
  if (Key1.PRight = True)then cy := (cy + 10) mod 100;
  if (Key1.PLeft = True)then cy := (cy - 10 + 100) mod 100;

  if ((Key1.PUp or key1.Pdown or
        Key1.PLeft or Key1.PRight) = true)then
  begin
    STG1.EntrySound(10);
    cx := 10;
    stg1.LoadPlayData('PlayData\PlayData'+IntToStr(cy)+'.PDF',ppd);
    aa1 := 0;
    if (FileExists('PlayData\PlayData'+IntToStr(cy)+'.PDF') = True)then aa1 := 1;
  end;
  if (cx > 0)then cx := cx - 1;

  //L摜
  STG1.DrawFont(150,20,'SELECT PLAY DATA',0);
  if (PlayRec = False)then STG1.DrawFont(150,40,'REPLAY MODE',0)
                      else STG1.DrawFont(150,40,'RECORD MODE',0);
  STG1.DrawFont(220,290,'PLAYDATA '+IntToStr(cy),1);
  //AL.BlendRect(STG1.BackBuf,rect(0,50,300,200),0,BM_NORMAL);

  if (aa1 = 1)then
  begin
    AL.Blend(STG1.BackBuf,0,50,Select1,rect(0  ,PPD.PlayerType*150,
                                            300,PPD.PlayerType*150+150),BM_SCREEN);
    STG1.DrawFont(100,210,format('NAME  %6s',[PPD.Name]),0);
    STG1.DrawFont(100,230,format('LEVEL %6s',[ans[(PPD.Dif+3)]]),0);
    STG1.DrawFont(100,250,format('SCORE       ',[]),0);
    if(PPD.Stage < 6 )then STG1.DrawFont(120,270,format('STAGE%d GAMEOVER',[PPD.Stage]),2);
    if(PPD.Stage = 6 )then STG1.DrawFont(120,270,format('ALL STAGE CLEAR',[]),2);
    if(PPD.Stage > 10)then STG1.DrawFont(120,270,format('STAGE %d SELECT ',[PPD.Stage-10]),2);
    if(PlayRec = true)then STG1.DrawFont(80,195,'SAVE AS THIS DATA',3);
    if(PPD.Playdata[89991]>0)then STG1.DrawFont(120,290,format('FPS %2d         ',[PPD.PlayData[89991]]),0);
    for jjj := 0 to 6 do
    begin
     aaa := (PPD.Score div trunc(power(10,jjj))) mod 10;
     if (jjj > 3)then STG1.DrawBank(180-jjj*12,250,aaa+1,2,9,0)
                 else STG1.DrawBank(180-jjj*12,250,aaa+1,1,9,0);
   end;
  end
  else
  begin
    STG1.DrawFont(150,125,'NO DATA',0);
    if (PlayRec = False)then STG1.DrawFont(150,145,'CAN NOT REPLAY THIS DATA',3)
                        else STG1.DrawFont(150,145,'CREATE NEW PLAYDATA',3);
    STG1.DrawFont(100,210,'NAME  ------',0);
    STG1.DrawFont(100,230,'LEVEL ------',0);
    STG1.DrawFont(100,250,'SCORE ------',0);
  end;

  if (cx > 0)then Alph1.WindNoise(STG1.BackBuf,rect(0,50,300,200),cx*10);
  if ((GetTickCount div 500) mod 2 = 1)then
  begin
    STG1.DrawBank(150,50,7,3,9,0);
    STG1.DrawBank(150,200,8,3,9,0);
  end;

  if ((Key1.Ptrig1 or Key1.Ptrig2 or Key1.Ptrig3)=True) then
  begin
    //Đ
    if ((SamplePlay = True)and(aa1 = 1))then
    begin
      if (PPD.Stage > 10)then
      begin                     //StageSelect^̏ꍇ
        StageNo := PPD.Stage-10;
        StageSel := True;
        STG1.PD[0].SLevel := 65;
      end
      else
      begin                     //ȊOStage1
        StageNo := 1;
        StageSel := False;
        STG1.PD[0].SLevel := 0;
      end;
      StageFile := 'Stage'+IntToStr(StageNo)+'.stg';
      PlayFrm := 0;
      STG1.Dif := PPD.Dif;
      STG1.PD[0].score := 0;
      case PPD.playerType of       //@
        0 : begin
              STG1.PD[0].Speed1 := 5;
              STG1.PD[0].Speed2 := 4;
            end;
        1 : begin
              STG1.PD[0].Speed1 := 7;
              STG1.PD[0].Speed2 := 5;
            end;
        2 : begin
              STG1.PD[0].Speed1 := 5;
              STG1.PD[0].Speed2 := 5;
            end;
      end;
      STG1.PD[0].SelectNo := PPD.Playertype;
      STG1.PD[0].Name := PPD.Name;
      Level1 := 1;
      Level2 := 1;
    end;
    //^
    if (PlayRec = True)then
    begin
      EntryFeedBack;
      RecNo := cy;
      Level1 := 13;
      Level2 := 0;
      cy := 0;    //Kvϐ
      cx := 0;
      aa1 := 0;
      NameEnt[0] := ' ';
      NameEnt[1] := ' ';
      NameEnt[2] := ' ';
    end;

  end;
  ImageDraw
end;


procedure TForm1.EntryFeedBack;
begin
  Feed_Count := 15;
  FeedBuf.BltFast(STG1.BackBuf,0,0,rect(0,0,300,300),DDBLTFAST_WAIT or DDBLTFAST_NOCOLORKEY);
  //AL.BlendRect(FeedBuf,rect(0,0,300,300),$080808,BM_SCREEN);
end;

procedure TForm1.DrawFeedBack;
begin
  if (Feed_Count > 1)then
  begin
    AL.MaskColor := $12345678; //ĂƁ`
    AL.AlphaBlend(STG1.BackBuf,0,0,FeedBuf,rect(0,0,300,300),Feed_Count*16, BM_NORMAL);
    Feed_Count := Feed_Count - 1;
    AL.MaskColor := $00000000;
  end;
  //if (Feed_Count < 1)then Feed_Count := 0;  
end;

procedure TForm1.ScoreAdd;
var
  TempBuf1 : TDDDDSurface;
  iii,aaa,bbb : Integer;
  tempTime : LongInt;
begin
  STG1.MuteSound;
  //摜
  TempBuf1 := TDDDDSurface.CreateOnSystemMemory(DDDD1,300,300,0);
  TempBuf1.BltFast(STG1.BackBuf,0,0,rect(0,0,300,300),DDBLTFAST_NOCOLORKEY or DDBLTFAST_WAIT);
  aaa := 0; //_
  bbb := STG1.MaxComb*4000+STG1.PD[0].PNo*8000+STG1.NoMiss;
  for iii := 0 to 120 do
  begin
    TempTime := TimeGetTime;
    STG1.BackBuf.BltFast(Title,0,0,rect(0,300,300,600),0);
    STG1.DrawFont(150,30 ,'STAGE CLEAR BONUS',0);
    STG1.DrawFont(100,70 ,format('MAXHIT 4000x%2d',[STG1.maxcomb]),0);
    STG1.DrawFont(235,70 ,format('%6d',[STG1.maxcomb*4000]),2);
    STG1.DrawFont(100,90 ,format('LEFT   8000x%2d',[STG1.PD[0].PNo]),0);
    STG1.DrawFont(235,90 ,format('%6d',[STG1.PD[0].PNo*8000]),2);
    STG1.DrawFont(100,110,format('NO MISS       ',[]),0);
    STG1.DrawFont(235,110,format('%6d',[STG1.NoMiss]),2);
    STG1.DrawFont(100,130,format('BONUS TOTAL   ',[]),0);
    STG1.DrawFont(235,130,format('%6d',[aaa]),0);
    STG1.DrawFont(75,180,'TOTALSCORE',0);
    STG1.DrawFont(75,210,format('%7d',[aaa+STG1.PD[0].Score]),0);

    if (iii < 30)then
      AL.Blt2(STG1.BackBuf,rect(iii*5,iii*5,300,300),TempBuf1,rect(0,0,300,300),DDBLT_WAIT)
    else
      AL.Blt2(STG1.BackBuf,rect(150,150,300,300),TempBuf1,rect(0,0,300,300),DDBLT_WAIT);
    //XRAZ
    if ((iii >= 30)and(iii <= 103))then aaa := (bbb * (iii-30)) div 73;
    while ((TimeGetTime - TempTime)<25)do;
    ImageDraw;
  end;
  //ݒ
  STG1.PD[0].Score := STG1.PD[0].Score + bbb;
  //KEY҂
  Key1.GetKey;
  Key1.GetKey;
  temptime := GetTickCount;
  while ((Key1.AllTrig = FALSE)and((temptime+10000) > GetTickCount))do
  begin
     Key1.GetKey;
  end;

  inc(Stageno);
  if (StageSel = False)then
  begin
    if (StageNo = 6)then           //AllNA`
    begin
      level1 := 30;
      if (PlayRec = true)then      //^悵Ă^
      begin
        PlayFrm := PlayFrm + 5;
        PlayDataWrite;
        PlayRec := False;
      end;
      if (SamplePlay = True)then   //ĐĂ̂ȂAA
      begin
        SamplePlay := False;
        Level1 := 5;
        Level2 := 1;
        FedeOut;
        EntryFeedBack;
      end;
    end
    else level1 := 7;              //Stage
  end;

  if (StageSel = true)then
  begin
    if (PlayRec = true)then
    begin
      PlayFrm := PlayFrm + 5;    //StageSelect̘^抮
      StageNo := StageNo +10 - 1;//StageSelect10P^AStageNoOɉZĂ̂-1
      PlayDataWrite;             //StageSelectȂ狭IɏI
      PlayRec := False;
    end;
    Level1 := 5;
    Level2 := 1;
    FedeOut;
    EntryFeedBack;
  end;

  Key1.GetKey;
  TempBuf1.Free;
end;

procedure TForm1.DDDD1Init(Sender: TObject; fNeedChange: Boolean);
begin
 timeBeginPeriod(1);

 if MessageDlg('tXN[ŋN܂HiHighColorȊO̊̏ꍇ́wYesxIł',
    mtConfirmation, [mbYes, mbNo], 0) = mrYes then
  begin
    DDDD1.FullScreenMode(640,480,16,0,'');
    FullScreenMode := True;
    ShowCursor(False);
  end
  else
  begin
    DDDD1.WindowMode(640,480);
    FullScreenMode := False;
    ShowCursor(True);
  end;

  //ReplayDirectory


  midi_ok := 0;
  //gpt|Y
  ans[0] := 'ON';
  ans[1] := 'OFF';
  ans[2] := 'EASY';
  ans[3] := 'NORMAL';
  ans[4] := 'HARD';
  ans[5] := 'NORMAL';
  ans[6] := 'VIDEO';
  ans[7] := 'SYSTEM';
  ans[8] := '----';
  ans[9] := 'DIRECT';
  ans[10]:= 'WAIT';
  ans[11]:= 'RED';
  ans[12]:= 'BLUE';
  ans[13]:= 'GREEN';
  ans[14]:= 'MIDI';
  ans[15]:= 'MP3';
  ans[16]:= 'WAVE';
  //O|oϐ̐ݒ
  Key1 := TKey.Create;
  //DDDD1.ReadPalette('bmp\Title.bmp');
  //DDDD1.UpdatePalette;
  DDDD1.Clear;
  DDDD1.Flip;
  DDDD1.Clear;
  //AlphLibCreate
  Alph1 := Talpha16.Create;
  Alph1.LoadRandomTable('Random.rtd');
  //Alph1.NormalBlendAlpha := 128;
  //if (fileExists('BlendDat.btd'))then Alph1.LoadBlendTable('BlendDat.btd')
  //                               else Alph1.ReadPalette('bmp\Load.bmp',BM_SCREEN or BM_MODULATE or BM_NORMAL);
  //Class
  DD := DDDD1;
  DS := DDSD1;
  AL := Alph1;
  DI := DDIDex1;
  KY := Key1;
  //DemoCreate
  //demo1 := Tdemo.create;
  //VerDisp;

  STG1 := TSTG.Create;
  STG1.DataClear;
  STG1.DDFLG := 1;
  if (STG1.ConfigRead = False)then
  begin
    diffcult := 1;
    BGMsound := 0;
    SlowWait := 0;
    DrawSize := 0;
    BltMode := 0;
    STG1.BackCut := 0;
    EditWait := 5;
    shotColor := 0;
    STG1.WaveVolume := 5;
    BGMMode := 0;
  end
  else
  with STG1.Configdata do
  begin
    diffcult := Flag[0];
    BGMsound := Flag[1];
    SlowWait := Flag[2];
    DrawSize := Flag[3];
    BltMode := Flag[4];
    STG1.BackCut := Flag[5];
    STG1.WaveVolume := Flag[6];
    EditWait := Flag[7];
    shotColor := Flag[8];
    BGMMode := Flag[9];
  end;

  LastTime := GetTickCount;
  stagefile := 'stage1.stg';
  stageNo := 1;
  Randomize;
  Level1 := 0;
  Level2 := 0;

  //t|\
  FrameTime := 0;
  Frame1 := 0;Frame2 := 0;
  //TCYύXj|̐ݒ
  //ShowCursor(False);
  Form1.Left := 0;
  Form1.Top  := 0;
  //menu
  cy := 0;
  //PlayData
  PlayRec := False;
  //ConfigLoad

  //BGM
  BGMPlay := False;
  BGMPlayMode := BGMMode;
  //KBGM Create
  if (KBGMOpen(10,MIDI_MAPPER) <> KBGM_NOERROR)then midi_ok := 1;
  //FeedBack
  FeedBuf := TDDDDSurface.CreateOnSystemMemory(DDDD1,300,300,0);
  Feed_Count := 0;

  Application.OnIdle := AppIdle;
end;

procedure TForm1.PrintStageLogo;
var
  LogoImage1 : TDDDDSurface;
  iii : Integer;
  tempTime : Longint;
begin
  if (FileExists('bmp\stage_font.bmp') = False)then begin Close; exit; end;
  LogoImage1 := TDDDDSurface.CreateOnSystemMemory(DDDD1,150,250,0);
  LogoImage1.LoadBMP('BMP\stage_font.bmp');

  for iii := 0 to 40 do
  begin
    tempTime := TimeGetTime;
    AL.FillRect(STG1.backBuf,rect(0,0,300,300),$FFFFFF);
    AL.AlphaBlend(STG1.BackBuf,75,100,LogoImage1,
                  rect(0,stageno*50-25,150,stageno*50),255-abs(255-iii*12),BM_MODULATE);
    if (iii > 20)then AL.AlphaBlend(STG1.BackBuf,75,100,LogoImage1,
                               rect(0,stageno*50-50,150,stageno*50-25),iii*12+10,BM_MODULATE);
    Imagedraw2;
    while (tempTime+25 > TimegetTime) do ;
  end;

  LogoImage1.Free;
end;

procedure TForm1.GameStop;
begin
     Sleep(250);
     while ((GetAsyncKeyState($79) and $8000) = 0) do ;
     Sleep(250);
end;

procedure TForm1.MP3Player1EndPlay(Sender: TObject;
  Reason: TMP3EndPlayReason);
begin
  if ((Reason = merSuccessful) and (BGMPlay = True)) then begin
    MP3Player1.Play;
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  DDSD1.SetPrimaryBufferFotmat(22050, 16, FALSE);
  //DDSD1.SetPrimaryBufferFotmat(44100, 16, True);
end;

procedure TForm1.FormResize(Sender: TObject);
begin
  if (DDDD1.BackBuffer = NIL)then exit;
  DDDD1.Flip;
  DDDD1.Clear;
  DDDD1.Flip;
  DDDD1.Clear;
end;

end.
