unit Kota43b;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, math, Defs,
  DDRaw,DDDD,DDSD,DSound,AlphaLib16;

const
  BomMax = 100;
  Effectmax = 200;

type
  TBossSetData = record
    hx,hy,hw,hh        : array[0..9] of Integer;
    _HP,_Score         : array[0..9] of Integer;
    _lx,_ly            : array[0..9] of Integer;
    //4x8 x 10 = 320Byte
  end;

type
  TEnemySetData = record
    celWidth,celheight : array[0..19] of Integer;
    hx,hy,hw,hh        : array[0..19] of Integer;
    HP,Score           : array[0..19] of Integer;
    //4x8 x 20 = 640Byte
  end;

type       //PlayData
  TPlayData = record
    PlayData : array[0..90000] of Byte;   //PlayData  90001
    Name : string[3];                     //Name          4
    playerType : Byte;                    //Type          1
    score : LongInt;                      //score         4
    Dif : shortint;                       //Փx        1
    Stage : Byte;                         //Stage         1     = 90012
  end;

type
  TCONFIG = record  //Փx  
    Flag : array [0..32] of Byte;
  end;

type                    //Score
  TScore = record  //Փx  
    Name : array [0..5,0..9] of string[3];  //1*4  * 6 * 10  = 240
    Score: array [0..5,0..9] of LongInt;    //4    * 6 * 10  = 240
    PlayType : array [0..5,0..9] of Byte;   //1    * 6 * 10  = 60
    Stage : array[0..5,0..9] of Byte;       //1    * 6 * 10  = 60;
  end;

type
  TStageData = record
    PartsFile : String[255];
    FromLine : Word;   //|vp
    ToLine   : Word;
    MD : array[0..6,0..511] of Byte;   //50x50=1Cell
    ED : array[0..5,0..511] of Byte;
  end;

type
  TImageBank = record     //摜oN
    width,height : Integer;
    col,row : Byte;   //As
    maskEmpty : boolean;
    Empty : boolean;
    Img : TDDDDSurFace;
    Msk : TDDDDSurFace;
  end;

type
  TSoundBank = record     //ʉoN
    FileName : string;
    OutPut : Byte;
    Empty : Boolean;
    WAVData : TDDSDWaveData;
    Play : Boolean;
  end;

type
  TEnemy = record         //Gp
    x,y,z : SmallInt;
    x1,y1,x2,y2 : SmallInt;
    a1,a2,a3,a4,a5 : Integer;
    h1,h2,h3,h4 : SmallInt;
    Shot : Boolean;
    Move : Byte;
    ATTK : Byte;
    BOM  : Byte;
    Kind : Byte;
    HP   : Integer;
    Hit  : Byte;
    Empty: Boolean;
    score: Integer;
  end;

type
  TPlayer = record        //vC|
    x,y : Integer;
    x1,y1,x2,y2 : SmallInt;
    a1,a2,a3,a4 : Integer;
    h1,h2,h3,h4 : SmallInt;
    Nomber : Byte;
    Hit    : Boolean;
    NoHit  : Integer;
    Empty  : Boolean;
    score  : LongInt;
    bom    : Byte;
    PNo    : Byte;
    HP     : Byte;
    SLevel : Integer;

    SelectNo : Byte;
    Speed1,Speed2 : Byte;
    AddENS : Byte;
    Name : String[3];
  end;

type
  TEnemyShot = record        //G̒e
    x,y : Integer;
    x1,y1,x2,y2 : SmallInt;
    a1,a2,a3,a4 : Integer;
    h1,h2,h3,h4 : SmallInt;
    Kind : Byte;
    Empty: Boolean;
  end;

type
  TPlayerShot = record        //vC|̒e
    x,y : Integer;
    x1,y1 : SmallInt;
    a1,a2,a3 : Integer;
    HitNo : SmallInt;
    h1,h2,h3,h4 : SmallInt;
    Kind : Byte;
    Power: Byte;
    Empty: Boolean;
  end;

type
  TBom = record              //
    x,y : SmallInt;
    x1,y1 : SmallInt;
    a1,a2,a3 : Integer;
    Kind : Byte;
    Empty: Boolean;
  end;

type
  TEffect = record              //GtFNg
    x,y : SmallInt;
    x1,y1 : SmallInt;
    a1,a2,a3 : Integer;
    Kind : Byte;
    Empty: Boolean;
  end;
type
  TItem = record              //ACe
    x,y : SmallInt;
    x1,y1 : SmallInt;
    Kind : Byte;
    Empty: Boolean;
  end;

type                             //_ptHg
  TSTGFont = record
    x,y : SmallInt;
    x1,y1 : SmallInt;
    Count : LongInt;
    TextNo : array [0..40] of Byte;
    TextWidth : Integer;
    opt  : Byte;
    Empty : Boolean;
  end;

type                                 //bossParts
  TBossPartsData = record
    x,y,z : Smallint;
    x1,y1,x2,y2,x3,y3 : Integer;
    a1,a2,a3,a4 : Integer;
    HP,MaxHP : Integer;
    h1,h2,h3,h4 : SmallInt;
    lx,ly : SmallInt;
    Link : Boolean;
    bom : Byte;
    Score : Integer;
    Level : Byte;
    Empty : Boolean;
    kind : Byte;
    Hit : Byte;
    ImageNo : Byte;
    count : Integer;
    Ex : Integer;
  end;

type
  TSTG = Class(Tobject)
  private
    FPScount,FPSframe : DWORD;
  public
    SD : TStageData;
    ConfigData : TCONFIG;
    BOD: array[0..10] of TBossPartsData;
    ED : array[0..50] of TEnemy;
    PD : array[0..2]   of TPlayer;
    ESD: array[0..210] of TEnemyShot;
    PSD: array[0..75]  of TPlayerShot;
    IB : array[0..40]  of TImageBank;
    SB : array[0..20]  of TSoundBank;
    BD : array[0..BomMax]  of TBom;
    SC : array[0..720] of SmallInt;
    TD : array[0..50]  of TSTGFont;
    EFD: array[0..Effectmax]  of TEffect;
    ID : array[0..25]  of TItem;
    SCR: TScore;
    //LN^`bZ`W
    ev_Step :Integer;
    ev_Board : TDDDDSurface; //
    ev_Count,ev_Time,ev_Disp : array [0..1] of Integer;
    ev_Buf : array[0..1]of TDDDDSurface;
    ev_text1,ev_text2 : array[0..1] of string;
    mes_Text1,mes_Text2 : array[0..31] of String;
    mes_Pos,mes_Time,mes_Disp : array[0..31] of Integer;

    //EnemySwap
    EnemyNo : Byte;
    ESwap : array[0..50] of Byte;
    BSwap : array[0..10] of Byte;
    //count
    DB,DE,DES,DPS : SmallInt;
    BDCount : Integer;
    PDCount : Integer;
    //SE
    DSoundNo  : array[0..7] of Byte;
    DSoundPlay: array[0..7] of Boolean;
    //stage
    BossName : string;
    BackGround : TDDDDSurFace;
    SCount,BSCount : Integer;
    PBank  : TDDDDSurFace;
    Pentry : boolean;
    PBX,PBY : Integer;
    PSpeed : Integer;
    StageClear : Boolean;
    StageNo : Integer;
    //\prbg}bv
    ENSBit : TDDDDSurFace;
    BHPBit,BHPBit_back : TDDDDSurFace;
    Layer  : TDDDDSurFace;
    BackBuf : TDDDDSurFace;
    TempBuf : TDDDDSurFace;
    STBack : TDDDDSurFace;
    //bZ|W\p
    MCount : Integer;
    MNo : Byte;
    //_Ő
    FlashCount : Byte;
    BossFlash : Integer;
    AnimeCount : Byte;
    //config
    SEOff      : Byte; // 0 or 1(False)
    Dif : ShortInt;        //Փx (0=Normal)
    BackESD : Byte;
    BossLevel : Byte;
    BackCut    : Byte;     //wi̓ߏ
    WaveVolume : Byte;
    //pointsystem
    DestroyEnemy : Integer;
    PointScore : Integer;
    MaxComb,NoMiss : Integer;
    //Plater 1Up
    BackScore : LongInt;
    //DirectDraw Wait Asinc
    DDFLG : Byte;
    //Error
    ErrorCode : Byte;
    //BackGround
    BackGroundSpeed : Integer;
    BackGroundStep : Integer;
    //SpecialEffect(u)
    SPEX : Integer;
    SPEX2: Integer;
    //bZ`WCxg
    mesivent : Byte;
    //Enemy&BossSetdata
    ESS : TEnemySetdata;
    BSS : array [0..9] of TBossSetData;
    constructor Create;                //ݒ
    //destructor  Destroy;               //
    procedure Free;
    function  ConfigRead : Boolean;
    procedure ConfigWrite;
    procedure DataClear;
    procedure PlaySTG;
    procedure Masking(x1,x2 : TBitmap);
    procedure EntryBank(FileName : String;
                        w,h, c,r, No : Integer; mask,mem : boolean);
    procedure DrawBank(x,y : Integer;
                       c,r, No,opt : Byte);
    procedure EntryPlayerShot(x,y,ax,ay,h1,h2,h3,h4 : SmallInt;
                              kind,pw : Byte);
    procedure MovePlayerShot;
    procedure EntryBom(x,y,ax,ay : SmallInt;
                       kind : Byte);
    procedure MoveBom;
    procedure EntryEnemyShot(x,y,ax,ay,h1,h2,h3,h4,a2 : SmallInt;
                             kind : Byte);
    procedure MoveEnemyShot;
    procedure AutoEnemyShot(x,y : SmallInt; kind : Byte; opt : Integer);
    procedure EntryEnemy(x,y,z,h1,h2,h3,h4,a2,a3,HP : SmallInt; move,attk,bom,kind : Byte; score:Integer);
    procedure MoveEnemy;
    procedure AutoEnemy(x,y : SmallInt; kind : Byte);
    procedure EntrySoundBank(FileName : String;
                             OutPut,No : Byte);
    procedure EntrySound(No : Byte);
    procedure MuteSound;
    procedure EntryEffect(x,y,x1,y1 : SmallInt; kind : Byte);
    procedure MoveEffect;
    procedure BomEffect(x,y,n : Integer);

    function  keisan1(x,y : Integer) : Integer;
    function  PlayerLong(x,y : Integer) : Integer;
    function  PlayerHit : Boolean;
    function  EnemyHit  : Boolean;
    procedure Draw;

    procedure EntryStage(FileName : String; Stage : Integer);
    procedure SetUpStage(Speed : Integer);
    procedure MoveStage;
    procedure MoveMessage;

    procedure EntryPText(x,y : Integer; Text : String; opt : byte);
    procedure MovePText;

    procedure StrMid1(Var DsStr : String;
                      Var SsStr : String;
                      a,b  : Integer);
    procedure LoadBoss(filename : string; Stage : Byte);
    procedure EntryBoss;
    procedure MoveBoss;
    procedure SettingBoss(stage : Byte);
    procedure BossHit;
    procedure BossDestroy(kind : Byte);
    procedure PlayerDestroy;
    procedure EnemyShotClear;
    procedure DataClear2;
    procedure DrawFont(x,y : Integer; mes : string; opt : Byte);
    procedure PlaySE;
    procedure EntryItem(x,y : SmallInt; Kind : Byte);
    procedure MoveItem;
    procedure SurFaceClear(src : TDDDDSurFace; color : LongInt);
    procedure PutBackFace(src : TDDDDSurFace;x,y : Integer;
                          rd : Trect; opt : Byte);
    procedure WaveDraw(rc : TRect;Count : Integer);
    procedure MoveFlash;
    procedure DrawBackGround;
    procedure SetBackGround(FileName : String; Kind : Byte);
    procedure MoveBackGround;
    procedure Clear;
    procedure SpecialEffect;
    procedure SpecialEffect2;
    procedure MaskColor(Dest : TDDDDSurface; rc : Trect;
                         DestCol,SrcCol : Integer);

    procedure LoadPlayData(filename : string; var aaa : TPlayData);
    procedure savePlayData(filename : string; var aaa : TPlayData);

    procedure LoadPlayerMes(Filename : string);

    procedure DrawBom;
    procedure LoadEnemySetData;
    procedure LoadBossSetData;

    procedure EntryMesBoard;
    procedure EntryMesBoard2(mes1,mes2:string;disp,count,pos:Integer);
    procedure DrawMesBoard;
    procedure DrawTMessage;
    procedure ClearMesBoard;

    procedure SkipStage;

    procedure MoveBoss1;
    procedure MoveBoss2;
    procedure MoveBoss3;
    procedure MoveBoss4;
    procedure MoveBoss5;

    procedure InitFPScounter;
    procedure SetFPScounter(time:longint);
    function  GetFPScounter : BYTE;

    //procedure Entry
  end;



implementation

constructor TSTG.Create;      //ݒ
var
  iii,jjj : Integer;
  ff : FILE;
begin
  inherited Create;

  BackBuf := TDDDDSurFace.CreateOnSystemMemory(DD,300,300,0);
  TempBuf := TDDDDSurFace.CreateOnSystemMemory(DD,450,450,0);
  STBack  := TDDDDSurFace.CreateOnSystemMemory(DD,300,350,0);
  BackBuf.ClipRect := rect(0,0,300,300);
  BackBuf.Clipping := True;
  STBack.ClipRect := rect(0,0,300,350);
  STBack.Clipping := True;
  for iii := 0 to 40 do
    IB[iii].Empty := False;
  //Op֐vZ
  for iii := 0 to 720 do
  begin
    SC[iii] := round(sin(3.141592*(iii*0.5)/180)*100);
  end;
  for iii := 0 to 7 do
  begin
    DSoundNo[iii] := 255;
    DSoundPlay[iii] := False;
  end;

  for iii := 0 to 20 do
  begin
    SB[iii].Empty := False;
  end;
  DataClear;
  SCount := 0;
  PSpeed := 1;
  if (FileExists('bmp\ENS.bmp') = False)then begin ErrorCode := 255; exit; end;
  ENSBit := TDDDDSurFace.CreateOnSystemMemory(DD,75,16,0);
  ENSBit.LoadBMP('bmp\ENS.bmp');
  if (FileExists('bmp\BossHP.bmp') = False)then begin ErrorCode := 255; exit; end;
  BHPBit := TDDDDSurFace.CreateOnSystemMemory(DD,300,10,0);
  BHPBit.LoadBMP('bmp\BossHP.bmp');
  BHPBit_back := TDDDDSurFace.CreateOnSystemMemory(DD,300,10,0);
  if (FileExists('bmp\Layer1.bmp') = False)then begin ErrorCode := 255; exit; end;
  Layer := TDDDDSurFace.CreateOnSystemMemory(DD,300,32,0);
  Layer.LoadBMP('bmp\Layer1.bmp');
  if (FileExists('bmp\event1.bmp') = False)then begin ErrorCode := 255; exit; end;
  ev_Board := TDDDDSurFace.CreateOnSystemMemory(DD,200,80,0);
  ev_Board.LoadBMP('bmp\event1.bmp');
  ev_Buf[0] := TDDDDSurface.CreateOnSystemMemory(DD,200,40,0);
  ev_Buf[1] := TDDDDSurface.CreateOnSystemMemory(DD,200,40,0);

  //config
  SEOff     := 0;
  dif := 0;
  Mcount := 0;
  PDCount := 0;
  BDCount := 0;
  BackCut := 0;
  WaveVolume := 0;
  //DirectDraw Flag
  DDFLG := 0;
  //Hiscore
  PointScore := 100;
  BackScore := 0;
  //Error
  ErrorCode := 0;
  //BitMapEnpty;
  PEntry := False;

  for iii := 0 to 5 do for jjj := 0 to 9 do
  begin
    SCR.score[iii,jjj] := 0;
    SCR.NAME[iii,jjj] := 'XXX';
    SCR.Stage[iii,jjj] := 0;
    SCR.PlayType[iii,jjj] := 0;
  end;
  if (FileExists('hisc.scr') = true)then
  begin
    assignfile(ff,'hisc.scr');
    ReSet(ff,1);
    blockRead(ff,SCR,600);
    closefile(ff);
  end;

end;

procedure  TSTG.Free;
var
  iii : Integer;
  ff : FILE;
begin
  //HiScore̋L^
  if (DiskFree(0) > 1024)then
  begin
    assignfile(ff,'hisc.scr');
    ReWrite(ff,1);
    blockWrite(ff,SCR,600);
    closefile(ff);
  end;
  //AL.SaveBlendTable('BlendDat.btd');
  for iii := 0 to 40 do
   if (IB[iii].Empty = True)then
   begin
    IB[iii].img.free;
    if (IB[iii].maskEmpty = True)then IB[iii].msk.free;
   end;

  for iii := 0 to 20 do
   if (SB[iii].Empty = True)then SB[iii].WAVData.Free;

  STBack.Free;
  Pbank.Free;
  ENSBit.Free;
  BHPBIt.Free;
  BHPBit_back.Free;
  Layer.Free;
  BackGround.free;
  BackBuf.free;
  TempBuf.Free;
  ev_Board.free;
  ev_Buf[0].free;
  ev_Buf[1].free;
end;


procedure TSTG.MoveFlash;
var
  iii : Integer;
begin
  for iii := 0 to 9 do  BOD[iii].Hit := 0;
  for iii := 0 to 50 do ED[iii].Hit := 0;
end;

procedure TSTG.PutBackFace(src : TDDDDSurFace;x,y : Integer;
                           rd : Trect; opt : Byte);
var                           
  DDOP : Longint;
begin
  DDOP := 0;
  if (DDFLG = 1)then DDOP := DDBLTFAST_WAIT;
  case opt of
   0 : BackBuf.BltFast(src,x,y,rd,DDBLTFAST_SRCCOLORKEY or DDOP); //
   1 : BackBuf.BltFast(src,x,y,rd,DDBLTFAST_NOCOLORKEY or DDOP);
   2 : AL.Blend(BackBuf,x,y,src,rd,BM_SCREEN);

  end;
end;
procedure TSTG.SurFaceClear(src : TDDDDSurFace; Color : LongInt);
begin
 src.FillRect(rect(0,0,src.Width,src.height),color);
end;

function TSTG.PlayerLong(x,y : Integer) : Integer;
begin
  PlayerLong := abs(PD[0].x-x)+abs(PD[0].y-y);
end;


procedure TSTG.PlaySTG;
begin
  MoveFlash;
  MoveBackGround;
  MoveStage;
  MovePlayerShot;
  if ((PD[0].HP < 1) and(PD[0].empty=True))then PlayerDestroy;
  MoveEnemy;
  if (BOD[0].HP < 1)then BossDestroy(BOD[0].Kind)
                    else MoveBoss;
  MoveEnemyShot;
  EnemyHit;
  BossHit;
  MoveBom;
  MoveMessage;
  MovePText;
  MoveEffect;
  MoveItem;
  //G_
  FlashCount := (FlashCount + 1) mod 2;
  BossFlash := (BossFlash + 1) mod 20;
  //vC|_
  PD[0].NoHit := PD[0].NoHit - 1;
  if (PD[0].NoHit < 0)then PD[0].NoHit := 0;
  //Player 1 Up
  if ((BackScore div 500000) < (PD[0].Score div 500000))then
  if (PD[0].PNo < 9)then
  begin
    EntrySound(12);
    PD[0].PNo := PD[0].PNo + 1;
    EntryPText(PD[0].x,PD[0].y-15,'PLAYER 1UP',0);
  end;
  BackScore := PD[0].Score;
  //L̃ZtJE^
  dec(ev_count[0]);
  if (ev_count[0] < 0)then ev_count[0] := 0;
  dec(ev_count[1]);
  if (ev_count[1] < 0)then ev_count[1] := 0;
end;
procedure TSTG.DataClear;
var
  iii : Integer;
begin
  for iii := 0 to 50  do ED[iii].Empty  := False;
  for iii := 0 to 2   do PD[iii].Empty  := False;
  for iii := 0 to 200 do ESD[iii].Empty := False;
  for iii := 0 to 75  do PSD[iii].Empty := False;
  for iii := 0 to BomMax  do BD[iii].Empty  := False;
  for iii := 0 to Effectmax  do EFD[iii].Empty := False;
  for iii := 0 to 50  do TD[iii].Empty  := False;
  for iii := 0 to 10  do BOD[iii].Empty := False;
  for iii := 0 to 25  do ID[iii].Empty := False;
end;

procedure TSTG.DataClear2;
var
  iii : Integer;
begin
  for iii := 0 to 50  do ED[iii].Empty  := False;
  for iii := 0 to 200 do ESD[iii].Empty := False;
  for iii := 0 to 75  do PSD[iii].Empty := False;
  for iii := 0 to BomMax  do BD[iii].Empty  := False;
  for iii := 0 to Effectmax  do EFD[iii].Empty := False;
  for iii := 0 to 50  do TD[iii].Empty  := False;
  for iii := 0 to 10  do BOD[iii].Empty := False;
  for iii := 0 to 25  do ID[iii].Empty := False;
  MCount := 0;
  SPEX := 0; SPEX2 := 0;
  MaxComb := 0;
  NoMiss := 30000;
end;

procedure TSTG.EnemyShotClear;
var
  iii : Integer;
begin
  for iii := 0 to 200 do
    ESD[iii].empty := False;
end;

procedure TSTG.Masking(x1,x2 : TBitmap);
var
  Temp : TBitmap;
begin
  Temp := TBitmap.Create;
  Temp.assign(x1);
  Temp.Mask( x1.canvas.Pixels[0,0] or $02000000 );
  x2.assign(Temp);
  Temp.free;
end;

//
procedure TSTG.DrawFont(x,y : Integer; mes : string; opt : Byte);
var
  iii,www,aaa : Integer;
  sss : string;
begin
  www := Length(mes);

  for iii := 0 to www-1 do
    begin
     StrMid1(sss,mes,iii+1,1);
     if (opt = 3)then aaa := AnsiPos(sss,'0123456789xABCDEFGHIJKLMNOPQRSTUVWXYZ %-')
                 else aaa := AnsiPos(sss,'0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ ()-+x%');
     if (aaa = 0)then aaa := 1;
     case opt of
      0,1,2 : DrawBank((x-www*6)+iii*12+6,y,aaa,opt+1,28,0);
      3     : DrawBank((x-www*4)+iii*7+4,y,aaa,1,27,0);
     end;
    end;
end;
//ImageBankE摜֘A---------------------

procedure TSTG.EntryBank(FileName : string;
                         w,h, c,r, No : Integer; mask,mem : boolean);
var
  Height,Width : Integer;
  temp : TBitmap;
  tempbuffer : TDDDDSurface;
begin
  //FileȂ
  if (FileExists(FileName) = False)then begin ErrorCode := 255; exit; end;
  temp := TBitmap.Create;
  temp.LoadFromFile(FileName);
  if (IB[No].Empty = True)then
  begin
    IB[No].img.free;
    if (IB[No].maskEmpty = True)then IB[No].msk.free;
  end;
  IB[No].Empty := True;
  Width := temp.width;
  Height := temp.height;
  IB[No].Img := TDDDDSurFace.CreateOnSystemMemory(DD,width,height,0);
  IB[No].Img.LoadBMP(FileName);
  IB[No].maskEmpty := False;
  if (mask = True)then    //KvȎMemoryߖ
  begin
    IB[No].maskEmpty := True;
    IB[No].Msk := TDDDDSurFace.CreateOnSystemmemory(DD,width,height,0);
    IB[No].Msk.LoadBMP(FileName);
    tempbuffer := TDDDDSurface.CreateOnSystemMemory(DD,width,height,0);
    tempbuffer.LoadBMP(Filename);
    MaskColor(tempbuffer,rect(0,0,width,height),$BB00FF,0);
    AL.Blend(IB[No].Msk,0,0,tempbuffer,rect(0,0,width,height),BM_Normal);
    //AL.Blend(IB[No].Msk,0,0,IB[No].img,rect(0,0,width,height),BM_SCREEN);
    //AL.Blend(IB[No].Msk,0,0,IB[No].img,rect(0,0,width,height),BM_SCREEN);
    tempbuffer.Free;
  end;
  IB[No].width  := w;   //PZ̉
  IB[No].Height := h;
  IB[No].col    := c;   //
  IB[No].Row    := r;   //c
  temp.free;
end;

procedure TSTG.DrawBank(x,y : Integer;
                        c,r, No,opt : Byte);
var
  aaa,ac,ar : Byte;
begin
  ac := c; ar := r;
  while ((IB[No].Width * ac) > 640) do
  begin
       ac := ac - (640 div IB[No].Width); ar := ar + 1;
  end;

   aaa := opt;
  if ((IB[No].maskEmpty = false)and(aaa = 1))then aaa := 0;
  case aaa of
   0 : PutBackFace(IB[no].img,x - (IB[No].Width div 2),
                              y - (IB[No].Height div 2),
                   rect((ac-1)*IB[No].Width,(ar-1)*IB[No].Height,
                        ac*IB[No].Width,ar*IB[No].Height),0);
   2:  PutBackFace(IB[no].img,x - (IB[No].Width div 2),
                              y - (IB[No].Height div 2),
                   rect((ac-1)*IB[No].Width,(ar-1)*IB[No].Height,
                        ac*IB[No].Width,ar*IB[No].Height),2);

   1 : PutBackFace(IB[no].msk,x - (IB[No].Width div 2),
                              y - (IB[No].Height div 2),
                   rect((ac-1)*IB[No].Width,(ar-1)*IB[No].Height,
                        ac*IB[No].Width,ar*IB[No].Height),0);

   3 : PutBackFace(IB[no].img,x - (IB[No].Width div 2),
                              y - (IB[No].Height div 2),
                   rect((ac-1)*IB[No].Width,(ar-1)*IB[No].Height,
                        ac*IB[No].Width,ar*IB[No].Height),1);
   4 : AL.Blend(BackBuf,x - (IB[No].Width div 2),
                              y - (IB[No].Height div 2),
                  IB[no].img,
                  rect((ac-1)*IB[No].Width,(ar-1)*IB[No].Height,
                        ac*IB[No].Width,ar*IB[No].Height),BM_SCREEN);
   5 : AL.Blend(BackBuf,x - (IB[No].Width div 2),
                              y - (IB[No].Height div 2),
                  IB[no].img,
                  rect((ac-1)*IB[No].Width,(ar-1)*IB[No].Height,
                        ac*IB[No].Width,ar*IB[No].Height),BM_NORMAL);
   10..25 :
       AL.AlphBlend(BackBuf,x - (IB[No].Width div 2),
                              y - (IB[No].Height div 2),
                      IB[no].img,
                      rect((ac-1)*IB[No].Width,(ar-1)*IB[No].Height,
                        ac*IB[No].Width,ar*IB[No].Height),(aaa-10)*16,BM_NORMAL);
   30..45 :
       AL.AlphBlend(BackBuf,x - (IB[No].Width div 2),
                              y - (IB[No].Height div 2),
                      IB[no].img,
                      rect((ac-1)*IB[No].Width,(ar-1)*IB[No].Height,
                        ac*IB[No].Width,ar*IB[No].Height),(aaa-30)*16,BM_SCREEN);
  end;
end;

//ʉoN֌W--------------------
procedure TSTG.EntrySoundBank(FileName : String;
                              OutPut,No : Byte);
begin
  SB[No].FileName := FileName;
  SB[No].OutPut   := OutPut;
  SB[No].Empty := True;
  SB[No].WAVData :=TDDSDWaveData.Create(DS,FileName);
end;

procedure TSTG.EntrySound(No : Byte);
begin
  SB[No].Play := True;
end;

procedure TSTG.MuteSound;
var
  iii : Integer;
begin
  for iii := 0 to 20 do
    SB[iii].Play := False;
  for iii := 0 to 7 do
    DSoundPlay[iii] := False;
end;

procedure TSTG.PlaySE;
var
  iii : Integer;
begin
  for iii := 0 to 20 do
  begin
    if ((SB[iii].PLAY = True) and (SB[iii].Empty = True))then
    begin
      //WAVData̓Kp
      if (DSoundNo[SB[iii].OutPut] <> iii)then
      begin
        DSoundNo[SB[iii].OutPut] := iii;
        DS.Channels[SB[iii].OutPut].WaveData := SB[iii].WAVData;
      end;
      DSoundPlay[SB[iii].OutPut] := True;
    end;
  end;
  //WAV Ply
  for iii := 0 to 7 do
    if ((DSoundPlay[iii] = True)and(SEOff = 0))then
    begin
     DS[iii].Volume := - WaveVolume * 100;
     DS[iii].stop;
     DS[iii].Play;
    end; 

  MuteSound;
end;
//vC|ȅ------------------
//memo
//
procedure TSTG.EntryPlayerShot(x,y,ax,ay,h1,h2,h3,h4 : SmallInt;
                                kind,pw : Byte);
var
  iii : Integer;
begin
  iii := 0;
  while ((PSD[iii].Empty = True) and (iii<75))do iii := iii + 1;
  if (iii = 75)then iii := AL.Rnd(50);
  PSD[iii].Empty := True;
  PSD[iii].x := x;
  PSD[iii].y := y;
  PSD[iii].x1 := ax;
  PSD[iii].y1 := ay;
  PSD[iii].h1 := h1; PSD[iii].h2 := h2;
  PSD[iii].h3 := h3; PSD[iii].h4 := h4;
  PSD[iii].a1 := 0;
  PSD[iii].a2 := 0;
  PSD[iii].a3 := 0;
  PSD[iii].kind := kind;
  PSD[iii].Power := pw;
  PSD[iii].HitNo := 0;
end;

procedure TSTG.MovePlayerShot;
var
  iii : Integer;
begin
  for iii := 0 to 75 do
  begin
    if (PSD[iii].Empty = True)then
    begin
    with PSD[iii] do
    begin
    x := x + x1; y := y + y1;
    if ((x<-10) or (x>310))then Empty := False;
    if ((y<-10) or (y>310))then Empty := False;
    with PSD[iii] do
     case kind of
      1,2,3 : begin
               a3 := 3;  //\oNNo
               a1 := kind;
              end;
      4     : begin        //ړip|
               a3 := 5;
               a2 := a2 + 1;
               //a1 := (a2 div 3)+1+(a2 mod 3) ;
               a1 := (a2 mod 16) + 1;
               if (a2 = 12)then
               begin
                 x1 := 0; y1 := 0;
                 EntryEffect(x,y,0,0,3);
                 EntryEffect(x,y,0,0,3);
               end;
               if (a2 > 47)then Empty := False;
              end;
      5 :     begin         //BOMpip|
               a3 := 5;
               a2 := a2 + 1;
               a1 := a2 mod 2 + 1;
               EntryPlayerShot(x,y,0,0, 0,0,45,45,4,power);
              end;
      10 : begin        //|U|
             a3 := a3 + 1;
             if (a3 > 1)then Empty := False;
           end;

     end;
    end;
    end;
  end;
end;

//Ȅ-----------------------------

procedure TSTG.EntryBom(x,y,ax,ay : SmallInt;
                        kind : Byte);
var
  iii : Integer;
begin
  iii := 0;
  while ((BD[iii].Empty = True) and (iii<BomMax))do iii := iii + 1;
  if (iii = BomMax)then iii := AL.Rnd(BomMax);
  BD[iii].Empty := True;
  BD[iii].x := x;
  BD[iii].y := y;
  BD[iii].x1 := ax;
  BD[iii].y1 := ay;
  BD[iii].a1 := 0;
  BD[iii].a2 := 0;
  BD[iii].a3 := 0;
  BD[iii].kind := kind;
end;

procedure TSTG.MoveBom;
var
  iii : Integer;
begin
  for iii := 0 to BomMax do
  begin
    if (BD[iii].Empty = True)then
    begin
    with BD[iii] do
    begin
      a3 := a3 + 1;
    case kind of
      0: begin
         if (a1 > 16)then Empty := False;
         if (a1 = 1)then BomEffect(x,y,0);
         end;
      1: begin
         if (a1 > 13)then Empty := False;
         end;
      9:
      begin
        if (a3 = 1)then
        begin
         EntrySound(0);
         EntryBom(x,y,0,-2,0);
         EntryBom(x,y,-1,1,0);
         EntryBom(x,y,1,1,0);
         BomEffect(x,y,3);
        end;
        if ((a3 mod 5) = 1)then
        begin
          if (a3 < 11)then EntrySound(0);
          EntryBom(x,y,AL.Rnd(9)-4,AL.Rnd(7),0);
          BomEffect(x,y,0);
        end;
        if (a3 > 25)then empty := False;
      end;
      2:
      begin
        if (a3 = 1)then
        begin
         EntrySound(1);
         EntrySound(0);
         EntryBom(x-10,y-10,-2,-2,0);
         EntryBom(x+10,y-10,2,-2,0);
         EntryBom(x+10,y+10,2,2,0);
         EntryBom(x-10,y+10,-2,2,0);
         EntryBom(x,y,0,0,1);
        end;
        BomEffect(x,y,2);
        if (a3 > 3)then EntryBom(x,y,AL.Rnd(11)-5,AL.Rnd(11)-5,0);
        if (a3 > 8)then empty := False;
      end;
      3:
      begin
        if (a3 = 1)then EntrySound(0);
        EntryBom(x,y,AL.Rnd(7)-3,AL.Rnd(5)-2,0);
        BomEffect(x,y,2);
        if (a3 > 2)then empty := False;
      end;
      4:
      begin
        if (a3 = 1)then
        begin
          EntrySound(2);
          EntryBom(x,y,AL.Rnd(7)-3,AL.Rnd(7)-3,1);
        end;
        BomEffect(x,y,4);
        EntryBom(x,y,AL.Rnd(16)-8,AL.Rnd(16)-3,0);
        EntrySound(0);
        if (a3 > 8)then empty := False;
      end;
      5:
      begin
        if (a3 = 1)then
        begin
          EntrySound(1);
          EntryBom(x,y,0,0,1);
        end;
        BomEffect(x,y,4);
        EntryBom(x,y,AL.Rnd(6)-3,AL.Rnd(8),9);
        EntrySound(0);
        if (a3 > 6)then empty := False;
      end;
      6:      //e΂T
      begin
        if (a3 = 1)then
        begin
          EntrySound(1);
          AutoEnemyShot(x,y+20,8,AL.Rnd(720));
          EntryBom(x,y,0,0,1);
          if (Dif = 1)then AutoEnemyShot(x,y+15,8,AL.Rnd(720));
          BomEffect(x,y,30);
        end;
        EntryBom(x,y,AL.Rnd(20)-10,AL.Rnd(20)-10,0);
        if (a3 > 3)then empty := False;
      end;
      7:      //削
      begin
        if ((a3 mod 3)=0)then
        begin
          //EntryBom(x+AL.Rnd(100)-50,y+AL.Rnd(100)-50,0,0,5);
          EntryBom(x+AL.Rnd(50)-25,y+AL.Rnd(50)-25,0,0,2);
          EntrySound(1);
        end;
        if (a3 > 12)then empty := False;
      end;
      8:      //Ԕ
      begin
        if (a3 = 1)then
        begin
          EntrySound(1);
          EntryBom(x+12,y+6,0,0,0);
          EntryBom(x-12,y+6,0,0,0);
          EntryBom(x   ,y-6,0,0,0);
        end;
        BomEffect(x,y,1);
        if (a3 > 5)then EntryBom(x,y,AL.Rnd(7)-3,AL.Rnd(7)-3,0);
        if (a3 > 7)then empty := False;
      end;

    end;
    x := x + x1; y := y + y1;
    if ((x<-30) or (x>330))then Empty := False;
    if ((y<-30) or (y>330))then Empty := False;
    a1 := a1 + 1;
    end;
    end;
  end;
end;

//GtFNgʂ̏------------------------
procedure TSTG.EntryEffect(x,y,x1,y1 : SmallInt; kind : Byte);
var
  iii : Integer;
begin
  iii := 0;
  while ((EFD[iii].Empty = True) and (iii<EffectMax))do iii := iii + 1;
  if (iii = EffectMax)then iii := AL.Rnd(EffectMax);
  EFD[iii].Empty := True;
  EFD[iii].x := x;
  EFD[iii].y := y;
  EFD[iii].x1 := x1;
  EFD[iii].y1 := y1;
  EFD[iii].a1 := 0;
  EFD[iii].a2 := 0;
  EFD[iii].a3 := 0;
  EFD[iii].kind := kind;
end;

procedure TSTG.MoveEffect;
var
  iii : Integer;
begin
  for iii := 0 to Effectmax do
  if (EFD[iii].Empty = True)then
    with EFD[iii] do
    begin
      a2 := a2 + 1;
      case kind of
        0 : begin
             a1 := a2+1;
             if (a2 > 5)then Empty := False;
             x := x + x1;
             y := y + y1;
            end;
        1 : begin
             a1 := a2+7;
             if (a2 > 5)then Empty := False;
             x := x + x1;
             y := y + y1;
            end;
        2 : begin
             if (a2 = 1)then begin x1 := x; y1 := y; a3 := AL.Rnd(720); end;
             a3 := (a3 + 24) mod 720;
             x := x1 + SC[a3] * (43-a2) div 100;
             y := y1 + SC[(a3 + 180) mod 720] * (43-a2) div 100;
             if (a2 > 40)then Empty := False;
             a1 := 13 + a2 div 7;
            end;
        3 : begin
             if (a2 = 1)then begin x1 := x; y1 := y; a3 := AL.Rnd(720); end;
             a3 := (a3 + 24) mod 720;
             x := x1 + SC[a3] * a2 div 100;
             y := y1 + SC[(a3 + 180) mod 720] * a2 div 100;
             if (a2 > 40)then Empty := False;
             a1 := 13 + a2 div 7;
            end;
        4 : begin
             a1 := a2+13;
             if (a2 > 6)then Empty := False;
             x := x + x1;
             y := y + y1;
            end;
        5 : begin
             if (a2 = 1)then
             begin
               x1 := x + AL.Rnd(400)-200;
               y1 := y + AL.Rnd(400)-200;
             end;
             a1 := 19;
             if (a2 > 18)then a1 := (a2-18) div 2 + 19;
             if (a2 > 27)then Empty := False;
             x := (x*29 + x1*1) div 30;
             y := (y*29 + y1*1) div 30;
             if (abs(y-150)>150)then Empty := False;
             if (abs(x-150)>150)then Empty := False;
            end;
        6 : begin
             a1 := a2+25;
             if (a2 > 1)then Empty := False;
             x := x + x1;
             y := y + y1;
            end;
        7 : begin
             a1 := a2+25;
             if (a2 > 6)then Empty := False;
             x := x + x1;
             y := y + y1;
            end;
        else Empty := false;

      end;

    end;
end;

procedure TSTG.BomEffect(x,y,n : Integer);
var
  iii : Integer;
begin
  for iii := 0 to n do
    EntryEffect(x,y,0,0,5);
end;

//ACȅ------------------------------

procedure TSTG.EntryItem(x,y : SmallInt; kind : Byte);
var
  iii : Integer;
begin
  iii := 0;
  while ((ID[iii].Empty = True) and (iii<25))do iii := iii + 1;
  ID[iii].Empty := True;
  ID[iii].x := x;
  if (ID[iii].x > 300)then ID[iii].x := 300;
  if (ID[iii].x < 0)  then ID[iii].x := 0;
  ID[iii].y := y;
  ID[iii].x1 := 0;
  ID[iii].y1 := 5;
  ID[iii].kind := kind;
end;

procedure TSTG.MoveItem;
var
  iii : Integer;
begin
  for iii := 0 to 25 do
  if (ID[iii].Empty = True)then
    with ID[iii] do
    begin
     if (PD[0].x > x)then x := x + 1
                     else x := x - 1;
     if (PlayerLong(x,y)<35)then
     case kind of
     0 : begin     //ShotPowerUp
       PD[0].SLevel := PD[0].SLevel + 1;
       if ((PD[0].Slevel div 20) <> ((PD[0].SLevel-1) div 20))then EntryPText(PD[0].x,PD[0].y,'POWER UP',0);
       PD[0].score := PD[0].score + PointScore;
       EntryPText(x,y,IntToStr(PointScore),0);
       PointScore := PointScore + 10;
       if (PointScore > 1000)then PointScore := 1000;

       if (PD[0].SLevel > 65)then PD[0].SLevel := 65;
       Empty := False;
       EntrySound(11);
       end;        //BomAdd
     1 : begin
       PD[0].BOM := PD[0].BOM + 1;
       if (PD[0].BOM > 6)then
       begin
         PD[0].BOM := 6;
         PD[0].score := PD[0].score + 10000;
         EntryPText(x,y,'10000 POINTS',0);
       end
       else EntryPText(x,y,'EXTRA BOM',0);
       EntrySound(12);
       Empty := False;
       end;
     end;
     y := y + y1 div 10;
     y1 := y1 + 1;
     if (y > 300)then
     begin
       Empty := False;
       if (kind = 0)then PointScore := 100;
     end;
    end;
end;

//URG̏--------------------------------

procedure TSTG.EntryEnemy(x,y,z,h1,h2,h3,h4,a2,a3,HP : SmallInt;
                          Move,attk,bom, kind : Byte; Score:Integer);
var
  iii : Integer;
begin
  iii := 0;
  while ((ED[iii].Empty = True) and (iii<50))do iii := iii + 1;
  ED[iii].Empty := True;
  ED[iii].x := x;
  ED[iii].y := y;
  ED[iii].z := z;
  ED[iii].a2 := a2;
  ED[iii].a3 := a3;
  ED[iii].a4 := 0;
  ED[iii].h1 := h1; ED[iii].h2 := h2;
  ED[iii].h3 := h3; ED[iii].h4 := h4;
  ED[iii].kind := kind;
  ED[iii].Move := Move;
  ED[iii].attk := attk;
  ED[iii].Hit := 0;
  ED[iii].HP := HP;
  ED[iii].x1 := 0;
  ED[iii].y1 := 0;
  ED[iii].bom := bom;
  ED[iii].score := score;
end;

procedure TSTG.MoveEnemy;
var
  iii,jjj,aaa : Integer;
  aa1,aa2,aa3,aa4 : Integer;
begin
  //G̍ႳXbv
  EnemyNo := 0;
  for iii := 0 to 50 do
   if (ED[iii].Empty = True)then
   begin
    ESwap[EnemyNo] := iii;
    EnemyNo := EnemyNo + 1;
   end;

  for iii := 0 to EnemyNo-1 do
   for jjj := 0 to (EnemyNo-iii-1) do
   begin
    if (ED[Eswap[iii]].z > ED[ESwap[iii+jjj]].z)then
    begin
      aaa := Eswap[iii];
      Eswap[iii] := ESwap[iii+jjj];
      ESwap[iii+jjj] := aaa;
    end;
   end;

  for iii := 0 to EnemyNo-1 do
  begin
    aaa := ESwap[iii];
    if (ED[aaa].Empty = True)then
    begin
    ED[aaa].a4 := ED[aaa].a4 + 1;
    with ED[aaa] do
    begin
      //
      Shot := False;
      case Move of
        0 :     //OiE
        begin
          y1 := 300; a1 := 2;
          if (a4 = 1)then a4 := AL.Rnd(40);
          if (a4 > 80)then if (x > 150)then begin x1 := x1 + 20; a1 := 3; end
                                       else begin x1 := x1 - 20; a1 := 1; end;
          x := x + x1 div 100;
          y := y + y1 div 100;
          if (100<PlayerLong(x,y))then
            if ((a4 mod (40-dif*15)) = 1)then AutoEnemyShot(x,y,attk,-1);
          if ((x < -25) or (x > 325)) then Empty := False;
        end;
        1 :    //OiE~EOi
        begin
          if (a4 = 1)then y1 := 800;
          if (y1 > 70)then y1 := y1 - 25;
          if (a4 > 65)then  y1 := y1 + 40;
          x := x + x1 div 100;
          y := y + y1 div 100;
          if ((a4 = 30)and(dif>-1))then AutoEnemyShot(x,y,3,180);
          if (a4 = 35)then AutoEnemyShot(x,y,attk,-1);
          if ((dif = 1)and(a4 = 10))then AutoEnemyShot(x,y,3,-1);
          a1 := 2;
          if (y > 350) then Empty := False;
        end;
        2 :    //OiE
        begin
          if (a4 = 1)then y1 := 600;
          y1 := y1 - 10;
          x := x + x1 div 100;
          y := y + y1 div 100;
          if ((a4>(33-dif*3))and(a4<39))then AutoEnemyShot(x,y,attk,-1);
          if ((y1 < 0) and (y < -20))then Empty := False;
          a1 := keisan1(PD[0].x - x ,PD[0].y - y);
          a1 := abs(360-a1);
          a1 := (a1 div 55)+1;
          if (y < -50) then Empty := False;
        end;
        3 :    //OiEށEoq|
        begin
          if (a4 = 1)then y1 := 600;
          y1 := y1 - 10;
          x := x + x1 div 100;
          y := y + y1 div 100;
          if (a4 = 30)then
          begin
            AutoEnemyShot(x-20,y,attk,200);
            AutoEnemyShot(x+20,y,attk,160);
            y := y - 15;
          end;
          if ((a4 > (37-dif*2)) and (a4 < 42))then
          begin
            AutoEnemyShot(x-40,y+10,5,-1);
            AutoEnemyShot(x+40,y+10,5,-1);
          end;
          if ((y1 < 0) and (y < -20))then Empty := False;
          a1 := 1;
        end;
        4 :    //OiEie΂Tj
        begin
          y := y + 4;
          if (y > 250)then
          begin
            Empty := False;
            EntryBom(x,y,0,0,6);
          end;
          a2 := (a2 + 1) mod 9;
          a1 := a2 + 1;
        end;
        5:     //ق됌TCȐ
        begin
          if (a4 = 1)then x1 := x;
          if (a4 = 1)then a4 := AL.Rnd(25);
          y := y + 3;
          a2 := (a2 + 12) mod 720;
          a3 := (a3 + 1) mod 18;
          a1 := a3 + 1;
          x := x1 + trunc(SC[a2]*30 / 100);
          if (100<PlayerLong(x,y))then
            if ((a4 mod (35-dif*15)) = 1)then AutoEnemyShot(x,y,attk,-1);
          if (y > 325) then Empty := False;
        end;
        6:     //fBAhVo|Kۂ
        begin
          if (a4 = 1)then begin a4 := AL.Rnd(15); y1 := -40; end;
          a1 := 1;
          if ((a4 > 35) and (a4 < 49)) then a1 := (a4-35) div 2 + 1;
          if (a4 > 48)then a1 := 7;
          if (a4 > 65)then
          begin
            if (x > 150)then x1 := x1 + 2
                        else x1 := x1 - 2;
            a1 := 10 + x1 div 30;
            y1 := y1 + 2;
          end;
          y := y + y1 div 10;
          x := x + x1 div 10;
          if ((DIF<>-1) and (a4 = 60))then AutoEnemyShot(x,y,attk,-1);
          if (a4 = 65)then AutoEnemyShot(x,y,3,-1);
          if ((DIF=1)and(a4 = 75))then AutoEnemyShot(x,y,3,-1);
          if ((x < -30) or (x > 330)) then Empty := False;
        end;
        7 :     //tC
        begin
          if (a4 = 1)then begin y1 := y*10; a2 := 180; end;
          y1 := y1 + PSpeed;
          y := y1 div 10;
          if (y > 325)then Empty := False;
          //U
          if ((y<PD[0].y+50)and(100<PlayerLong(x,y)))then
           if ((a4 mod (45-DIF*15)) = 1)then AutoEnemyShot(x,y,attk,a2);
          //C]
          aa1 := keisan1(PD[0].x - x ,PD[0].y - y);  //]vZ
          if (abs(aa1-a2)<360)then
            if (aa1>a2)then a2 := a2 + 4
                       else a2 := a2 - 4
          else
            if (360>a2)then a2 := a2 - 4
                       else a2 := a2 + 4;
          if (abs(aa1-a2)<5)then a2 := aa1; //s߂h~

          a2 := (a2 + 720) mod 720;
          a1 := ((a2+20) mod 720) div 40 + 1;
          if (y > 325) then Empty := False;
        end;
      8 :     //
        begin
          if (a4 = 1)then
          begin
            y1 := y*10;
            if (x > 150)then x := 200 + x
                        else x := -50 - (150-x);
            a2 := 180;
          end;
          y1 := y1 + PSpeed;
          y := y1 div 10;
          if (a4 = 105)then a4 := 105 + AL.Rnd(45);
          if ((a4 > 5) and (a4 < 105))then
           if (x > 150)then x := x - 2
                       else x := x + 2;
          if (y > 325)then Empty := False;
          //U
          if (100<PlayerLong(x,y))then
           if ((a4 mod (52-DIF*15)) = 1)then AutoEnemyShot(x,y,attk,a2);
          //C]
          aa1 := keisan1(PD[0].x - x ,PD[0].y - y);  //]vZ
          if (abs(aa1-a2)<360)then
            if (aa1>a2)then a2 := a2 + 4
                       else a2 := a2 - 4
          else
            if (360>a2)then a2 := a2 - 4
                       else a2 := a2 + 4;
          if (abs(aa1-a2)<5)then a2 := aa1; //s߂h~
          
          a2 := (a2 + 720) mod 720;
          a1 := ((a2+20) mod 720)div 40 + 1;
          if (y > 325) then Empty := False;
        end;
      9 :     //PbgC
        begin
          if (a4 = 1)then begin y1 := y*10; a2 := 180; end;
          y1 := y1 + PSpeed;
          y := y1 div 10;
          if (y > 325)then Empty := False;
          //U
          aa1 := keisan1(PD[0].x - x ,PD[0].y - y);  //]vZ
          if ((y<PD[0].y)and(100<PlayerLong(x,y)))then
           if ((abs(aa1-a2)<3)and((a4 mod 5)=1))then
           begin
            EntrySound(6);
            EntryEnemyShot(x*100+SC[(a2+360)mod 720]*(AL.Rnd(20)-10)
                          ,y*100+SC[(a2+180)mod 720]*(AL.Rnd(20)-10)
                          ,SC[(a2+180)mod 720]*6
                          ,SC[a2]*6
                          ,0,0,8,8,
                          ((a2+22) mod 720) div 45 + 1,  1);
           end;
          //C]
          if (abs(aa1-a2)<360)then
            if (aa1>a2)then a2 := a2 + (2+Dif)
                       else a2 := a2 - (2+Dif)
          else
            if (360>a2)then a2 := a2 - (2+Dif)
                       else a2 := a2 + (2+Dif);
          if (abs(aa1-a2)<2+Dif)then a2 := aa1; //s߂h~

          a2 := (a2 + 720) mod 720;
          a1 := ((a2+20) mod 720)div 40 + 1;
          if (y > 325) then Empty := False;
        end;

      10 :     //{X
        begin
          if (a4 = 1)then begin y := 350; x1 := x; a2 := 0; end;
          if (a4 < 45)then y := 375 + SC[720-a4*4]*3;
          x := x1 + SC[a4*4 mod 720] div 3;
          if (a4 > 700)then y := y - 1;
          if (y < -50)then Empty := False;
          if (a4 > 45)then
          begin
           aa1 := (a4-45) mod 360;
           case (aa1 div 72 + 1) of
            1 : if ((aa1 mod (4-DIF))=0)then AutoEnemyShot(x,y,5,-1);
            2,5 :if ((aa1 mod (5-DIF))=0)then
                 begin
                  AutoEnemyShot(x-35,y+10,10,(aa1 * 10)mod 720);
                  AutoEnemyShot(x+35,y+10,10,((360 - aa1 * 10)+7200)mod 720);
                 end;
            3 : if ((aa1 mod (16-DIF*4))=0)then AutoEnemyShot(x,y,8,aa1);
           end;
          end;
          a1 := 1;
        end;

      11 :    //q^
        begin
          if (a4 = 1)then if (x > 150)then x1 := -1  //ړ̐ݒ
                                      else x1 := 1;
          y := y + 1;
          x := x + x1;
          aa1 := a4;
          if (aa1 mod (6-dif) = 1)then AutoEnemyShot(x,y,attk,(aa1 * 30) mod 720);
          if (y > 350)then Empty := False;
          if (abs(x-150) > 200)then Empty := False;
        end;

      12 :   //Ɛ
        begin
          if (a4 = 1)then
            begin y1 := -30; y := 325; a4 := AL.Rnd(20)+1; end;
          if ((a4 > 105) and (a4 < 160))then y1 := y1 + 2;
          y := y + y1 div 10;
          if (a4 = 130)then z := z + 100;//ύX
          if (a4 > 400)then Empty := False;
          case (a4 div 50) of
            0,1 : a3 := 1;
            2 : a3 := (a4-100) div 5 + 1;
            else  a3 := 10;
          end;
          if (a4 = 140)then
          begin
            AutoEnemyShot(x,y,attk,-1);
            if (Dif = 1)then AutoEnemyShot(x,y,14,-1);
          end;  
        end;

       13 :   //^q    ~O
        begin
          if (a4 = 1)then
            begin a2 := x * 720 div 300; end;
          a1 := (a4 mod 9) + 1;
          case a4 div 50 of
            0,1,2,3 :
                  begin
                   a2 := (a2 + 4) mod 720;
                   x := 150 + (SC[a2] * ((240-a4)) div 100);
                   y := 100 + (SC[(a2+180) mod 720] * ((240-a4)) div 100);
                  end;
            4   : begin
                   a2 := (a2 + 4) mod 720;
                   x := 150 + (SC[a2] * 4) div 10;
                   y := 100 + (SC[(a2+180) mod 720] * 4) div 10;
                  end;
            5,6 : y := y - 3;
            7   : Empty := False;
          end;
          if ((a4 = 140) and (Dif > -1))then AutoEnemyShot(x,y,attk,180);
          if (a4 = 180)then AutoEnemyShot(x,y,attk,180);
          if ((a4 = 220) and (Dif > 0))then AutoEnemyShot(x,y,attk,-1);
        end;

        14 :   //^q    ~OiE獶j
        begin
          if (a4 = 1)then
            begin a2 := 720 + x div 2; a4 := 75 - x div 4 ; end;
          a1 := (a4 mod 9) + 1;
          if ((a2 < 540)and(a2 > 500)) then y := y - 2
          else
          begin
            a2 := (a2 + 718) mod 720;
            x := 25  + SC[(a2+180) mod 720] * 3;
            y := 350 + SC[a2] * 3;
          end;
          if (y < 0)then Empty := False;
          if (a4 = 120)then AutoEnemyShot(x,y,attk,-1);
          if ((a4 = 160)and(Dif > -1))then AutoEnemyShot(x,y,attk,-1);
        end;

        15 :   //^q    ~OiEj
        begin
          if (a4 = 1)then
            begin a2 := 360 - x div 2; a4 := 75 - x div 4; end;
          a1 := (a4 mod 9) + 1;
          if ((a2 < 580)and(a2 > 540)) then y := y - 2
          else
          begin
            a2 := (a2 + 2) mod 720;
            x := 275 + SC[(a2+180) mod 720] * 3;
            y := 350 + SC[a2] * 3;
          end;
          if (y < 0)then Empty := False;
          if (a4 = 120)then AutoEnemyShot(x,y,attk,-1);
          if ((a4 = 160)and(Dif > -1))then AutoEnemyShot(x,y,attk,-1);
        end;

        16 :  //]C
        begin
          if (a4 = 1)then begin y1 := y*10; a2 := 180; end;
          y1 := y1 + PSpeed;
          y := y1 div 10;

          a2 := (a2 + 1) mod 575;
          aaa := a2 mod 72;
          if (aaa mod (9-Dif*3) = 1)then
            case (a2 div 72) of
              0,3 : AutoEnemyShot(x,y,10,aaa*5);
              1,5 : AutoEnemyShot(x,y,8,aaa);
              2,7 : AutoEnemyShot(x,y,3,aaa*5);
              4,6 : AutoEnemyShot(x,y,13,aaa*5);
            end;
          a1 := (a1 + 1) mod 5 + 1;
          if (y > 332) then Empty := False;
        end;

      end;

    if (a3 > 0)then a1 := a3;
    end;
    end;
  end;
end;

procedure TSTG.AutoEnemy(x,y : smallInt; kind : Byte);
begin
  with ESS do
  begin
  case kind of
  //                                                \
  //                         HitArea                     a3 4  HP     M A B  No Sc
  10 : EntryEnemy(x,y,150,  hx[0],hy[0],hw[0],hh[0], 0,0, hp[0],  0,0,3, 0,score[0]); //΂̃UR
  11 : EntryEnemy(x,y,150,  hx[0],hy[0],hw[0],hh[0], 0,0, hp[0],  0,3,3, 0,score[0]);
  20 : EntryEnemy(x,y,150,  hx[1],hy[1],hw[1],hh[1], 0,0, hp[1],  1,1,3, 0,score[1]); //΂̃URNႤ
  21 : EntryEnemy(x,y,150,  hx[1],hy[1],hw[1],hh[1], 0,0, hp[1],  1,3,3, 0,score[1]);
  30 : EntryEnemy(x,y,140,  hx[2],hy[2],hw[2],hh[2], 0,1, hp[2],  1,8,2, 1,score[2]);  //123  ^̃c
  31 : EntryEnemy(x,y,140,  hx[3],hy[3],hw[3],hh[3], 0,2, hp[3],  1,9,2, 1,score[3]);
  32 : EntryEnemy(x,y,140,  hx[4],hy[4],hw[4],hh[4], 0,3, hp[4],  1,0,2, 1,score[4]);
  40 : EntryEnemy(x,y,150,  hx[5],hy[5],hw[5],hh[5], 0,0, hp[5],  2,5,9, 2,score[5]);
  41 : EntryEnemy(x,y,150,  hx[5],hy[5],hw[5],hh[5], 0,0, hp[5],  2,6,9, 2,score[5]);
  50 : EntryEnemy(x,y,150,  hx[6],hy[6],hw[6],hh[6], 0,0, hp[6],  3,7,2, 3,score[6]);
  51 : EntryEnemy(x,y,150,  hx[6],hy[6],hw[6],hh[6], 0,0, hp[6],  3,4,2, 3,score[6]);
  60 : EntryEnemy(x,y,150,  hx[7],hy[7],hw[7],hh[7], 0,0, hp[7],  4,0,6, 4,score[7]);
  70 : EntryEnemy(x,y,150,  hx[8],hy[8],hw[8],hh[8], 0,0, hp[8],  5,0,3, 5,score[8]); //NX^
  80 : EntryEnemy(x,325,130,hx[9],hy[9],hw[9],hh[9], 0,0, hp[9],  6,0,9, 6,score[9]); //Vo|K
  81 : EntryEnemy(x,325,130,hx[9],hy[9],hw[9],hh[9], 0,0, hp[9],  6,3,9, 6,score[9]);
  82 : EntryEnemy(x,325,130,hx[9],hy[9],hw[9],hh[9], 0,0, hp[9],  6,8,9, 6,score[9]);
  90 : EntryEnemy(x,y,100,  hx[10],hy[10],hw[10],hh[10], 0,0, hp[10],  7,3,8, 7,score[10]);   //C
  91 : EntryEnemy(x,y,100,  hx[10],hy[10],hw[10],hh[10], 0,0, hp[10],  7,4,8, 7,score[10]);
  100: EntryEnemy(x,y,100,  hx[11],hy[11],hw[11],hh[11], 0,0, hp[11],  8,1,8, 8,score[11]);    //
  101: EntryEnemy(x,y,100,  hx[11],hy[11],hw[11],hh[11], 0,0, hp[11],  8,10,8,8,score[11]);
  110: EntryEnemy(x,y,100,  hx[12],hy[12],hw[12],hh[12], 0,0, hp[12],  9,1,8, 9,score[12]);   //PbgC
  120: EntryEnemy(x,y,170,  hx[13],hy[13],hw[13],hh[13], 0,0, hp[13], 10,1,7,10,score[13]);   //{X
  130: EntryEnemy(x,y,170,  hx[14],hy[14],hw[14],hh[14], 0,5, hp[14], 11,13,2,1,score[14]);  //q^(c)
  131: EntryEnemy(x,y,170,  hx[14],hy[14],hw[14],hh[14], 0,5, hp[14], 11,11,2,1,score[14]);  //q^()
  132: EntryEnemy(x,y,170,  hx[14],hy[14],hw[14],hh[14], 0,5, hp[14], 11,12,2,1,score[14]);  //q^()
  140: EntryEnemy(x,y,60,   hx[15],hy[15],hw[15],hh[15], 0,0, hp[15],  12,0,3,11,score[15]);  //^
  141: EntryEnemy(x,y,60,   hx[15],hy[15],hw[15],hh[15], 0,0, hp[15],  12,3,3,11,score[15]);  //^
  142: EntryEnemy(x,y,60,   hx[15],hy[15],hw[15],hh[15], 0,0, hp[15],  12,13,3,11,score[15]);  //^
  150: EntryEnemy(x,y,150,  hx[16],hy[16],hw[16],hh[16], 0,0, hp[16],  13,0,3,12,score[16]);  //^q(~)
  151: EntryEnemy(x,y,150,  hx[16],hy[16],hw[16],hh[16], 0,0, hp[16],  13,3,3,12,score[16]);  //^q
  152: EntryEnemy(x,y,150,  hx[16],hy[16],hw[16],hh[16], 0,0, hp[16],  13,13,3,12,score[16]);  //^q
  153: EntryEnemy(x,y,150,  hx[16],hy[16],hw[16],hh[16], 0,0, hp[16],  13,8,3,12,score[16]);  //^q
  160: EntryEnemy(x,y,150,  hx[16],hy[16],hw[16],hh[16], 0,0, hp[16],  14,0,3,12,score[16]); //^q(<<~)
  161: EntryEnemy(x,y,150,  hx[16],hy[16],hw[16],hh[16], 0,0, hp[16],  14,3,3,12,score[16]);
  162: EntryEnemy(x,y,150,  hx[16],hy[16],hw[16],hh[16], 0,0, hp[16],  14,13,3,12,score[16]);
  165: EntryEnemy(x,y,150,  hx[16],hy[16],hw[16],hh[16], 0,0, hp[16],  15,0,3,12,score[16]); //^q(>>~)
  166: EntryEnemy(x,y,150,  hx[16],hy[16],hw[16],hh[16], 0,0, hp[16],  15,3,3,12,score[16]);
  167: EntryEnemy(x,y,150,  hx[16],hy[16],hw[16],hh[16], 0,0, hp[16],  15,13,3,12,score[16]);
  170: EntryEnemy(x,y,100,  hx[17],hy[17],hw[17],hh[17], 0,0, hp[17],  16,0,8, 13,score[17]);   //]C
  //boss
  255:EntryBoss;
  end;
  end;
end;

//G̒ȅ--------------------------

procedure TSTG.EntryEnemyShot(x,y,ax,ay,h1,h2,h3,h4,a2 : SmallInt;
                              Kind : Byte);
var
  iii : Integer;
begin
  iii := 0;
  while ((ESD[iii].Empty = True) and (iii<201))do iii := iii + 1;
  ESD[iii].Empty := True;
  ESD[iii].x := x;
  ESD[iii].y := y;
  ESD[iii].x1 := ax;
  ESD[iii].y1 := ay;
  ESD[iii].a1 := 0;
  ESD[iii].a2 := a2;
  ESD[iii].a3 := 0;
  ESD[iii].h1 := h1;
  ESD[iii].h2 := h2;
  ESD[iii].h3 := h3;
  ESD[iii].h4 := h4;
  ESD[iii].kind := kind;
end;

procedure TSTG.MoveEnemyShot;
var
  iii : Integer;
begin
  for iii := 0 to 200 do
  begin
    if (ESD[iii].Empty = True)then
    begin

    with ESD[iii] do
    begin
    case kind of
      0 :begin
          a2 := (a2 + 1) mod 6;
          a1 := a2 + 17;
         end;
      1 : a1 := a2 + 0;
      2 :begin
          a2 := (a2 + 1) mod 6;
          a1 := a2 + 23;
         end;
      3 :begin
          a1 := a2 + 29;
         end;
      4 :begin
          a2 := (a2 + 1) mod 6;
          a1 := a2 + 23;
          x1 := trunc(x1 * 0.95); y1 := trunc(y1 * 0.95);
          a3 := a3 + 1;
          if (a3 > 40)then
           begin Empty := False; AutoEnemyShot(x div 100,y div 100,3,-1); end;
         end;
      5 :begin
          a3 := a3 + 1;
          a1 := 255;  //OF|U|p
          if (a3 = 40)then EntrySound(14);
          case (a3 div 40) of
            0,3 : begin
                 h2 := -100;
                 h3 := 0;
                 h4 := 0;
                end;
            1,2 : begin
                 h1 := 0;
                 h2 := abs(300 - (y div 100)) div 2;
                 h3 := 30;   
                 h4 := abs(300- y div 100);
                end;
            4 : Empty := False;
          end;
         end;
    end;

    x := x + x1; y := y + y1;
    if ((x<0) or (x>30000))then Empty := False;
    if ((y<0) or (y>30000))then Empty := False;
    end;

    end;
  end;
end;

//G̒e̊ȗo^p-----------------------

procedure TSTG.AutoEnemyShot(x,y : SmallInt; Kind : Byte; opt : Integer);
var
  k1,k2,k3,ax,ay,iii,aaa : Integer;
begin
  if (abs(x-150)>150)then exit;
  if (abs(y-150)>160)then exit;
  if (opt < 0)then k1 := keisan1(PD[0].x-x ,PD[0].y-y)
              else k1 := opt;
  k1 := k1 mod 720;            
  ay := SC[k1];
  ax := SC[(k1+180) mod 720];
  k2 := ((k1+22) mod 720) div 45 + 1;
  case Kind of
    0 : begin
          EntryEnemyShot(x*100,y*100,ax*3,ay*3, 0,0,8,8, 0,  0);
          EntrySound(5);
        end;
    1 : begin
          EntryEnemyShot(x*100,y*100,ax*4,ay*4, 0,0,8,8, k2, 1);
          EntrySound(6);
        end;
    2 : begin
          EntryEnemyShot(x*100,y*100,ax*5,ay*5, 0,0,8,8, 0,  2);
          EntrySound(5);
        end;
    3 : begin
          EntrySound(6);
          for iii := 0 to 2 do
          begin
            k3 := (k1 +660 + iii*60) mod 720;
            ay := SC[k3]; ax := SC[(k3+180) mod 720];
            k2 := ((k3+22) mod 720) div 45 + 1;
            EntryEnemyShot(x*100,y*100,ax*4,ay*4, 0,0,8,8, k2,  1);
          end;
          EntryEffect(x,y,0,0,1);
        end;
    4 : begin
          EntrySound(6);
          for iii := 0 to 2 do
          begin
            k3 := (k1 + 660 + iii*60) mod 720;
            ay := SC[k3]; ax := SC[(k3+180) mod 720];
            k2 := ((k3+22) mod 720) div 45 + 1;
            EntryEnemyShot(x*100,y*100,ax*6,ay*6, 0,0,8,8, k2,  1);
          end;
          EntryEffect(x,y,0,0,1);
        end;
    5 : begin
          EntrySound(5);
          k1 := k1 + (AL.Rnd(180)-90);
          k1 := (k1 + 720) mod 720;
          ay := SC[k1];
          ax := SC[(k1+180) mod 720];
          EntryEnemyShot(x*100,y*100,ax*3,ay*3, 0,0,8,8, 0,  0);
          EntryEffect(x,y,0,0,1);
        end;
    6 : begin
          EntrySound(5);
          k1 := k1 + (AL.Rnd(120)-60);
          k1 := (k1 + 720) mod 720;
          ay := SC[k1]; ax := SC[(k1+180) mod 720];
          k2 := ((k1+22) mod 720) div 45 + 1;
          EntryEnemyShot(x*100,y*100,ax*4,ay*4, 0,0,8,8, k2,  1);
          EntryEffect(x,y,0,0,1);
        end;
    7 : begin
          EntrySound(7);
          for iii := 0 to 5 do
          begin
            ay := SC[k1];
            ax := SC[(k1+180) mod 720];
            ax := trunc(ax * (3 + iii*0.5));
            ay := trunc(ay * (3 + iii*0.5));
            EntryEnemyShot(x*100,y*100,ax,ay, 0,0,12,12, iii, 3);
          end;
        end;
    8 : begin
          EntrySound(6);
          for iii := 0 to 11 do
          begin
            k3 := (k1 + iii*60) mod 720;
            ay := SC[k3];
            ax := SC[(k3+180) mod 720];
            k2 := ((k3+22) mod 720) div 45 + 1;
            EntryEnemyShot(x*100,y*100,ax*3,ay*3, 0,0,8,8, k2, 0);
          end;
          EntryEffect(x,y,0,0,1);
        end;
    9 : begin
          EntrySound(6);
          for iii := 0 to 11 do
          begin
            k3 := (k1 + iii*60) mod 720;
            ay := SC[k3];
            ax := SC[(k3+180) mod 720];
            k2 := ((k3+22) mod 720) div 45 + 1;
            EntryEnemyShot(x*100,y*100,ax*6,ay*6, 0,0,8,8, k2, 1);
          end;
          EntryEffect(x,y,0,0,1);
        end;
    10 : begin
          Entrysound(6);
          ay := SC[k1];
          ax := SC[(k1+180) mod 720];
          k2 := ((k1+22) mod 720) div 45 + 1;
          EntryEnemyShot(x*100+SC[(k1+360)mod 720]*10
                        ,y*100+SC[(k1+180)mod 720]*10
                        ,ax*3,ay*3, 0,0,8,8, k2,  1);
          EntryEnemyShot(x*100-SC[(k1+360)mod 720]*10
                        ,y*100-SC[(k1+180)mod 720]*10
                        ,ax*3,ay*3, 0,0,8,8, k2,  1);
          EntryEffect(x,y,0,0,1);
         end;
    11 : begin
          BackESD := (BackESD + 1) mod 2;
          Entrysound(6);
          for iii := 0 to 5 do
          begin
           if (BackESD=1)then aaa := (k1 + (iii-3)*25 + 720) mod 720
                         else aaa := (k1 + (3-iii)*25 + 720) mod 720;
           ay := trunc(SC[aaa]*(iii*0.4+2));
           ax := trunc(SC[(aaa+180) mod 720]*(iii*0.4+3));
           EntryEnemyShot(x*100,y*100,ax,ay, 0,0,8,8, 1,  0);
          end;
          EntryEffect(x,y,0,0,1);
         end;
     12 : begin
          BackESD := (BackESD + 1) mod 2;
          Entrysound(6);
          for iii := 0 to 5 do
          begin
           if (BackESD=1)then aaa := (k1 + (iii-3)*25 + 720) mod 720
                         else aaa := (k1 + (3-iii)*25 + 720) mod 720;
           ay := trunc(SC[aaa]*(iii*0.5+3));
           ax := trunc(SC[(aaa+180) mod 720]*(iii*0.5+3));
           EntryEnemyShot(x*100,y*100,ax,ay, 0,0,8,8, iii,  3);
          end;
          EntryEffect(x,y,0,0,1);
         end;
     13 : begin
          Entrysound(6);
          for iii := 0 to 5 do
          begin
           ay := trunc(SC[k1]*(iii*0.5+2));
           ax := trunc(SC[(k1+180) mod 720]*(iii*0.5+2));
           EntryEnemyShot(x*100,y*100,ax,ay, 0,0,8,8, iii,  0);
          end;
          EntryEffect(x,y,0,0,1);
         end;
     14 : begin
          entrysound(5);
          EntryEnemyShot(x*100,y*100,ax*4,ay*4, 0,0,8,8, 0,  4);
          end;
     15 : begin                       //|U|
          //EntrySound(14); //͌ŏo
          EntryEnemyShot(x*100,y*100,0,0, 0,0,0,0, 0, 5);
          end;
  end;
end;

//pxŕԂ-----------------------

function TSTG.keisan1(x,y : Integer) : Integer;
var
  atk : Integer;
begin
  //atx := x; aty := y;          //ϐɑ
  //if (atx = 0)then atx := 1;       //O
  //if (aty = 0)then aty := 1;
  //atk := trunc( arctan(aty / atx) * 18000 / 3.1415);  //ArcTangĊpx߂
  //if (atx < 0)then atk := atk + 18000;                //0-360ȓ̊pxɒ
  //if ((x = 0)and(y = 0))then atk := trunc(arctan(0));
  atk := AL.atant2(x,y);
  keisan1 := (atk * 720) shr 10;     //ϐ֑
end;

//蔻s-------------------------

function TSTG.PlayerHit : Boolean;
var
  iii,aaa : Integer;
begin
  PlayerHit := False;
  for iii := 0 to 200 do
  begin
    if (ESD[iii].Empty = true)then
    begin
      aaa := 0;
      if ((abs((PD[0].x+PD[0].h1) - (ESD[iii].x div 100 + ESD[iii].h1))
           < ((PD[0].h3 + ESD[iii].h3) div 2)))then aaa := aaa + 1;
      if ((abs((PD[0].y+PD[0].h2) - (ESD[iii].y div 100 + ESD[iii].h2))
           < ((PD[0].h4 + ESD[iii].h4) div 2)))then aaa := aaa + 1;
      if (aaa = 2)then
      begin
         PlayerHit := True;
         if (ESD[iii].kind <> 5)then ESD[iii].Empty := False;
      end;
    end;
  end;
  {
  for iii := 0 to 50 do
  begin
    if (ED[iii].Hit = True)then
    begin
      aaa := 0;
      if ((abs((PD[0].x+PD[0].h1) - (ED[iii].x+ED[iii].h1))
           < ((PD[0].h3 + ED[iii].h3) div 2)))then aaa := aaa + 1;
      if ((abs((PD[0].y+PD[0].h2) - (ED[iii].y+ED[iii].h2))
           < ((PD[0].h4 + ED[iii].h4) div 2)))then aaa := aaa + 1;
      if (aaa = 2)then
      begin
        PlayerHit := True;
      end;
    end;
  end;
  }
end;


function TSTG.EnemyHit : Boolean;
var
  iii,jjj,kkk,aaa,aaa2 : Integer;
begin
  EnemyHit := False;
  for iii := 0 to 50 do
  if (ED[iii].Empty = true)then
    for jjj := 0 to 75 do
    if (PSD[jjj].Empty = true)then
    if ((ED[iii].Empty = true) and (ED[iii].z > 99))then
    with ED[iii] do
    begin
      aaa := 0;
      if ((abs((x+h1) - (PSD[jjj].x + PSD[jjj].h1))
            < ((h3 + PSD[jjj].h3) div 2)))then aaa := aaa + 1;
      if ((abs((y+h2) - (PSD[jjj].y + PSD[jjj].h2))
            < ((h4 + PSD[jjj].h4) div 2)))then aaa := aaa + 1;
      if (aaa = 2)then
      begin
         PSD[jjj].HitNo := PSD[jjj].HitNo + 1;
         PD[0].score := PD[0].score + 1;
         //EnemyHit := True;
         Hit := 1;//if ((PSD[jjj].kind = 4)and(hit=0))then hit := 1;
         if (PSD[jjj].kind < 4)then EntryEffect(PSD[jjj].x,PSD[jjj].y,                            0,-4,0);
         if (PSD[jjj].kind = 4)then EntryEffect(PSD[jjj].x+AL.Rnd(40)-20,PSD[jjj].y+AL.Rnd(40)-20,0,0 ,0);
         HP := HP - PSD[jjj].power;
         if (PSD[jjj].kind < 4)then PSD[jjj].Empty := False;
         if (HP < 1)then
           begin
             Empty := False;
             DestroyEnemy := (DestroyEnemy + 1) mod 109;//Item
             if ((DestroyEnemy mod 10) = 1)then
               for kkk := 0 to (3+PSD[jjj].HitNo div 14) do EntryItem(x+AL.Rnd(40)-20,y+AL.Rnd(40)-20,0);
             if (DestroyEnemy = 108)then EntryItem(x,y,1);
             //AddScore
             PD[0].score := PD[0].score + (score * (PSD[jjj].HitNo div 7 + 1));
             EntryBom(x,y,0,2,BOM);
             if (MaxComb < (PSD[jjj].HitNo div 7 + 1))then MaxComb := (PSD[jjj].HitNo div 7 + 1);
             if (PSD[jjj].HitNo > 6)then
               //EntryPText(x,y,'x'+IntToStr((PSD[jjj].HitNo div 7) + 1),0);
               EntryPText(x,y,IntToStr(score)+'x'+IntToStr((PSD[jjj].HitNo div 7) + 1),0);
             //Ռ`
             if (z = 100)then
             begin
               aaa2 := AL.Rnd(4);
               STBack.BltFast(IB[29].img,x-25,y-25+(50-(SCount mod 500)div 10),rect(aaa2*50,0,aaa2*50+50,50),
                              DDBLTFAST_SRCCOLORKEY);
             end;

           end;
      end;
    end;

end;

procedure TSTG.BossHit;
var
  iii,jjj,aa1 : Integer;
begin
  //boss
  if (BOD[0].Empty = True)then
   for iii := 0 to 9 do
   if ((BOD[iii].Level = 0)and(BOD[iii].Empty = True))then
    for jjj := 0 to 75 do
    if (PSD[jjj].Empty = true)then
    if ((BOD[iii].Level = 0) and (abs(BOD[iii].z-150)<49) and (BOD[iii].Empty = True))then
    with BOD[iii] do
    begin
      aa1 := 0;
      if ((abs((x+h1) - (PSD[jjj].x + PSD[jjj].h1))
            < ((h3 + PSD[jjj].h3) div 2)))then aa1 := aa1 + 1;
      if ((abs((y+h2) - (PSD[jjj].y + PSD[jjj].h2))
            < ((h4 + PSD[jjj].h4) div 2)))then aa1 := aa1 + 1;
      if (aa1 = 2)then
      begin
         PSD[jjj].HitNo := PSD[jjj].HitNo + 1;
         PD[0].score := PD[0].score + 1;
         Hit := 1;//if ((PSD[jjj].kind = 4) and (hit=0))then Hit := 1;
         if (PSD[jjj].kind < 4)then EntryEffect(PSD[jjj].x,PSD[jjj].y,                            0,-4,0);
         if (PSD[jjj].kind = 4)then EntryEffect(PSD[jjj].x+AL.Rnd(40)-20,PSD[jjj].y+AL.Rnd(40)-20,0,0 ,0);
         HP := HP - PSD[jjj].power; //qbg|Cg炷
         if (PSD[jjj].kind < 4)then PSD[jjj].Empty := False;    //ip|ȊOȂe
         if (HP < 1)then
           begin
             //j󂵂Ƃ
             Level := 1; a1 := 2;  //j󂵂ƂtO
             EnemyShotClear;
             //_̕\ƌvZ
             PD[0].score := PD[0].score + (score * (PSD[jjj].HitNo div 7 + 1));
             EntryBom(x,y,0,0,BOM);
             if (MaxComb < (PSD[jjj].HitNo div 7 + 1))then MaxComb := (PSD[jjj].HitNo div 7 + 1);
             if (PSD[jjj].HitNo > 6)then EntryPText(x,y,IntToStr(score)+'x'+IntToStr((PSD[jjj].HitNo div 7) + 1),0)
                                    else EntryPText(x,y,IntToStr(score),0);
           end;
      end;
    end;
 end;



//Xe|Wt@C̓ǂݍ-------------------------
procedure TSTG.EntryStage(FileName : String; Stage : Integer);
var
  FF : FILE;
  temp : TBitmap;
begin
  StageNo := Stage;
  BackESD := 0;

  if (FileExists(FileName) = False)then begin ErrorCode := 255; exit; end;
  assignfile(ff,FileName);
  ReSet(ff,1);
  blockRead(ff,SD,6916);
  closefile(ff);

  if (FileExists(SD.PartsFile) = False)then begin ErrorCode := 255; exit; end;
  temp := TBitmap.Create;
  temp.LoadFromFile(SD.PartsFile);
  if (PEntry = True)then PBank.free;
  PBank := TDDDDSurFace.CreateOnSystemMemory(DD,temp.width,temp.height,0);
  PBank.LoadBMP(SD.PartsFile);
  PEntry := True;

  PBX := round(temp.Width  / 50);
  PBY := round(temp.Height / 50);
  temp.free;
end;
//Xe|Wpݒ---------------------------------
procedure TSTG.SetUpStage(Speed : Integer);
var
  iii,jjj,ax,ay : integer;
begin
  SurFaceClear(STBack,0);
  BSCount := 500*6;
  SCount := 500*6;
  PSpeed := Speed;
  PSpeed := Pspeed + (SD.MD[6,0]-127);
  StageClear := False;
  for iii := 0 to 6 do
   for jjj := 0 to 5 do
   begin
    ax := SD.MD[jjj,iii] mod PBX;
    ay := SD.MD[jjj,iii] div PBX;
    STBack.BltFast(PBank,jjj*50,300-iii*50,
                   rect(ax*50,ay*50,ax*50+50,ay*50+50),DDBLTFAST_NOCOLORKEY or DDBLTFAST_WAIT);
   end;
end;
//Xe|W
procedure TSTG.MoveStage;
var
  iii,aaa,ax,ay : Integer;
begin
  BSCount := SCount;
  SCount := SCount + PSpeed;
  aaa := Scount div 500;
  //C
  if (aaa = SD.FromLine)then SCount := SD.ToLine*500 + (SCount mod 500);
  //Go
  if (aaa <> (BSCount div 500))then
  begin
   STBack.BltFast(STBack,0,50,rect(0,0,300,300),DDBLTFAST_NOCOLORKEY or DDBLTFAST_WAIT);
   for iii := 0 to 5 do
   begin
    ax := SD.MD[iii,aaa] mod PBX;
    ay := SD.MD[iii,aaa] div PBX;
    STBack.BltFast(PBank,iii*50,0,
                   rect(ax*50,ay*50,ax*50+50,ay*50+50),0);
   end;
   if (SD.MD[6,aaa] < 200)then PSpeed := Pspeed + (SD.MD[6,aaa]-127);
   if ((SD.MD[6,aaa] > 200))then EntryMesBoard;//mesivent := SD.MD[6,aaa];
   for iii := 0 to 5 do
    if (SD.ED[iii,aaa] > 0)then
      AutoEnemy(iii*50+25,-25,SD.ED[iii,aaa]);
  end;
end;

procedure TSTG.SkipStage;
var
  iii,jjj : Integer;
begin
  for iii := 0 to 200 do
    for jjj := 0 to 5 do
     if (SD.ED[jjj,iii] = 255)then
     begin
       SCount := iii*500-100;
     end;
end;

//_\
procedure TSTG.EntryPText(x,y : Integer; Text : String; opt : byte);
var
  iii,jjj,aaa : Integer;
  sss : String;
begin
  iii := 0;
  while ((TD[iii].Empty = True) and (iii<50))do iii := iii + 1;
  TD[iii].Empty := True;
  TD[iii].x := x;
  TD[iii].y := y;
  TD[iii].Count := 80;
  if (opt > 0)then TD[iii].count := 120;
  TD[iii].TextWidth := Length(Text);
  TD[iii].opt := opt;
  for jjj := 0 to TD[iii].TextWidth-1 do
    begin
     StrMid1(sss,Text,jjj+1,1);
     if (opt > 0)then aaa := ansiPos(sss,'0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ (-+')
                 else aaa := AnsiPos(sss,'0123456789xABCDEFGHIJKLMNOPQRSTUVWXYZ %');
     if (aaa = 0)then aaa := 1;
     TD[iii].TextNo[jjj] := aaa;
    end;
  //ʊȌꍇ֊񂹂
  if (TD[iii].y < 25)then
    TD[iii].y := 25;

end;

procedure TSTG.MovePText;
var
  iii : Integer;
begin
  for iii := 0 to 50 do
   if (TD[iii].Empty = True)then
   begin
    TD[iii].x := TD[iii].x + TD[iii].x1;
    TD[iii].y := TD[iii].y + TD[iii].y1;
    TD[iii].count := TD[iii].count - 1;
    if (TD[iii].count < 1)then TD[iii].Empty := False;
   end;
end;

procedure TSTG.StrMid1(var DsStr : String;
                       Var SsStr : String;
                       a,b : Integer);
var
  nnn : Integer;
  sss : string;
begin
  sss := SsStr;
  nnn := Length(SsStr);
  if (a > 1)then delete(sss,1,a-1);
  if (a+b-1 < nnn)then delete(sss,b+1,255);
  if (Length(sss) > 1)then sss := '3';
  DsStr := sss;
  end;
//vC|̔j
procedure TSTG.PlayerDestroy;
begin
  PDCount := PDCount + 1;
  if (PDCount < 3)then Entrybom(PD[0].x,PD[0].y,0,0,5);
  if (PDCount = 40)then
  begin
    NoMiss := 0;
    PD[0].SLevel := PD[0].SLevel - 15;
    if (PD[0].SLevel < 0)then PD[0].SLevel := 0;
    PDCount := 0;
    if (PD[0].PNo > 0)then
    begin
     PD[0].PNo := PD[0].PNo - 1;
     PD[0].HP := 4;          //V|h Full
     PD[0].a2 := 150;        //ENS Full
     if (PD[0].BOM < 3)then PD[0].BOM := 3
                       else PD[0].BOM := PD[0].BOM + 1;
     if (PD[0].BOM > 6)then PD[0].BOM := 6;
     PD[0].NoHit := 100;     //G
    end
    else PD[0].Empty := False;
  end;
end;

//
procedure TSTG.MoveMessage;
begin
  if (MCount > 0)then MCount := MCount - 1;
end;

//ꂼL̉摜\----------------

procedure TSTG.Draw;
var
  iii,jjj,aaa,ax,ay : Integer;
  dddsd,sddsd :  DDSurfaceDesc2;
begin
  //
  DB := 0;
  DE := 0;
  DES := 0;
  DPS := 0;
  //stage
  aaa := 50 - (SCount mod 500) div 10;
  if (BackCut = 1)then
   begin
    PutBackFace(STBack,0,0,rect(0,aaa,300,aaa+300),1);
   end
   ELSE
   begin
    DrawBackGround;
    PutBackFace(STBack,0,0,rect(0,aaa,300,aaa+300),0);
   end;
  //Enemy
  for iii := 0 to EnemyNo-1 do
  begin
   aaa := ESwap[iii];
   if (ED[aaa].Empty = True)then
   begin
    if ((ED[aaa].hit = 1) and (FlashCount = 0))then
      DrawBank(ED[aaa].x,ED[aaa].y,
               ED[aaa].a1,1, ED[aaa].kind + 10,1)
    else
      DrawBank(ED[aaa].x,ED[aaa].y,
               ED[aaa].a1,1, ED[aaa].kind + 10,0);
    DE := DE + 1;
   end;
  end;

   //EnemyBoss
  if (BOD[0].Empty = true)then
  begin
  for iii := 0 to 9 do
   BSwap[iii] := iii;
  for iii := 0 to 9 do
   for jjj := 0 to 10-iii-1 do
    if (BOD[Bswap[iii]].z > BOD[BSwap[iii+jjj]].z)then
    begin
     aaa := BSwap[iii+jjj];
     BSwap[iii+jjj] := Bswap[iii];
     Bswap[iii] := aaa;
    end;
  for iii := 0 to 9 do
  if ((BOD[BSwap[iii]].Empty = True) and
      (BOD[BSwap[iii]].Level < 2))then
   with BOD[BSwap[iii]] do
   begin
   if ((Hit = 1) and (FlashCount = 0))then
     DrawBank(x,y,a1,1,30+ImageNo,1)
   else
     DrawBank(x,y,a1,1,30+ImageNo,Ex);
   end;
  end;

  if (BOD[0].empty = true)then
   for iii := 0 to 9 do
    if ((BOD[iii].Empty = True)and(BOD[BSwap[iii]].Level < 2))then
     with BOD[iii] do
     if ((HP div 160 < 6)and(iii <> 0)and(Hit = 1))then DrawFont(x,y,IntToStr(HP div 16 + 1)+' %',3);

  //Bom
  drawbom;

  //Player
  if (PD[0].HP > 0)then
  begin
    if ((PD[0].NoHit mod 2) = 1)then
      DrawBank(PD[0].x,PD[0].y,4+(PD[0].a1 div 3),PD[0].SelectNo+1,0,1)
    else
      DrawBank(PD[0].x,PD[0].y,4+(PD[0].a1 div 3),PD[0].SelectNo+1,0,0);
    DrawBank(PD[0].x,PD[0].y+20,random(2)+1,4,0,4);
  end;
  //PlayerShot
  AnimeCount := (AnimeCount + 1) and $FF;
  for iii := 0 to 75 do
  if (PSD[iii].Empty = True)then
   with PSD[iii] do
   begin
    case PSD[iii].kind of
    1,2,3 : DrawBank(x,y, a1,1, a3,0);
    4,5   : DrawBank(x,y, a1,1, a3,4);
    10    : DrawBank(x,y*2-150, (AnimeCount and 3) +5,1, 25,4);
    end;
   end;

  //Item
  for iii := 0 to 25 do
    if (ID[iii].Empty = True)then
      DrawBank(ID[iii].x,ID[iii].y,9+ID[iii].kind,3,9,0);

  //PointGetFont
  for iii := 0 to 50 do
   if ((TD[iii].Empty = True)and(TD[iii].count mod 2 = 0))then
     for jjj := 0 to TD[iii].TextWidth-1 do
       with TD[iii] do DrawBank((x+jjj*8)-TextWidth*4,y,TextNo[jjj],1,27,0);

  //Effect
  BackBuf.Lock(dddsd);
  IB[4].Img.Lock(sddsd);
  for iii := 0 to Effectmax do
    if (EFD[iii].Empty = True)then
      AL.DirectBlend(dddsd,EFD[iii].x-4,EFD[iii].y-4,
                     sddsd,rect(EFD[iii].a1*8-8,0,EFD[iii].a1*8,8),BM_SCREEN);
  BackBuf.UnLock;
  IB[4].Img.unLock;

  //ComShot
  for iii := 0 to 200 do
  if (ESD[iii].Empty = True)then
  begin
    if (ESD[iii].kind = 5)then
     with ESD[iii] do
     begin
      aaa := (a3 mod 40) div 2;
      ax := a3 mod 4;
      case (a3 div 40) of
        0 : AL.AlphaBlend(BackBuf,x div 100, y div 100,
                          IB[25].img,rect(ax*40+18,0,
                                          ax*40+20,300),240-aaa*12,
                     BM_SCREEN);
        1,2 : AL.Blend(BackBuf,x div 100 - 20, y div 100,
                     IB[25].img,rect(ax*40,0,
                                     ax*40+40,300),
                      BM_SCREEN);
        3 : AL.AlphaBlend(BackBuf,x div 100 - (20-aaa), y div 100,
                          IB[25].img,rect(ax*40+20 - (20-aaa),0,
                                          ax*40+20 + (20-aaa),300),
                          (20-aaa)*12,BM_SCREEN);                
      end;
     end
    else
      DrawBank(ESD[iii].x div 100,ESD[iii].y div 100,
               ESD[iii].a1,1, 2,0);
    DES := DES + 1;
  end;

  //SpecialEffect
  if (SPEX > 0)then
  begin
    AL.WindNoise(BackBuf,rect(0,0,300,300),SPEX);
    SPEX := SPEX - 1;
  end;
  if (SPEX2 > 0)then
  begin
    aaa := 0;
    if (SPEX2 > 15)then aaa := 15;
    AL.BlendRect(BackBuf,rect(0,150-SPEX2,300,150+SPEX2),$101010*(aaa div 10),BM_SCREEN);
    SPEX2 := SPEX2 - 1;
  end;

  //fBXvC֌W
  //ip[W
  if (PD[0].SelectNo <> 1)then
  begin
       DrawBank(PD[0].x-46,PD[0].y-123,31,1,4,4);
       DrawBank(PD[0].x+46,PD[0].y-123,31,1,4,4);
  end
  else
  begin
       DrawBank(PD[0].x-58,PD[0].y-151,31,1,4,4);
       DrawBank(PD[0].x+58,PD[0].y-151,31,1,4,4);
  end;
  //Xe|^X
  AL.Blend(BackBuf,0,0,Layer,rect(0,16,300,32),BM_NORMAL);
  if (PD[0].y < 280)then AL.Blend(BackBuf,0,284,Layer,rect(0,0,300,16),BM_NORMAL);
  //Փx
  case dif of
    0 : DrawFont(188,10,'NORMAL',3);
    1 : DrawFont(188,10,'HARD',3);
    -1: DrawFont(188,10,'EASY',3);
  end;
  //XRA
  for iii := 0 to 6 do
  begin
   aaa := (PD[0].score div trunc(power(10,iii))) mod 10;
   if (iii > 3)then DrawBank(85-iii*10,10,aaa+1,2,9,4)
               else DrawBank(85-iii*10,10,aaa+1,1,9,4);
  end;
  DrawFont(105,12,PD[0].Name ,3);
  for iii := 0 to 6 do   //hiScore
  begin
   aaa := (SCR.score[DIF+1,0] div trunc(power(10,iii))) mod 10;
   DrawFont(285-iii*7,11,intToStr(aaa),3)
              // else DrawBank(290-iii*12,9,aaa+1,1,9,4);
  end;
  //ENS
  aaa := PD[0].a2 div 2;
  if (aaa > 75)then aaa := 75;
  if (PD[0].y < 280)then
    PutBackFace(ENSBit,20,288,rect(0,8,aaa,16),1)
                    else
    AL.Blend(BackBuf,20,288,ENSBit,rect(0,8,aaa,16),BM_ADD);
  //Shield
  if (PD[0].y < 280)then
    for iii := 0 to PD[0].HP-1 do DrawBank(144+iii*11,291,11,3,9,0)
                    else
    for iii := 0 to PD[0].HP-1 do DrawBank(144+iii*11,291,11,3,9,4);
  //c@
  if (PD[0].y < 280)then
   DrawBank(238,292,1+PD[0].PNo,1,27,0);
  //{
  //if (PD[0].y < 280)then
  DrawBank(280,292,1+PD[0].Bom,1,27,0);
  //BossHP
  if (BOD[0].Empty = True)then
  begin
    BHPBit_Back.BltFast(BHPBit,0,0,rect(0,0,300,10),DDBLTFAST_NOCOLORKEY);
    AL.FillRect(BHPBit_back,rect(BOD[0].HP*300 div BOD[0].maxHP,0,300,10),$000000);
    AL.Blend(BackBuf,0,15,BHPBit_back,rect(0,0,300,10),BM_SCREEN);
  end;
   //PutBackFace(BHPBit,50,20,rect(0,0,(BOD[0].HP*200 div BOD[0].MaxHP),9),0);

  //TMessage
  DrawTMessage;

  //LN^`̃Zt
  DrawMesBoard;
  //e
   //DrawFont(20,20,IntToStr(DES),3);
end;

//BOSSp
//----------------------------------------------------
//----------------------------------------------------
//----------------------------------------------------
procedure TSTG.LoadBoss(filename : string; stage : Byte);
var
  iii : Integer;
  sss : string;
  temp : TBitmap;
begin
  temp := TBitmap.Create;
  for iii := 0 to 9 do
   with BOD[iii] do
   begin
    x := 0; y := 0; z := 0;
    x1 := 0; y1 := 0;
    lx := 0; ly := 0; link := False;
    bom := 0; level := 0; empty := false;
    HP := 0; score := 0; kind := 0;
    h1 := 0; h2 := 0; h3 := 0; h4 := 0;
    count := 0; hit := 0;
   end;
  BDCount := 0;
  BossLevel := 0;
  BossFlash := 0;

  for iii := 0 to 9 do
  begin
   sss := 'bmp\Boss'+IntToStr(stage)+IntToStr(iii)+'.bmp';
   if (FileExists(sss) = true)then
   begin
    temp := TBitmap.create;
    temp.loadfromfile(sss);
    case stage of
      1,2,3,4 : EntryBank(sss,temp.width div 2,temp.height,2,1,30+iii,true,true);
      5 : begin
            if (iii = 0)then EntryBank(sss,temp.width div 2,temp.height,2,1,30+iii,true,true)
                        else EntryBank(sss,temp.width div 2,temp.height,2,1,30+iii,true,False);
          end;
    end;
   end;
  end;

  SettingBoss(stage);
  temp.Free;
end;

procedure TSTG.EntryBoss;
begin
  BOD[0].empty := True;
   //warning Messeage
  MCount := 160;
  MNo := 3;
  //EntryPText(150,200,'',5);
  //EntryPText(100,200,'BIG TARGET',3);
  //EntryPText(180,216,'COMING SOON',3);
  EntrySound(8);
  BossLevel := 0;
end;

procedure TSTG.MoveBoss;
var
  iii,jjj,aaa : Integer;
begin
  if (BOD[0].Empty = true)then
   begin
   for iii := 0 to 9 do
    if (BOD[iii].empty = true)then
    with BOD[iii] do
    begin
     if (((HP * 100 div MaxHP) < 20) and (iii > 0))then
      if ((BossFlash > (HP * 100 div MaxHP)) and (Level = 0))then
      begin
       Hit := 1;
       EntryEffect(x+AL.Rnd(h3)-h3 div 2,y+AL.Rnd(h4)-h4 div 2,0,5,7);
      end;
     if (link = True)then
     begin
      x := BOD[0].x + lx;
      y := BOD[0].y + ly;
     end;
     if (Level = 0)then a1 := 1
                   else a1 := IB[30+BOD[iii].ImageNo].col;
    end;
   //EUp^|
   case BOD[0].kind of
    1 : moveBoss1;
    2 : moveBoss2;
    3 : moveBoss3;
    4 : moveBoss4;
    5 : moveBoss5;
   end;


   for iii := 0 to 9 do
    if (BOD[iii].empty = true)then
    with BOD[iii] do
     if (link = True)then
     begin
      x := BOD[0].x + lx;
      y := BOD[0].y + ly;
     end;

  end;
end;

procedure TSTG.BossDestroy(kind : Byte);
var
  iii : Integer;
begin
  if (BOD[0].HP < 1)then
  begin
   BDCount := BDCount + 1;
   if (BDCount = 1)then
   begin
     EnemyShotClear;
     EntryBom(BOD[0].x,BOD[0].y,0,5,4);
     SpecialEffect;
     EntryMesBoard;
     EntryMesBoard;
   end;

   if ((BDCount and 3) = 0)then Entrysound(0);

   for iii := 0 to 10 do
     if ((BOD[iii].Empty = true)and(((BDCount+iii) mod 3)=0) )then
      if (Al.rnd(BDcount) < 65)
       then with BOD[iii] do EntryBom(x+h1-h3+Al.rnd(h3*2),y+h2-h4+Al.rnd(h4*2),Al.rnd(6)-3,AL.rnd(9),0)
       else with BOD[iii] do EntryBom(x+h1-h3+AL.rnd(h3*2),y+h2-h4+AL.rnd(h4*2),AL.rnd(6)-3,AL.rnd(9),2);

   case kind of
    1 : begin
         BOD[0].y := BOD[0].y + (BDCount div 30);
         if (BDCount > 100)then StageClear := True;
        end;
    2 : begin
          BOD[0].y := BOD[0].y + (BDCount div 30);
         if (BDCount > 100)then StageClear := True;
        end;
    3 : begin     //stage3
        BOD[0].y := BOD[0].y + 1;
        if (BDCount = 100)then StageClear := True;
        end;
    4 : begin     //Stage4
         if (BDCount = 4)then
         begin
           BOD[1].Level := 2; BOD[2].Level := 2;
         end;

         BOD[0].y := (BOD[0].y*9 + BOD[0].y1*1) div 10;
         BOD[0].x := (BOD[0].x*9 + BOD[0].x1*1) div 10;
         case (BDCount div 40) of
           1 : begin
                 BOD[0].x1 := 150;
                 BOD[0].y1 := 50;
               end;
           2 : begin
                 BOD[0].x1 := 150;
                 BOD[0].y1 := 250;
               end;
         end;
         if (BDCount = 110)then StageClear := True;

        end;
    5 : begin   //Stage5
         if (BDCount = 4)then
          for iii := 0 to 4 do
          begin
            BOD[5+iii].empty := False;
            EntryBom(BOD[5+iii].x,BOD[5+iii].y,0,0,2);
          end;
         BOD[0].y := (BOD[0].y*4 + BOD[0].y1*1) div 5;
         BOD[0].x := (BOD[0].x*4 + BOD[0].x1*1) div 5;
         if (BDCount mod 20 = 1)then
         begin
              BOD[0].x1 := AL.Rnd(200)+50;
              BOD[0].y1 := AL.Rnd(200)+50;
              EntryBom(BOD[0].x,BOD[0].y,0,0,5);
         end;
         if (BDCount = 120)then StageClear := True;
        end;

   end;
   for iii := 0 to 9 do
    if (BOD[iii].empty = true)then
    with BOD[iii] do
     if (link = True)then
     begin
      x := BOD[0].x + lx;
      y := BOD[0].y + ly;
     end;
  end;
end;

procedure TSTG.SettingBoss(stage : Byte);
var
  iii : Integer;
begin
 BOD[0].kind := stage;
 for iii := 0 to 9 do BOD[iii].Ex := 0;
 case stage of         //{X̐ݒ
    1:begin            //stage1-------------
        SetBackGround('bmp\bstage1.bmp',0);
        //{
          BossName := 'BLACK DOLL';
        with BOD[0] do begin
        empty := true;
        x := 100; y := 400; z := 55;
        x1 := 1; y1 := -100; a2 := 0;
        score := 10000; HP := 3000;
        h1 := 0; h2 := -15; h3 := 50; h4 := 40;
        ImageNo := 0;
        end;
        //
        with BOD[1] do begin
        empty := true; link := true;
        lx := -95; ly := 7; z := 50; bom := 5;
        score := 4000; HP := 1500;
        h1 := -10; h2 := 8; h3 := 50; h4 := 27;
        ImageNo := 1;
        end;
        //E
        with BOD[2] do begin
        empty := true; link := true;
        lx := 95; ly := 7; z := 50;
        score := 4000; HP := 1500; bom := 5;
        h1 := 10; h2 := 8; h3 := 50; h4 := 27;
        ImageNo := 2;
        end;
        //GW
        with BOD[3] do begin
        empty := true; link := true;
        lx := -60; ly := 20; z := 60;
        score := 1000; HP := 1000; bom := 5;
        h1 := 0; h2 := 0; h3 := 34; h4 := 42;
        ImageNo := 3;
        end;
        //EGW
        with BOD[4] do begin
        empty := true; link := true;
        lx := 60; ly := 20; z := 60;
        score := 1000; HP := 1000; bom := 5;
        h1 := 0; h2 := 0; h3 := 34; h4 := 42;
        ImageNo := 3;
        end;
        //GW
        with BOD[5] do begin
        empty := true; link := true;
        lx := 0; ly := 25; z := 60;
        score := 2000; HP := 2000; bom := 5;
        h1 := 0; h2 := 0; h3 := 40; h4 := 42;
        ImageNo := 4;
        end;
      end;
    2:begin            //stage2-------------
        SetBackGround('bmp\bstage2.bmp',1);
        //{
        BossName := 'SHAKE HAND';
        with BOD[0] do begin
        empty := true;
        x := 150; y := 150; z := 160;
        x1 := 1; y1 := -100; a2 := 0;
        score := 10000; HP := 3500;
        h1 := 0; h2 := 0; h3 := 40; h4 := 50;
        ImageNo := 0;
        end;
        //Op|c
        with BOD[1] do begin
        empty := true; link := true;
        lx := -40; ly := -30; z := 170; bom := 5;
        score := 4000; HP := 2000;
        h1 := 0; h2 := 0; h3 := 25; h4 := 30;
        ImageNo := 1;
        end;
        //EOp|c
        with BOD[2] do begin
        empty := true; link := true;
        lx := 40; ly := -30; z := 170;
        score := 4000; HP := 2000; bom := 5;
        h1 := 0; h2 := 0; h3 := 25; h4 := 30;
        ImageNo := 2;
        end;
        //UIvV1ij
        with BOD[3] do begin
        empty := true; link := true;
        lx := -65; ly := 30; z := 180;
        score := 3000; HP := 2000; bom := 5;
        h1 := 0; h2 := 0; h3 := 35; h4 := 50;
        ImageNo := 3;
        end;
        //UIvV2iEj
        with BOD[4] do begin
        empty := true; link := true;
        lx := 65; ly := 30; z := 180;
        score := 3000; HP := 2000; bom := 5;
        h1 := 0; h2 := 0; h3 := 35; h4 := 50;
        ImageNo := 4;
        end;
        //ij
        with BOD[5] do begin
        empty := true; link := true;
        lx := -40; ly := 105; z := 150;
        score := 2500; HP := 2000; bom := 5;
        h1 := 0; h2 := 0; h3 := 70; h4 := 40;
        ImageNo := 5;
        end;
        //iEj
        with BOD[6] do begin
        empty := true; link := true;
        lx := 40; ly := 105; z := 150;
        score := 2500; HP := 2000; bom := 5;
        h1 := 0; h2 := 0; h3 := 70; h4 := 40;
        ImageNo := 6;
        end;
      end;
    3:begin            //stage3-------------
        SetBackGround('bmp\bstage3.bmp',1);
      //{
        BossName := 'BIG GUN';
        with BOD[0] do begin
        empty := true;
        x := 150; y := -100; z := 140;
        x1 := 0; y1 := 0; a2 := 0;
        score := 10000; HP := 4200;
        h1 := 0; h2 := -30; h3 := 30; h4 := 30;
        ImageNo := 0;
        end;
        //냍PbgCij
        with BOD[1] do begin
        empty := true; link := true;
        lx := -27; ly := -70; z := 150; bom := 5;
        score := 4000; HP := 1500;
        h1 := 0; h2 := 0; h3 := 20; h4 := 20;
        ImageNo := 1;
        end;
        //냍PbgCiEj
        with BOD[2] do begin
        empty := true; link := true;
        lx := 26; ly := -70; z := 150; bom := 5;
        score := 4000; HP := 1500;
        h1 := 0; h2 := 0; h3 := 20; h4 := 20;
        ImageNo := 2;
        end;
        //oJij
        with BOD[3] do begin
        empty := true; link := true;
        lx := -46; ly := 8; z := 150; bom := 5;
        score := 2000; HP := 2500;
        h1 := 0; h2 := 0; h3 := 20; h4 := 50;
        ImageNo := 3;
        end;
        //oJiEj
        with BOD[4] do begin
        empty := true; link := true;
        lx := 50; ly := 9; z := 150; bom := 5;
        score := 2000; HP := 2500;
        h1 := 0; h2 := 0; h3 := 20; h4 := 50;
        ImageNo := 4;
        end;
        //Pbg^Nij
        with BOD[5] do begin
        empty := true; link := true;
        lx := -97; ly := -12; z := 150; bom := 5;
        score := 2500; HP := 2000;
        h1 := 0; h2 := 0; h3 := 40; h4 := 80;
        ImageNo := 5;
        end;
        //Pbg^NiEj
        with BOD[6] do begin
        empty := true; link := true;
        lx := 99; ly := -11; z := 150; bom := 5;
        score := 2500; HP := 2000;
        h1 := 0; h2 := 0; h3 := 40; h4 := 80;
        ImageNo := 6;
        end;
      end;
    4:begin            //stage4-------------
        SetBackGround('bmp\bstage4.bmp',2);
        //{
        BossName := 'BLOOD HUNTER';
        with BOD[0] do begin
        empty := true; bom := 5;
        x := 150; y := 450; z := 150;
        x1 := 150; y1 := 450; a2 := 0;
        score := 10000; HP := 6000;
        h1 := 0; h2 := -30; h3 := 40; h4 := 20;
        ImageNo := 0;
        end;
        //IvV
        with BOD[1] do begin
        empty := True; link := True; bom := 5;
        lx := -120; ly := -90; z := 160;
        x1 := 0; y1 := 0; a2 := 0;
        score := 4000; HP := 2000;
        h1 := 0; h2 := 0; h3 := 60; h4 := 80;
        ImageNo := 1;
        end;
        //EIvV
        with BOD[2] do begin
        empty := True; link := True; bom := 5;
        lx := 120; ly := -90; z := 160;
        x1 := 0; y1 := 0; a2 := 0;
        score := 4000; HP := 2000;
        h1 := 0; h2 := 0; h3 := 60; h4 := 80;
        ImageNo := 2;
        end;
        //oJ
        with BOD[3] do begin
        empty := True; link := True; bom := 5;
        lx := -71; ly := -60; z := 160;
        x1 := 0; y1 := 0; a2 := 0;
        score := 2000; HP := 2500;
        h1 := 0; h2 := 0; h3 := 38; h4 := 90;
        ImageNo := 3;
        end;
        //EoJ
        with BOD[4] do begin
        empty := True; link := True; bom := 5;
        lx := 71; ly := -60; z := 160;
        x1 := 0; y1 := 0; a2 := 0;
        score := 2000; HP := 2500;
        h1 := 0; h2 := 0; h3 := 38; h4 := 90;
        ImageNo := 4;
        end;

      end;

    5 :begin            //stage5 LastBoss-------------
        SetBackGround('bmp\bstage5.bmp',3);
        //{
        BossName := 'CREATURE';
        with BOD[0] do begin
        empty := true; bom := 5;
        x := 150; y := 400; z := 70;
        x1 := 0; y1 := 600; a2 := 0;
        score := 5000; HP := 15000;
        h1 := 0; h2 := 0; h3 := 40; h4 := 40;
        ImageNo := 0;
        end;
        //Ojbg
        with BOD[1] do begin
        empty := True; link := True; bom := 5;
        lx := -50; ly := 50; z := 60;
        x1 := 0; y1 := 0; a2 := 0;
        score := 5000; HP := 4500;
        h1 := 0; h2 := 0; h3 := 40; h4 := 40;
        ImageNo := 1;
        EX := 9;
        end;
        //OjbgE
        with BOD[2] do begin
        empty := True; link := True; bom := 5;
        lx := 50; ly := 50; z := 60;
        x1 := 0; y1 := 0; a2 := 0;
        score := 5000; HP := 4500;
        h1 := 0; h2 := 0; h3 := 40; h4 := 40;
        ImageNo := 2;
        EX := 9;
        end;
        //jbg
        with BOD[3] do begin
        empty := True; link := True; bom := 5;
        lx := -80; ly := 30; z := 50;
        x1 := 0; y1 := 0; a2 := 0;
        score := 6000; HP := 3500;
        h1 := 0; h2 := 0; h3 := 40; h4 := 40;
        ImageNo := 3;
        EX := 9;
        end;
        //jbgE
        with BOD[4] do begin
        empty := True; link := True; bom := 5;
        lx := 80; ly := 30; z := 50;
        x1 := 0; y1 := 0; a2 := 0;
        score := 6000; HP := 3500;
        h1 := 0; h2 := 0; h3 := 40; h4 := 40;
        ImageNo := 4;
        EX := 9;
        end;
        //]jbg
        for iii := 0 to 4 do
         With BOD[5+iii] do
         begin
          empty := False; Link := True; bom := 5;
          lx := 0; ly := 0; z := 190;
          score := 10000; HP := 3000;
          h1 := 0; h2 := 0; h3 := 10; h4 := 10;
          Ex := 4;
          ImageNo := 5;
         end;
      end;

  end;
  BOD[0].Empty := False;
  for iii := 0 to 9 do
  begin
    BOD[iii].MaxHP := BOD[iii].HP;
    BOD[iii].Count := 0;
  end;  
end;

//----------------
procedure TSTG.WaveDraw(rc : TRect; Count : Integer);
begin
  AL.WindNoise(BackBuf,rc,Count*5);
end;
//-------
function TSTG.ConfigRead : Boolean;
var
  iii : Integer;
  ff : file;
begin
  if (FileExists('config.dat') = true)then
  begin
    ConfigRead := True;
    assignfile(ff,'config.dat');
    ReSet(ff,1);
    blockRead(ff,configdata,32);
    closefile(ff);
  end
  else
  begin
    for iii := 0 to 32 do
      ConfigData.Flag[iii] := 0;
    configread := False;  
  end;

end;

procedure TSTG.ConfigWrite;
var
  ff : file;
begin
  if (DiskFree(0) > 1024)then
  begin
    assignfile(ff,'config.dat');
    ReWrite(ff,1);
    blockWrite(ff,ConfigData,32);
    closefile(ff);
  end;
end;

procedure TSTG.DrawBackGround;
var
  aaa : Integer;
begin
  aaa := (BackGroundStep mod 3000) div 10;
  aaa := 300 - aaa;
  PutBackFace(BackGround,0,0,      rect(0,aaa,300,300),1);
  PutBackFace(BackGround,0,300-aaa,rect(0,0,300,aaa),1);
end;

procedure TSTG.SetBackGround(FileName : String; Kind : Byte);
begin
  if (FileExists(FileName) = true)then
  begin
   BackGround := TDDDDSurFace.createOnSystemMemory(DD,300,300,0);
   BackGround.LoadBMP(FileName);
  end
  ELSE
  begin
   BackGround := TDDDDSurFace.createOnSystemMemory(DD,300,300,0);
   SurFaceClear(BackGRound,0);
  end;
  BackGroundStep := 0;
  BackGroundSpeed := SD.MD[6,511]-127;
end;

procedure TSTG.MoveBackGround;
begin
  case BackGroundSpeed of
    0   : BackGroundStep := 0;
    100 : BackGroundStep := BackGroundStep + PSpeed;
    -100: BackGroundStep := BackGroundStep + PSpeed div 2;
    else  backGroundStep := BackGroundStep + BackGroundSpeed;
  end;
  backgroundStep := (backGroundStep + 3000) mod 3000;
end;

procedure TSTG.Clear;
begin
  AL.Fillrect(BackBuf,rect(0,0,300,300),0);
end;

procedure TSTG.SpecialEffect;
begin
  SPEX := 25;
end;

procedure TSTG.SpecialEffect2;
begin
  SPEX2 := 150;
end;

procedure TSTG.MaskColor(Dest : TDDDDSurface; rc : Trect;
                         DestCol,SrcCol : Integer);
var
  dx1,dy1,dx2,dy2 : Integer;
  dddsd:DDSurfaceDesc2;
  dpix1,dpix2 :PWORD;
  jjj,iii,aaa : Integer;
  tempcolor,tempcolor2 : word;
begin
  //Surface݂͑Ă邩ȁH
  if Dest.IsLost Then Exit;
  //Wg₷`
  dx1 := rc.Left ; dy1 := rc.Top;
  dx2 := rc.Right; dy2 := rc.Bottom;
  //͂ݏo֎~
  if (dx1 > dx2)then begin aaa := dx1; dx1 := dx2; dx2 := aaa; end;
  if (dy1 > dy2)then begin aaa := dy1; dx1 := dy2; dy2 := aaa; end;
  if ((dx1 < 0) and (dx2 < 0))then exit;
  if ((dx1 > Dest.Width) and (dx2 > Dest.Width))then Exit;
  if ((dy1 < 0) and (dy2 < 0))then exit;
  if ((dy1 > Dest.Height) and (dy2 > Dest.Height))then Exit;

  if (dx1 < 0)then dx1 := 0;
  if (dy1 < 0)then dy1 := 0;
  if (dx2 > dest.width )then dx2 := dest.Width;
  if (dy2 > dest.Height)then dy2 := dest.Height;

  tempColor := AL.RGB24to16(destCol);
  tempcolor2 := AL.RGB24to16(srcCol);
  //SurfaceLockI
  Dest.Lock(dddsd);
  dpix1:=dddsd.lpSurface;
  //W摜AhXɕϊ
  Inc(dpix1,dx1*1+dy1*(dddsd.lPitch div 2));
  //vfBOB
  for iii := dx1 to dy2-1 do begin
    dpix2 := dpix1;
    for jjj := dx1 to dx2-1 do
    begin
      //F̒uisrcColȂ炻̐FdestColɂj
      if (dpix2^ <> tempcolor2)then
      begin
       dpix2^ := TempColor;
      end;
      //1Pixeli߂
      Inc(dpix2);
    end;
    //1LINEi߂
    Inc(dpix1,(dddsd.lPitch div 2));
  end;
  //SurfaceLockI
  Dest.Unlock;
end;

procedure Tstg.LoadPlayData(filename : string; var aaa : TPlayData);
var
  ff : file;
begin
  if (FileExists(filename) = True)then
  begin
    assignfile(ff,filename);
    ReSet(ff,1);
    blockRead(ff,aaa,sizeof(TPlayData));
    closefile(ff);
  end;
end;

procedure Tstg.SavePlayData(filename : string; var aaa : TPlayData);
var
  ff : file;
begin
  if (DiskFree(0) > 1024)then
  begin
    assignfile(ff,filename);
    ReWrite(ff,1);
    blockWrite(ff,aaa,sizeof(TPlayData));
    closefile(ff);
  end;
end;

procedure TSTG.DrawBom;
var
  iii,aaa : Integer;
begin
  for iii := 0 to BomMax do
  with BD[iii] do
   begin
   aaa := 50-a1;
   if (aaa > 45)then aaa := 45;
   if ((Empty = True) and (kind < 2))then
   begin
    if(kind = 0)then DrawBank(x,y,a3,1, 1,0)
                else Drawbank(x,y,a1,1, 26,4);

   end;
  end;
end;

procedure TSTG.LoadPlayerMes(Filename : string);
var
  ff : textfile;
  InData : string;
  iii,No,aaa : Integer;
begin
  //Ǘϐ̏
  clearMesBoard;
  ev_step := 1;
  ev_count[0] := 0; ev_count[1] := 0;
  ev_time[0] := 100; ev_time[0] := 100;
  AL.FillRect(ev_Buf[0],rect(0,0,200,40),0);
  AL.FillRect(ev_Buf[1],rect(0,0,200,40),0);
  //Zt̓ǂݍ
  if (fileExists(filename) = true)then
  begin
    iii := 0;
    AssignFile(ff,filename);
    Reset(ff);
    No := 0;
    while ((No<31) and (not(EOF(FF))))do
    begin
      inc(iii);
      readln(ff,InData);
      aaa := iii mod 6;
      No  := iii div 6;
      case aaa of
        1 : begin
              mes_Pos[No] := StrToIntDef(InData,0);
            end;
        2 : begin
              mes_Disp[No] := StrToIntDef(InData,0);
            end;
        3 : begin
              mes_Time[No] := StrToIntDef(InData,0);
            end;
        4 : begin
              mes_Text1[No] := InData;
            end;
        5 : begin
              mes_Text2[No] := InData;
            end;
      end;
    end;
    closefile(ff);
  end;
  mesivent := 0;
end;

procedure TSTG.LoadEnemySetData;
var
  FF : File;
begin
//EnemySetData
  assignfile(ff,'EnemySetData.dat');
  ReSet(ff,1);
  BlockRead(ff,ESS,640);
  CloseFile(ff);
end;

procedure TSTG.LoadBossSetData;
var
  FF : File;
begin
//EnemySetData
  assignfile(ff,'BossSetData.dat');
  ReSet(ff,1);
  BlockRead(ff,BSS,3200);
  CloseFile(ff);
end;

procedure TSTG.EntryMesBoard2(mes1,mes2:string;disp,count,pos:Integer);
var
  aaa : Integer;
begin
  if (pos > 1)then exit;
  aaa := pos;
  if (ev_count[aaa] > 0)then ev_time[aaa] := count + 10
                        else ev_time[aaa] := count;
  ev_count[aaa] := count;
  ev_disp[aaa] := disp;
  Al.FillRect(ev_Buf[aaa],rect(0,0,200,40),0);
  AL.TextOut(ev_Buf[aaa],12,6 ,mes1,$FFFFFF,9,[]);
  AL.TextOut(ev_Buf[aaa],11,6 ,mes1,$FFFFFF,9,[]);
  AL.TextOut(ev_Buf[aaa],12,22,mes2,$FFFFFF,9,[]);
  AL.TextOut(ev_Buf[aaa],11,22,mes2,$FFFFFF,9,[]);
end;

procedure TSTG.EntryMesBoard;
var
  aaa: Integer;
begin
  if (mes_pos[ev_step] > 1)then exit;
  aaa := mes_pos[ev_step];
  if (ev_count[aaa] > 0)then ev_time[aaa] := mes_time[ev_step] + 10
                        else ev_time[aaa] := mes_time[ev_step];
  ev_count[aaa] := mes_time[ev_step];
  ev_disp[aaa] := mes_disp[ev_step];
  Al.FillRect(ev_Buf[aaa],rect(0,0,200,40),0);
  AL.TextOut(ev_Buf[aaa],12,6 ,mes_text1[ev_step],$FFFFFF,9,[]);
  AL.TextOut(ev_Buf[aaa],11,6 ,mes_text1[ev_step],$FFFFFF,9,[]);
  AL.TextOut(ev_Buf[aaa],12,22,mes_text2[ev_step],$FFFFFF,9,[]);
  AL.TextOut(ev_Buf[aaa],11,22,mes_text2[ev_step],$FFFFFF,9,[]);
  inc(ev_step);
  if (ev_step > 30)then ev_step := 30;
end;

procedure TSTG.DrawMesBoard;
var
  aaa,bbb : Integer;
begin
  if (ev_count[0] > 0)then
  begin
    aaa := ev_count[0];
    //̃tF[hCEtF[hAEg
    if ((aaa >= 0) and (aaa <= 10))then
    begin
      bbb := aaa;
      Drawbank(220+40,20+40,ev_disp[0]+1,1,24,10+(bbb*15) div 10);
      AL.Blend(Backbuf,20,20,ev_Board,rect(0,0,200,bbb*4),BM_MODULATE);
      BackBuf.BltFast(ev_Buf[0],20,20,rect(0,0,199,bbb*4),DDBLTFAST_WAIT or DDBLTFAST_SRCCOLORKEY);
    end;
    if ((aaa >= ev_time[0]-10) and (aaa <= ev_time[0]))then
    begin
      bbb := aaa - (ev_time[0] - 10);
      Drawbank(220+40,20+40,ev_disp[0]+1,1,24,25-(bbb*15) div 10);
      AL.Blend(Backbuf,20,20,ev_Board,rect(0,0,200,40-bbb*4),BM_MODULATE);
    end;
    if ((aaa >= 11) and (aaa <= ev_time[0]-11))then
    begin
      Drawbank(220+40,20+40,ev_disp[0]+1,1,24,0);
      AL.Blend(Backbuf,20,20,ev_Board,rect(0,0,200,40),BM_MODULATE);
    end;
    //\
    if ((aaa >= ev_time[0]-20)and(aaa <= ev_time[0]-10))then
    begin
      bbb := abs(aaa - (ev_time[0]-10));
      BackBuf.BltFast(ev_Buf[0],20,20,rect(0,0,bbb*20,20),DDBLTFAST_WAIT or DDBLTFAST_SRCCOLORKEY);
    end;
    if ((aaa >= ev_time[0]-30)and(aaa <= ev_time[0]-20))then
    begin
      bbb := abs(aaa - (ev_time[0]-20));
      BackBuf.BltFast(ev_Buf[0],20,20,rect(0,0,200,20)    ,DDBLTFAST_WAIT or DDBLTFAST_SRCCOLORKEY);
      BackBuf.BltFast(ev_Buf[0],20,40,rect(0,20,bbb*20,40),DDBLTFAST_WAIT or DDBLTFAST_SRCCOLORKEY);
    end;
    if ((aaa >= 11)and(aaa <= ev_time[0]-30))then
      BackBuf.BltFast(ev_Buf[0],20,20,rect(0,0,200,40),DDBLTFAST_WAIT or DDBLTFAST_SRCCOLORKEY);

  end;


    if (ev_count[1] > 0)then
  begin
    aaa := ev_count[1];
    //̃tF[hCEtF[hAEg
    if ((aaa >= 0) and (aaa <= 10))then
    begin
      bbb := aaa;
      Drawbank(40,200+40,ev_disp[1]+1,1,24,10+(bbb*15) div 10);
      AL.Blend(Backbuf,80,240,ev_Board,rect(0,40,200,40+bbb*4),BM_MODULATE);
      BackBuf.BltFast(ev_Buf[1],80,240,rect(0,0,199,bbb*4),DDBLTFAST_WAIT or DDBLTFAST_SRCCOLORKEY);
    end;
    if ((aaa >= ev_time[1]-10) and (aaa <= ev_time[1]))then
    begin
      bbb := aaa - (ev_time[1] - 10);
      Drawbank(40,200+40,ev_disp[1]+1,1,24,25-(bbb*15) div 10);
      AL.Blend(Backbuf,80,240,ev_Board,rect(0,40,200,80-bbb*4),BM_MODULATE);
    end;
    if ((aaa >= 11) and (aaa <= ev_time[1]-11))then
    begin
      Drawbank(40,200+40,ev_disp[1]+1,1,24,0);
      AL.Blend(Backbuf,80,240,ev_Board,rect(0,40,200,80),BM_MODULATE);
    end;
    //\
    if ((aaa >= ev_time[1]-20)and(aaa <= ev_time[1]-10))then
    begin
      bbb := abs(aaa - (ev_time[1]-10));
      BackBuf.BltFast(ev_buf[1],80,240,rect(0,0,bbb*20,20),DDBLTFAST_WAIT or DDBLTFAST_SRCCOLORKEY);
    end;
    if ((aaa >= ev_time[1]-30)and(aaa <= ev_time[1]-20))then
    begin
      bbb := abs(aaa - (ev_time[1]-20));
      BackBuf.BltFast(ev_buf[1],80,240,rect(0,0,200,20)    ,DDBLTFAST_WAIT or DDBLTFAST_SRCCOLORKEY);
      BackBuf.BltFast(ev_buf[1],80,260,rect(0,20,bbb*20,40),DDBLTFAST_WAIT or DDBLTFAST_SRCCOLORKEY);
    end;
    if ((aaa >= 11)and(aaa <= ev_time[1]-30))then
      BackBuf.BltFast(ev_buf[1],80,240,rect(0,0,200,40),DDBLTFAST_WAIT or DDBLTFAST_SRCCOLORKEY);

  end;
{
    if ((aaa >= 0)and(aaa <= 9))then
    begin
      bbb := aaa;
      AL.Blend(Backbuf,210,50,ev_Board,rect(0,0,200,bbb*4),BM_MULTIPLE);
      AL.AlphaBlendRect(BackBuf,rect(210,50,210+bbb*8,50+bbb*8),$AAFFAA,bbb*25,BM_SCREEN);
    end;
    if ((aaa >= ev_time[0]-9)and(aaa <= ev_time[0]))then
    begin
      bbb := ev_time[0] - aaa;
      AL.Blend(Backbuf,210-bbb*20,50,ev_Board,rect(0,0,bbb*20,40),BM_MULTIPLE);
      AL.AlphaBlendRect(BackBuf,rect(210,50,210+bbb*8,50+bbb*8),$AAFFAA,bbb*25,BM_SCREEN);
    end;

    if ((aaa >= ev_time[0]-19)and(aaa <= ev_time[0]-10))then
    begin
      bbb := ev_time[0]-10 - aaa;
      AL.Blend(Backbuf,10,50,ev_Board,rect(0,0,200,40),BM_MULTIPLE);
      BackBuf.BltFast(ev_Buf[0],10,50,rect(0,0,bbb*20,20),DDBLTFAST_WAIT or DDBLTFAST_SRCCOLORKEY);
    end;
    if ((aaa >= ev_time[0]-29)and(aaa <= ev_time[0]-20))then
    begin
      bbb := ev_time[0]-20 - aaa;
      AL.Blend(Backbuf,10,50,ev_Board,rect(0,0,200,40),BM_MULTIPLE);
      BackBuf.BltFast(ev_Buf[0],10,50,rect(0,0,199,20)    ,DDBLTFAST_WAIT or DDBLTFAST_SRCCOLORKEY);
      Backbuf.BltFast(ev_Buf[0],10,70,rect(0,20,bbb*20,39),DDBLTFAST_WAIT or DDBLTFAST_SRCCOLORKEY);
    end;
    if ((aaa >= 10)and(aaa <= ev_time[0]-30))then
    begin
      AL.Blend(Backbuf,10,50,ev_Board,rect(0,0,200,40),BM_MULTIPLE);
      BackBuf.BltFast(ev_Buf[0],10,50,rect(0,0,199,39)    ,DDBLTFAST_WAIT or DDBLTFAST_SRCCOLORKEY);
    end;

    if ((aaa > 10)and(aaa < ev_time[0]-9))then
    begin
      AL.AlphaBlendRect(BackBuf,rect(210,50,290,130),$000000,128,BM_NORMAL);
      Drawbank(210+40,50+40,ev_disp[0]+1,1,24,0);
    end;

  end;

  if (ev_count[1] > 0)then
  begin
    aaa := ev_count[1];
    if ((aaa >= 0)and(aaa <= 9))then
    begin
      bbb := aaa;
      AL.Blend(Backbuf,90,180,ev_Board,rect(0,40,bbb*20,80),BM_MULTIPLE);
      AL.AlphaBlendRect(BackBuf,rect(90-bbb*8,180,90,180+bbb*8),$AAFFAA,bbb*25,BM_SCREEN);
    end;
    if ((aaa >= ev_time[1]-9)and(aaa <= ev_time[1]))then
    begin
      bbb := ev_time[1] - aaa;
      AL.Blend(Backbuf,90,180,ev_Board,rect(0,40,bbb*20,80),BM_MULTIPLE);
      AL.AlphaBlendRect(BackBuf,rect(90-bbb*8,180,90,180+bbb*8),$AAFFAA,bbb*25,BM_SCREEN);
    end;

    if ((aaa >= ev_time[1]-19)and(aaa <= ev_time[1]-10))then
    begin
      bbb := ev_time[1]-10 - aaa;
      AL.Blend(Backbuf,90,180,ev_Board,rect(0,40,200,80),BM_MULTIPLE);
      BackBuf.BltFast(ev_Buf[1],90,180,rect(0,0,bbb*20,20),DDBLTFAST_WAIT or DDBLTFAST_SRCCOLORKEY);
    end;
    if ((aaa >= ev_time[1]-29)and(aaa <= ev_time[1]-20))then
    begin
      bbb := ev_time[1]-20 - aaa;
      AL.Blend(Backbuf,90,180,ev_Board,rect(0,40,200,80),BM_MULTIPLE);
      BackBuf.BltFast(ev_Buf[1],90,180,rect(0,0,199,20)    ,DDBLTFAST_WAIT or DDBLTFAST_SRCCOLORKEY);
      Backbuf.BltFast(ev_Buf[1],90,200,rect(0,20,bbb*20,39),DDBLTFAST_WAIT or DDBLTFAST_SRCCOLORKEY);
    end;
    if ((aaa >= 10)and(aaa <= ev_time[1]-30))then
    begin
      AL.Blend(Backbuf,90,180,ev_Board,rect(0,40,200,80),BM_MULTIPLE);
      BackBuf.BltFast(ev_Buf[1],90,180,rect(0,0,199,39)    ,DDBLTFAST_WAIT or DDBLTFAST_SRCCOLORKEY);
    end;

    if ((aaa > 10)and(aaa < ev_time[1]-9))then
    begin
      AL.AlphaBlendRect(BackBuf,rect(10,180,90,260),$000000,128,BM_NORMAL);
      Drawbank(10+40,180+40,ev_disp[1]+1,1,24,0);
    end;

  end;   }
end;

procedure TSTG.ClearMesBoard;
var
  iii : Integer;
begin
  for iii := 0 to 31 do
    mes_pos[iii] := 255;
end;

procedure TSTG.DrawTMessage;
var
  aaa : Integer;
begin
  //bZ|W
  if (MCount > 0)then
  begin
   //AL.BlendRect(BackBuf,rect(0,125,300,175),$888888,BM_MULTIPLE);
   //AL.TVDisplay2(BackBuf,rect(0,125,300,175));
   //if (MCount > 20)then
   if ((MCount > 10)and(MCount < 150))then
   begin
     AL.BlendRect(BackBuf,rect(0,125,300,175),$000000,BM_SCREEN);
     DrawBank(((MCount*6) mod 300)-150,150,1,MNo,8,4);
     DrawBank(((MCount*6) mod 300)+150,150,1,MNo,8,4);
   end;

   case MCount of

     140..149,0..9:
              begin
               aaa := (MCount mod 10) + 1;
               AL.BlendRect(BackBuf,rect(150-aaa*15,150-aaa*2,150+aaa*15,150+aaa*2),
                            AL.RGB24to16($181818*aaa),BM_SCREEN);
              end;
     150..159,10..19:
              begin
               aaa := (MCount mod 10) + 1;
               AL.BlendRect(BackBuf,rect(aaa*15,125+aaa*2,300-aaa*15,175-aaa*2),
                            AL.RGB24to16($FFFFFF-$181818*aaa),BM_SCREEN);
              end;

   end;

  end;                       
end;

procedure TSTG.MoveBoss1;
var
  iii,jjj,aaa : Integer;
begin
  with BOD[0] do
        begin
         if ((y > -70)and(a2 = 0))then
          begin y := y - 12; EntryBom(x,y,AL.Rnd(15)-7,AL.Rnd(8),0); entrysound(0);end;
         if ((y < -70)and(a2 = 0))then
          begin a2 := 1; for jjj := 0 to 5 do BOD[jjj].z := BOD[jjj].z + 100; end;
         if (a2 = 1)then y1 := y1 + 1;
         if ((a2 = 1)and(y1 > 60))then a2 := 2;
         if (a2 > 0)then y := y1 + SC[(count*5 mod 720)]*30 div 100;
         x := x + x1;
         if ((x < 50)or(x > 250))then x1 := -x1;
         count := (count + 1) mod 720;
         if (a2 = 2)then
         begin
          if (count mod (20-dif*10) = 1)then
           if (BOD[1].level=0)then autoenemyshot(x-25,y,5,-1)
                              else autoenemyshot(x-25,y,3,-1);
          if (count mod (20-dif*10) = 1)then
           if (BOD[2].level=0)then autoenemyshot(x+25,y,5,-1)
                              else autoenemyshot(x+25,y,3,-1)

         end;
         end;
         if (BOD[0].count mod (30-dif) = 1)then
         begin
           if ((BOD[1].level=0)and(BOD[3].Level>0))then
             if (dif = 1)then autoenemyshot(BOD[1].x,BOD[1].y,10,-1)
                         else autoenemyshot(BOD[1].x,BOD[1].y,13,200);
           if ((BOD[2].level=0)and(BOD[4].Level>0))then
             if (dif = 1)then autoenemyshot(BOD[2].x,BOD[2].y,10,-1)
                         else autoenemyshot(BOD[2].x,BOD[2].y,13,160);
         end;
end;

procedure TSTG.MoveBoss2;
var
  iii,jjj,aaa,tempLevel : Integer;
begin
  inc(BOD[0].count);
  aaa := BOD[0].count;
  tempLevel := BossLevel;

  case BossLevel of
    0 :  begin  //o
           BOD[0].x := 150;
           BOD[0].y := -200+aaa*2;
           if (aaa > 125)then inc(BossLevel);
         end;
    1  : begin  //Ɉړ
           BOD[0].x := 150;
           BOD[0].y := 50 + aaa * 2;
           if (aaa > 100)then inc(BossLevel);
         end;
    2 : begin   //
           if ((aaa mod 4)=0)then AutoEnemyShot(BOD[0].x,BOD[0].y,8,aaa*(2+dif));
           if (aaa > 40)then inc(BossLevel);
         end;
    3 : begin   //˂炢``
           if ((aaa mod 30)<10)then AutoEnemyShot(BOD[0].x,BOD[0].y,5,-1);
           if (aaa > 120)then BossLevel := 4;
         end;
    4  : begin  //Oւǂ
           BOD[0].x := 150;
           BOD[0].y := 250 - aaa * 2;
           if (aaa > 100)then inc(BossLevel);
         end;
    5 : begin   //[U[
           if ((BOD[3].level = 0)and(aaa = 10))then AutoEnemyShot(BOD[3].x,BOD[3].y,15,0);
           if ((BOD[3].level <> 0)and((aaa mod (7-dif*2))=0))then AutoEnemyShot(BOD[0].x-40,BOD[0].y,3,-1);
           if ((BOD[4].level = 0)and(aaa = 10))then AutoEnemyShot(BOD[4].x,BOD[4].y,15,0);
           if ((BOD[4].level <> 0)and((aaa mod (7-dif*2))=0))then AutoEnemyShot(BOD[0].x+40,BOD[0].y,3,-1);
           if (aaa > 150)then inc(BossLevel);
           if ((dif = 1)and((aaa mod 10)=1))then AutoEnemyShot(BOD[0].x,BOD[0].y+15,3,-1);
         end;
    6 : begin   //3
           if ((aaa mod 6) = 0)then
           begin
             AutoEnemyShot(BOD[0].x-15,BOD[0].y,4,360-aaa*4);
             AutoEnemyShot(BOD[0].x+15,BOD[0].y,4,aaa*4);
           end;
           if ((dif = 1)and((aaa mod 10)=1))then AutoEnemyShot(BOD[0].x,BOD[0].y+15,3,-1);
           if (aaa > 80)then inc(BossLevel);
         end;
    7 : begin   //@
           BOD[0].x := 150-AL.SinT2(aaa*4) div 10;
           BOD[0].y := abs(BOD[0].x-150) div 2 + 50;
           if ((aaa mod (20-dif*5))=0)then
           begin
             AutoEnemyShot(BOD[4].x-10,BOD[4].y,8,-1);
             AutoEnemyShot(BOD[3].x+10,BOD[3].y,8,AL.rnd(360));
           end;
           if (((aaa mod 40)<5)and(dif = 1))then AutoEnemyShot(BOD[0].x,BOD[0].y,4,-1);
           if (aaa > 256)then inc(BossLevel);
         end;
    8 : begin   //ӂӂ
           BOD[0].x := 150;
           BOD[0].y := 50;
           if ((aaa > 20)and(aaa < 40))then
           begin
             if ((aaa mod 4)=0)then AutoEnemyShot(BOD[0].x-20,BOD[0].y,8,aaa*(1+dif));
             if ((aaa mod 4)=2)then AutoEnemyShot(BOD[0].x+20,BOD[0].y,8,aaa*(1+dif));
           end;
           if (aaa > 80)then inc(BossLevel);
         end;
    9 : begin  //
          BOD[0].x := 150;
          BOD[0].y := 50 + aaa * 2;
          if (aaa > 50)then inc(BossLevel);
        end;
    10:begin //@
          if (aaa = 20)then
            for iii := 0 to 30 do AutoEnemyShot(BOD[0].x,BOD[0].y,14,iii*24);
          if ((dif = 1)and(aaa = 40))then AutoEnemyShot(BOD[0].x,BOD[0].y,9,0);
          if (aaa > 72)then inc(BossLevel);
       end;
    11:begin
          BOD[0].x := 150;
          BOD[0].y := 150 + aaa * 2;
          if (aaa > 50)then BossLevel := 2;
       end;

  end;

  if (tempLevel <> BossLevel)then BOD[0].count := 0;
end;

procedure TSTG.MoveBoss3;
var
  iii,jjj,aaa : Integer;
  TempLevel : Integer;
begin
       inc(BOD[0].count);
  aaa := BOD[0].count;
  tempLevel := BossLevel;

  case BossLevel of
    0 :  begin
           if (aaa > 160)then inc(BossLevel);
         end;
    1 :  begin  //o
           BOD[0].x := 150;
           BOD[0].y := -200+aaa*6;
           if (aaa > 120)then inc(BossLevel);
           if (((aaa mod 3)=1)and(BOD[0].y<300))then
           begin
             AutoEnemyShot(BOD[1].x,BOD[1].y,14,aaa*8);
             AutoEnemyShot(BOD[2].x,BOD[2].y,14,aaa*8);
           end;
         end;
    2  : begin  //߂Ă
           BOD[0].y := 500 - aaa*2;
           if (BOD[0].y < 200)then
           begin
             AutoEnemyShot(BOD[1].x,BOD[1].y,6,-1);
             AutoEnemyShot(BOD[2].x,BOD[2].y,5,-1);
           end;
           if (aaa > 200)then inc(BossLevel);
         end;
    3  : begin  //cC
           BOD[0].y := 100;
           if ((aaa mod (15-dif*5))=0)then
           begin
             AutoEnemyShot(BOD[0].x-20,BOD[0].y-32,3,360-aaa*2);
             AutoEnemyShot(BOD[0].x-30,BOD[0].y-32,3,360-aaa*2);
             AutoEnemyShot(BOD[0].x+20,BOD[0].y-32,3,aaa*2);
             AutoEnemyShot(BOD[0].x+30,BOD[0].y-32,3,aaa*2);
           end;
           if (aaa > 180)then inc(BossLevel);
         end;
    4  : begin  //ړ
           BOD[0].y := 100-aaa;
           if (aaa > 50)then inc(BossLevel);
         end;
    5  : begin  //KbK
           BOD[0].y := 50;
           if ((aaa mod (6-dif*3))=0)then
           begin
             AutoEnemyShot(BOD[0].x-25,BOD[0].y-32,3,720-aaa*8);
             AutoEnemyShot(BOD[0].x-25,BOD[0].y-32,3,720-aaa*8+360);
             AutoEnemyShot(BOD[0].x+25,BOD[0].y-32,3,aaa*8);
             AutoEnemyShot(BOD[0].x+25,BOD[0].y-32,3,aaa*8+360);
           end;
           if (aaa > 90)then inc(BossLevel);
         end;
    6  : begin  //KbK
           BOD[0].y := 50;
           if ((aaa mod (6-dif*3))=0)then
           begin
             if (BOD[3].level <> 0)then
             begin
               AutoEnemyShot(BOD[0].x-25,BOD[0].y-32,4,aaa*8);
               AutoEnemyShot(BOD[0].x-25,BOD[0].y-32,4,aaa*8+360);
             end
             else
               AutoEnemyShot(BOD[3].x,BOD[3].y+45-aaa,14,360-aaa*4);

             if (BOD[4].level <> 0)then
             begin
               AutoEnemyShot(BOD[0].x+25,BOD[0].y-32,4,720-aaa*8);
               AutoEnemyShot(BOD[0].x+25,BOD[0].y-32,4,720-aaa*8+360);
             end
             else
               AutoEnemyShot(BOD[4].x,BOD[4].y+45-aaa,14,aaa*4);
           end;
           if (aaa > 90)then inc(BossLevel);
         end;
    7  : begin  //ړ
           BOD[0].y := 50+aaa;
           if (aaa > 50)then inc(BossLevel);
         end;
    8 : begin
          if ((aaa mod (30-dif*10))=0)then
          begin
            if (BOD[3].level = 0)then
               for iii:=0 to 10 do
                 AutoEnemyShot(BOD[3].x-20+AL.rnd(20),BOD[3].y-20+AL.rnd(40),1,-1)
            else
               for iii:=0 to 3 do
                 AutoEnemyShot(BOD[0].x-30+AL.rnd(20),BOD[0].y-20+AL.rnd(40),13,-1);

            if (BOD[4].level = 0)then
               for iii:=0 to 10 do
                 AutoEnemyShot(BOD[4].x-20+AL.rnd(20),BOD[4].y-20+AL.rnd(40),1,-1)
            else
               for iii:=0 to 3 do
                 AutoEnemyShot(BOD[0].x+10+AL.rnd(20),BOD[0].y-20+AL.rnd(40),13,-1);
          end;
          if (aaa > 120)then inc(BossLevel);
        end;
    9  : begin  //΂܂
           if ((aaa mod (6-dif*3))=0)then
           begin
             AutoEnemyShot(BOD[0].x-40,BOD[0].y-35,11,aaa*8);
             AutoEnemyShot(BOD[0].x+40,BOD[0].y-35,11,10800-aaa*8);
           end;
           if (aaa > 90)then inc(BossLevel);
         end;
    10 : begin  //ҋ@
           BOD[0].y := 100-aaa;
           if (aaa > 50)then inc(BossLevel);
         end;
    11 : begin  //΂܂
           BOD[0].y := 50+aaa*4;
           if ((aaa mod (8-dif*3))=0)then
           begin
             AutoEnemyShot(BOD[0].x-40,BOD[0].y-35,11,370-aaa*5);
             AutoEnemyShot(BOD[0].x+40,BOD[0].y-35,11,aaa*5);
           end;
           if (aaa > 100)then inc(BossLevel);
         end;
    12 : begin  //ړ
           BOD[0].y := 500-aaa*2;
          if ((aaa mod (7-dif*3))=0)then
           begin
             AutoEnemyShot(BOD[0].x-25,BOD[0].y-32,3,1440-aaa*6);
             AutoEnemyShot(BOD[0].x+25,BOD[0].y-32,3,aaa*6);
           end;
           if (aaa > 200)then inc(BossLevel);
         end;
    13 : begin  //_e
           BOD[0].y := 100;
           if ((aaa mod (2-dif))=0)then
           begin
             AutoEnemyShot(BOD[1].x,BOD[1].y,6,aaa*4);
             AutoEnemyShot(BOD[2].x,BOD[2].y,5,1080-aaa*4);
           end;
           if (aaa > 100)then BossLevel := 3;
         end;
  end;

  STBack.BltFast(IB[29].img,BOD[0].x-60-AL.rnd(35),BOD[0].y-55+(50-(SCount mod 500)div 10)-AL.rnd(10),
                 rect(0,0,50,50),DDBLTFAST_SRCCOLORKEY);
  STBack.BltFast(IB[29].img,BOD[0].x+10+AL.rnd(35),BOD[0].y-55+(50-(SCount mod 500)div 10)-Al.rnd(10),
                 rect(0,0,50,50),DDBLTFAST_SRCCOLORKEY);

  if (tempLevel <> BossLevel)then BOD[0].count := 0;
end;

procedure TSTG.MoveBoss4;
var
  iii,jjj,aaa,templevel : Integer;
begin
  inc(BOD[0].count);
  aaa := BOD[0].count;
  tempLevel := BossLevel;

  //move code
  BOD[0].y := (BOD[0].y*9 + BOD[0].y1*1) div 10;
  BOD[0].x := (BOD[0].x*9 + BOD[0].x1*1) div 10;

  case (BossLevel) of
    0 : begin  //ҋ@
         if (aaa > 100)then inc(BossLevel);
        end;
    1 : begin
         BOD[0].y1 := 200;
         if (aaa > 40)then inc(bosslevel);
        end;
    2 : begin
         BOD[0].y1 := 100;
         if (aaa > 50)then inc(bosslevel);
        end;
    3 : begin
         BOD[0].y1 := 100;
         if ((aaa mod (8 - dif*3)) = 0)then
         begin
          if (BOD[1].level <> 0)then AutoEnemyShot(BOD[0].x-10,BOD[0].y-20,13,1080-aaa*4)
                                else AutoEnemyShot(BOD[1].x,BOD[1].y,13,1080-aaa*4);
          if (BOD[2].level <> 0)then AutoEnemyShot(BOD[0].x+10,BOD[0].y-20,13,aaa*4)
                                else AutoEnemyShot(BOD[2].x,BOD[2].y,13,aaa*4);
         end;
         if (aaa = 90)then inc(BossLevel);
        end;
    4 : if (aaa > 100)then inc(BossLevel);
    5 : begin
          BOD[0].y1 := 175;
           if ((aaa mod (5-dif*2))=0)then
           begin
             AutoEnemyShot(BOD[0].x-10,BOD[0].y-32,3,720-aaa*8);
             AutoEnemyShot(BOD[0].x-10,BOD[0].y-32,3,720-aaa*8+360);
             AutoEnemyShot(BOD[0].x+10,BOD[0].y-32,3,aaa*8);
             AutoEnemyShot(BOD[0].x+10,BOD[0].y-32,3,aaa*8+360);
           end;
           if (aaa > 90)then inc(BossLevel);
         end;
    6 : begin
         BOD[0].y1 := 100;
         if (aaa > 50)then inc(BossLevel);
        end;
    7 : begin
           if ((aaa mod (5-dif*2))=0)then
           begin
             AutoEnemyShot(BOD[0].x-10,BOD[0].y-32,3,720-aaa*8);
             AutoEnemyShot(BOD[0].x-10,BOD[0].y-32,4,720-aaa*8+360);
             AutoEnemyShot(BOD[0].x+10,BOD[0].y-32,3,aaa*8);
             AutoEnemyShot(BOD[0].x+10,BOD[0].y-32,4,aaa*8+360);
           end;
           if (aaa > 90)then inc(BossLevel);
         end;
    8 : if (aaa > 50)then inc(BossLevel);
    9 : begin
         if ((aaa mod (25-dif*5)) = 0)then
         begin
           AutoEnemyShot(BOD[1].x,BOD[1].y,14,-1);
           AutoEnemyShot(BOD[2].x,BOD[2].y,14,-1)
         end;
         if (((aaa mod 2)=0)and((aaa mod 27)<8))then
         begin
           AutoEnemyShot(BOD[3].x,BOD[3].y,9,aaa*(3+dif));
           AutoEnemyShot(BOD[4].x,BOD[4].y,9,1440-aaa*(3+dif));
         end;
         if (aaa > 200)then inc(BossLevel);
        end;
    10 : begin
         BOD[0].y1 := 150;
         if ((aaa mod (25-dif*5)) = 0)then
         begin
           AutoEnemyShot(BOD[0].x-5,BOD[0].y-30,14,630);
           AutoEnemyShot(BOD[0].x+5,BOD[0].y-30,14,450);
         end;
         if (((aaa mod 2)=0)and((aaa mod 27)<8))then
         begin
           AutoEnemyShot(BOD[3].x,BOD[3].y,9,aaa*(3+dif));
           AutoEnemyShot(BOD[4].x,BOD[4].y,8,aaa*(3+dif));
         end;
         if (aaa > 200)then inc(BossLevel);
        end;
    11 : begin
           if ((aaa mod (4-dif*2))=0)then
           begin
             AutoEnemyShot(BOD[1].x,BOD[1].y-15,2,-1);
             AutoEnemyShot(BOD[2].x,BOD[2].y-15,2,-1);
           end;
           if (aaa > 100)then inc(BossLevel);
         end;
    12 : begin
           BOD[0].y1 := -100;
           if (aaa > 50)then inc(BossLevel);
         end;
    13 : begin
           if (aaa = 5)then
            for iii := 0 to (8+dif*5) do
             AutoEnemyShot(AL.rnd(325),0,15,-1);
           if (aaa > 200)then BossLevel := 3;
         end;
  end;

  if (tempLevel <> BossLevel)then BOD[0].count := 0;

end;

procedure TSTG.MoveBoss5;
var
  iii,jjj,aaa : Integer;
begin
  BOD[0].Count := BOD[0].count + 1;
             //BossLeveli܂ȍsLevelj
             case BossLevel of
               0 : //ҋ@
                  begin
                     if (BOD[0].count = 150)then begin BOD[0].count := 0; BossLevel := 1; end;
                  end;
               1 : //oV|
                  begin
                    BOD[0].x1 := 150; BOD[0].y1 := 60;
                    BOD[0].y := (BOD[0].y*14 + BOD[0].y1*1) div 15;
                    BOD[0].x := (BOD[0].x*14 + BOD[0].x1*1) div 15;
                    if (BOD[0].count = 40)then begin BOD[0].count := 0; BossLevel := 2; end;
                  end;
               2 : //oV|wʉ
                  begin
                    for iii := 0 to 3 do
                      BOD[1+iii].Ex := 10 + BOD[0].Count div 5;
                    if (BOD[0].count = 75)then
                    begin
                      for iii := 0 to 3 do BOD[1+iii].Ex := 0;
                      SpecialEffect;
                      for iii := 0 to 4 do BOD[iii].z := BOD[iii].z + 100;
                      BOD[0].count := 0; BossLevel := 3;
                      mesIvent := (123+127);
                    end;
                  end;
                3 : //U`
                   begin
                     BOD[0].Count := BOD[0].Count mod 1200;
                     aaa := BOD[0].Count mod 60;
                     //{̈ړ
                     BOD[0].y := (BOD[0].y*5 + BOD[0].y1*1) div 6;
                     BOD[0].x := (BOD[0].x*5 + BOD[0].x1*1) div 6;
                     if (aaa = 50)then
                     begin
                       BOD[0].x1 := AL.Rnd(100)+100;
                       BOD[0].y1 := AL.Rnd(40)+60;
                     end;
                     //Q`Ԉڍs
                     if (BOD[0].HP < 9000)then begin BOD[0].Count := 0;BossLevel := 4; end;
                     if (aaa < 50)then case (BOD[0].Count div 60) of
                      1,4,15,16 : //{̐
                       begin
                        if (aaa mod (4-Dif) = 1)then
                        begin
                         AutoEnemyShot(BOD[0].x-30,BOD[0].y,4,aaa*6);
                         AutoEnemyShot(BOD[0].x+30,BOD[0].y,4,360-aaa*6);
                        end;
                       end;
                      8 : //E΂T
                       begin
                        if (aaa mod (7-Dif*2) = 1)then
                        begin
                         BackESD := 1;
                         if (BOD[3].Level=0)then AutoEnemyShot(BOD[3].x,BOD[3].y-10,13,270-aaa*5)
                                            else AutoEnemyShot(BOD[0].x-25,BOD[0].y+3,13,270-aaa*5);
                         if (BOD[4].Level=0)then AutoEnemyShot(BOD[4].x,BOD[4].y-10,13,90+aaa*5)
                                            else AutoEnemyShot(BOD[0].x+25,BOD[0].y-3,13,90+aaa*5);
                        end;
                       end;
                      2,9,17,18 : //
                       begin
                        if (aaa mod (5-Dif) = 1)then
                        begin
                         BackESD := 1;
                         if (BOD[3].Level=0)then AutoEnemyShot(BOD[3].x,BOD[3].y-10,11,360-aaa*7)
                                            else AutoEnemyShot(BOD[0].x-30,BOD[0].y+3,11,360-aaa*7);
                         if (BOD[4].Level=0)then AutoEnemyShot(BOD[4].x,BOD[4].y-10,11,aaa*7)
                                            else AutoEnemyShot(BOD[0].x+30,BOD[0].y-3,11,aaa*7);
                        end;
                       end;
                      5,12,19 : //^ԉ
                       begin
                         if (aaa mod (3-Dif) = 1)then
                          begin
                           AutoEnemyShot(BOD[0].x+30,BOD[0].y+10,14,aaa*12);
                           AutoEnemyShot(BOD[0].x-30,BOD[0].y+10,14,720-aaa*12);
                          end;
                       end;
                      7,11 : //]
                       begin
                        if (aaa<20)then if (aaa mod 3 = 1)then
                        begin
                         if (BOD[1].Level=0)then AutoEnemyShot(BOD[1].x,BOD[1].y,9,aaa*(2+DIF))
                                            else AutoEnemyShot(BOD[0].x-20,BOD[0].y,9,aaa*(4+DIF*2));
                         if (BOD[2].Level=0)then AutoEnemyShot(BOD[2].x,BOD[2].y,9,aaa*(2+DIF))
                                            else AutoEnemyShot(BOD[0].x+20,BOD[0].y,9,aaa*(4+DIF*2));
                        end;
                       end;
                      14 : //]iuNn[cj
                       begin
                        if (aaa mod (5-DIF) = 1)then
                        begin
                         if (BOD[1].Level=0)then AutoEnemyShot(BOD[1].x,BOD[1].y,9,aaa*10)
                                            else AutoEnemyShot(BOD[0].x-30,BOD[0].y+3,9,aaa*10);
                         if (BOD[2].Level=0)then AutoEnemyShot(BOD[2].x,BOD[2].y,9,720-aaa*10)
                                            else AutoEnemyShot(BOD[0].x+30,BOD[0].y-3,9,720-aaa*10);
                        end;
                       end;
                     end;

                   end;
                4 : //p|c؂藣 -----------
                   begin
                     if (BOD[0].count = 3)then EntryMesBoard;
                     for iii := 0 to 3 do BOD[iii+1].ly := BOD[iii+1].ly + 1;
                     if (BOD[0].Count = 120)then
                     begin
                       for iii := 0 to 3 do
                       begin
                         EntryBom(BOD[1+iii].x,BOD[1+iii].y,0,0,5);
                         BOD[1+iii].Empty := False;
                         BOD[0].Count := 0;
                         BossLevel := 5;
                       end;
                     end;
                   end;
                5 : //EɗhԂčU
                   begin
                    //̍U
                    if (BOD[0].Count = 1190)then
                    begin
                      BOD[0].Count := 0;
                      BossLevel := 6;
                    end;
                    aaa := BOD[0].Count mod 60;
                    //{̈ړ
                    case (BOD[0].Count div 60) of
                      9,19,20 : //S
                         begin
                          BOD[0].x1 := 150; BOD[0].y1 := 100;
                          BOD[0].y := (BOD[0].y*15 + BOD[0].y1*1) div 16;
                          BOD[0].x := (BOD[0].x*15 + BOD[0].x1*1) div 16;
                         end;
                      0,10 : //ʊO
                         begin
                         if (aaa = 2)then
                            for iii := 0 to 24 do AutoEnemyShot(BOD[0].x,BOD[0].y,13,iii*30);
                          BOD[0].x1 := 150; BOD[0].y1 := -150;
                          BOD[0].y := (BOD[0].y*15 + BOD[0].y1*1) div 16;
                          BOD[0].x := (BOD[0].x*15 + BOD[0].x1*1) div 16;
                         end;
                      2,6,12,16 : //E琳
                         begin
                          BOD[0].x := 150+SC[360-aaa*6+180]*3;
                          BOD[0].y := -80+SC[360-aaa*6];
                          if (aaa mod (3-Dif) = 0)then
                          begin
                               //AutoEnemyShot(BOD[0].x,BOD[0].y,13,180);
                               AutoEnemyShot(BOD[0].x,BOD[0].y,11,-1);
                               AutoEnemyShot(BOD[0].x,BOD[0].y,9,-1);
                          end;
                         end;
                      4,7,14,17 : //E琳
                         begin
                          BOD[0].x := 150+SC[aaa*6+180]*3;
                          BOD[0].y := -80+SC[aaa*6];
                          if (aaa mod (3-Dif) = 0)then
                          begin
                               AutoEnemyShot(BOD[0].x,BOD[0].y,9,-1);
                               AutoEnemyShot(BOD[0].x,BOD[0].y,14,-1);
                               AutoEnemyShot(BOD[0].x,BOD[0].y,13,180);
                          end;
                         end;
                    end;

                   end;

                6 :begin //]jbg
                     if (BOD[0].count = 3)then EntryMesBoard;
                     BOD[5].Count := (BOD[5].Count + 4) mod 720;  //jbg̉]pƂȂ
                     for iii := 0 to 4 do
                     begin
                       BOD[5+iii].Ex := 30+BOD[0].Count div 5;
                       BOD[5+iii].lx := SC[(BOD[5].Count+iii*144+180) mod 720];
                       BOD[5+iii].ly := SC[(BOD[5].Count+iii*144) mod 720];
                       BOD[5+iii].Empty := True;
                     end;
                     if (BOD[0].Count = 74)then
                     begin
                       for iii := 0 to 4 do BOD[5+iii].Ex := 4;
                       BOD[0].Count := 0;
                       BossLevel := 7;
                       BOD[5].a3 := 1000;  //aTCYɂ
                       BOD[5].a4 := 1000;
                     end;
                     BOD[0].x1 := 150;
                     BOD[0].y1 := 60;
                     BOD[0].y := (BOD[0].y*9 + BOD[0].y1*1) div 10;
                     BOD[0].x := (BOD[0].x*9 + BOD[0].x1*1) div 10;
                   end;

                7 :begin //]jbgōU
                     BOD[5].Count := (BOD[5].Count + 6) mod 720;  //jbg̉]pƂȂ
                     BOD[0].Count := BOD[0].Count mod 1200;
                     aaa := BOD[0].Count mod 120;
                     BOD[5].a3 := (BOD[5].a3*15 + BOD[5].a4) div 16;
                     for iii := 0 to 4 do
                     begin
                       BOD[5+iii].lx := (SC[(BOD[5].Count+iii*144+180) mod 720]*BOD[5].a3) div 1000;
                       BOD[5+iii].ly := (SC[(BOD[5].Count+iii*144) mod 720]*BOD[5].a3) div 1000;
                     end;

                     for iii := 0 to 4 do with BOD[5+iii] do
                      case (BOD[0].Count div 120) of
                       0   : //P_W
                          begin
                            BOD[5].a4 := 100;
                            if (aaa mod (25-Dif*10) = 12)then
                            begin
                              AutoEnemyShot(x,y,9,-1);
                              AutoEnemyShot(x,y,9,Al.rnd(720));
                            end;
                          end;
                       1 : //KbKe
                          begin
                            BOD[5].a4 := 800;
                            if (aaa = 5)then AutoEnemyShot(x,y,15,0);
                            if (aaa mod (7-Dif*2) = 1)then
                            begin
                              AutoEnemyShot(x,y,10,aaa*6);
                              AutoEnemyShot(x,y,10,aaa*6+360);
                            end;
                          end;
                       2 : //_
                          begin
                            BOD[5].a4 := 350;
                            if (aaa mod (10-Dif*4) = 1)then
                            begin
                              AutoEnemyShot(x,y,5,-1);
                              AutoEnemyShot(x,y,6,-1);
                            end;
                          end;
                       3 : //F
                          begin
                            BOD[5].a4 := 500;
                            if (aaa mod (12-Dif*3) = 1)then
                                  AutoEnemyShot(x,y,7,iii*144+aaa*3);
                          end;
                       4 : //
                          begin
                            BOD[5].a4 := 500;
                            if (aaa mod (12-Dif*3) = 1)then
                                  AutoEnemyShot(x,y,11,iii*144+aaa*3);
                          end;
                       6 : //ԉ
                          begin
                            BOD[5].a4 := 600;
                            if (aaa mod (15-Dif*5) = 1)then
                               AutoEnemyShot(x,y,7,-1);
                          end;
                       7,5 : //[U[
                          begin
                            BOD[5].a4 := 200;
                            if (iii = 0)then BOD[5].count := BOD[5].count - 6;
                            if (aaa = 20)then AutoEnemyShot(x,y,15,0);
                            if ((aaa = 70)and(iii=0))then for jjj := 0 to 24 do AutoEnemyShot(BOD[0].x,BOD[0].y,13,jjj*30);
                          end;
                       8 : //E΂΂
                          begin
                            BOD[5].a4 := 200;
                            if (aaa mod (5-Dif*2) = 1)then AutoEnemyShot(x,y,4,AL.Rnd(720));
                          end;
                       9 : //
                          begin
                            BOD[5].a4 := 200;
                            if (aaa mod (8-Dif*2) = 1)then AutoEnemyShot(x,y,9,180);
                          end;
                      end;

                   end;

             end;
end;

procedure TSTG.InitFPScounter;
begin
  FPScount := 0;
  FPSframe := 0;
end;

procedure TSTG.SetFPScounter(time:longint);
begin
  if ((time < 0)or(time >1000))then exit;
  if (FPSframe > 10000)then exit;
  FPScount := FPScount + time;
  inc(FPSframe);
end;

function  TSTG.GetFPScounter : BYTE;
var
  aaa:Integer;
begin
  aaa := round(1000 / (FPScount / FPSframe)-0.5);
  if (aaa > 255)then aaa := 255;
  result := aaa;
end;

end.
