unit MapA;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, StdCtrls, ComCtrls, ExtCtrls;

type
  TStageData = record     //摜oN
    PartsFile : String[255];
    FromLine : Word;   //|vp
    ToLine   : Word;
    MD : array[0..6,0..511] of Byte;   //50x50=1Cell
    ED : array[0..5,0..511] of Byte;
  end;
//MD
//[0,1,2,3,4,5,   6       7        ].....
// PartsData     Goto  SpeedAdd
// 256+2+2+(7*512)+(6*512) = 6916
//           3584   3072

type
  TForm1 = class(TForm)
    ScrollBar1: TScrollBar;
    ScrollBar2: TScrollBar;
    ScrollBar3: TScrollBar;
    Button1: TButton;
    Edit1: TEdit;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    OPEN1: TMenuItem;
    SAVEAS1: TMenuItem;
    Button3: TButton;
    Edit3: TEdit;
    Image1: TImage;
    Label1: TLabel;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    OpenDialog2: TOpenDialog;
    Image2: TImage;
    Label2: TLabel;
    Edit2: TEdit;
    Label3: TLabel;
    Edit5: TEdit;
    Edit6: TEdit;
    Edit7: TEdit;
    Image3: TImage;
    Label4: TLabel;
    Label5: TLabel;
    Edit8: TEdit;
    New1: TMenuItem;
    Data1: TMenuItem;
    MapClear1: TMenuItem;
    EnemyClear1: TMenuItem;
    CheckBox1: TCheckBox;
    Label6: TLabel;
    Label7: TLabel;
    ComboBox1: TComboBox;
    Edit4: TEdit;
    Label8: TLabel;
    Label9: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Edit1Exit(Sender: TObject);
    procedure ScrollBar2Change(Sender: TObject);
    procedure ScrollBar3Change(Sender: TObject);
    procedure Image1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Image2MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure ScrollBar1Change(Sender: TObject);
    procedure Edit2Exit(Sender: TObject);
    procedure Edit5Exit(Sender: TObject);
    procedure Edit8Exit(Sender: TObject);
    procedure SAVEAS1Click(Sender: TObject);
    procedure New1Click(Sender: TObject);
    procedure OPEN1Click(Sender: TObject);
    procedure MapClear1Click(Sender: TObject);
    procedure EnemyClear1Click(Sender: TObject);
    procedure Edit4Exit(Sender: TObject);
    procedure Edit5Change(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure Edit4Change(Sender: TObject);
  private
    { Private 錾 }

  public
    { Public 錾 }
    SD : TStageData;
    MapMode : Boolean;
    EnemyNo : Byte;   //Gԍ
    PB : TBitmap;     //p|cp摜
    PBX,PBY : Byte;   //p|c̏c
    PartsNo : Byte;
    PX,PY   : Byte;
    MX,MY   : Integer;
    POX,POY,PMX,PMY : Integer; //PointMark
    procedure StageClear;
    procedure PartsDraw;
    procedure MapDraw;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
  MapMode := True;
  EnemyNo := 0;
  PB := TBitmap.Create;
  PBX := 1;
  PBY := 1;
  MX := 0;
  MY := 0;
  PX := 0;
  PY := 0;
  POX := 0;
  POY := 0;
  PMX := 0;
  PMY := 0;
  PartsNo := 0;
  StageClear;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  if (MapMode = False)then
  begin
    MapMode := True;
    Edit3.Text := 'Map Setting Mode';
  end
  else
  begin
    MapMode := False;
    Edit3.Text := 'Enemy Setting Mode';
  end;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  if OpenDialog2.Execute then
  begin
    Edit1.Text := OpenDialog2.FileName;
    SD.PartsFile := OpenDialog2.FileName;
    PB := TBitmap.Create;
    PB.LoadFromFile(OpenDialog2.FileName);
    PBX := Round(PB.Width / 50);
    PBY := Round(PB.Height / 50);
    ScrollBar2.Position := 0;
    ScrollBar3.Position := 0;
    ScrollBar1.Position := 0;
    if (PBX < 6)then ScrollBar2.Max := 0
                else ScrollBar2.Max := PBX - 5;
    if (PBY < 6)then ScrollBar3.Max := 0
                else ScrollBar3.Max := PBY - 5;
    PartsDraw;
    MapDraw;
  end;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  PB.Free;
end;

procedure TForm1.Edit1Exit(Sender: TObject);
begin
  SD.PartsFile := Edit1.Text;
end;

procedure TForm1.ScrollBar2Change(Sender: TObject);
begin
  PartsDraw;
end;

procedure TForm1.ScrollBar3Change(Sender: TObject);
begin
  PartsDraw;
end;

procedure TForm1.StageClear;
var
  iii,jjj : Integer;
begin
  for iii := 0 to 511 do
   for jjj := 0 to 6 do
    SD.MD[jjj,iii] := 0;
  for iii := 0 to 511 do
   for jjj := 0 to 5 do
    SD.ED[jjj,iii] := 0;
  for iii := 0 to 511 do      //x
   SD.MD[6,iii] := 127;
end;

procedure TForm1.Image1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  PX := X div 50 + ScrollBar2.Position;
  PY := Y div 50 + ScrollBar3.Position;
  if (PX > (PBX-1))then PX := PBX-1;
  if (PY > (PBY-1))then PY := PBY-1;
  if (Button = mbRight)then
   begin
    POX := PX; POY := PY;
    PMX := MX; PMY := MY;
   end;
  PartsDraw;
  PartsNo := PX + PY*PBX;
  Edit6.Text := IntToStr(PartsNo);
end;

procedure TForm1.PartsDraw;
var
  iii : Integer;
begin
  PatBlt(Image1.Canvas.handle,0,0,250,250,BlackNess);
  BitBlt(Image1.Canvas.Handle,0,0,250,250,
         PB.canvas.handle,
         ScrollBar2.Position*50,
         ScrollBar3.Position*50,
         srcCopy);
  PatBlt(Image1.Canvas.handle,
         (PX-ScrollBar2.Position)*50,
         (PY-ScrollBar3.Position)*50,
         10,10,WhiteNess);
   PatBlt(Image1.Canvas.handle,
         (POX-ScrollBar2.Position)*50+40,
         (POY-ScrollBar3.Position)*50+40,
         10,10,WhiteNess);
  Image1.Canvas.Pen.Color := clWhite;
  for iii := 0 to 5 do
  begin
   Image1.Canvas.MoveTo(0,iii*50);
   Image1.Canvas.LineTo(250,iii*50);
  end;
  for iii := 0 to 5 do
  begin
   Image1.Canvas.MoveTo(iii*50,0);
   Image1.Canvas.LineTo(iii*50,250);
  end;
  Image1.Repaint;
end;

procedure TForm1.MapDraw;
var
  iii,jjj,ax,ay : Integer;
begin
  Image2.Canvas.Font.Size := 12;
  PatBlt(Image2.Canvas.Handle,0,0,300,400,BlackNess);
  PatBlt(Image3.Canvas.Handle,0,0,300,400,WhiteNess);
  for iii := 0 to 8 do
   if (iii+(511-ScrollBar1.Position) < 512)then
   begin

    Image3.Canvas.TextOut(0,(8-iii)*50+15,'SP : '+IntToStr(SD.MD[6,iii+(511-ScrollBar1.Position)]-127));
    for jjj := 0 to 5 do
    begin
     ax := SD.MD[jjj,iii+(511-ScrollBar1.Position)] mod PBX;
     ay := (SD.MD[jjj,iii+(511-ScrollBar1.Position)] div PBX);
     BitBlt(Image2.Canvas.Handle,jjj*50,(8-iii)*50,50,50,
            PB.canvas.handle,ax*50,ay*50,srcCopy);
     if (SD.ED[jjj,iii+(511-ScrollBar1.Position)] > 0)then
       Image2.Canvas.TextOut(jjj*50+20,(8-iii)*50+20,IntToStr(SD.ED[jjj,iii+(511-ScrollBar1.Position)]));
    end;
   end;
  PatBlt(Image2.Canvas.handle,
         (MX)*50,
         (8-(MY-(511-ScrollBar1.Position)))*50,
         10,10,WhiteNess);
  Edit7.Text := IntToStr(MX)+' , '+IntToStr(MY);
  Edit5.Text := IntToStr(SD.MD[6,MY]-127);
  Edit4.Text := IntToStr(SD.MD[6,511] - 127);

  Image2.Repaint;
end;

procedure TForm1.Image2MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var
  aax,aay : Integer;
begin
  MX := X div 50;
  MY := (8 - Y div 50) + (511-ScrollBar1.Position);
  if (MY > 511)then MY := 511;
  if (MX > 5  )then MX := 5;
  if (MapMode = True)then
  begin
  if (Button = mbRight)then
  begin
    PartsNo := SD.MD[MX,MY];
    PartsDraw;
  end;  
  SD.MD[MX,MY] := PartsNo;
  MapDraw;
  end;
  if (MapMode = False)then
  begin
   if (Button = mbRight)then
   begin
    EnemyNo := SD.ED[MX,MY];
    ComboBox1.Text := IntToStr(SD.ED[MX,MY]);
   end;
   SD.ED[MX,MY] := StrToInt(ComboBox1.Text);
   MapDraw;
  end;

  if ((CheckBox1.Checked = True)and(MapMode = True)) then
  begin
    aax := -(PMX-MX)+POX; aay := PMY-MY+POY;
    if (aax > (PBX-1))then aax := PBX-1;
    if (aay > (PBY-1))then aay := PBY-1;
    if (aax < 0)then aax := 0;
    if (aay < 0)then aay := 0;
    PX := aax; PY := aay;
    PartsNo := aax+aay*PBX;
    PartsDraw;
    SD.MD[MX,MY] := PartsNo;
    MapDraw;
  end;
end;

procedure TForm1.ScrollBar1Change(Sender: TObject);
begin
  MapDraw;
end;

procedure TForm1.Edit2Exit(Sender: TObject);
var
  aaa : Integer;
begin
  aaa := StrToIntDef(Edit2.Text,0);
  if (aaa < 0)then aaa := 0;
  Edit2.Text := IntToStr(aaa);
  SD.FromLine := aaa;
end;

procedure TForm1.Edit5Exit(Sender: TObject);
var
  aaa : Integer;
begin
  aaa := StrToIntDef(Edit5.Text,0);
  if ((aaa < -127) or (aaa > 127))then aaa := 0;
  SD.MD[6,MY] := aaa+127;
  MapDraw;
end;

procedure TForm1.Edit8Exit(Sender: TObject);
var
  aaa : Integer;
begin
  aaa := StrToIntDef(Edit8.Text,0);
  if (aaa < 0)then aaa := 0;
  Edit8.Text := IntToStr(aaa);
  SD.ToLine := aaa;
end;

procedure TForm1.SAVEAS1Click(Sender: TObject);
var
  FF : FILE;
begin
  if SaveDialog1.Execute then
  begin
   assignfile(ff,SaveDialog1.FileName);
   ReWrite(ff,1);
   blockWrite(ff,SD,6916);
   closefile(ff);
  end;
end;

procedure TForm1.New1Click(Sender: TObject);
begin
  StageClear;
  PB := TBitmap.Create;
  MapDraw;
  PartsDraw;
  SD.PartsFile := 'None';
end;

procedure TForm1.OPEN1Click(Sender: TObject);
var
  FF : FILE;
begin
  if OpenDialog1.Execute then
  begin
   assignfile(ff,OpenDialog1.FileName);
   ReSet(ff,1);
   blockRead(ff,SD,6916);
   closefile(ff);
   Edit1.Text := SD.PartsFile;
   Edit2.Text := IntToStr(SD.FromLine);
   Edit8.Text := IntToStr(SD.ToLine);
   PB := TBitmap.Create;
   PB.LoadFromFile(SD.PartsFile);
   PBX := Round(PB.Width / 50);
   PBY := Round(PB.Height / 50);
   ScrollBar2.Position := 0;
   ScrollBar3.Position := 0;
   ScrollBar1.Position := 0;
   if (PBX < 6)then ScrollBar2.Max := 0
               else ScrollBar2.Max := PBX - 5;
   if (PBY < 6)then ScrollBar3.Max := 0
               else ScrollBar3.Max := PBY - 5;
   MapDraw;
   PartsDraw;
  end;
end;

procedure TForm1.MapClear1Click(Sender: TObject);
var
  iii,jjj : Integer;
begin
  for iii := 0 to 511 do
   for jjj := 0 to 6 do
    SD.MD[jjj,iii] := 0;
  for iii := 0 to 511 do      //x
   SD.MD[6,iii] := 127;
  MapDraw; 
end;

procedure TForm1.EnemyClear1Click(Sender: TObject);
var
  iii,jjj : Integer;
begin
   for iii := 0 to 511 do
   for jjj := 0 to 5 do
    SD.ED[jjj,iii] := 0;
   MapDraw; 
end;

procedure TForm1.Edit4Exit(Sender: TObject);
var
  aaa : Byte;
begin

end;

procedure TForm1.Edit5Change(Sender: TObject);
var
  aaa : Integer;
begin
  aaa := StrToIntDef(Edit5.Text,0);
  if ((aaa < -127) or (aaa > 127))then aaa := 0;
  SD.MD[6,MY] := aaa+127;
  Edit5.Text := IntToStr(aaa);
  MapDraw;
end;

procedure TForm1.ComboBox1Change(Sender: TObject);
var
  aaa : Integer;
begin
  aaa := StrToIntDef(ComboBox1.Text,0);
  EnemyNo := aaa;
  ComboBox1.text := IntToStr(aaa);
end;

procedure TForm1.Edit4Change(Sender: TObject);
var
  aaa : Integer;
begin
  aaa := StrToIntDef(Edit4.Text,0);
  if ((aaa < -127) or (aaa > 127))then aaa := 0;
  SD.MD[6,511] := aaa+127;
  Edit4.Text := IntToStr(SD.MD[6,511] - 127);
  MapDraw;
end;

end.
