/* This file was created by Nokia Developer's Suite for J2ME(TM) */

import java.lang.*;
import javax.microedition.lcdui.*;
import com.nokia.mid.ui.FullCanvas;

public class ReversiCanvas extends FullCanvas implements Runnable, Const
{
  private final ReversiMIDlet midlet;
  private final Display display;
  private Hra hra;
  private volatile Thread animationThread = null;

//------------------------------------------------------------------------------
// konstruktor
  public ReversiCanvas(ReversiMIDlet midlet, Display display)
  {
    this.midlet = midlet;
    this.display = display;
    hra = new Hra();
    hra.stav = -2;

  }

//------------------------------------------------------------------------------
//
  public synchronized void start()
  {
      animationThread = new Thread(this);
      animationThread.start();
  }


//------------------------------------------------------------------------------
//
  public synchronized void stop()
  {
      animationThread = null;
  }


//------------------------------------------------------------------------------
//
  public void run()
  {
      Thread currentThread = Thread.currentThread();

      try
      {
          // This ends when animationThread is set to null, or when
          // it is subsequently set to a new thread; either way, the
          // current thread should terminate
          while (currentThread == animationThread)
          {
              long startTime = System.currentTimeMillis();
              tick();
              repaint(0, 0, getWidth(), getHeight());
              serviceRepaints();
              long timeTaken = System.currentTimeMillis() - startTime;
              if (timeTaken < MILLIS_PER_TICK)
              {
                  synchronized (this)
                  {
                      wait(MILLIS_PER_TICK - timeTaken);
                  }
              }
              else
              {
                  currentThread.yield();
              }
          }
      }
      catch (InterruptedException e)
      {
      }
  }

//------------------------------------------------------------------------------
// provede se behem kazdeho ticku
  private void tick()
  {
    hra.cas++;
    if (hra.cas > 30000)
      hra.cas = 0;
    hra.curzor++;
    if (hra.curzor > 3)
      hra.curzor = 0;
  }

//------------------------------------------------------------------------------
//
  public void keyPressed(int keyCode)
  {
    switch (keyCode) {
      case KEY_SOFTKEY1:
        hra.menu1 = true;
        break;
      case KEY_SOFTKEY2:
        hra.menu2 = true;
        break;
      case KEY_SOFTKEY3:
        hra.menu3 = true;
        break;
      case KEY_UP_ARROW:
        hra.up = true;
        break;
      case KEY_DOWN_ARROW:
        hra.down = true;
        break;
      case KEY_LEFT_ARROW:
        hra.left = true;
        break;
      case KEY_RIGHT_ARROW:
        hra.right = true;
        break;
      case KEY_NUM5:
        hra.fire = true;
        break;
      case KEY_NUM2:
        hra.up = true;
        break;
      case KEY_NUM8:
        hra.down = true;
        break;
      case KEY_NUM4:
        hra.left = true;
        break;
      case KEY_NUM6:
        hra.right = true;
        break;
    }
  }

//------------------------------------------------------------------------------
//
  public void keyReleased(int keyCode)
  {
    switch (keyCode) {
      case KEY_SOFTKEY1:
        hra.menu1 = false;
        break;
      case KEY_SOFTKEY2:
        hra.menu2 = false;
        break;
      case KEY_SOFTKEY3:
        hra.menu3 = false;
        break;
      case KEY_UP_ARROW:
        hra.up = false;
        break;
      case KEY_DOWN_ARROW:
        hra.down = false;
        break;
      case KEY_LEFT_ARROW:
        hra.left = false;
        break;
      case KEY_RIGHT_ARROW:
        hra.right = false;
        break;
      case KEY_NUM5:
        hra.fire = false;
        break;
      case KEY_NUM2:
        hra.up = false;
        break;
      case KEY_NUM8:
        hra.down = false;
        break;
      case KEY_NUM4:
        hra.left = false;
        break;
      case KEY_NUM6:
        hra.right = false;
        break;
    }
  }

//------------------------------------------------------------------------------
//
  public void paint(Graphics g)
  {
      switch (hra.stav)
      {
        case -3:
          hra.kresli(g);
          if (hra.fadeOut(g))
            hra.stav = -2;
          break;
        case -2:
          hra.uloz_nastaveni();
          hra.splash = null;
          hra.splash = ReversiMIDlet.createImage("/s.png");
          hra.sp2 = null;
          hra.sp2 = ReversiMIDlet.createImage("/m.png");
          hra.vyber = null;
          hra.vyber = ReversiMIDlet.createImage("/c2.png");
          hra.playSound(hra.SOUND_1, 0);
          hra.stav = -1;
          hra.je = true;
          hra.cas = 0;
          break;
        case -1:
          hra.kresli_nastaveni(g);
          if (hra.fadeIn(g))
            hra.stav = 0;
          break;
        case 0: // nastaveni obtiznosti
          hra.klavesy_nastaveni();
          hra.kresli_nastaveni(g);
          break;
        case 1: // go to start
          hra.kresli_nastaveni(g);
          if (hra.fadeOut(g))
            hra.stav = 2;
          break;
        case 2:
          hra.splash = null;
          hra.splash = ReversiMIDlet.createImage("/p.png");
          hra.vyber = null;
          hra.vyber = ReversiMIDlet.createImage("/c.png");
          for (int i = 0; i < 8; i++)
            for (int ii = 0; ii < 8; ii++) {
              hra.pole[i][ii] = 0;
              hra.faze[i][ii] = 0;
            }
          hra.pole[3][3] = 1;
          hra.pole[4][4] = 1;
          hra.pole[3][4] = 2;
          hra.pole[4][3] = 2;
          hra.clean_pole();
          hra.aktualizuj_score();
          hra.stav = 3;
          hra.menu1 = false;
          hra.menu2 = false;
          hra.menu3 = false;
          hra.fire = false;
          hra.stopSound();
          break;
        case 3:
          hra.kresli(g);
          if (hra.fadeIn(g))
            hra.stav = 4;
          break;
        case 4: // hra
          hra.klavesy();
          hra.kresli(g);
          break;
        case 5: // go to continue
          hra.kresli_nastaveni(g);
          if (hra.fadeOut(g))
            hra.stav = 6;
          break;
        case 6:
          hra.splash = null;
          hra.splash = ReversiMIDlet.createImage("/p.png");
          hra.vyber = null;
          hra.vyber = ReversiMIDlet.createImage("/c.png");
          hra.stav = 3;
          hra.menu1 = false;
          hra.menu2 = false;
          hra.menu3 = false;
          hra.fire = false;
          hra.stopSound();
          break;
        case 98: // go to exit
          hra.kresli_nastaveni(g);
          if (hra.fadeOut(g))
            hra.stav = 99;
          break;
        case 99: // exit
          hra.stopSound();
          midlet.exitRequested();
          break;
      } //switch
  }

}
