/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.applet;

import java.applet.Applet;
import java.applet.AppletStub;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;

public class AppletLoader
extends Applet
implements Runnable,
AppletStub {
    public static final int STATE_INIT = 1;
    public static final int STATE_DETERMINING_PACKAGES = 2;
    public static final int STATE_CHECKING_CACHE = 3;
    public static final int STATE_DOWNLOADING = 4;
    public static final int STATE_EXTRACTING_PACKAGES = 5;
    public static final int STATE_UPDATING_CLASSPATH = 6;
    public static final int STATE_SWITCHING_APPLET = 7;
    public static final int STATE_INITIALIZE_REAL_APPLET = 8;
    public static final int STATE_START_REAL_APPLET = 9;
    public static final int STATE_DONE = 10;
    protected int percentage;
    protected int currentSizeDownload;
    protected int totalSizeDownload;
    protected int currentSizeExtract;
    protected int totalSizeExtract;
    protected Image logo;
    protected Image progressbar;
    protected Image offscreen;
    protected Color bgColor = Color.white;
    protected Color errorColor = Color.red;
    protected Color fgColor = Color.black;
    protected URL[] urlList;
    protected ClassLoader classLoader;
    protected Thread loaderThread;
    protected Thread animationThread;
    protected Applet lwjglApplet;
    protected boolean fatalError;
    protected String fatalErrorDescription;
    protected boolean debugMode;
    protected boolean prependHost;
    protected String subtaskMessage = "";
    protected int state = 1;
    protected boolean lzmaSupported = false;
    protected boolean pack200Supported = false;
    protected String[] genericErrorMessage = new String[]{"An error occured while loading the applet.", "Please contact support to resolve this issue.", "<placeholder for error message>"};
    protected boolean certificateRefused;
    protected String[] certificateRefusedMessage = new String[]{"Permissions for Applet Refused.", "Please accept the permissions dialog to allow", "the applet to continue the loading process."};
    static /* synthetic */ Class class$java$security$CodeSource;
    static /* synthetic */ Class class$java$security$SecureClassLoader;

    public void init() {
        this.state = 1;
        String[] requiredArgs = new String[]{"al_main", "al_logo", "al_progressbar", "al_jars"};
        for (int i = 0; i < requiredArgs.length; ++i) {
            if (this.getParameter(requiredArgs[i]) != null) continue;
            this.fatalErrorOccured("missing required applet parameter: " + requiredArgs[i], null);
            return;
        }
        this.debugMode = this.getBooleanParameter("al_debug", false);
        this.prependHost = this.getBooleanParameter("al_prepend_host", true);
        this.bgColor = this.getColor("al_bgcolor", Color.white);
        this.setBackground(this.bgColor);
        this.fgColor = this.getColor("al_fgcolor", Color.black);
        this.errorColor = this.getColor("al_errorcolor", Color.red);
        this.logo = this.getImage(this.getParameter("al_logo"));
        this.progressbar = this.getImage(this.getParameter("al_progressbar"));
        if (this.logo == null || this.progressbar == null) {
            this.fatalErrorOccured("Unable to load logo and progressbar images", null);
        }
        try {
            Class.forName("LZMA.LzmaInputStream");
            this.lzmaSupported = true;
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            Pack200.class.getSimpleName();
            this.pack200Supported = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private String generateStacktrace(Exception exception) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        exception.printStackTrace(printWriter);
        return ((Object)result).toString();
    }

    public void start() {
        if (this.lwjglApplet != null) {
            this.lwjglApplet.start();
        } else if (this.loaderThread == null && !this.fatalError) {
            this.loaderThread = new Thread(this);
            this.loaderThread.setName("AppletLoader.loaderThread");
            this.loaderThread.start();
            this.animationThread = new Thread(){

                public void run() {
                    while (AppletLoader.this.loaderThread != null) {
                        AppletLoader.this.repaint();
                        AppletLoader.this.sleep(100L);
                    }
                    AppletLoader.this.animationThread = null;
                }
            };
            this.animationThread.setName("AppletLoader.animationthread");
            this.animationThread.start();
        }
    }

    public void stop() {
        if (this.lwjglApplet != null) {
            this.lwjglApplet.stop();
        }
        super.stop();
    }

    public void destroy() {
        if (this.lwjglApplet != null) {
            this.lwjglApplet.destroy();
        }
        this.progressbar = null;
        this.logo = null;
        super.destroy();
    }

    public Applet getApplet() {
        return this.lwjglApplet;
    }

    public void appletResize(int width, int height) {
        this.resize(width, height);
    }

    public final void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        if (this.state == 10) {
            return;
        }
        if (this.offscreen == null) {
            this.offscreen = this.createImage(this.getWidth(), this.getHeight());
        }
        Graphics og = this.offscreen.getGraphics();
        FontMetrics fm = og.getFontMetrics();
        og.setColor(this.bgColor);
        og.fillRect(0, 0, this.getWidth(), this.getHeight());
        int x = 0;
        int y = 0;
        if (this.logo != null && !this.fatalError) {
            x = (this.getWidth() - this.logo.getWidth(this)) / 2;
            y = (this.getHeight() - this.logo.getHeight(this)) / 2;
        }
        og.setColor(this.fgColor);
        String message = this.getDescriptionForState();
        if (this.fatalError) {
            String[] errorMessage;
            String[] stringArray = errorMessage = this.certificateRefused ? this.certificateRefusedMessage : this.genericErrorMessage;
            if (!this.certificateRefused) {
                errorMessage[errorMessage.length - 1] = this.fatalErrorDescription;
            }
            for (int i = 0; i < errorMessage.length; ++i) {
                if (errorMessage[i] == null) continue;
                int messageX = (this.getWidth() - fm.stringWidth(errorMessage[i])) / 2;
                int messageY = (this.getHeight() - fm.getHeight() * errorMessage.length) / 2;
                og.setColor(this.errorColor);
                og.drawString(errorMessage[i], messageX, messageY + i * fm.getHeight());
            }
        } else {
            og.setColor(this.fgColor);
            og.drawImage(this.logo, x, y, null);
            int messageX = (this.getWidth() - fm.stringWidth(message)) / 2;
            int messageY = y + this.logo.getHeight(null) + 20;
            og.drawString(message, messageX, messageY);
            if (this.subtaskMessage.length() > 0) {
                messageX = (this.getWidth() - fm.stringWidth(this.subtaskMessage)) / 2;
                og.drawString(this.subtaskMessage, messageX, messageY + 20);
            }
            int barSize = this.progressbar.getWidth(this) * this.percentage / 100;
            og.clipRect(0, 0, x + barSize, this.getHeight());
            og.drawImage(this.progressbar, x, y, null);
        }
        og.dispose();
        g.drawImage(this.offscreen, 0, 0, null);
    }

    protected String getDescriptionForState() {
        switch (this.state) {
            case 1: {
                return "Initializing loader";
            }
            case 2: {
                return "Determining packages to load";
            }
            case 3: {
                return "Checking cache for existing files";
            }
            case 4: {
                return "Downloading packages";
            }
            case 5: {
                return "Extracting downloaded packages";
            }
            case 6: {
                return "Updating classpath";
            }
            case 7: {
                return "Switching applet";
            }
            case 8: {
                return "Initializing real applet";
            }
            case 9: {
                return "Starting real applet";
            }
            case 10: {
                return "Done loading";
            }
        }
        return "unknown state";
    }

    protected String trimExtensionByCapabilities(String file) {
        if (!this.pack200Supported) {
            file = file.replaceAll(".pack", "");
        }
        if (!this.lzmaSupported) {
            file = file.replaceAll(".lzma", "");
        }
        return file;
    }

    protected void loadJarURLs() throws Exception {
        this.state = 2;
        String jarList = this.getParameter("al_jars");
        jarList = this.trimExtensionByCapabilities(jarList);
        StringTokenizer jar = new StringTokenizer(jarList, ", ");
        int jarCount = jar.countTokens() + 1;
        this.urlList = new URL[jarCount];
        URL path = this.getCodeBase();
        for (int i = 0; i < jarCount - 1; ++i) {
            this.urlList[i] = new URL(path, jar.nextToken());
        }
        String osName = System.getProperty("os.name");
        String nativeJar = null;
        if (osName.startsWith("Win")) {
            nativeJar = this.getParameter("al_windows");
        } else if (osName.startsWith("Linux") || osName.startsWith("FreeBSD")) {
            nativeJar = this.getParameter("al_linux");
        } else if (osName.startsWith("Mac")) {
            nativeJar = this.getParameter("al_mac");
        } else if (osName.startsWith("Solaris") || osName.startsWith("SunOS")) {
            nativeJar = this.getParameter("al_solaris");
        } else {
            this.fatalErrorOccured("OS (" + osName + ") not supported", null);
        }
        if (nativeJar == null) {
            this.fatalErrorOccured("no lwjgl natives files found", null);
        } else {
            nativeJar = this.trimExtensionByCapabilities(nativeJar);
            this.urlList[jarCount - 1] = new URL(path, nativeJar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.state = 3;
        this.percentage = 5;
        try {
            this.debug_sleep(2000L);
            this.loadJarURLs();
            String path = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    String codebase = "";
                    if (AppletLoader.this.prependHost) {
                        codebase = AppletLoader.this.getCodeBase().getHost();
                        if (codebase == null || codebase.length() == 0) {
                            codebase = "localhost";
                        }
                        codebase = codebase + File.separator;
                    }
                    return System.getProperty("java.io.tmpdir") + File.separator + codebase + AppletLoader.this.getParameter("al_title") + File.separator;
                }
            });
            File dir = new File(path);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            dir = new File(dir, "version");
            boolean cacheAvailable = false;
            String version = this.getParameter("al_version");
            float latestVersion = 0.0f;
            if (version != null) {
                latestVersion = Float.parseFloat(version);
                if (dir.exists() && latestVersion <= this.readVersionFile(dir)) {
                    cacheAvailable = true;
                    this.percentage = 90;
                    if (this.debugMode) {
                        System.out.println("Loading Cached Applet Version " + latestVersion);
                    }
                    this.debug_sleep(2000L);
                }
            }
            if (!cacheAvailable) {
                this.downloadJars(path);
                this.extractJars(path);
                this.extractNatives(path);
                if (version != null) {
                    this.percentage = 90;
                    this.writeVersionFile(dir, latestVersion);
                }
            }
            this.updateClassPath(path);
            this.switchApplet();
            this.state = 10;
        }
        catch (AccessControlException ace) {
            this.fatalErrorOccured(ace.getMessage(), ace);
            this.certificateRefused = true;
        }
        catch (Exception e) {
            this.fatalErrorOccured(e.getMessage(), e);
        }
        finally {
            this.loaderThread = null;
        }
    }

    protected float readVersionFile(File file) throws Exception {
        DataInputStream dis = new DataInputStream(new FileInputStream(file));
        float version = dis.readFloat();
        dis.close();
        return version;
    }

    protected void writeVersionFile(File file, float version) throws Exception {
        DataOutputStream dos = new DataOutputStream(new FileOutputStream(file));
        dos.writeFloat(version);
        dos.close();
    }

    protected void updateClassPath(String path) throws Exception {
        this.state = 6;
        this.percentage = 95;
        URL[] urls = new URL[this.urlList.length];
        for (int i = 0; i < this.urlList.length; ++i) {
            urls[i] = new URL("file:" + path + this.getJarName(this.urlList[i]));
        }
        this.classLoader = new URLClassLoader(urls){

            protected PermissionCollection getPermissions(CodeSource codesource) {
                PermissionCollection perms = null;
                try {
                    Method method = (class$java$security$SecureClassLoader == null ? (class$java$security$SecureClassLoader = AppletLoader.class$("java.security.SecureClassLoader")) : class$java$security$SecureClassLoader).getDeclaredMethod("getPermissions", class$java$security$CodeSource == null ? (class$java$security$CodeSource = AppletLoader.class$("java.security.CodeSource")) : class$java$security$CodeSource);
                    method.setAccessible(true);
                    perms = (PermissionCollection)method.invoke((Object)this.getClass().getClassLoader(), codesource);
                    String host = AppletLoader.this.getCodeBase().getHost();
                    if (host != null && host.length() > 0) {
                        perms.add(new SocketPermission(host, "connect,accept"));
                    } else if (codesource.getLocation().getProtocol().equals("file")) {
                        String path = codesource.getLocation().getFile().replace('/', File.separatorChar);
                        perms.add(new FilePermission(path, "read"));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return perms;
            }
        };
        this.debug_sleep(2000L);
        System.setProperty("org.lwjgl.librarypath", path + "natives");
        System.setProperty("net.java.games.input.librarypath", path + "natives");
    }

    protected void switchApplet() throws Exception {
        this.state = 7;
        this.percentage = 100;
        this.debug_sleep(2000L);
        Class<?> appletClass = this.classLoader.loadClass(this.getParameter("al_main"));
        this.lwjglApplet = (Applet)appletClass.newInstance();
        this.lwjglApplet.setStub(this);
        this.lwjglApplet.setSize(this.getWidth(), this.getHeight());
        this.setLayout(new BorderLayout());
        this.add(this.lwjglApplet);
        this.validate();
        this.state = 8;
        this.lwjglApplet.init();
        this.state = 9;
        this.lwjglApplet.start();
    }

    protected void downloadJars(String path) throws Exception {
        URLConnection urlconnection;
        this.state = 4;
        int[] fileSizes = new int[this.urlList.length];
        for (int i = 0; i < this.urlList.length; ++i) {
            urlconnection = this.urlList[i].openConnection();
            urlconnection.setDefaultUseCaches(false);
            if (urlconnection instanceof HttpURLConnection) {
                ((HttpURLConnection)urlconnection).setRequestMethod("HEAD");
            }
            fileSizes[i] = urlconnection.getContentLength();
            this.totalSizeDownload += fileSizes[i];
        }
        this.percentage = 10;
        int initialPercentage = 10;
        byte[] buffer = new byte[65536];
        for (int i = 0; i < this.urlList.length; ++i) {
            int unsuccessfulAttempts = 0;
            int maxUnsuccessfulAttempts = 3;
            boolean downloadFile = true;
            while (downloadFile) {
                int bufferSize;
                downloadFile = false;
                this.debug_sleep(2000L);
                urlconnection = this.urlList[i].openConnection();
                if (urlconnection instanceof HttpURLConnection) {
                    urlconnection.setRequestProperty("Cache-Control", "no-cache");
                    urlconnection.connect();
                }
                String currentFile = this.getFileName(this.urlList[i]);
                InputStream inputstream = this.getJarInputStream(currentFile, urlconnection);
                FileOutputStream fos = new FileOutputStream(path + currentFile);
                long downloadStartTime = System.currentTimeMillis();
                int downloadedAmount = 0;
                int fileSize = 0;
                String downloadSpeedMessage = "";
                while ((bufferSize = inputstream.read(buffer, 0, buffer.length)) != -1) {
                    this.debug_sleep(10L);
                    fos.write(buffer, 0, bufferSize);
                    this.currentSizeDownload += bufferSize;
                    fileSize += bufferSize;
                    this.percentage = initialPercentage + this.currentSizeDownload * 45 / this.totalSizeDownload;
                    this.subtaskMessage = "Retrieving: " + currentFile + " " + this.currentSizeDownload * 100 / this.totalSizeDownload + "%";
                    downloadedAmount += bufferSize;
                    long timeLapse = System.currentTimeMillis() - downloadStartTime;
                    if (timeLapse >= 1000L) {
                        float downloadSpeed = (float)downloadedAmount / (float)timeLapse;
                        downloadSpeed = (float)((int)(downloadSpeed * 100.0f)) / 100.0f;
                        downloadSpeedMessage = " @ " + downloadSpeed + " KB/sec";
                        downloadedAmount = 0;
                        downloadStartTime = System.currentTimeMillis();
                    }
                    this.subtaskMessage = this.subtaskMessage + downloadSpeedMessage;
                }
                inputstream.close();
                fos.close();
                if (!(urlconnection instanceof HttpURLConnection) || fileSize == fileSizes[i] || fileSizes[i] <= 0) continue;
                if (++unsuccessfulAttempts < maxUnsuccessfulAttempts) {
                    downloadFile = true;
                    this.currentSizeDownload -= fileSize;
                    continue;
                }
                throw new Exception("failed to download " + currentFile);
            }
        }
        this.subtaskMessage = "";
    }

    protected InputStream getJarInputStream(String currentFile, final URLConnection urlconnection) throws Exception {
        final InputStream[] is = new InputStream[1];
        for (int j = 0; j < 3 && is[0] == null; ++j) {
            Thread t = new Thread(){

                public void run() {
                    try {
                        is[0] = urlconnection.getInputStream();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            };
            t.setName("JarInputStreamThread");
            t.start();
            int iterationCount = 0;
            while (is[0] == null && iterationCount++ < 5) {
                try {
                    t.join(1000L);
                }
                catch (InterruptedException inte) {}
            }
            if (is[0] != null) continue;
            try {
                t.interrupt();
                t.join();
                continue;
            }
            catch (InterruptedException inte) {
                // empty catch block
            }
        }
        if (is[0] == null) {
            throw new Exception("Unable to get input stream for " + currentFile);
        }
        return is[0];
    }

    protected void extractLZMA(String in, String out) throws Exception {
        File f = new File(in);
        FileInputStream fileInputHandle = new FileInputStream(f);
        Class<?> clazz = Class.forName("LZMA.LzmaInputStream");
        Constructor<?> constructor = clazz.getDeclaredConstructor(InputStream.class);
        InputStream inputHandle = (InputStream)constructor.newInstance(fileInputHandle);
        FileOutputStream outputHandle = new FileOutputStream(out);
        byte[] buffer = new byte[16384];
        int ret = inputHandle.read(buffer);
        while (ret >= 1) {
            ((OutputStream)outputHandle).write(buffer, 0, ret);
            ret = inputHandle.read(buffer);
        }
        inputHandle.close();
        ((OutputStream)outputHandle).close();
        outputHandle = null;
        inputHandle = null;
        f.delete();
    }

    protected void extractPack(String in, String out) throws Exception {
        File f = new File(in);
        FileOutputStream fostream = new FileOutputStream(out);
        JarOutputStream jostream = new JarOutputStream(fostream);
        Pack200.Unpacker unpacker = Pack200.newUnpacker();
        unpacker.unpack(f, jostream);
        jostream.close();
        f.delete();
    }

    protected void extractJars(String path) throws Exception {
        this.state = 5;
        float increment = 10.0f / (float)this.urlList.length;
        for (int i = 0; i < this.urlList.length; ++i) {
            this.percentage = 55 + (int)(increment * (float)(i + 1));
            String filename = this.getFileName(this.urlList[i]);
            if (filename.endsWith(".pack.lzma")) {
                this.subtaskMessage = "Extracting: " + filename + " to " + filename.replaceAll(".lzma", "");
                this.debug_sleep(1000L);
                this.extractLZMA(path + filename, path + filename.replaceAll(".lzma", ""));
                this.subtaskMessage = "Extracting: " + filename.replaceAll(".lzma", "") + " to " + filename.replaceAll(".pack.lzma", "");
                this.debug_sleep(1000L);
                this.extractPack(path + filename.replaceAll(".lzma", ""), path + filename.replaceAll(".pack.lzma", ""));
                continue;
            }
            if (filename.endsWith(".pack")) {
                this.subtaskMessage = "Extracting: " + filename + " to " + filename.replace(".pack", "");
                this.debug_sleep(1000L);
                this.extractPack(path + filename, path + filename.replace(".pack", ""));
                continue;
            }
            if (!filename.endsWith(".lzma")) continue;
            this.subtaskMessage = "Extracting: " + filename + " to " + filename.replace(".lzma", "");
            this.debug_sleep(1000L);
            this.extractLZMA(path + filename, path + filename.replace(".lzma", ""));
        }
    }

    protected void extractNatives(String path) throws Exception {
        JarEntry entry;
        File nativeFolder;
        this.state = 5;
        int initialPercentage = this.percentage;
        String nativeJar = this.getJarName(this.urlList[this.urlList.length - 1]);
        Certificate[] certificate = AppletLoader.class.getProtectionDomain().getCodeSource().getCertificates();
        if (certificate == null) {
            URL location = AppletLoader.class.getProtectionDomain().getCodeSource().getLocation();
            JarURLConnection jurl = (JarURLConnection)new URL("jar:" + location.toString() + "!/org/lwjgl/util/applet/AppletLoader.class").openConnection();
            jurl.setDefaultUseCaches(true);
            certificate = jurl.getCertificates();
        }
        if (!(nativeFolder = new File(path + "natives")).exists()) {
            nativeFolder.mkdir();
        }
        JarFile jarFile = new JarFile(path + nativeJar, true);
        Enumeration<JarEntry> entities = jarFile.entries();
        this.totalSizeExtract = 0;
        while (entities.hasMoreElements()) {
            entry = entities.nextElement();
            if (entry.isDirectory() || entry.getName().indexOf(47) != -1) continue;
            this.totalSizeExtract = (int)((long)this.totalSizeExtract + entry.getSize());
        }
        this.currentSizeExtract = 0;
        entities = jarFile.entries();
        while (entities.hasMoreElements()) {
            int bufferSize;
            File f;
            entry = entities.nextElement();
            if (entry.isDirectory() || entry.getName().indexOf(47) != -1 || (f = new File(path + "natives" + File.separator + entry.getName())).exists() && !f.delete()) continue;
            this.debug_sleep(1000L);
            InputStream in = jarFile.getInputStream(jarFile.getEntry(entry.getName()));
            FileOutputStream out = new FileOutputStream(path + "natives" + File.separator + entry.getName());
            byte[] buffer = new byte[65536];
            while ((bufferSize = in.read(buffer, 0, buffer.length)) != -1) {
                this.debug_sleep(10L);
                ((OutputStream)out).write(buffer, 0, bufferSize);
                this.currentSizeExtract += bufferSize;
                this.percentage = initialPercentage + this.currentSizeExtract * 20 / this.totalSizeExtract;
                this.subtaskMessage = "Extracting: " + entry.getName() + " " + this.currentSizeExtract * 100 / this.totalSizeExtract + "%";
            }
            AppletLoader.validateCertificateChain(certificate, entry.getCertificates());
            in.close();
            ((OutputStream)out).close();
        }
        this.subtaskMessage = "";
        jarFile.close();
        File f = new File(path + nativeJar);
        f.delete();
    }

    protected static void validateCertificateChain(Certificate[] ownCerts, Certificate[] native_certs) throws Exception {
        if (native_certs == null) {
            throw new Exception("Unable to validate certificate chain. Native entry did not have a certificate chain at all");
        }
        if (ownCerts.length != native_certs.length) {
            throw new Exception("Unable to validate certificate chain. Chain differs in length [" + ownCerts.length + " vs " + native_certs.length + "]");
        }
        for (int i = 0; i < ownCerts.length; ++i) {
            if (ownCerts[i].equals(native_certs[i])) continue;
            throw new Exception("Certificate mismatch: " + ownCerts[i] + " != " + native_certs[i]);
        }
    }

    protected Image getImage(String s) {
        try {
            URL url = AppletLoader.class.getResource("/" + s);
            if (url == null) {
                url = new URL(this.getCodeBase(), s);
            }
            Image image = super.getImage(url);
            MediaTracker tracker = new MediaTracker(this);
            tracker.addImage(image, 0);
            tracker.waitForAll();
            return image;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected String getJarName(URL url) {
        String fileName = url.getFile();
        if (fileName.endsWith(".pack.lzma")) {
            fileName = fileName.replaceAll(".pack.lzma", "");
        } else if (fileName.endsWith(".pack")) {
            fileName = fileName.replaceAll(".pack", "");
        } else if (fileName.endsWith(".lzma")) {
            fileName = fileName.replaceAll(".lzma", "");
        }
        return fileName.substring(fileName.lastIndexOf(47) + 1);
    }

    protected String getFileName(URL url) {
        String fileName = url.getFile();
        return fileName.substring(fileName.lastIndexOf(47) + 1);
    }

    protected Color getColor(String color, Color defaultColor) {
        String param_color = this.getParameter(color);
        if (param_color != null) {
            return new Color(Integer.parseInt(param_color, 16));
        }
        return defaultColor;
    }

    protected boolean getBooleanParameter(String name, boolean defaultValue) {
        String parameter = this.getParameter(name);
        if (parameter != null) {
            return Boolean.parseBoolean(parameter);
        }
        return defaultValue;
    }

    protected void fatalErrorOccured(String error, Exception e) {
        this.fatalError = true;
        this.fatalErrorDescription = "Fatal error occured (" + this.state + "): " + error;
        System.out.println(this.fatalErrorDescription);
        if (e != null) {
            System.out.println(this.generateStacktrace(e));
        }
        this.repaint();
    }

    protected void debug_sleep(long ms) {
        if (this.debugMode) {
            this.sleep(ms);
        }
    }

    protected void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

