/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.examples.spaceinvaders;

import java.awt.Rectangle;
import org.lwjgl.examples.spaceinvaders.Sprite;

public abstract class Entity {
    protected float x;
    protected float y;
    protected Sprite sprite;
    protected float dx;
    protected float dy;
    private Rectangle me = new Rectangle();
    private Rectangle him = new Rectangle();

    public Entity(Sprite sprite, int x, int y) {
        this.sprite = sprite;
        this.x = x;
        this.y = y;
    }

    public void move(long delta) {
        this.x += (float)delta * this.dx / 1000.0f;
        this.y += (float)delta * this.dy / 1000.0f;
    }

    public void setHorizontalMovement(float dx) {
        this.dx = dx;
    }

    public void setVerticalMovement(float dy) {
        this.dy = dy;
    }

    public float getHorizontalMovement() {
        return this.dx;
    }

    public float getVerticalMovement() {
        return this.dy;
    }

    public void draw() {
        this.sprite.draw((int)this.x, (int)this.y);
    }

    public void doLogic() {
    }

    public int getX() {
        return (int)this.x;
    }

    public int getY() {
        return (int)this.y;
    }

    public boolean collidesWith(Entity other) {
        this.me.setBounds((int)this.x, (int)this.y, this.sprite.getWidth(), this.sprite.getHeight());
        this.him.setBounds((int)other.x, (int)other.y, other.sprite.getWidth(), other.sprite.getHeight());
        return this.me.intersects(this.him);
    }

    public abstract void collidedWith(Entity var1);
}

