/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test;

import org.lwjgl.LWJGLException;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;

public class WindowCreationTest {
    private DisplayMode[] located_modes;
    private DisplayMode[] fixed_modes = new DisplayMode[10];
    private int window_x = 0;
    private int window_y = 0;
    private float color = 0.0f;
    private int direction = 1;
    private boolean running = false;
    private boolean fullscreen = false;

    public boolean initialize() {
        try {
            this.located_modes = Display.getAvailableDisplayModes();
            System.out.println("Found " + this.located_modes.length + " display modes");
            this.findFixedModes();
            this.setDefaultDisplayMode();
            this.window_y = 100;
            this.window_x = 100;
            Display.setLocation((int)this.window_x, (int)this.window_y);
            Display.create();
            return true;
        }
        catch (LWJGLException le) {
            le.printStackTrace();
            return false;
        }
    }

    private void findFixedModes() {
        this.fixed_modes[0] = this.getDisplayMode(640, 480, 16, -1);
        this.fixed_modes[1] = this.getDisplayMode(640, 480, 24, -1);
        this.fixed_modes[2] = this.getDisplayMode(640, 480, 32, -1);
        this.fixed_modes[3] = this.getDisplayMode(800, 600, 16, -1);
        this.fixed_modes[4] = this.getDisplayMode(800, 600, 24, -1);
        this.fixed_modes[5] = this.getDisplayMode(800, 600, 32, -1);
        this.fixed_modes[6] = this.getDisplayMode(1024, 768, 16, -1);
        this.fixed_modes[7] = this.getDisplayMode(1024, 768, 24, -1);
        this.fixed_modes[8] = this.getDisplayMode(1024, 768, 32, -1);
    }

    private void execute() {
        this.running = true;
        while (!Display.isCloseRequested() && this.running) {
            this.handleInput();
            this.render();
            Display.update();
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void destroy() {
        Display.destroy();
    }

    private void handleInput() {
        while (Keyboard.next()) {
            if (!Keyboard.getEventKeyState()) continue;
            if (Keyboard.getEventKey() == 1) {
                this.running = false;
            }
            if (Keyboard.getEventKey() == 38) {
                for (int i = 0; i < this.fixed_modes.length; ++i) {
                    System.out.println("[" + i + "]: " + this.fixed_modes[i]);
                }
            }
            if (Keyboard.getEventKey() == 11) {
                this.setMode(0);
            }
            if (Keyboard.getEventKey() == 2) {
                this.setMode(1);
            }
            if (Keyboard.getEventKey() == 3) {
                this.setMode(2);
            }
            if (Keyboard.getEventKey() == 4) {
                this.setMode(3);
            }
            if (Keyboard.getEventKey() == 5) {
                this.setMode(4);
            }
            if (Keyboard.getEventKey() == 6) {
                this.setMode(5);
            }
            if (Keyboard.getEventKey() == 7) {
                this.setMode(6);
            }
            if (Keyboard.getEventKey() == 8) {
                this.setMode(7);
            }
            if (Keyboard.getEventKey() == 9) {
                this.setMode(8);
            }
            if (Keyboard.getEventKey() == 203 && !Display.isFullscreen()) {
                Display.setLocation((int)(this.window_x -= 10), (int)this.window_y);
            }
            if (Keyboard.getEventKey() == 205 && !Display.isFullscreen()) {
                Display.setLocation((int)(this.window_x += 10), (int)this.window_y);
            }
            if (Keyboard.getEventKey() == 200 && !Display.isFullscreen()) {
                Display.setLocation((int)this.window_x, (int)(this.window_y -= 10));
            }
            if (Keyboard.getEventKey() == 208 && !Display.isFullscreen()) {
                Display.setLocation((int)this.window_x, (int)(this.window_y += 10));
            }
            if (Keyboard.getEventKey() != 33) continue;
            try {
                if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                    System.out.println("Performing Display.destroy()/create() cycle");
                    DisplayMode saved_mode = Display.getDisplayMode();
                    Display.destroy();
                    Display.setDisplayMode((DisplayMode)saved_mode);
                    this.fullscreen = !this.fullscreen;
                    Display.setFullscreen((boolean)this.fullscreen);
                    Display.create();
                    continue;
                }
                this.fullscreen = !this.fullscreen;
                Display.setFullscreen((boolean)this.fullscreen);
            }
            catch (LWJGLException lwjgle) {
                lwjgle.printStackTrace();
            }
        }
    }

    private void setMode(int mode) {
        if (this.fixed_modes[mode] == null) {
            System.out.println("Unable to set mode. Not valid: " + mode);
            return;
        }
        try {
            Display.setDisplayMode((DisplayMode)this.fixed_modes[mode]);
        }
        catch (LWJGLException le) {
            le.printStackTrace();
            System.out.println("Exception while setting mode: " + this.fixed_modes[mode]);
        }
    }

    private void render() {
        GL11.glClearColor((float)this.color, (float)this.color, (float)this.color, (float)1.0f);
        GL11.glClear((int)16384);
        this.color += (float)this.direction * 0.05f;
        if (this.color > 1.0f) {
            this.color = 1.0f;
            this.direction = -1 * this.direction;
        } else if (this.color < 0.0f) {
            this.direction = -1 * this.direction;
            this.color = 0.0f;
        }
    }

    public static void main(String[] args) throws LWJGLException {
        System.out.println("The following keys are available:\nESCAPE:\t\tExit test\nARROW Keys:\tMove window when in non-fullscreen mode\nL:\t\tList selectable display modes\n0-8:\t\tSelection of display modes\nF:\t\tToggle fullscreen\nSHIFT-F:\tToggle fullscreen with Display.destroy()/create() cycle");
        WindowCreationTest wct = new WindowCreationTest();
        if (wct.initialize()) {
            wct.execute();
            wct.destroy();
        }
        System.exit(0);
    }

    protected boolean setDefaultDisplayMode() {
        try {
            DisplayMode[] dm = org.lwjgl.util.Display.getAvailableDisplayModes((int)640, (int)480, (int)-1, (int)-1, (int)-1, (int)-1, (int)-1, (int)-1);
            org.lwjgl.util.Display.setDisplayMode((DisplayMode[])dm, (String[])new String[]{"width=640", "height=480", "freq=60", "bpp=" + Display.getDisplayMode().getBitsPerPixel()});
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private DisplayMode getDisplayMode(int width, int height, int bpp, int freq) {
        DisplayMode[] dm = null;
        try {
            dm = org.lwjgl.util.Display.getAvailableDisplayModes((int)width, (int)height, (int)width, (int)height, (int)bpp, (int)bpp, (int)freq, (int)freq);
            if (dm == null || dm.length == 0) {
                System.out.println("Problem retrieving mode with " + width + "x" + height + "x" + bpp + "@" + freq);
            }
        }
        catch (LWJGLException le) {
            le.printStackTrace();
            System.out.println("Problem retrieving mode with " + width + "x" + height + "x" + bpp + "@" + freq);
        }
        return dm != null && dm.length != 0 ? dm[0] : null;
    }
}

