/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.input;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import org.lwjgl.input.Cursor;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;

public class HWCursorTest {
    private static Cursor[] cursor = null;
    private static int mouse_x;
    private static int mouse_y;
    private static int mouse_btn;

    public void execute() {
        this.initialize();
        this.mainLoop();
        this.cleanup();
    }

    protected boolean setDisplayMode() {
        try {
            DisplayMode[] dm = org.lwjgl.util.Display.getAvailableDisplayModes((int)640, (int)480, (int)-1, (int)-1, (int)-1, (int)-1, (int)60, (int)60);
            org.lwjgl.util.Display.setDisplayMode((DisplayMode[])dm, (String[])new String[]{"width=640", "height=480", "freq=60", "bpp=" + Display.getDisplayMode().getBitsPerPixel()});
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void initialize() {
        try {
            this.setDisplayMode();
            Display.create();
            this.glInit();
            HWCursorTest.initNativeCursors();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private static void initNativeCursors() throws Exception {
        int cursorWidth;
        if ((Cursor.getCapabilities() & 1) == 0) {
            System.out.println("No HW cursor support!");
            System.exit(0);
        }
        cursor = new Cursor[3];
        int cursorImageCount = 1;
        int cursorHeight = cursorWidth = Math.min(64, Cursor.getMaxCursorSize());
        IntBuffer cursorImages = ByteBuffer.allocateDirect(cursorWidth * cursorHeight * cursorImageCount * 4).order(ByteOrder.nativeOrder()).asIntBuffer();
        IntBuffer cursorDelays = null;
        for (int j = 0; j < cursorWidth; ++j) {
            for (int l = 0; l < cursorHeight; ++l) {
                cursorImages.put(-1);
            }
        }
        cursorImages.flip();
        HWCursorTest.cursor[0] = new Cursor(cursorWidth, cursorHeight, cursorWidth / 2, cursorHeight / 2, cursorImageCount, cursorImages, cursorDelays);
        cursorImageCount = 3;
        cursorImages = ByteBuffer.allocateDirect(cursorWidth * cursorHeight * cursorImageCount * 4).order(ByteOrder.nativeOrder()).asIntBuffer();
        cursorDelays = ByteBuffer.allocateDirect(cursorImageCount * 4).order(ByteOrder.nativeOrder()).asIntBuffer();
        for (int i = 0; i < cursorImageCount; ++i) {
            int offColor = 0;
            int onColor = -65536;
            if (i == 1) {
                onColor = -16711936;
            } else if (i == 2) {
                onColor = -16776961;
            }
            int centerSize = cursorWidth / 5 * (i + 1);
            int centerLeft = cursorWidth / 2 - centerSize / 2;
            int centerRight = cursorWidth / 2 + centerSize / 2;
            for (int j = 0; j < cursorWidth; ++j) {
                for (int l = 0; l < cursorHeight; ++l) {
                    if (j >= centerLeft && j < centerRight && l >= centerLeft && l < centerRight) {
                        cursorImages.put(offColor);
                        continue;
                    }
                    cursorImages.put(onColor);
                }
            }
        }
        cursorDelays.put(2000).put(2000).put(2000);
        cursorDelays.flip();
        cursorImages.flip();
        HWCursorTest.cursor[1] = new Cursor(cursorWidth, cursorHeight, cursorWidth / 2, cursorHeight / 2, cursorImageCount, cursorImages, cursorDelays);
        cursorImageCount = 20;
        cursorImages = ByteBuffer.allocateDirect(cursorWidth * cursorHeight * cursorImageCount * 4).order(ByteOrder.nativeOrder()).asIntBuffer();
        cursorDelays = ByteBuffer.allocateDirect(cursorImageCount * 4).order(ByteOrder.nativeOrder()).asIntBuffer();
        cursorDelays.put(new int[]{100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100});
        float step = -0.05f;
        for (int i = 0; i < cursorImageCount; ++i) {
            for (int j = 0; j < cursorWidth; ++j) {
                for (int l = 0; l < cursorHeight; ++l) {
                    cursorImages.put((int)step);
                }
            }
            step += step;
        }
        cursorImages.flip();
        cursorDelays.flip();
        HWCursorTest.cursor[2] = new Cursor(cursorWidth, cursorHeight, cursorWidth / 2, cursorHeight / 2, cursorImageCount, cursorImages, cursorDelays);
        Mouse.setNativeCursor((Cursor)cursor[0]);
    }

    private void mainLoop() {
        while (!Keyboard.isKeyDown((int)1) && !Display.isCloseRequested()) {
            Display.update();
            if (Display.isVisible()) {
                this.processKeyboard();
                this.processMouse();
                this.render();
                continue;
            }
            if (Display.isDirty()) {
                this.render();
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void render() {
        GL11.glClear((int)16384);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)mouse_x, (float)mouse_y, (float)0.0f);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glBegin((int)7);
        GL11.glColor3f((float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glVertex2i((int)-50, (int)-50);
        GL11.glColor3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glVertex2i((int)50, (int)-50);
        GL11.glColor3f((float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glVertex2i((int)50, (int)50);
        GL11.glColor3f((float)1.0f, (float)0.0f, (float)1.0f);
        GL11.glVertex2i((int)-50, (int)50);
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    private void processMouse() {
        mouse_x = Mouse.getX();
        mouse_y = Mouse.getY();
        while (Mouse.next()) {
            int button = Mouse.getEventButton();
            if (button < 0 || button >= 3 || !Mouse.getEventButtonState()) continue;
            mouse_btn = Mouse.getEventButton();
            this.switchCursor();
        }
    }

    private void processKeyboard() {
        if (Keyboard.isKeyDown((int)33)) {
            try {
                try {
                    Mouse.setNativeCursor(null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(1);
                }
                for (int i = 0; i < cursor.length; ++i) {
                    cursor[i].destroy();
                }
                Display.setFullscreen((boolean)true);
                this.glInit();
                HWCursorTest.initNativeCursors();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (Keyboard.isKeyDown((int)17)) {
            try {
                try {
                    Mouse.setNativeCursor(null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(1);
                }
                for (int i = 0; i < cursor.length; ++i) {
                    cursor[i].destroy();
                }
                Display.setFullscreen((boolean)false);
                this.glInit();
                HWCursorTest.initNativeCursors();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (Keyboard.isKeyDown((int)50)) {
            try {
                Mouse.setNativeCursor(null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (Keyboard.isKeyDown((int)49)) {
            this.switchCursor();
        }
        while (Keyboard.next()) {
            if (Keyboard.getEventKey() != 57 || !Keyboard.getEventKeyState()) continue;
            Mouse.setGrabbed((!Mouse.isGrabbed() ? 1 : 0) != 0);
        }
    }

    private void switchCursor() {
        try {
            Mouse.setNativeCursor((Cursor)cursor[mouse_btn]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void cleanup() {
        try {
            Mouse.setNativeCursor(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        for (int i = 0; i < cursor.length; ++i) {
            cursor[i].destroy();
        }
        Display.destroy();
    }

    private void glInit() {
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GLU.gluOrtho2D((float)0.0f, (float)Display.getDisplayMode().getWidth(), (float)0.0f, (float)Display.getDisplayMode().getHeight());
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glViewport((int)0, (int)0, (int)Display.getDisplayMode().getWidth(), (int)Display.getDisplayMode().getHeight());
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        Display.setVSyncEnabled((boolean)true);
    }

    public static void main(String[] args) {
        System.out.println("Change between fullscreen and windowed mode, by pressing F and W respectively. Enable hw cursor with N and disable it with M.");
        HWCursorTest cursorTest = new HWCursorTest();
        cursorTest.execute();
        System.exit(0);
    }

    static {
        mouse_btn = 0;
    }
}

