/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.openal;

import java.nio.FloatBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.ALC10;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;

public abstract class BasicTest {
    public BasicTest() {
        try {
            AL.create();
            System.out.println("Default device: " + ALC10.alcGetString(null, (int)4100));
            if (ALC10.alcIsExtensionPresent(null, (String)"ALC_ENUMERATION_EXT")) {
                String[] devices = ALC10.alcGetString(null, (int)4101).split("\u0000");
                System.out.println("Available devices: ");
                for (int i = 0; i < devices.length; ++i) {
                    System.out.println(i + ": " + devices[i]);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Unable to create OpenAL.\nPlease make sure that OpenAL is available on this system. Exception: " + e);
            return;
        }
    }

    protected void alExit() {
        if (AL.isCreated()) {
            AL.destroy();
        }
    }

    protected FloatBuffer createFloatBuffer(float[] data) {
        FloatBuffer temp = BufferUtils.createFloatBuffer((int)data.length).put(data);
        temp.flip();
        return temp;
    }

    protected void pause(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void exit(int error) {
        System.out.println("OpenAL Error: " + AL10.alGetString((int)error));
        this.alExit();
        System.exit(-1);
    }

    protected boolean setDisplayMode() {
        try {
            DisplayMode[] dm = org.lwjgl.util.Display.getAvailableDisplayModes((int)640, (int)480, (int)-1, (int)-1, (int)-1, (int)-1, (int)60, (int)60);
            org.lwjgl.util.Display.setDisplayMode((DisplayMode[])dm, (String[])new String[]{"width=640", "height=480", "freq=60", "bpp=" + Display.getDisplayMode().getBitsPerPixel()});
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

