/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.openal;

import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.ALCcontext;
import org.lwjgl.openal.ALCdevice;

public class OpenALInfo {
    protected void execute(String[] args) {
        try {
            AL.create(null, (int)-1, (int)60, (boolean)false);
            this.checkForErrors();
        }
        catch (LWJGLException le) {
            this.die("Init", le.getMessage());
        }
        this.printALCInfo();
        this.printALInfo();
        this.checkForErrors();
        AL.destroy();
    }

    private void printALCInfo() {
        IntBuffer version = BufferUtils.createIntBuffer((int)2);
        if (ALC10.alcIsExtensionPresent(null, (String)"ALC_ENUMERATION_EXT")) {
            if (ALC10.alcIsExtensionPresent(null, (String)"ALC_ENUMERATE_ALL_EXT")) {
                this.printDevices(4115, "playback");
            } else {
                this.printDevices(4101, "playback");
            }
            this.printDevices(784, "capture");
        } else {
            System.out.println("No device enumeration available");
        }
        ALCdevice device = ALC10.alcGetContextsDevice((ALCcontext)ALC10.alcGetCurrentContext());
        this.checkForErrors();
        System.out.println("Default device: " + ALC10.alcGetString((ALCdevice)device, (int)4100));
        System.out.println("Default capture device: " + ALC10.alcGetString((ALCdevice)device, (int)785));
        ALC10.alcGetInteger((ALCdevice)AL.getDevice(), (int)4096, (IntBuffer)version);
        ALC10.alcGetInteger((ALCdevice)AL.getDevice(), (int)4097, (IntBuffer)((IntBuffer)version.position(1)));
        this.checkForErrors();
        System.out.println("ALC version: " + version.get(0) + "." + version.get(1));
        System.out.println("ALC extensions:");
        String[] extensions = ALC10.alcGetString((ALCdevice)device, (int)4102).split(" ");
        for (int i = 0; i < extensions.length; ++i) {
            if (extensions[i].trim().length() == 0) continue;
            System.out.println("    " + extensions[i]);
        }
        this.checkForErrors();
    }

    private void printALInfo() {
        System.out.println("OpenAL vendor string: " + AL10.alGetString((int)45057));
        System.out.println("OpenAL renderer string: " + AL10.alGetString((int)45059));
        System.out.println("OpenAL version string: " + AL10.alGetString((int)45058));
        System.out.println("AL extensions:");
        String[] extensions = AL10.alGetString((int)45060).split(" ");
        for (int i = 0; i < extensions.length; ++i) {
            if (extensions[i].trim().length() == 0) continue;
            System.out.println("    " + extensions[i]);
        }
        this.checkForErrors();
    }

    private void printDevices(int which, String kind) {
        String[] devices = ALC10.alcGetString(null, (int)which).split("\u0000");
        this.checkForErrors();
        System.out.println("Available " + kind + " devices: ");
        for (int i = 0; i < devices.length; ++i) {
            System.out.println("    " + devices[i]);
        }
    }

    private void die(String kind, String description) {
        System.out.println(kind + " error " + description + " occured");
    }

    private void checkForErrors() {
        int error;
        ALCdevice device = ALC10.alcGetContextsDevice((ALCcontext)ALC10.alcGetCurrentContext());
        int error2 = ALC10.alcGetError((ALCdevice)device);
        if (error2 != 0) {
            this.die("ALC", ALC10.alcGetString((ALCdevice)device, (int)error2));
        }
        if ((error = AL10.alGetError()) != 0) {
            this.die("AL", AL10.alGetString((int)error));
        }
    }

    public static void main(String[] args) {
        OpenALInfo openalInfo = new OpenALInfo();
        openalInfo.execute(args);
        System.exit(0);
    }
}

