/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.opengl;

import java.nio.IntBuffer;
import java.util.Random;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.Sys;
import org.lwjgl.opengl.ContextAttribs;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL32;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.GLSync;
import org.lwjgl.opengl.PixelFormat;

public final class SyncTest {
    private SyncTest() {
    }

    public static void main(String[] args) {
        SyncTest.runTest(args);
        SyncTest.cleanup();
        System.exit(0);
    }

    private static void runTest(String[] args) {
        if (args.length < 2) {
            SyncTest.argsError("Insufficient number of arguments.");
        }
        int clears = 1;
        int timeout = 0;
        try {
            clears = Integer.parseInt(args[0]);
            timeout = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException e) {
            SyncTest.argsError("Invalid number format.");
        }
        ContextAttribs ca = new ContextAttribs();
        try {
            DisplayMode[] modes = Display.getAvailableDisplayModes();
            DisplayMode displayMode = SyncTest.chooseMode(modes, 1024, 768);
            if (displayMode == null) {
                displayMode = SyncTest.chooseMode(modes, 800, 600);
            }
            if (displayMode == null) {
                displayMode = SyncTest.chooseMode(modes, 640, 480);
            }
            if (displayMode == null) {
                SyncTest.kill("Failed to set an appropriate display mode.");
            }
            System.out.println("Setting display mode to: " + displayMode);
            Display.setDisplayMode((DisplayMode)displayMode);
            Display.create((PixelFormat)new PixelFormat(8, 24, 0), (ContextAttribs)ca);
        }
        catch (LWJGLException e) {
            SyncTest.kill(e.getMessage());
        }
        System.out.println("\n---------\n");
        String version = GL11.glGetString((int)7938);
        System.out.println("GL Version: " + version);
        System.out.println("ARB_sync: " + GLContext.getCapabilities().GL_ARB_sync);
        if (!GLContext.getCapabilities().OpenGL32 && !GLContext.getCapabilities().GL_ARB_sync) {
            SyncTest.kill("OpenGL3.2 or ARB_sync support is required for this test.");
        }
        System.out.println("\n---------\n");
        System.out.println("Clearing the framebuffer a gazillion times...");
        Random rand = new Random(System.currentTimeMillis());
        for (int i = 0; i < clears; ++i) {
            GL11.glClearColor((float)rand.nextFloat(), (float)rand.nextFloat(), (float)rand.nextFloat(), (float)1.0f);
            GL11.glClear((int)16384);
        }
        GLSync sync = GL32.glFenceSync((int)37143, (int)0);
        System.out.println("\nWaiting on fence...");
        long time = Sys.getTime();
        int status = GL32.glClientWaitSync((GLSync)sync, (int)0, (long)(timeout < 0 ? -1L : (long)(timeout * 1000 * 1000)));
        System.out.println("\nFence sync complete after: " + (double)(Sys.getTime() - time) / (double)Sys.getTimerResolution() + " seconds.");
        System.out.print("\nWait Status: ");
        switch (status) {
            case 37146: {
                System.out.println("ALREADY_SIGNALED");
                break;
            }
            case 37148: {
                System.out.println("CONDITION_SATISFIED");
                break;
            }
            case 37147: {
                System.out.println("TIMEOUT_EXPIRED");
                break;
            }
            case 37149: {
                System.out.println("WAIT_FAILED");
                break;
            }
            default: {
                System.out.println("Unexpected wait status: 0x" + Integer.toHexString(status));
            }
        }
        IntBuffer property = BufferUtils.createIntBuffer((int)1);
        GL32.glGetSync((GLSync)sync, (int)37140, null, (IntBuffer)property);
        System.out.println("Sync Status: " + (property.get(0) == 37144 ? "UNSIGNALED" : "SIGNALED"));
        GL32.glDeleteSync((GLSync)sync);
        int error = GL11.glGetError();
        if (error != 0) {
            System.out.println("\nTest failed with OpenGL error: " + error);
        } else {
            System.out.println("\nTest completed successfully.");
        }
    }

    private static DisplayMode chooseMode(DisplayMode[] modes, int width, int height) {
        DisplayMode bestMode = null;
        for (int i = 0; i < modes.length; ++i) {
            DisplayMode mode = modes[i];
            if (mode.getWidth() != width || mode.getHeight() != height || mode.getFrequency() > 85 || bestMode != null && (mode.getBitsPerPixel() < bestMode.getBitsPerPixel() || mode.getFrequency() <= bestMode.getFrequency())) continue;
            bestMode = mode;
        }
        return bestMode;
    }

    private static void cleanup() {
        if (Display.isCreated()) {
            Display.destroy();
        }
    }

    private static void argsError(String msg) {
        System.out.println("\nInvalid arguments error: " + msg);
        System.out.println("\nUsage: SyncTest <clears> <timeout>:\n");
        System.out.println("clears\t- Number of times to clear the framebuffer.");
        System.out.println("timeout\t- WaitSync timeout in milliseconds.");
        SyncTest.cleanup();
        System.exit(-1);
    }

    static void kill(String reason) {
        System.out.println("The SyncTest program was terminated because an error occured.\n");
        System.out.println("Reason: " + (reason == null ? "Unknown" : reason));
        SyncTest.cleanup();
        System.exit(-1);
    }
}

