/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.opengl;

import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.ContextAttribs;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.PixelFormat;

public final class VersionTest {
    private VersionTest() {
    }

    public static void main(String[] args) {
        VersionTest.initialize(args);
        VersionTest.cleanup();
        System.exit(0);
    }

    private static void initialize(String[] args) {
        block27: {
            if (args.length < 2) {
                VersionTest.argsError("Insufficient number of arguments");
            }
            int majorInput = 1;
            int minorInput = 0;
            try {
                majorInput = Integer.parseInt(args[0]);
                minorInput = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException e) {
                VersionTest.argsError("Invalid number format");
            }
            ContextAttribs ca = new ContextAttribs(majorInput, minorInput);
            if (2 < args.length) {
                for (int i = 2; i < args.length; ++i) {
                    if (Pattern.matches("[0-9]+", args[i])) {
                        ca = ca.withLayer(Integer.parseInt(args[i]));
                        continue;
                    }
                    if ("debug".equalsIgnoreCase(args[i])) {
                        ca = ca.withDebug(true);
                        continue;
                    }
                    if ("fc".equalsIgnoreCase(args[i])) {
                        ca = ca.withForwardCompatible(true);
                        continue;
                    }
                    if ("core".equalsIgnoreCase(args[i])) {
                        ca = ca.withProfileCore(true);
                        continue;
                    }
                    if ("compatibility".equalsIgnoreCase(args[i])) {
                        ca = ca.withProfileCompatibility(true);
                        continue;
                    }
                    VersionTest.argsError("Unknown argument: '" + args[i] + "'");
                }
            }
            try {
                DisplayMode[] modes = Display.getAvailableDisplayModes();
                DisplayMode displayMode = VersionTest.chooseMode(modes, 1024, 768);
                if (displayMode == null) {
                    displayMode = VersionTest.chooseMode(modes, 800, 600);
                }
                if (displayMode == null) {
                    displayMode = VersionTest.chooseMode(modes, 640, 480);
                }
                if (displayMode == null) {
                    VersionTest.kill("Failed to set an appropriate display mode.");
                }
                System.out.println("Setting display mode to: " + displayMode);
                Display.setDisplayMode((DisplayMode)displayMode);
                Display.create((PixelFormat)new PixelFormat(8, 24, 0), (ContextAttribs)ca);
            }
            catch (LWJGLException e) {
                VersionTest.kill(e.getMessage());
            }
            System.out.println("\n---------\n");
            String version = GL11.glGetString((int)7938);
            System.out.print("GL Version requested: " + majorInput + '.' + minorInput);
            if (ca.isProfileCore()) {
                System.out.print(" - Core Profile");
            } else if (ca.isProfileCompatibility()) {
                System.out.print(" - Compatibility Profile");
            }
            System.out.println("\nGL Version returned : " + version);
            StringTokenizer version_tokenizer = new StringTokenizer(version, ". ");
            int majorVersion = Integer.parseInt(version_tokenizer.nextToken());
            int minorVersion = Integer.parseInt(version_tokenizer.nextToken());
            if (majorVersion != majorInput || minorVersion != minorInput) {
                if (majorInput == 1 && minorInput == 0) {
                    System.out.println("\tThe maximum supported version has been returned. The driver is well-behaved. :)");
                } else if (majorInput < 3 && majorVersion < 3) {
                    System.out.println("\tThe maximum supported version pre-3.0 has been returned. The driver is well-behaved. :)");
                } else {
                    System.out.println("\tThe requested version was not returned. The driver is buggy! :(");
                }
            } else {
                System.out.println("\tThe requested version was returned. :)");
            }
            if (ca.isProfileCompatibility() && !GLContext.getCapabilities().GL_ARB_compatibility) {
                System.out.println("\tThe driver does not support the Compatibility Profile.");
            }
            System.out.println("\n---------\n");
            System.out.println("Debug mode: " + ca.isDebug());
            System.out.println("Forward compatible mode: " + ca.isForwardCompatible());
            System.out.println("ARB_compatibility: " + GLContext.getCapabilities().GL_ARB_compatibility);
            try {
                GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
                System.out.println("Deprecated functionality present: true");
            }
            catch (Throwable t) {
                System.out.println("Deprecated functionality present: false");
                if (!GLContext.getCapabilities().GL_ARB_compatibility) break block27;
                System.out.println("\tARB_compatibility is present, but LWJGL has enabled pseudo-forward compatible mode.");
            }
        }
    }

    private static DisplayMode chooseMode(DisplayMode[] modes, int width, int height) {
        DisplayMode bestMode = null;
        for (int i = 0; i < modes.length; ++i) {
            DisplayMode mode = modes[i];
            if (mode.getWidth() != width || mode.getHeight() != height || mode.getFrequency() > 85 || bestMode != null && (mode.getBitsPerPixel() < bestMode.getBitsPerPixel() || mode.getFrequency() <= bestMode.getFrequency())) continue;
            bestMode = mode;
        }
        return bestMode;
    }

    private static void cleanup() {
        if (Display.isCreated()) {
            Display.destroy();
        }
    }

    private static void argsError(String msg) {
        System.out.println("\nInvalid arguments error: " + msg);
        System.out.println("\nUsage: VersionTest <majorVersion> <minorVersion> {<layer>, 'debug', 'fc'}:\n");
        System.out.println("majorVersion\t- Major OpenGL version.");
        System.out.println("majorVersion\t- Minor OpenGL version.");
        System.out.println("layer\t- Layer plane (optional).");
        System.out.println("debug\t- Enables debug mode (optional).");
        System.out.println("fc\t- Enables forward compatibility mode (optional).");
        VersionTest.cleanup();
        System.exit(-1);
    }

    static void kill(String reason) {
        System.out.println("The VersionTest program was terminated because an error occured.\n");
        System.out.println("Reason: " + (reason == null ? "Unknown" : reason));
        VersionTest.cleanup();
        System.exit(-1);
    }
}

