/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.opengl.awt;

import java.nio.FloatBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.ARBTransposeMatrix;
import org.lwjgl.opengl.AWTGLCanvas;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.test.applet.Test;

public class AWTGearsCanvas
extends AWTGLCanvas
implements Test {
    private float view_rotx = 20.0f;
    private float view_roty = 30.0f;
    private float view_rotz = 0.0f;
    private int gear1;
    private int gear2;
    private int gear3;
    private float angle = 0.0f;
    long startTime = 0L;
    long fps = 0L;
    int current_width;
    int current_height;

    public void paintGL() {
        if (this.startTime == 0L) {
            this.setup();
            this.startTime = System.currentTimeMillis() + 5000L;
        }
        try {
            this.angle += 2.0f;
            if (this.getWidth() != this.current_width || this.getHeight() != this.current_height) {
                this.current_width = this.getWidth();
                this.current_height = this.getHeight();
                GL11.glViewport((int)0, (int)0, (int)this.current_width, (int)this.current_height);
            }
            GL11.glClear((int)16640);
            GL11.glPushMatrix();
            GL11.glRotatef((float)this.view_rotx, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)this.view_roty, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)this.view_rotz, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)-3.0f, (float)-2.0f, (float)0.0f);
            GL11.glRotatef((float)this.angle, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glCallList((int)this.gear1);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glTranslatef((float)3.1f, (float)-2.0f, (float)0.0f);
            GL11.glRotatef((float)(-2.0f * this.angle - 9.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glCallList((int)this.gear2);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glTranslatef((float)-3.1f, (float)4.2f, (float)0.0f);
            GL11.glRotatef((float)(-2.0f * this.angle - 25.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glCallList((int)this.gear3);
            GL11.glPopMatrix();
            GL11.glPopMatrix();
            this.swapBuffers();
            this.repaint();
        }
        catch (LWJGLException e) {
            throw new RuntimeException(e);
        }
        if (this.startTime > System.currentTimeMillis()) {
            ++this.fps;
        } else {
            long timeUsed = 5000L + (this.startTime - System.currentTimeMillis());
            this.startTime = System.currentTimeMillis() + 5000L;
            System.out.println(this.fps + " frames in " + (float)timeUsed / 1000.0f + " seconds = " + (float)this.fps / ((float)timeUsed / 1000.0f));
            this.fps = 0L;
        }
    }

    private void setup() {
        FloatBuffer pos = BufferUtils.createFloatBuffer((int)4).put(new float[]{5.0f, 5.0f, 10.0f, 0.0f});
        FloatBuffer red = BufferUtils.createFloatBuffer((int)4).put(new float[]{0.8f, 0.1f, 0.0f, 1.0f});
        FloatBuffer green = BufferUtils.createFloatBuffer((int)4).put(new float[]{0.0f, 0.8f, 0.2f, 1.0f});
        FloatBuffer blue = BufferUtils.createFloatBuffer((int)4).put(new float[]{0.2f, 0.2f, 1.0f, 1.0f});
        pos.flip();
        red.flip();
        green.flip();
        blue.flip();
        GL11.glLight((int)16384, (int)4611, (FloatBuffer)pos);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)16384);
        GL11.glEnable((int)2929);
        this.gear1 = GL11.glGenLists((int)1);
        GL11.glNewList((int)this.gear1, (int)4864);
        GL11.glMaterial((int)1028, (int)5634, (FloatBuffer)red);
        this.gear(1.0f, 4.0f, 1.0f, 20, 0.7f);
        GL11.glEndList();
        this.gear2 = GL11.glGenLists((int)1);
        GL11.glNewList((int)this.gear2, (int)4864);
        GL11.glMaterial((int)1028, (int)5634, (FloatBuffer)green);
        this.gear(0.5f, 2.0f, 2.0f, 10, 0.7f);
        GL11.glEndList();
        this.gear3 = GL11.glGenLists((int)1);
        GL11.glNewList((int)this.gear3, (int)4864);
        GL11.glMaterial((int)1028, (int)5634, (FloatBuffer)blue);
        this.gear(1.3f, 2.0f, 0.5f, 10, 0.7f);
        GL11.glEndList();
        GL11.glEnable((int)2977);
        GL11.glMatrixMode((int)5889);
        System.err.println("GL_VENDOR: " + GL11.glGetString((int)7936));
        System.err.println("GL_RENDERER: " + GL11.glGetString((int)7937));
        System.err.println("GL_VERSION: " + GL11.glGetString((int)7938));
        System.err.println();
        System.err.println("glLoadTransposeMatrixfARB() supported: " + GLContext.getCapabilities().GL_ARB_transpose_matrix);
        if (!GLContext.getCapabilities().GL_ARB_transpose_matrix) {
            GL11.glLoadIdentity();
        } else {
            FloatBuffer identityTranspose = BufferUtils.createFloatBuffer((int)16).put(new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f});
            identityTranspose.flip();
            ARBTransposeMatrix.glLoadTransposeMatrixARB((FloatBuffer)identityTranspose);
        }
        float h = 1.0f;
        GL11.glFrustum((double)-1.0, (double)1.0, (double)(-h), (double)h, (double)5.0, (double)60.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-40.0f);
    }

    private void gear(float inner_radius, float outer_radius, float width, int teeth, float tooth_depth) {
        float angle;
        int i;
        float r0 = inner_radius;
        float r1 = outer_radius - tooth_depth / 2.0f;
        float r2 = outer_radius + tooth_depth / 2.0f;
        float da = (float)Math.PI * 2 / (float)teeth / 4.0f;
        GL11.glShadeModel((int)7424);
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glBegin((int)8);
        for (i = 0; i <= teeth; ++i) {
            angle = (float)i * 2.0f * (float)Math.PI / (float)teeth;
            GL11.glVertex3f((float)(r0 * (float)Math.cos(angle)), (float)(r0 * (float)Math.sin(angle)), (float)(width * 0.5f));
            GL11.glVertex3f((float)(r1 * (float)Math.cos(angle)), (float)(r1 * (float)Math.sin(angle)), (float)(width * 0.5f));
            if (i >= teeth) continue;
            GL11.glVertex3f((float)(r0 * (float)Math.cos(angle)), (float)(r0 * (float)Math.sin(angle)), (float)(width * 0.5f));
            GL11.glVertex3f((float)(r1 * (float)Math.cos(angle + 3.0f * da)), (float)(r1 * (float)Math.sin(angle + 3.0f * da)), (float)(width * 0.5f));
        }
        GL11.glEnd();
        GL11.glBegin((int)7);
        for (i = 0; i < teeth; ++i) {
            angle = (float)i * 2.0f * (float)Math.PI / (float)teeth;
            GL11.glVertex3f((float)(r1 * (float)Math.cos(angle)), (float)(r1 * (float)Math.sin(angle)), (float)(width * 0.5f));
            GL11.glVertex3f((float)(r2 * (float)Math.cos(angle + da)), (float)(r2 * (float)Math.sin(angle + da)), (float)(width * 0.5f));
            GL11.glVertex3f((float)(r2 * (float)Math.cos(angle + 2.0f * da)), (float)(r2 * (float)Math.sin(angle + 2.0f * da)), (float)(width * 0.5f));
            GL11.glVertex3f((float)(r1 * (float)Math.cos(angle + 3.0f * da)), (float)(r1 * (float)Math.sin(angle + 3.0f * da)), (float)(width * 0.5f));
        }
        GL11.glEnd();
        GL11.glBegin((int)8);
        for (i = 0; i <= teeth; ++i) {
            angle = (float)i * 2.0f * (float)Math.PI / (float)teeth;
            GL11.glVertex3f((float)(r1 * (float)Math.cos(angle)), (float)(r1 * (float)Math.sin(angle)), (float)(-width * 0.5f));
            GL11.glVertex3f((float)(r0 * (float)Math.cos(angle)), (float)(r0 * (float)Math.sin(angle)), (float)(-width * 0.5f));
            GL11.glVertex3f((float)(r1 * (float)Math.cos(angle + 3.0f * da)), (float)(r1 * (float)Math.sin(angle + 3.0f * da)), (float)(-width * 0.5f));
            GL11.glVertex3f((float)(r0 * (float)Math.cos(angle)), (float)(r0 * (float)Math.sin(angle)), (float)(-width * 0.5f));
        }
        GL11.glEnd();
        GL11.glBegin((int)7);
        for (i = 0; i < teeth; ++i) {
            angle = (float)i * 2.0f * (float)Math.PI / (float)teeth;
            GL11.glVertex3f((float)(r1 * (float)Math.cos(angle + 3.0f * da)), (float)(r1 * (float)Math.sin(angle + 3.0f * da)), (float)(-width * 0.5f));
            GL11.glVertex3f((float)(r2 * (float)Math.cos(angle + 2.0f * da)), (float)(r2 * (float)Math.sin(angle + 2.0f * da)), (float)(-width * 0.5f));
            GL11.glVertex3f((float)(r2 * (float)Math.cos(angle + da)), (float)(r2 * (float)Math.sin(angle + da)), (float)(-width * 0.5f));
            GL11.glVertex3f((float)(r1 * (float)Math.cos(angle)), (float)(r1 * (float)Math.sin(angle)), (float)(-width * 0.5f));
        }
        GL11.glEnd();
        GL11.glBegin((int)8);
        for (i = 0; i < teeth; ++i) {
            angle = (float)i * 2.0f * (float)Math.PI / (float)teeth;
            GL11.glVertex3f((float)(r1 * (float)Math.cos(angle)), (float)(r1 * (float)Math.sin(angle)), (float)(width * 0.5f));
            GL11.glVertex3f((float)(r1 * (float)Math.cos(angle)), (float)(r1 * (float)Math.sin(angle)), (float)(-width * 0.5f));
            float u = r2 * (float)Math.cos(angle + da) - r1 * (float)Math.cos(angle);
            float v = r2 * (float)Math.sin(angle + da) - r1 * (float)Math.sin(angle);
            float len = (float)Math.sqrt(u * u + v * v);
            GL11.glNormal3f((float)(v /= len), (float)(-(u /= len)), (float)0.0f);
            GL11.glVertex3f((float)(r2 * (float)Math.cos(angle + da)), (float)(r2 * (float)Math.sin(angle + da)), (float)(width * 0.5f));
            GL11.glVertex3f((float)(r2 * (float)Math.cos(angle + da)), (float)(r2 * (float)Math.sin(angle + da)), (float)(-width * 0.5f));
            GL11.glNormal3f((float)((float)Math.cos(angle)), (float)((float)Math.sin(angle)), (float)0.0f);
            GL11.glVertex3f((float)(r2 * (float)Math.cos(angle + 2.0f * da)), (float)(r2 * (float)Math.sin(angle + 2.0f * da)), (float)(width * 0.5f));
            GL11.glVertex3f((float)(r2 * (float)Math.cos(angle + 2.0f * da)), (float)(r2 * (float)Math.sin(angle + 2.0f * da)), (float)(-width * 0.5f));
            u = r1 * (float)Math.cos(angle + 3.0f * da) - r2 * (float)Math.cos(angle + 2.0f * da);
            v = r1 * (float)Math.sin(angle + 3.0f * da) - r2 * (float)Math.sin(angle + 2.0f * da);
            GL11.glNormal3f((float)v, (float)(-u), (float)0.0f);
            GL11.glVertex3f((float)(r1 * (float)Math.cos(angle + 3.0f * da)), (float)(r1 * (float)Math.sin(angle + 3.0f * da)), (float)(width * 0.5f));
            GL11.glVertex3f((float)(r1 * (float)Math.cos(angle + 3.0f * da)), (float)(r1 * (float)Math.sin(angle + 3.0f * da)), (float)(-width * 0.5f));
            GL11.glNormal3f((float)((float)Math.cos(angle)), (float)((float)Math.sin(angle)), (float)0.0f);
        }
        GL11.glVertex3f((float)(r1 * (float)Math.cos(0.0)), (float)(r1 * (float)Math.sin(0.0)), (float)(width * 0.5f));
        GL11.glVertex3f((float)(r1 * (float)Math.cos(0.0)), (float)(r1 * (float)Math.sin(0.0)), (float)(-width * 0.5f));
        GL11.glEnd();
        GL11.glShadeModel((int)7425);
        GL11.glBegin((int)8);
        for (i = 0; i <= teeth; ++i) {
            angle = (float)i * 2.0f * (float)Math.PI / (float)teeth;
            GL11.glNormal3f((float)(-((float)Math.cos(angle))), (float)(-((float)Math.sin(angle))), (float)0.0f);
            GL11.glVertex3f((float)(r0 * (float)Math.cos(angle)), (float)(r0 * (float)Math.sin(angle)), (float)(-width * 0.5f));
            GL11.glVertex3f((float)(r0 * (float)Math.cos(angle)), (float)(r0 * (float)Math.sin(angle)), (float)(width * 0.5f));
        }
        GL11.glEnd();
    }

    public void start() {
    }

    public void stop() {
    }
}

