/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.opengl.pbuffers;

import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.Pbuffer;
import org.lwjgl.opengl.PixelFormat;
import org.lwjgl.test.opengl.pbuffers.TextureRenderer;
import org.lwjgl.test.opengl.pbuffers.UniqueRenderer;
import org.lwjgl.test.opengl.pbuffers.UniqueRendererRTT;
import org.lwjgl.util.glu.GLU;
import org.lwjgl.util.vector.Vector2f;

public final class PbufferTest {
    private static final int TEXTURE_SIZE = 512;
    private static final int QUAD_SIZE = 64;
    private TextureRenderer texRenderer;
    private DisplayMode mode;
    private Vector2f quadPosition;
    private float texScaleX;
    private float texScaleY;
    private Vector2f quadVelocity;
    private float angle;
    private float angleRotation = 1.0f;
    private static final float MAX_SPEED = 20.0f;
    private static int texID;

    public PbufferTest(int renderMode) {
        try {
            this.mode = this.findDisplayMode(800, 600, 16);
            Display.setDisplayMode((DisplayMode)this.mode);
            Display.create((PixelFormat)new PixelFormat(16, 0, 0, 0, 0));
            this.glInit();
            if ((Pbuffer.getCapabilities() & 1) == 0) {
                System.out.println("No Pbuffer support!");
                System.exit(-1);
            }
            System.out.println("Pbuffer support detected. Initializing...\n");
            switch (renderMode) {
                case 1: {
                    System.out.print("Creating pbuffer with unique context...");
                    this.texRenderer = new UniqueRenderer(512, 512, texID);
                    break;
                }
                case 2: {
                    System.out.print("Creating render-to-texture pbuffer with unique context...");
                    this.texRenderer = new UniqueRendererRTT(512, 512, texID);
                }
            }
            System.out.println("OK");
            this.quadPosition = new Vector2f(100.0f, 100.0f);
            this.quadVelocity = new Vector2f(1.0f, 1.0f);
            this.texScaleX = 512.0f / (float)this.mode.getWidth();
            this.texScaleY = 512.0f / (float)this.mode.getHeight();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void execute() {
        this.mainLoop();
        this.cleanup();
    }

    private void mainLoop() {
        while (!Keyboard.isKeyDown((int)1) && !Display.isCloseRequested()) {
            if (Display.isVisible()) {
                this.processKeyboard();
                this.logic();
                this.render();
            } else {
                if (Display.isDirty()) {
                    this.render();
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            Display.update();
            Display.sync((int)100);
        }
    }

    private void logic() {
        this.angle += this.angleRotation;
        if (this.angle > 360.0f) {
            this.angle -= 360.0f;
        }
        this.quadPosition.x += this.quadVelocity.x;
        this.quadPosition.y += this.quadVelocity.y;
        if (this.quadPosition.x + 64.0f >= (float)this.mode.getWidth() || this.quadPosition.x - 64.0f <= 0.0f) {
            this.quadVelocity.x *= -1.0f;
        }
        if (this.quadPosition.y + 64.0f >= (float)this.mode.getHeight() || this.quadPosition.y - 64.0f <= 0.0f) {
            this.quadVelocity.y *= -1.0f;
        }
    }

    private void render() {
        this.texRenderer.enable();
        GL11.glClear((int)16384);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(this.quadPosition.x * this.texScaleX), (float)(this.quadPosition.y * this.texScaleY), (float)0.0f);
        GL11.glRotatef((float)this.angle, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glBegin((int)7);
        GL11.glColor3f((float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glVertex2i((int)-64, (int)-64);
        GL11.glVertex2i((int)64, (int)-64);
        GL11.glColor3f((float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glVertex2i((int)64, (int)64);
        GL11.glVertex2i((int)-64, (int)64);
        GL11.glEnd();
        GL11.glPopMatrix();
        this.texRenderer.updateTexture();
        try {
            Display.makeCurrent();
        }
        catch (LWJGLException e) {
            throw new RuntimeException(e);
        }
        GL11.glClear((int)16384);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.quadPosition.x, (float)this.quadPosition.y, (float)0.0f);
        GL11.glRotatef((float)this.angle, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex2i((int)-64, (int)-64);
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex2i((int)64, (int)-64);
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex2i((int)64, (int)64);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex2i((int)-64, (int)64);
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    private void processKeyboard() {
        Keyboard.poll();
        if (Keyboard.isKeyDown((int)33)) {
            try {
                Display.setDisplayMode((DisplayMode)this.mode);
                Display.setFullscreen((boolean)true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (Keyboard.isKeyDown((int)17)) {
            try {
                Display.setFullscreen((boolean)false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (Keyboard.isKeyDown((int)200)) {
            this.quadVelocity.y += 0.1f;
        }
        if (Keyboard.isKeyDown((int)208)) {
            this.quadVelocity.y -= 0.1f;
        }
        if (Keyboard.isKeyDown((int)205)) {
            this.quadVelocity.x += 0.1f;
        }
        if (Keyboard.isKeyDown((int)203)) {
            this.quadVelocity.x -= 0.1f;
        }
        if (Keyboard.isKeyDown((int)78)) {
            this.angleRotation += 0.1f;
        }
        if (Keyboard.isKeyDown((int)74)) {
            this.angleRotation -= 0.1f;
        }
        if (this.quadVelocity.x < -20.0f) {
            this.quadVelocity.x = -20.0f;
        }
        if (this.quadVelocity.x > 20.0f) {
            this.quadVelocity.x = 20.0f;
        }
        if (this.quadVelocity.y < -20.0f) {
            this.quadVelocity.y = -20.0f;
        }
        if (this.quadVelocity.y > 20.0f) {
            this.quadVelocity.y = 20.0f;
        }
        if (this.angleRotation < 0.0f) {
            this.angleRotation = 0.0f;
        }
        if (this.angleRotation > 20.0f) {
            this.angleRotation = 20.0f;
        }
    }

    private void cleanup() {
        IntBuffer buffer = BufferUtils.createIntBuffer((int)1);
        buffer.put(0, texID);
        GL11.glDeleteTextures((IntBuffer)buffer);
        this.texRenderer.destroy();
        Display.destroy();
    }

    private DisplayMode findDisplayMode(int width, int height, int bpp) throws LWJGLException {
        DisplayMode[] modes = Display.getAvailableDisplayModes();
        for (int i = 0; i < modes.length; ++i) {
            if (modes[i].getWidth() != width || modes[i].getHeight() != height || modes[i].getBitsPerPixel() < bpp) continue;
            return modes[i];
        }
        return null;
    }

    static void initGLState(int width, int height, float color) {
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GLU.gluOrtho2D((float)0.0f, (float)width, (float)0.0f, (float)height);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glViewport((int)0, (int)0, (int)width, (int)height);
        GL11.glClearColor((float)color, (float)color, (float)color, (float)0.0f);
    }

    private void glInit() {
        Display.setVSyncEnabled((boolean)true);
        IntBuffer buffer = BufferUtils.createIntBuffer((int)1);
        GL11.glGenTextures((IntBuffer)buffer);
        texID = buffer.get(0);
        GL11.glTexEnvf((int)8960, (int)8704, (float)8448.0f);
        GL11.glEnable((int)3553);
        GL11.glBindTexture((int)3553, (int)texID);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        PbufferTest.initGLState(this.mode.getWidth(), this.mode.getHeight(), 0.0f);
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            PbufferTest.kill("Invalid arguments length.");
        }
        int mode = -1;
        try {
            mode = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException e) {
            PbufferTest.kill("Invalid mode.");
        }
        if (mode != 1 && mode != 2) {
            PbufferTest.kill("Invalid mode.");
        }
        System.out.println("Change between fullscreen and windowed mode, by pressing F and W respectively");
        System.out.println("Move quad using arrowkeys, and change rotation using +/-");
        PbufferTest test = new PbufferTest(mode);
        test.execute();
        System.exit(0);
    }

    private static void kill(String msg) {
        System.out.println(msg);
        System.out.println("-------");
        System.out.println("Usage: java org.lwjgl.test.opengl.pbuffer.PbufferTest <mode>");
        System.out.println("\n<mode>.");
        System.out.println("\t1: no render-to-texture");
        System.out.println("\t2: with render-to-texture");
        System.exit(-1);
    }
}

