/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.opengl.shaders;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.GL11;
import org.lwjgl.test.opengl.shaders.ShadersTest;

abstract class Shader {
    private static final IntBuffer int_buffer = BufferUtils.createIntBuffer((int)16);
    protected static IntBuffer programBuffer = BufferUtils.createIntBuffer((int)1);
    protected static ByteBuffer fileBuffer = BufferUtils.createByteBuffer((int)10240);

    protected Shader() {
    }

    abstract void render();

    abstract void cleanup();

    public static int glGetInteger(int gl_enum) {
        GL11.glGetInteger((int)gl_enum, (IntBuffer)int_buffer);
        return int_buffer.get(0);
    }

    protected static ByteBuffer getShaderText(String file) {
        ByteBuffer shader = null;
        try {
            byte character;
            ClassLoader loader = ShadersTest.class.getClassLoader();
            InputStream inputStream = loader.getResourceAsStream("org/lwjgl/test/opengl/shaders/" + file);
            if (inputStream == null) {
                ShadersTest.kill("A shader source file could not be found: " + file);
            }
            BufferedInputStream stream = new BufferedInputStream(inputStream);
            while ((character = (byte)stream.read()) != -1) {
                fileBuffer.put(character);
            }
            stream.close();
            fileBuffer.flip();
            shader = BufferUtils.createByteBuffer((int)fileBuffer.limit());
            shader.put(fileBuffer);
            shader.clear();
            fileBuffer.clear();
        }
        catch (IOException e) {
            ShadersTest.kill("Failed to read the shader source file: " + file, e);
        }
        return shader;
    }

    protected static void checkProgramError(String programFile, ByteBuffer programSource) {
        if (GL11.glGetError() == 1282) {
            programSource.clear();
            byte[] bytes = new byte[programSource.capacity()];
            programSource.get(bytes);
            int errorPos = Shader.glGetInteger(34379);
            int lineStart = 0;
            int lineEnd = -1;
            for (int i = 0; i < bytes.length; ++i) {
                if (bytes[i] != 10) continue;
                if (i <= errorPos) {
                    lineStart = i + 1;
                    continue;
                }
                lineEnd = i;
                break;
            }
            if (lineEnd == -1) {
                lineEnd = bytes.length;
            }
            ShadersTest.kill("Low-level program error in file: " + programFile + "\n\tError line: " + new String(bytes, lineStart, lineEnd - lineStart) + "\n\tError message: " + GL11.glGetString((int)34932));
        }
    }

    protected static int getUniformLocation(int ID, String name) {
        fileBuffer.clear();
        int length = name.length();
        char[] charArray = new char[length];
        name.getChars(0, length, charArray, 0);
        for (int i = 0; i < length; ++i) {
            fileBuffer.put((byte)charArray[i]);
        }
        fileBuffer.put((byte)0);
        fileBuffer.flip();
        int location = ARBShaderObjects.glGetUniformLocationARB((int)ID, (ByteBuffer)fileBuffer);
        if (location == -1) {
            throw new IllegalArgumentException("The uniform \"" + name + "\" does not exist in the Shader Program.");
        }
        return location;
    }

    protected static void printShaderObjectInfoLog(String file, int ID) {
        ARBShaderObjects.glGetObjectParameterARB((int)ID, (int)35716, (IntBuffer)programBuffer);
        int logLength = programBuffer.get(0);
        if (logLength <= 1) {
            return;
        }
        ByteBuffer log = BufferUtils.createByteBuffer((int)logLength);
        ARBShaderObjects.glGetInfoLogARB((int)ID, null, (ByteBuffer)log);
        char[] charArray = new char[logLength];
        for (int i = 0; i < logLength; ++i) {
            charArray[i] = (char)log.get();
        }
        System.out.println("\nInfo Log of Shader Object: " + file);
        System.out.println("--------------------------");
        System.out.println(new String(charArray, 0, logLength));
    }

    protected static void printShaderProgramInfoLog(int ID) {
        ARBShaderObjects.glGetObjectParameterARB((int)ID, (int)35716, (IntBuffer)programBuffer);
        int logLength = programBuffer.get(0);
        if (logLength <= 1) {
            return;
        }
        ByteBuffer log = BufferUtils.createByteBuffer((int)logLength);
        ARBShaderObjects.glGetInfoLogARB((int)ID, null, (ByteBuffer)log);
        char[] charArray = new char[logLength];
        for (int i = 0; i < logLength; ++i) {
            charArray[i] = (char)log.get();
        }
        System.out.println("\nShader Program Info Log: ");
        System.out.println("--------------------------");
        System.out.println(new String(charArray, 0, logLength));
    }
}

