/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.opengl.shaders;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.ARBProgram;
import org.lwjgl.opengl.GL11;
import org.lwjgl.test.opengl.shaders.Shader;
import org.lwjgl.test.opengl.shaders.ShadersTest;

final class ShaderFP
extends Shader {
    final String vpFile;
    final ByteBuffer vpSource;
    final int vpID;
    final String fpFile;
    final ByteBuffer fpSource;
    final int fpID;

    ShaderFP(String vpShaderFile, String fpShaderFile) {
        this.vpFile = vpShaderFile;
        this.vpSource = ShaderFP.getShaderText(vpShaderFile);
        ARBProgram.glGenProgramsARB((IntBuffer)programBuffer);
        this.vpID = programBuffer.get(0);
        ARBProgram.glBindProgramARB((int)34336, (int)this.vpID);
        ARBProgram.glProgramStringARB((int)34336, (int)34933, (ByteBuffer)this.vpSource);
        ShaderFP.checkProgramError(this.vpFile, this.vpSource);
        this.fpFile = fpShaderFile;
        this.fpSource = ShaderFP.getShaderText(fpShaderFile);
        ARBProgram.glGenProgramsARB((IntBuffer)programBuffer);
        this.fpID = programBuffer.get(0);
        ARBProgram.glBindProgramARB((int)34820, (int)this.fpID);
        ARBProgram.glProgramStringARB((int)34820, (int)34933, (ByteBuffer)this.fpSource);
        ShaderFP.checkProgramError(this.fpFile, this.fpSource);
    }

    void render() {
        GL11.glEnable((int)34336);
        ARBProgram.glBindProgramARB((int)34336, (int)this.vpID);
        GL11.glEnable((int)34820);
        ARBProgram.glBindProgramARB((int)34820, (int)this.fpID);
        ARBProgram.glProgramLocalParameter4fARB((int)34336, (int)0, (float)ShadersTest.getSin(), (float)((float)ShadersTest.getSpecularity() * 8.0f), (float)0.0f, (float)0.0f);
        ARBProgram.glProgramLocalParameter4fARB((int)34820, (int)0, (float)ShadersTest.getSin(), (float)((float)ShadersTest.getSpecularity() * 8.0f), (float)((float)(-ShadersTest.getDisplayWidth()) * 0.5f), (float)((float)(-ShadersTest.getDisplayHeight()) * 0.5f));
        ShadersTest.renderObject();
        GL11.glDisable((int)34336);
        GL11.glDisable((int)34820);
    }

    void cleanup() {
        programBuffer.put(0, this.vpID);
        ARBProgram.glDeleteProgramsARB((IntBuffer)programBuffer);
        programBuffer.put(0, this.fpID);
        ARBProgram.glDeleteProgramsARB((IntBuffer)programBuffer);
    }
}

