/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.opengl.shaders;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ARBUniformBufferObject;
import org.lwjgl.opengl.GL20;
import org.lwjgl.test.opengl.shaders.Shader;
import org.lwjgl.test.opengl.shaders.ShadersTest;

final class ShaderUNI
extends Shader {
    final String file;
    final ByteBuffer source;
    final int shaderID;
    final int programID;
    final int uniformA;
    final int uniformB;

    ShaderUNI(String shaderFile) {
        this.file = shaderFile;
        this.source = ShaderUNI.getShaderText(shaderFile);
        this.shaderID = GL20.glCreateShader((int)35633);
        GL20.glShaderSource((int)this.shaderID, (ByteBuffer)this.source);
        GL20.glCompileShader((int)this.shaderID);
        ShaderUNI.printShaderObjectInfoLog(this.file, this.shaderID);
        GL20.glGetShader((int)this.shaderID, (int)35713, (IntBuffer)programBuffer);
        if (programBuffer.get(0) == 0) {
            ShadersTest.kill("A compilation error occured in a vertex shader.");
        }
        this.programID = GL20.glCreateProgram();
        GL20.glAttachShader((int)this.programID, (int)this.shaderID);
        GL20.glLinkProgram((int)this.programID);
        ShaderUNI.printShaderProgramInfoLog(this.programID);
        GL20.glGetProgram((int)this.programID, (int)35714, (IntBuffer)programBuffer);
        if (programBuffer.get(0) == 0) {
            ShadersTest.kill("A linking error occured in a shader program.");
        }
        this.uniformA = ShaderUNI.getUniformLocation(this.programID, "uniformA");
        this.uniformB = ShaderUNI.getUniformLocation(this.programID, "uniformB");
        String[] uniformNames = new String[]{"uniformA", "uniformB"};
        IntBuffer tmp = BufferUtils.createIntBuffer((int)uniformNames.length);
        ARBUniformBufferObject.glGetUniformIndices((int)this.programID, (ByteBuffer)ShaderUNI.toByteBuffer(uniformNames), (IntBuffer)tmp);
        System.out.println("uniformA index = " + tmp.get(0));
        System.out.println("uniformB index = " + tmp.get(1));
    }

    private static ByteBuffer toByteBuffer(String[] strs) {
        int length = 0;
        for (int i = 0; i < strs.length; ++i) {
            length += strs[i].length() + 1;
        }
        ByteBuffer buff = BufferUtils.createByteBuffer((int)length);
        for (int i = 0; i < strs.length; ++i) {
            buff.put(strs[i].getBytes());
            buff.put((byte)0);
        }
        buff.flip();
        return buff;
    }

    void render() {
        GL20.glUseProgram((int)this.programID);
        GL20.glUniform2f((int)this.uniformA, (float)ShadersTest.getSin(), (float)((float)ShadersTest.getSpecularity() * 8.0f));
        GL20.glUniform3f((int)this.uniformB, (float)0.0f, (float)0.7f, (float)0.0f);
        ShadersTest.renderObject();
        GL20.glUseProgram((int)0);
    }

    void cleanup() {
        GL20.glDetachShader((int)this.programID, (int)this.shaderID);
        GL20.glDeleteShader((int)this.shaderID);
        GL20.glDeleteProgram((int)this.programID);
    }
}

