/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.opengl.shaders;

import java.nio.FloatBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.Sys;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.ContextAttribs;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.PixelFormat;
import org.lwjgl.test.opengl.shaders.Shader;
import org.lwjgl.test.opengl.shaders.ShaderFP;
import org.lwjgl.test.opengl.shaders.ShaderFSH;
import org.lwjgl.test.opengl.shaders.ShaderUNI;
import org.lwjgl.test.opengl.shaders.ShaderVP;
import org.lwjgl.test.opengl.shaders.ShaderVSH;
import org.lwjgl.util.glu.GLU;
import org.lwjgl.util.glu.Sphere;

public final class ShadersTest {
    private static DisplayMode displayMode;
    private static boolean run;
    private static final FloatBuffer vectorBuffer;
    private static Sphere sphere;
    private static Shader shader;
    private static float frameTime;
    private static float angle;
    private static float sin;
    private static int specularity;

    private ShadersTest() {
    }

    public static void main(String[] args) {
        ShadersTest.initialize(args);
        long lastFrameTime = 0L;
        while (run) {
            if (!Display.isVisible()) {
                Thread.yield();
            } else {
                long frameStart = Sys.getTime();
                frameTime = (float)((double)(frameStart - lastFrameTime) / (double)Sys.getTimerResolution());
                lastFrameTime = frameStart;
                sin = (float)Math.sin(Math.toRadians(angle += 0.1f));
                ShadersTest.handleIO();
                GL11.glClear((int)16640);
                if (shader != null) {
                    shader.render();
                } else {
                    ShadersTest.renderObject();
                }
                GL11.glPopMatrix();
                GL11.glPushMatrix();
            }
            Display.update();
            if (!Display.isCloseRequested()) continue;
        }
        ShadersTest.cleanup();
        System.exit(0);
    }

    private static void initialize(String[] args) {
        if (args.length != 1) {
            ShadersTest.argsError();
        }
        try {
            DisplayMode[] modes = Display.getAvailableDisplayModes();
            DisplayMode displayMode = ShadersTest.chooseMode(modes, 1024, 768);
            if (displayMode == null) {
                displayMode = ShadersTest.chooseMode(modes, 800, 600);
            }
            if (displayMode == null) {
                displayMode = ShadersTest.chooseMode(modes, 640, 480);
            }
            if (displayMode == null) {
                ShadersTest.kill("Failed to set an appropriate display mode.");
            }
            System.out.println("Setting display mode to: " + displayMode);
            Display.setDisplayMode((DisplayMode)displayMode);
            Display.create((PixelFormat)new PixelFormat(8, 24, 0), (ContextAttribs)("UNI".equalsIgnoreCase(args[0]) ? new ContextAttribs(3, 1) : null));
            ShadersTest.displayMode = displayMode;
        }
        catch (LWJGLException e) {
            ShadersTest.kill(e.getMessage());
        }
        if ("NONE".equalsIgnoreCase(args[0])) {
            shader = null;
        } else if ("VP".equalsIgnoreCase(args[0])) {
            if (!GLContext.getCapabilities().GL_ARB_vertex_program) {
                ShadersTest.kill("The ARB_vertex_program extension is not supported.");
            }
            shader = new ShaderVP("shaderVP.vp");
        } else if ("FP".equalsIgnoreCase(args[0])) {
            if (!GLContext.getCapabilities().GL_ARB_vertex_program) {
                ShadersTest.kill("The ARB_vertex_program extension is not supported.");
            }
            if (!GLContext.getCapabilities().GL_ARB_fragment_program) {
                ShadersTest.kill("The ARB_fragment_program extension is not supported.");
            }
            shader = new ShaderFP("shaderFP.vp", "shaderFP.fp");
        } else if ("VSH".equalsIgnoreCase(args[0])) {
            if (!GLContext.getCapabilities().GL_ARB_vertex_shader) {
                ShadersTest.kill("The ARB_vertex_shader extension is not supported.");
            }
            shader = new ShaderVSH("shaderVSH.vsh");
        } else if ("FSH".equalsIgnoreCase(args[0])) {
            if (!GLContext.getCapabilities().GL_ARB_vertex_shader) {
                ShadersTest.kill("The ARB_vertex_shader extension is not supported.");
            }
            if (!GLContext.getCapabilities().GL_ARB_fragment_shader) {
                ShadersTest.kill("The ARB_fragment_shader extension is not supported.");
            }
            shader = new ShaderFSH("shaderFSH.vsh", "shaderFSH.fsh");
        } else if ("UNI".equalsIgnoreCase(args[0])) {
            if (!GLContext.getCapabilities().OpenGL31) {
                ShadersTest.kill("OpenGL version 3.1 is not supported.");
            }
            shader = new ShaderUNI("shaderUNI.vsh");
        } else {
            ShadersTest.argsError();
        }
        GL11.glViewport((int)0, (int)0, (int)displayMode.getWidth(), (int)displayMode.getHeight());
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GLU.gluPerspective((float)45.0f, (float)((float)displayMode.getWidth() / (float)displayMode.getHeight()), (float)1.0f, (float)10.0f);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-4.0f);
        GL11.glRotatef((float)15.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glPushMatrix();
        GL11.glClearDepth((double)1.0);
        GL11.glDepthFunc((int)515);
        GL11.glHint((int)3152, (int)4354);
        GL11.glFrontFace((int)2305);
        GL11.glPolygonMode((int)1028, (int)6914);
        GL11.glCullFace((int)1029);
        GL11.glEnable((int)2884);
        GL11.glAlphaFunc((int)517, (float)0.0f);
        GL11.glEnable((int)3008);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3042);
        GL11.glShadeModel((int)7425);
        if (shader == null) {
            GL11.glEnable((int)2896);
            GL11.glEnable((int)16384);
        }
        vectorBuffer.clear();
        vectorBuffer.put(1.0f).put(1.0f).put(1.0f).put(1.0f);
        vectorBuffer.clear();
        GL11.glLight((int)16384, (int)4609, (FloatBuffer)vectorBuffer);
        vectorBuffer.put(1.0f).put(1.0f).put(1.0f).put(1.0f);
        vectorBuffer.clear();
        GL11.glLight((int)16384, (int)4608, (FloatBuffer)vectorBuffer);
        vectorBuffer.put(1.0f).put(1.0f).put(0.5f).put(1.0f);
        vectorBuffer.clear();
        GL11.glLight((int)16384, (int)4610, (FloatBuffer)vectorBuffer);
        vectorBuffer.put(-0.33333334f).put(0.33333334f).put(0.33333334f).put(0.0f);
        vectorBuffer.clear();
        GL11.glLight((int)16384, (int)4611, (FloatBuffer)vectorBuffer);
        vectorBuffer.put(0.2f).put(0.2f).put(0.2f).put(1.0f);
        vectorBuffer.clear();
        GL11.glLightModel((int)2899, (FloatBuffer)vectorBuffer);
        sphere = new Sphere();
    }

    private static void handleIO() {
        if (Keyboard.getNumKeyboardEvents() != 0) {
            while (Keyboard.next()) {
                if (Keyboard.getEventKeyState()) continue;
                switch (Keyboard.getEventKey()) {
                    case 13: {
                        if (specularity >= 8) break;
                        ++specularity;
                        break;
                    }
                    case 12: {
                        if (specularity <= 1) break;
                        --specularity;
                        break;
                    }
                    case 1: {
                        run = false;
                    }
                }
            }
        }
        while (Mouse.next()) {
        }
    }

    static int getDisplayWidth() {
        return displayMode.getWidth();
    }

    static int getDisplayHeight() {
        return displayMode.getHeight();
    }

    static float getSin() {
        return sin;
    }

    static int getSpecularity() {
        return specularity;
    }

    static void renderObject() {
        GL11.glColor3b((byte)-1, (byte)-1, (byte)-1);
        sphere.draw(1.0f, 32, 32);
    }

    private static DisplayMode chooseMode(DisplayMode[] modes, int width, int height) {
        DisplayMode bestMode = null;
        for (int i = 0; i < modes.length; ++i) {
            DisplayMode mode = modes[i];
            if (mode.getWidth() != width || mode.getHeight() != height || mode.getFrequency() > 85 || bestMode != null && (mode.getBitsPerPixel() < bestMode.getBitsPerPixel() || mode.getFrequency() <= bestMode.getFrequency())) continue;
            bestMode = mode;
        }
        return bestMode;
    }

    private static void cleanup() {
        if (shader != null) {
            shader.cleanup();
        }
        if (Display.isCreated()) {
            Display.destroy();
        }
    }

    private static void argsError() {
        System.out.println("\nInvalid program arguments.");
        System.out.println("\nUsage: ShadersTest <shaderType>, where <shaderType> argument can be one of the following:\n");
        System.out.println("none\t- Use fixed function rendering.");
        System.out.println("vp\t- Use ARB_vertex_program (low-level) only.");
        System.out.println("vsh\t- Use ARB_vertex_shader (GLSL) only.");
        System.out.println("fp\t- Use ARB_vertex_program + ARB_fragment_program (low-level).");
        System.out.println("fsh\t- Use ARB_vertex_shader + ARB_fragment_shader (GLSL).");
        ShadersTest.cleanup();
        System.exit(-1);
    }

    static void kill(String reason) {
        System.out.println("The ShaderTest program was terminated because an error occured.\n");
        System.out.println("Reason: " + (reason == null ? "Unknown" : reason));
        ShadersTest.cleanup();
        System.exit(-1);
    }

    static void kill(String reason, Throwable t) {
        System.out.println("The ShaderTest program was terminated because an exception occured.\n");
        System.out.println("Reason: " + reason == null ? "Unknown" : reason);
        System.out.println("Exception message: " + t.getMessage());
        ShadersTest.cleanup();
        System.exit(-1);
    }

    static {
        run = true;
        vectorBuffer = BufferUtils.createFloatBuffer((int)4);
        specularity = 4;
    }
}

